<?php
    /**
     * @class  smartuxController
     * @author 그냥재미로
     * @brief  smartux 모듈의 controller class
     **/

	/**
	 * android GCM
	 * registration_ids [1~1000] 까지가능
	 */	
    class smartuxController extends smartux {
    	/**
    	 * @brief Initialization
    	 **/
    	function init() {    		
    	}

    	/** 
    	 * @brief 알림 수신 디바이스 등록. (api) 
    	 * 앱에서 구글 GCM 아이디 등록. [미사용]
    	 **/
		function _dispSmartUXRegisterDeviceAPI($args) {	
			$args->controller = "_dispSmartUXRegisterDeviceAPI";
            return $args;
        }


        /** API
         * @brief 수신가능한 알림목록 반환. (api)
         * 수신가능한 알림목록 반환. [미사용]
         **/
        function _dispSmartUXMemberNotficationListAPI()
        {        	
			$args->controller = "_dispSmartUXMemberNotficationListAPI";
            return $args;
        }
                
        
    	/**
    	 * @brief trigger for document insertion.
    	 * @param $obj : document object.
    	 * 새글 알림 수신자에게 알림 전송
    	 **/    	 
    	function triggerInsertDocument(&$obj)
    	{

    		$notificationMember = null;
    		$notificationAdmin = null;
    		
    		//환경설정 참조
    		$oSmartuxAdminModel = &getAdminModel('smartux');
    		$config = $oSmartuxAdminModel->getConfig();    		
    		
    		// 알림 서비스 사용하지 않는다면, module_srl 없다면 return
    		if($config->use_notification == "N" || $config->use_documentall == "N" || !$obj->module_srl  ) return;
    					
			// 모듈정보 조회
			$args->module_srl = $obj->module_srl;
			$output = executeQuery('module.getMidInfo', $args);

			// 모듈정보가 없다면 return
			if (!$output->toBool() || !$output->data) return;
			$module_info = $output->data;
			
			// 모듈 브라우저 타이틀 다국어처리						
			if(substr($module_info->browser_title,0,12)=='$user_lang->') {
				// 한글만 처리함
				$argsLang->name = str_replace('$user_lang->', '', $module_info->browser_title);
				$argsLang->lang_code = 'ko';				 
				$output = executeQueryArray('smartux.getLang', $argsLang);
				$browser_title = $output->data[0]->value;				 
				$module_info->browser_title = $output->data[0]->value;
			}else{
				$browser_title = $module_info->browser_title;
			}    		
			
			// 새글알림, 새글알림 3번
			$args->module_srls = ("3,".$args->module_srl );
			
			// 모듈 알림을 수신하는 사용자 목록
			$output = executeQuery('smartux.getUserNotificationListByModuleSrl', $args);
			
			// 알림수신자가 없다면 return
			if (!$output->toBool() || !$output->data) return;
			
			if($output->data) $notificationAdmin = $output->data;									
			$notificationSenderDeviceList = $this->mergeNotificationSender($notificationAdmin, $notificationMember);
								
			//알림전송 데이터 정리
			$notificationSenderAndroid->site_name = $config->site_name;
			$notificationSenderAndroid->gcm_api_key = $config->gcm_api_key;
			$notificationSenderAndroid->device_id = $notificationSenderDeviceList;
			$notificationSenderAndroid->type = "document";
			$notificationSenderAndroid->title = strip_tags($obj->title);
			$notificationSenderAndroid->content = $obj->content;
			$notificationSenderAndroid->nick_name = $obj->nick_name;
			$notificationSenderAndroid->browser_title = $browser_title;
			$notificationSenderAndroid->url = getFullUrl('','document_srl', $obj->document_srl);
						
			// 알림전송
			$this->sendMessageAndroidByCurl($notificationSenderAndroid);			
    	}
    	
    	
    	
    	/**
    	 * @brief trigger for comment insertion.
    	 * @param $obj : SendMessage object.
    	 * 원글, 상위 댓글 작성자에게 댓글 알림 전송
    	 **/
    	function triggerInsertComment(&$obj)
    	{    		    		
    		$notificationMember = null;
    		$notificationAdmin = null;
    		
    		//환경설정 참조    		
    		$oSmartuxAdminModel = &getAdminModel('smartux');
    		$config = $oSmartuxAdminModel->getConfig();    		
    		
    		// 알림 서비스 사용하지 않는다면, module_srl 없다면 return
    		if($config->use_notification == "N" || ($config->use_comment == "N" &&  $config->use_commentall == "N")  || !$obj->module_srl  ) return;    		    		

			// 모듈정보 조회
			$args->module_srl = $obj->module_srl;
			$output = executeQuery('module.getMidInfo', $args);
			
			// 모듈정보가 없다면 return
			if (!$output->toBool() || !$output->data) return;
			$module_info = $output->data;
				
			//모듈 브라우저 타이틀 다국어처리
			if(substr($module_info->browser_title,0,12)=='$user_lang->') {
				// 한글만 처리함
				$argsLang->name = str_replace('$user_lang->', '', $module_info->browser_title);
				$argsLang->lang_code = 'ko';
				$output = executeQueryArray('smartux.getLang', $argsLang);
				$browser_title = $output->data[0]->value;
				$module_info->browser_title = $output->data[0]->value;
			}else{
				$browser_title = $module_info->browser_title;
			}
						
			
			// 댓글알림
			if($config->use_comment == "Y"){			
				// 댓글알림 처리 parent_srl 여부에 따라 처리함.
				if($obj->parent_srl)
				{				
					$args->parent_srl = $obj->parent_srl;
					$output = executeQuery('smartux.getMemberSrlByParentSrl', $args);
					
					// 오류 or 댓글정보가 없다면 return
					if (!$output->toBool() || !$output->data) return;
	
					//상위 댓글 작성회원 댓글알림 수신여부 확인 ( 댓글알림 2번 ) # 문서와 댓글 작성자가 같다면 패쓰.
					if($obj->member_srl != $output->data->member_srl)
					{
						$args->module_srls = ("2");
						$args->member_srl = $output->data->member_srl;
						$output = executeQuery('smartux.getAllowNotificationCommentInfoByMemberSrl', $args);					
						if($output->data) $notificationMember = $output->data;
					}				
					
				}
				else
				{				
					//문서 작성자 정보 조회
					$args->document_srl = $obj->document_srl;
					$output = executeQuery('smartux.getMemberSrlByDocumentSrl', $args);				
					
					// 오류 or 문서정보가 없다면 return
					if (!$output->toBool() || !$output->data) return;
					
					//문서 작성회원 댓글알림 수신여부 확인 ( 댓글알림 2번 ) # 문서와 댓글 작성자가 같다면 패쓰.				
					if($obj->member_srl != $output->data->member_srl)
					{
						$args->module_srls = ("2");
						$args->member_srl = $output->data->member_srl;				
						$output = executeQuery('smartux.getAllowNotificationCommentInfoByMemberSrl', $args);
						if($output->data) $notificationMember = $output->data;
					}
									
	    		}
			}
			
    		// 댓글 모두알림
    		if($config->use_commentall == "Y")
    		{    		
	    		// 댓글모두 알림을 수신하는 관리자 ( 댓글 모두알림 4번 )
	    		$args->module_srls = ("4" );
	    		$output = executeQuery('smartux.getUserNotificationListByModuleSrl', $args);


	    		if($output->data) $notificationAdmin = $output->data;	    		   		    		
    		}
    		
    		
    		// 알림수신자가 없다면 return
    		if ($notificationMember == null &&  $notificationAdmin == null) return;
    		 
    		// 알림 수신자 목록 정리
    		// 회원만
    		if($notificationMember != null &&  $notificationAdmin == null)
    		{
    			$notificationSenderDeviceList = array($notificationMember->device_id);
    		}
    		// 회원, 관리자 or 관리자
    		else if( ($notificationMember != null &&  $notificationAdmin != null) || ($notificationMember == null &&  $notificationAdmin != null) )
    		{
    			$notificationSenderDeviceList = $this->mergeNotificationSender($notificationAdmin, $notificationMember);
    		}
    		
    		// 알림전송 데이터 정리
    		$notificationSenderAndroid->site_name = $config->site_name;
    		$notificationSenderAndroid->gcm_api_key = $config->gcm_api_key; 
    		$notificationSenderAndroid->device_id = $notificationSenderDeviceList;
    		$notificationSenderAndroid->type = "comment";
    		
    		//TODO 타이틀 길이를 잘라서 보냄
    		$notificationSenderAndroid->title = strip_tags($obj->content); //content, html 테그 제거 후 title 에 적용
    		$notificationSenderAndroid->content = $obj->content;
    		$notificationSenderAndroid->nick_name = $obj->nick_name;
    		$notificationSenderAndroid->browser_title = $browser_title;
    		$notificationSenderAndroid->url = getFullUrl('','document_srl', $obj->document_srl);
    		    		
    		// 알림전송
    		$this->sendMessageAndroidByCurl($notificationSenderAndroid);
    	
    	}
    	
    	/**
    	 * @brief trigger for member insertion.
    	 * @param $obj : member object.
    	 * 회원가입 알림 수신자에게 알림 전송
    	 **/
    	function triggerInsertMember(&$obj)
    	{   		
    		//환경설정 참조
    		$oSmartuxAdminModel = &getAdminModel('smartux');
    		$config = $oSmartuxAdminModel->getConfig();
    		
    		// 알림 서비스 사용하지 않는다면 return
    		if($config->use_notification == "N" || $config->use_member_signup == "N") return;


    		// 회원가입알림 수신확인 [회원가입 target_module_srl = 5 ]    	
    		$args->module_srls = ("5");
    		$output = executeQuery('smartux.getUserNotificationListByModuleSrl', $args);    		
    		if($output->data) $notificationMember = $output->data;
    		    		
    		// 알림수신자가 없다면 return
    		if ($notificationMember == null) return;    		
    		
    		// 알림 수신자 목록 정리
    		$notificationAdmin = null;
   			$notificationSenderDeviceList = $this->mergeNotificationSender($notificationAdmin, $notificationMember);
   				
   			//알림전송 데이터 정리
   			$notificationSenderAndroid->site_name = $config->site_name;
   			$notificationSenderAndroid->gcm_api_key = $config->gcm_api_key;   			
   			$notificationSenderAndroid->device_id = $notificationSenderDeviceList;
   			$notificationSenderAndroid->type = "singup";
   			$notificationSenderAndroid->title = $obj->user_name." : ".$obj->email_address;
   			$notificationSenderAndroid->content = "";
   			$notificationSenderAndroid->nick_name = $obj->nick_name;
   			$notificationSenderAndroid->browser_title = "";
   			$notificationSenderAndroid->url = getFullUrl('','');
   			$this->sendMessageAndroidByCurl($notificationSenderAndroid);
    		
    	}
    	
    	/**
    	 * @brief trigger for Communication SendMessage.
    	 * @param $obj : SendMessage object.
    	 * 쪽지 수신자에게 알림 전송
    	 **/
    	function triggerCommunicationSendMessage($receiver_args)
    	{    		
    		//환경설정 참조
    		$oSmartuxAdminModel = &getAdminModel('smartux');
    		$config = $oSmartuxAdminModel->getConfig();
    		
    		// 알림 서비스 사용하지 않는다면 return
    		if($config->use_notification == "N" || $config->use_message == "N") return;
    		    	    	
    		//쪽지알림 수신확인 [쪽지 target_module_srl = 1 ]
    		$receiver_args->target_module_srl = '1';
    		$output = executeQuery('smartux.getUserNotificationMessageByReceiverSrl', $receiver_args);
    	
			// 오류 or 알림정보가 없다면 return
			if (!$output->toBool() || !$output->data) return;
    	
    		// 쪽지 알림을 수신중이라면
    		if($output->data->allow_notification == 'Y')
    		{
    			//sender_srl 로 닉네임 조회
    			$args->member_srl = $receiver_args->sender_srl;
    			$outputNickname = executeQuery('smartux.getMemberNicknameByMemberSrl', $args);
    				
    			//알림전송 데이터 정리
    			$notificationSenderAndroid->site_name = $config->site_name;
    			$notificationSenderAndroid->gcm_api_key = $config->gcm_api_key;
    			$notificationSenderAndroid->device_id = array($output->data->device_id);    			
    			$notificationSenderAndroid->type = "message";    			    			    			
    			$notificationSenderAndroid->title = strip_tags($receiver_args->title);
    			$notificationSenderAndroid->content = $receiver_args->content;
    			$notificationSenderAndroid->nick_name = $outputNickname->data->nick_name;
    			$notificationSenderAndroid->browser_title = "message";    				
    			$notificationSenderAndroid->url = getFullUrl('','act','dispCommunicationMessages','message_srl',$receiver_args->message_srl);
    			$notificationSenderAndroid->url = str_replace('&amp;', '&', $notificationSenderAndroid->url);
    			$this->sendMessageAndroidByCurl($notificationSenderAndroid);
    		}
    	
    	}
    	
    	
    	/**
    	 * @brief notification sender device id check and merge.
    	 * @param $notificationAdmin : admin.
    	 * @param $notificationMember : member.
    	 * @result $device_id : array().
    	 * 알림 수진자 중복 체크 및 병합
    	 **/
    	function mergeNotificationSender($notificationAdmin, $notificationMember)
    	{    	    		    		
    		$device_id = array();
    		
    		//관리자
    		if( $notificationAdmin != null )
    		{
    			if(count($notificationAdmin) == 1)
    			{
    				foreach ($notificationAdmin as $key => $value)
    				{    						
    					if($key == "device_id" && $value != "" )
    					{
    						if (!in_array($value, $device_id))
    						{
    							array_push($device_id, $value);
    						}
    					}
    				}
    			}
    			else if(count($notificationAdmin) > 1)
    			{
    				foreach ($notificationAdmin as $key => $value)
    				{    			
    					if($value->device_id !=""){
    						if (!in_array($value, $device_id))
    						{
    							array_push($device_id, $value->device_id);
    						}
    					}
    				}
    			}    			
    		}
    		
    		// 회원
    		if( $notificationMember != null )    		
    		{    			
    			if(count($notificationMember) == 1)
    			{
    				foreach ($notificationMember as $key => $value)
    				{    					
    					if($key == "device_id" && $value != "" )
    					{
    						if (!in_array($value, $device_id))
    						{
    							array_push($device_id, $value);
    						}
    					}    				
    				}
    			}
    			else if(count($notificationMember) > 1)
    			{    				    				
    				foreach ($notificationMember as $key => $value)
    				{    				    				
    					if($value->device_id !=""){
    						if (!in_array($value, $device_id))
    						{
    							array_push($device_id, $value->device_id);
    						}
    					}
    				}
    			} 
    			 
    		}
    		return $device_id;    	    	
    	}

    	
    	/** 
    	 * @brief Google GCM Sender
    	 * @param $args : notification data object.
    	 * 구글 GCM으로 알림전송.
    	 **/
    	function sendMessageAndroidByCurl($args) {
    		$auth = $args->gcm_api_key;
    		    		
    		$data = array(
				'registration_ids' => $args->device_id,
				'data' => array('site_name' => $args->site_name, 'type' => $args->type, 'browser_title' => $args->browser_title, 'title'=>$args->title, 'content'=>$args->content, 'nick_name'=>$args->nick_name , 'url'=>$args->url)
    		);
    	
    		$headers = array(
    				"Content-Type:application/json",
    				"Authorization:key=".$auth
    		);
    	
    		$ch = curl_init();
    		curl_setopt($ch, CURLOPT_URL, "https://android.googleapis.com/gcm/send");
    		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    		curl_setopt($ch, CURLOPT_POST, true);
    		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode2($data));
    		$result = curl_exec($ch);
    		curl_close($ch);

			//TODO 알림 메시지 전송결과를 업데이트 해준다. (성공, 실패, 보낸 횟수, 마지막 보낸시간)
			debugprint($data);
			debugprint("GCM Sender Result ======================================= start");
			debugprint($result);
			debugprint("GCM Sender Result ======================================= end");
    		
    	}
    	    	
    	
    }
?>