<?php
    /**
     * @class  smartuxAdminController
     * @author 그냥재미로
     * @brief  smartux 모듈의 admin controller class
     **/

    class smartuxAdminController extends smartux {

        /**
         * @brief 
         * role : 초기화
         **/
        function init() 
        {
        	
        }

        /**
         * @brief 알림 서비스 대상 등록, 수정
         * target Table : smartux_notification
         **/
        function procSmartuxAdminInsert()
        {    
        	debugprint("procSmartuxAdminInsert");   	
        	// args 추출
        	$args = Context::gets('smartux_srl', 'target_module', 'module','member_srl','user_id','user_name','nick_name','platform','os_ver','device_id','allow_notification');

        	$expArray = explode("," , $args->target_module);        	 
        	$args->target_module_srl = $expArray[0];
        	$args->browser_title = $expArray[1];
        	
        	if($args->smartux_srl){ //업데이트		
        		$output = executeQuery('smartux.updateNotification', $args);
        		if (!$output->toBool()) return $output;
        		
        	}else{//인서트
        		$args->smartux_srl = getNextSequence();
        		$output = executeQuery('smartux.insertNotification', $args);
        		if (!$output->toBool()) return $output;
        	}
        	
        	if (!$output->toBool())
        	{
        		return $output;
        	}
        	        	
        	$redirectUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispSmartuxAdminIndex');
        	$this->setRedirectUrl($redirectUrl);
 
        }
                
        
        /**
         * @brief
         * target Table : smartux_notification
         **/
        function procSmartuxAdminDelete()
        {

        	$smartux_srl = Context::get('smartux_srl');        	        	
        	if (!$smartux_srl) return new Object(-1, 'msg_invalid_request');
        	        
        	if ($smartux_srl)
        	{
        		$args->smartux_srl = $smartux_srl;
        		executeQuery('smartux.deleteSmartuxBySmartuxSrl', $args);
        	}        	
        	
        	if(version_compare(__ZBXE_VERSION__, '1.5.0', '>='))
        	{
        		$redirectUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispSmartuxAdminIndex');
        		$this->setRedirectUrl($redirectUrl);        		
        	}
        	else
        	{
	        	$this->add('module','smartux');
	        	$this->add('page',Context::get('page'));
	        	$this->setMessage('success_deleted');
        	}

        }
        
        
        /**
         * @brief
         * target Table : module_config
         **/        
        function procSmartuxAdminInsertConfig()
        {
        	
	        $oModuleController = &getController('module');

	        //args 추출
	        $args->site_name = Context::get('site_name');
	        $args->use_notification = Context::get('use_notification');
	        $args->use_message = Context::get('use_message');
	        $args->use_document = Context::get('use_document');
	        $args->use_comment = Context::get('use_comment');
	        $args->use_documentall = Context::get('use_documentall');
	        $args->use_commentall = Context::get('use_commentall');
	        $args->use_member_signup = Context::get('use_member_signup');
	        
	        $args->gcm_api_key = Context::get('gcm_api_key');
	       
	        $this->setMessage('success_updated');
	        
	        if(version_compare(__ZBXE_VERSION__, '1.5.0', '>='))
	        { 
	        	$oModuleController->updateModuleConfig('smartux', $args);	        
	        	if(!in_array(Context::getRequestMethod(),array('XMLRPC','JSON')))
	        	{
	        		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispSmartuxAdminConfig');
	        		header('location: ' . $returnUrl);
	        		return;
	        	}
	        }
	        else
	        {
	        	$oModuleController->insertModuleConfig('smartux', $args);
	        }
	        
        }
        

	}
?>