<?php
/**
 * @class  xewallAdminView
 * @author 바람꽃 (wndflwr@gmail.com)
 * @brief  xewall 모듈의 admin view class
 **/

class xewallAdminView extends xewall {

	/**
	 * @brief 초기화
	 *
	 * board 모듈은 일반 사용과 관리자용으로 나누어진다.\n
	 **/
	function init() {
		$this->setTemplatePath($this->module_path.'tpl');
	}
	
	/**
	 * @function dispXewallAdminModuleSetup
	 * @brief 기본적인 모듈들의 정보를 설정할 수 있다.
	 */
	function dispXewallAdminModuleSetup() {
		// $module_info 던지기
		$oModuleModel = &getModel('module');
		$module_info = $oModuleModel->getModuleInfoByMid('xewall');
		Context::set('module_info', $module_info);
		
		// $module_category 던지기
		$module_category = $oModuleModel->getModuleCategories();
		Context::set('module_category', $module_category);
		
		// $layout_list (레이아웃 목록) 던지기
		$oLayoutModel = &getModel('layout');
		$layout_list = $oLayoutModel->getLayoutList();
		Context::set('layout_list', $layout_list);
		
		// $mlayout_list (모바일 레이아웃 목록) 던지기
		$mobile_layout_list = $oLayoutModel->getLayoutList(0, "M");
		Context::set('mlayout_list', $mobile_layout_list);
		
		// $skin_list (스킨 목록) 던지기
		$skin_list = $oModuleModel->getSkins($this->module_path);
		Context::set('skin_list', $skin_list);
		
		// 템플릿 파일 설정
		$this->setTemplateFile('module_config');
	}
	
	
	/**
	 * @function dispXewallADminGeneralSetup
	 * @brief 일반적인 설정을 설정하는 창
	 */
	function dispXewallAdminGeneralSetup() {
		// module_categories 정보 불러와서 뿌리기
		$oModuleModel = &getModel('module');
		$category_list = $oModuleModel->getModuleCategories();
		Context::set('category_list', $category_list);
		
		// XE에 존재하는 모든 게시판 불러오기
		$args->modules = "'bodex','beluxe','board'";
		$board_list = executeQueryArray('xewall.getModulesByModuleName', $args);
		
		// 관리자가 모든 사용자들이 무조건 듣도록 지정한 게시판
		$args->type1 = "D";
		$default_module_list = executeQueryArray('xewall.getFavouriteByType', $args);
		
		// 관리자가 사용자에게 듣기 선택을 허용한 게시판 불러오기
		$args->type1 = "A";
		$available_module_list = executeQueryArray('xewall.getFavouriteByType', $args);
		
		// 위의 모듈 리스트들을 module_srl이 키 값을 가지도록
		$arrBoardList = array();
		$keyBoardList = array();
		foreach ($board_list->data as $val) {
			$arrBoardList[$val->module_srl] = $val;
			$keyBoardList[] = $val->module_srl;
		}
		$arrDefList = array();
		foreach ($default_module_list->data as $val) {
			$arrDefList[$val->target_srl] = $arrBoardList[$val->target_srl];
		}
		$arrAvaList = array();
		foreach ($available_module_list->data as $val) {
			$arrAvaList[$val->target_srl] = $arrBoardList[$val->target_srl];
		}
		// 필요 없어진 데이터들 메모리에서 해제
		unset($board_list);
		unset($default_module_list);
		unset($available_module_list);
		
		// arrBoardList 에서 arrDefList와 arrAvaList에 존재하는 모듈들을 제거한다.
		foreach ($keyBoardList as $val) {
			if ($arrDefList[$val]) {
				unset($arrBoardList[$val]);
				continue;
			}
			if ($arrAvaList[$val]) {
				unset($arrBoardList[$val]);
				continue;
			}
		}
		
		// 관리자가 각 모듈에게 설정한 값들을 불러온다. (xewall_favourite_config 테이블)
		$output = executeQueryArray('xewall.getFavouriteConfig');
		$xewall_config = array();
		
		foreach ($output->data as $val) {
			$config = unserialize($val->config);
			
			// 게시판의 색깔 설정 받아오기. (기본 색은 #f5f7f7)
			$xewall_config[$val->module_srl]['background_color'] = $config->background_color;
		}
		Context::set('xewall_config', $xewall_config);
		
		// 정리된 모듈 리스트들을 보내기
		Context::set('module_list', $arrBoardList);
		Context::set('default_module_list', $arrDefList);
		Context::set('available_module_list', $arrAvaList);
		
		// 모듈 설정값 불러오기 (module_config), 기본 값 설정
		$moduleConfig = $oModuleModel->getModuleConfig('xewall');
		if (!$moduleConfig->refresh_rate) $moduleConfig->refresh_rate = 30;
		if (!$moduleConfig->doc_summary) $moduleConfig->doc_summary = 500;
		if (!$moduleConfig->doc_more) $moduleConfig->doc_more = ' (more...)';
		if (!$moduleConfig->com_summary) $moduleConfig->com_summary = 500;
		if (!$moduleConfig->com_more) $moduleConfig->com_more = ' (more...)';
		if (!$moduleConfig->check_login) $moduleConfig->check_login = 'N';
		Context::set('module_config', $moduleConfig);
		
		// 에디터 스킨 정보 던지기
		$oEditorModel = &getModel('editor');
		$editor_skin_list = $oEditorModel->getEditorSkinList();
		Context::set('editor_skin_list', $editor_skin_list);
		
		// 템플릿 파일 설정
		$this->setTemplateFile('general_config');
	}
	
	
	/**
	 * @function dispXewallAdminXMPPSetup
	 * @brief XMPP 관련된 사항들을 설정한다.
	 */
	function dispXewallAdminXMPPSetup() {
		$oModuleModel = &getModel('module');
		
		// XMPP 모듈인 notifycra 모듈이 존재하는지 확인한다.
		$notifycraModule = &getModule('notifycra');
		if (!$notifycraModule) {
			$this->setTemplateFile('xmpp_not_installed');
			return;
		}
		Context::set('notifycraModule', $notifycraModule);
		
		// XMPP 접속 정보 보내기
		$xmpp_server_info = $oModuleModel->getModuleConfig('notifycra');
		Context::set('xmpp_server_info', $xmpp_server_info);
		
		// 모듈 설정사항 보내기
		
		$config = $oModuleModel->getModuleConfig('xewall');
		Context::set('module_config', $config);
		
		
		
		// 템플릿 파일 설정
		$this->setTemplateFile('xmpp_config');
	}
}
?>
