<?php
/**
 * @class  xewallAdminController
 * @author 바람꽃 (wndflwr@gmail.com)
 * @brief  xewall 모듈의 admin controller class
 **/

class xewallAdminController extends xewall {

	/**
	 * @brief 초기화
	 **/
	function init() {
	}
	
	
	/**
	 * @function procXewallAdminModuleConfig
	 * @brief 기본 모듈세팅 설정
	 */
	function procXewallAdminModuleConfig() {
		// 필요한 변수들 받기
		$module_srl = Context::get('module_srl');
		$args->mid = 'xewall';
		$args->module = 'xewall';
		$args->module_category_srl = Context::get('module_category_srl');
		$args->browser_title = Context::get('browser_title');
		$args->layout_srl = Context::get('layout_srl');
		$args->use_mobile = Context::get('use_mobile');
		$args->mlayout_srl = Context::get('mlayout_srl');
		$args->skin = Context::get('skin');
		$args->mskin = Context::get('mskin');
		$args->description = Context::get('description');
		$args->header_text = Context::get('header_text');
		$args->footer_text = Context::get('footer_text');
		
		$oModuleModel = &getModel('module');
		$oModuleController = &getController('module');
		
		$module_info = $oModuleModel->getModuleInfoByMid('xewall');
		
		// 정보가 있으면 업데이트, 없으면 신규 입력
		if ($module_info) {
			$args->module_srl = $module_info->module_srl;
			unset($output->mid);
			$output = $oModuleController->updateModule($args);
		}
		else {
			$output = $oModuleController->insertModule($args);
		}
		
		//$this->setRedirectUrl(getNotEncodedUrl('act', 'dispXewallAdminModuleSetup'));
		$this->setRedirectUrl(Context::get('success_return_url'));
		return true;
	}
	
	
	/**
	* @function procXewallAdminSaveModuleList
	* @brief 기본으로 듣는 게시판의 리스트들과 각 모듈에게 세팅이 된 설정값들을 저장한다.
	* 기본으로 듣는 게시판은 type="D" 이다.
	*/
	function procXewallAdminSaveModuleList() {
		// 데이터 받기 => array 변환
		$available_module_list = Context::get('available_module_list');
		$available_module_list = explode(',', $available_module_list);
		$default_module_list = Context::get('default_module_list');
		$default_module_list = explode(',', $default_module_list);
		
		// 빈 값이 들어왔을 때 그냥 array로 간다.
		if (!Context::get('available_module_list'))
			$available_module_list = array();
		if (!Context::get('default_module_list'))
			$default_module_list = array();
		
		// 관리자의 정보 받기
		$admin_info = Context::get('logged_info');
		
		// 각각 받은 데이터 DB에 저장 (type="D" || type="A" 인 모든 favourite 요소를 다 삭제 후 다시 삽입)
		$output = executeQuery('xewall.deleteFavouriteAorD', null);
		
		// DB에 저장 작업
		foreach($available_module_list as $val) {
			unset($args);
			$args->member_srl = 0;
			$args->target_srl = $val;
			$args->type = "A";
			$output = executeQuery('xewall.insertFavourite', $args);
			if (!$output->toBool()) {
				$this->setError(-1);
				$this->setMessage('msg_db_error');
				return $this;
			}
		}
		foreach($default_module_list as $val) {
			unset($args);
			$args->member_srl = 0;
			$args->target_srl = $val;
			$args->type = "D";
			$output = executeQuery('xewall.insertFavourite', $args);
			if (!$output->toBool()) {
				$this->setError(-1);
				$this->setMessage('msg_db_error');
				return $this;
			}
		}
		
		// 각 게시판들의 설정들을 저장한다.
		// 먼저 받은 데이터를 array 구조체로 해석
		$colors = Context::get('colors');
		$colors = explode('&', $colors);
		$module_info = array();
		foreach ($colors as $val) {
			$tmp = explode('=', $val);
			$module_info[$tmp[0]] = new stdClass();
			$module_info[$tmp[0]]->background_color = $tmp[1];
		}
		
		// 각각의 설정 정보를 serialize 시켜서 저장한다.
		unset($args);
		foreach ($module_info as $key => $val) {
			
			$args->module_srl = $key;
			$args->config = serialize($val);
			
			$output = executeQuery('xewall.deleteFavouriteConfig', $args);
			$output = executeQuery('xewall.insertFavouriteConfig', $args);
		}
	}
	
	
	/**
	 * @function procXewallAdminOrganizeBoard
	 * @brief 게시판 초기화
	 */
	function procXewallAdminInitBoard() {
		$output = executeQuery('xewall.deleteFavouriteAorD');
		
		$this->setError($output->error);
		$this->setMessage($output->message);
	}
	
	
	/**
	 * @function procXewallAdminInitBoardAll
	 * @brief 모든 게시판 초기화 (사용자들 꺼까지 완전히...)
	 */
	function procXewallAdminInitBoardAll() {
		$output = executeQuery('xewall.deleteFavouriteAll');
		
		$this->setError($output->error);
		$this->setMessage($output->message);
	}
	
	
	/**
	 * @function procXewallAdminSaveNavi
	 * @brief 네비게이션 관련 설정사항 저장
	 */
	function procXewallAdminSaveNavi() {
		$args->doc_sort_index = Context::get('doc_sort_index');
		$args->doc_order_type = Context::get('doc_order_type');
		$args->doc_list_count = Context::get('doc_list_count');
		
		// 유효성 검사
		try {
			$args->doc_list_count = intval($args->doc_list_count);
		} catch (Exception $e) {
			$args->doc_list_count = 10;
		}
		if ($args->doc_list_count < 1) {
			$args->doc_list_count = 10;
		}
		
		$oModuleModel = &getModel('module');
		$config = $oModuleModel->getModuleConfig('xewall');
		$config->doc_sort_index = $args->doc_sort_index;
		$config->doc_order_type = $args->doc_order_type;
		$config->doc_list_count = $args->doc_list_count;
		
		// 저장
		$oModuleController = &getController('module');
		$oModuleController->insertModuleConfig('xewall', $config);
		
	}
	
	/**
	 * @function procXewallAdminSaveEditor
	 * @brief 에디터 관련 설정 사항을 저장
	 */
	function procXewallAdminSaveEditor() {
		// 값 받기
		$args = Context::gets('allow_fileupload', 'enable_autosave', 'enable_default_component', 'enable_component', 'resizable', 'disable_html', 'height', 'skin');
		
		// 유효성 검사 ???
		try {
			$args->height = intval($args->height);
		} catch (Exception $e) {
			$args->height = 100;
		}
		
		$oModuleModel = &getModel('module');
		$config = $oModuleModel->getModuleConfig('xewall');
		
		$config->allow_fileupload = $args->allow_fileupload;
		$config->enable_autosave = $args->enable_autosave;
		$config->enable_default_component = $args->enable_default_component;
		$config->enable_component = $args->enable_component;
		$config->resizable = $args->resizable;
		$config->disable_html = $args->disable_html;
		$config->height = $args->height;
		$config->skin = $args->skin;
		
		// 값 저장
		$oModuleController = &getController('module');
		$oModuleController->insertModuleConfig('xewall', $config);
	}
	
	
	/**
	 * @function procXewallAdminSaveAction
	 * @brief 동작과 관련된 사항들을 저장한다.
	 */
	function procXewallAdminSaveAction() {
		$args = Context::gets('refresh_rate', 'doc_summary', 'doc_more', 'com_summary', 'com_more', 'check_login');
		
		$oModuleModel = &getModel('module');
		$config = $oModuleModel->getModuleConfig('xewall');
		
		$config->refresh_rate = $args->refresh_rate;
		$config->doc_summary = $args->doc_summary;
		$config->doc_more = $args->doc_more;
		$config->com_summary = $args->com_summary;
		$config->com_more = $args->com_more;
		$config->check_login = $args->check_login;
		
		$oModuleController = &getController('module');
		$oModuleController->insertModuleConfig('xewall', $config);
	}
	
	
	/**
	 * @function procXewallAdminUseXMPP
	 * @brief XMPP 사용할지 안할지 여부를 저장하는 버튼.
	 */
	function procXewallAdminUseXMPP() {
		$oModuleModel = &getModel('module');
		$oModuleController = &getController('module');
		$config = $oModuleModel->getModuleConfig('xewall');
		$status = Context::get('status');
		// XMPP 사용함으로 저장
		if ($status == 'true') {
			$config->use_xmpp = 'Y';
		}
		// XMPP 사용 안함으로 저장
		else {
			$config->use_xmpp = 'N';
		}
		$oModuleController->insertModuleConfig('xewall', $config);
	}
}
?>
