// 밖에서도 쓸 수 있는 함수 빼놓기
var Xewall = {
		functions: null,
		default_listen: null,
		default_listen_init: null
};

var documentList = new Array();

jQuery(function($) {
	/**
	 * 필요한 전역변수들 선언
	 */
	var page = 1;
	
	
	/**
	 * 문서의 모든 내용은 HTML DOM객체로 가지고 있음과 동시에 documentList 변수에도 함께 가지고 있는다.
	 */
	//var documentList = new Array();
	
	/**
	 * 상수 선언 CALL_TYPE
	 * 에디터를 부를 때 종류를 정의한다.
	 */
	var CALL_TYPE = {
			NEW_DOC : 0,	// 새로운 문서 만들 때
			MOD_DOC : 1,	// 문서 수정할 때
			NEW_COMM : 2,	// 새로운 댓글 만들 때
			MOD_COMM : 3,	// 댓글 수정할 때
			NEW_CCOMM : 4,	// 새로운 대댓글 만들 때
			MOD_CCOMM : 5	// 대댓글 수정할 때
	};
	
	/**
	 * 기본 함수 목록들을 모아둔다. => common functions
	 */
	var functions = {
			
			/**
			 * @param[int] document_srl
			 * @param[boolean] include_content = false: content도 함께 불러올 것인가 결정
			 * @brief document_srl에 해당하는 문서의 내용을 최신으로 업데이트 시킨다.
			 * (include_content == true)일 경우 content도 함께 불러온다.
			 * (include_content == false)일 경우 content는 불러오지 않는다. 
			 */
			refresh_document: function(document_srl, include_content) {
				
				var myCall = new MyMethodCall('xewall', 'getXewallDocument');
				myCall.addElement('document_srl', document_srl).addElement('include_content', include_content);
				myCall.callAjax(function(data, textStatus, xhr) {
					
					// 에러 확인
					var error = parseInt($(data).find('error:first').text());
					var message = $(data).find('message:first').text();
					if (error) {
						functions.showLogMsg(message);
						return;
					}
					
					// 문서에 내용 업데이트
					var doc = new Document();
					doc.setDocumentObj($(data).find('document:first'));
					
					// 문서가 존재하면 업데이트 없으면 신규삽입
					var $domObj = $('.document_srl_' + document_srl);
					if ($domObj.length) {
						// DOM 에 업데이트
						doc.setInfoToDomObj($domObj);
						
					} else {
						// 신규 삽입
						var $newDomObj = $('.dummies:first .document_ori');
						functions.insertDocument2DOM($newDomObj, 'sort');
					}
					
					// documentList에 삽입
					documentList[document_srl] = null;
					documentList[document_srl] = functions.get_object_vars(doc);
					
					// 메모리 해제
					$domObj = null;
					doc = null;
					
				}, function(xhr, textStatus){
					
					// 에러 메시지 출력
					functions.showLogMsg('Ajax Call Error : ' + textStatus);
					
				});
				myCall = null;
			},
			
			
			/**
			 * 새로고침을 눌렀을 때
			 * 서버에서 각 문서의 document_srl, last_update 정보를 불러온다.
			 * 그리고 메모리(documentList)에 있는 해당하는 document_srl의 last_update를 비교해서 차이가 있다면
			 * 해당 문서에 대한 정보를 따로 받아와서 업데이트를 실행한다.
			 * sample_com = 문서에서 샘플로 들고 올 댓글들
			 */
			refresh_document_list: function(listen, page, list_count, sample_com) {
				
				var myCall = new MyMethodCall('xewall', 'getXewallDocumentList');
				myCall.addElement('module_srl', listen);
				myCall.addElement('page', page);
				if (list_count) myCall.addElement('list_count', list_count);
				myCall.callAjax(function(data, textStatus, xhr) {
					
					var recv_page = parseInt($(data).children('response').children('page').text());
					var $documentList = $(data).children('response').children('documentList').children();
					// 불러져온 모든 document 정보를 html로 만들어서 문서에 삽입
					if (recv_page == 1)
						$documentList = $documentList.get().reverse();
					else
						$documentList = $documentList.get();
					$($documentList).each(function() {
						// documentList[받은 document_srl] 에 값이 존재하지 않을 경우만 실행
						var recv_document_srl = parseInt($(this).children('document_srl').text());
						if (typeof(documentList[recv_document_srl]) != 'undefined') return;
						
						// 더미를 복사
						var $document = $('.dummies:first .document_ori:first').clone(true);
						
						// 더미의 class 적절하게 만지기
						$document.removeClass('document_ori').addClass('document');
						
						// Document() 클래스를 이용하여 값 받고 적절한 값을 DOM에 삽입한 다음 문서에 삽입한다.
						var doc = new Document();
						doc.setDocumentObj($(this));
						doc.setInfoToDomObj($document);
						
						// 전역 array 에 삽입
						documentList[doc.document_srl] = functions.get_object_vars(doc);
						
						// 문서에 삽입
						/*
						if (recv_page == 1)
							$('div.xewall .list').prepend($document);
						else
							$('div.xewall .list').append($document);
						*/
						functions.insertDocument2DOM($document, 'sort');
						
						$document.fadeIn();
						
						// summary 박스의 크기를 조정한다.
						if ($document.find('.summary').height() < 100 && ($document.find('.thumbnail').length)) {
							$document.find('.summary').height(100);
						}
						
						// 각각의 document에 샘플 댓글 (3개)을 보이도록 하자. (마지막 페이지 계산하기)
						if (xewall.sample_comment_count) {
							var last_page = Math.ceil(doc.comment_count / xewall.sample_comment_count);
							functions.refresh_comment_list(doc.document_srl, xewall.sample_comment_count, last_page, true);
						}
						$document = null;
						doc = null;
					});
					
					$('div.xewall .loading').hide();
					
					// scroll 이벤트를 바인딩 시킨다.
					$(window).scroll(event_handler.onScroll);
					
					// refresh_freq 초기화
					xewall.refresh_freq_1 = xewall.refresh_freq_0;
					
				}, function(xhr, textStatus) {
					
					// 에러 메시지 출력
					functions.showLogMsg('Ajax Call Error : ' + textStatus);
					
					xewall.refresh_freq_1 = xewall.refresh_freq_0;
				});
				myCall = null;
				return false;
			},
			
			/**
			 * @param[int] document_srl
			 * @param[boolean] include_content = false : content도 함께 불러올 것인가 결정
			 */
			refresh_comment: function(comment_srl, include_content) {
				
				// 서버에 댓글 정보 요청
				var myCall = new MyMethodCall();
				myCall.setModule('xewall').setAct('getXewallComment');
				myCall.addElement('comment_srl', comment_srl);
				myCall.addElement('include_content', include_content);
				myCall.callAjax(function(data, textStatus, xhr) {
					// 에러가 있는지 확인한다.
					var error = parseInt($(data).find('error:first').text());
					var message = $(data).find('message:first').text();
					if (error) {
						functions.showLogMsg(message);
						return;
					}
					
					// 받은 데이터를 등록
					var comment = new Comment();
					
					// 받은 정보를 저장
					comment.setCommentObj($(data).find('comment'));
					
					// 사용자의 브라우저에 존재하지 않는 댓글이라면 댓글 삽입, 보이는 댓글이라면 업뎃
					if (documentList[comment.document_srl].comments[comment_srl]) {
						// 댓글 정보 업데이트
						var $comObj = $('.comment_srl_' + comment_srl);
						comment.setInfoToDomObj($comObj);
						$comObj = null;
						
					} else {
						// 댓글 정보 삽입
						var $comObj = $('.dummies:first .comment_ori').clone(true);
						comment.setInfoToDomObj($comObj);
						functions.insertComment2Document($comObj, comment.document_srl, 'sort');
						functions.clearOrphant(comment.document_srl);
						$comObj = null;
					}
					
					// documentList에 추가 / 업데이트? 덮어쓰기?
					documentList[comment.document_srl].comments[comment_srl] = null;
					documentList[comment.document_srl].comments[comment_srl] = functions.get_object_vars(comment);
					
					// 메모리에서 해제
					comment = null;
					
				}, function(xhr, textStatus) {
					
					// 에러 메시지 띄우기
					functions.showLogMsg('Ajax Call Error : ' + textStatus);
					
				}, true);
				
				myCall = null;
			},
			
			/**
			 * @param[int] document_srl
			 * @param[int] count : 몇 개로 짤라서 불러올 것인가?
			 * @param[int] page : 페이지?
			 * @brief 해당하는 document_srl을 받아서 해당하는 문서의 댓글리스트들을 refresh 시킨다.
			 */
			refresh_comment_list: function(document_srl, count, page, is_sample) {
				
				// 인자로 받은 변수들 정리
				if (!count) count = xewall.list_count_com;
				// page 정보가 없다면 마지막 페이지를 불러오면 된다.
				if (!page) {
					// 마지막 페이지 계산하기.
					// 이 문서의 전체 댓글 수를 구해서 count(list_count) 만큼 나누어서 반올림한다.
					var tot_comment_count = documentList[parseInt(document_srl)].comment_count;
					
					if (tot_comment_count <= count) {
						page = 1;
					} else {
						page = Math.ceil(tot_comment_count / count);
					}
				}
				
				// 서버에 댓글 리스트들 정보 요청
				var myCall = new MyMethodCall('xewall', 'getXewallCommentList');
				myCall.addElement('document_srl', document_srl);
				myCall.addElement('count', count);
				myCall.addElement('page', page);
				myCall.callAjax(function(data, textStatus, xhr) {
					
					// 불러와진 댓글 수가 0이면 취소.
					if ($(data).find('comments').children().length == 0) return false;
					
					// page_navigation 정보
					var page_navigation = $(data).find('page_navigation');
					
					// 각각의 코멘트들에 대하여
					var $comments = $(data).find('comments').children();
					$comments.each(function() {
						
						// Comment() 클래스를 이용해 처리한다.
						var comment = new Comment();
						
						// 받은 정보를 객체에 저장
						comment.setCommentObj($(this));
						
						// 문서에 추가시키는데 만약 존재하면 업데이트만 하기
						var $oriDOM = $('div.xewall .comment_srl_' + comment.comment_srl);
						if ($oriDOM.length) {
							// 업데이트
							comment.setInfoToDomObj($oriDOM);
						} else {
							// 신규 삽입
							var $newDOM = $('.dummies:first .comment_ori').clone(true);
							comment.setInfoToDomObj($newDOM);
							$newDOM.removeClass('comment_ori').addClass('comment');
							
							// sorting 하면서 삽입하기
							functions.insertComment2Document($newDOM, comment.document_srl, 'sort');
							functions.clearOrphant(comment.document_srl);
							
							$newDOM = null;
						}
						// 댓글 객체를 documentList에 추가시킨다.
						documentList[document_srl].comments[comment.comment_srl] = null;
						documentList[document_srl].comments[comment.comment_srl] = functions.get_object_vars(comment);
						
						comment = null;
					});
					
					
					// 삽입되어진 댓글의 갯수를 세어서 문서의 전체 댓글 수와 틀리면 댓글 더 보기 버튼을 나타내도록 한다.
					var cur_page = parseInt($(data).find('cur_page').text());
					var total_count = parseInt($(data).find('total_count').text());
					var first_page = parseInt($(data).find('first_page').text());
					
					// 샘플링이 아닐 경우 댓글 더 보기 + 댓글 페이지 정보를 기록
					var $more_page = $('div.xewall .document_srl_' + document_srl).find('.more_page');
					$more_page.attr('total_count', total_count);
					if (!is_sample) {
						$more_page.attr('total_page', $(data).find('total_page').text());
						$more_page.attr('cur_page', cur_page);
						$more_page.attr('page_count', $(data).find('page_count').text());
						$more_page.attr('first_page', first_page);
						$more_page.attr('last_page', $(data).find('last_page').text());
					}
					if (cur_page === first_page) {
						$more_page.hide();
					} else {
						$more_page.show();
					}
				
				}, function(xhr, textStatus) {
					
					console.log('Ajax Call Error' + textStatus);
					
				}, true);
				myCall = null;
			},
			
			
			/**
			 * @param[DOM Object] editorDOM
			 * @param[Object] ref
			 * 
			 * @param[int] ref.upload_target_srl
			 * @param[int] ref.document_srl
			 * @param[int] ref.comment_srl
			 * @param[int] ref.parent_srl
			 * 
			 * @param[String] editor_type : FULL || SIMPLE
			 * @param[String] content : 글을 쓰다가 에디터로 바꿀 경우 글의 내용을 content에 보존해서 넘겨주세요.
			 * @param[CALL_TYPE] call_type : 에디터 부르는 종류 (상수 CALL_TYPE 참조)
			 * @brief 에디터를 불러와서 해당 HTML DOM 객체에 적용시킨다.
			 * editorDOM 변수는 "editor" 를 class로 가지는 <div> 태그여야 하고 <form> 태그를 내포하고 있어야만 합니다.
			 */
			call_editor: function($editorDOM, ref, editor_type, content, call_type) {
				
				// editorDOM의 유효성 검사
				if (typeof($editorDOM) == 'undefined') return;
				if ($editorDOM.find('form').length == 0) return;
				if ($editorDOM.attr('class') != 'editor') return;
				
				if (call_type === null) return;
				
				// upload_target_srl == null 이라면 0으로 바꿔준다.
				if (ref.upload_target_srl === null || !ref.upload_target_srl) {
					ref.upload_target_srl = 0;
				}
				
				// 에디터를 불러와서 적용시킨다.
				var myCall = new MyMethodCall();
				myCall.setModule('xewall').setAct('getXewallEditor');
				myCall.addElement('upload_target_srl', ref.upload_target_srl);
				myCall.addElement('editor_type', editor_type);
				myCall.addElement('call_type', call_type);
				myCall.addElement('editor_sequence', $editorDOM.children('form:first').attr('editor_sequence'));
				myCall.callAjax(function(data, textStatus, xhr) {
					//  받은 데이터를 HTML 에 적용
					var editor = $(data).find('editor').text();
					
					// 버그있다. 버그. 버그 고치고 가자.
					// <!-- 여기서 --> 찾아서 모조리 지우기
					var textCopy = '';
					var length = editor.length;
					var start = 0;
					var end = 0;
					do {
						end = editor.indexOf('<!--', start);
						textCopy += editor.slice(start, end);
						start = editor.indexOf('-->', end) + 3;
					} while(end > -1);
					//textCopy += '>';
					editor = textCopy;
					
					// 원래 에디터에 내용이 있었다면 내용 제거 TODO
					// document_srl과 comment_srl을 제외한 모든 자식 요소들 제거
					$editorDOM.find('form').children().each(function() {
						var will_remove = true;
						var inputName = $(this).attr('name');
						if (inputName === 'document_srl') will_remove = false;
						else if (inputName === 'comment_srl') will_remove = false;
						else if (inputName === 'content') will_remove = false;
						else if (inputName === 'parent_srl') will_remove = false;
						else will_remove = true;
						if (will_remove)
							$(this).remove();
					});
					
					// editor_sequence 따내기
					var editor_sequence = $(data).find('upload_target_srl').text();
					
					// $editorDOM 의 editor_sequence 초기화
					$editorDOM.find('form').removeAttr('editor_sequence');
					
					// call_type에 따라 다른 action 취한다.
					switch (call_type) {
					// 새 문서를 만드는 것이라면 document_srl = 새로 할당받은 srl
					case CALL_TYPE.NEW_DOC:
						$editorDOM.find('input[name="document_srl"]').val(editor_sequence);
						$editorDOM.find('input[name="comment_srl"]').val('0');
						$editorDOM.find('input[name="parent_srl"]').val('0');
						$editorDOM.find('input[name="upload_target_srl"]').val('0');
						break;
					// 문서를 수정하는 경우라면 document_srl = parameter로 받은 srl
					case CALL_TYPE.MOD_DOC:
						$editorDOM.find('input[name="document_srl"]').val(ref.document_srl);
						$editorDOM.find('input[name="comment_srl"]').val('0');
						$editorDOM.find('input[name="parent_srl"]').val('0');
						$editorDOM.find('input[name="upload_target_srl"]').val('0');
						break;
					// 새 댓글을 다는 경우라면 document_srl = parameter로 받은 srl
					// comment_srl = 새로 할당받은 srl
					case CALL_TYPE.NEW_COMM:
						$editorDOM.find('input[name="document_srl"]').val(ref.document_srl);
						$editorDOM.find('input[name="comment_srl"]').val(editor_sequence);
						$editorDOM.find('input[name="parent_srl"]').val('0');
						$editorDOM.find('input[name="upload_target_srl"]').val('0');
						break;
					// 댓글을 수정하는 경우라면 document_srl = parameter 로 받은 srl
					// comment_srl = parameter로 받은 srl
					case CALL_TYPE.MOD_COMM:
						$editorDOM.find('input[name="document_srl"]').val(ref.document_srl);
						$editorDOM.find('input[name="comment_srl"]').val(ref.comment_srl);
						$editorDOM.find('input[name="parent_srl"]').val('0');
						$editorDOM.find('input[name="upload_target_srl"]').val('0');
						break;
					// 새로운 대댓글을 다는 경우라면 document_srl = parameter로 받은 srl
					// comment_srl = 새로 할당받은 srl
					// parent_srl = parameter로 받은 srl
					case CALL_TYPE.NEW_CCOMM:
						$editorDOM.find('input[name="document_srl"]').val(ref.document_srl);
						$editorDOM.find('input[name="comment_srl"]').val(editor_sequence);
						$editorDOM.find('input[name="parent_srl"]').val(ref.parent_srl);
						$editorDOM.find('input[name="upload_target_srl"]').val('0');
						break;
					// 대댓글을 수정하는 경우라면 document_srl = parameter로 받은 srl
					// comment_srl = parameter 로 받은 srl
					// parent_srl = parameter 로 받은 srl
					case CALL_TYPE.MOD_CCOMM:
						$editorDOM.find('input[name="document_srl"]').val(ref.document_srl);
						$editorDOM.find('input[name="comment_srl"]').val(ref.comment_srl);
						$editorDOM.find('input[name="parent_srl"]').val(ref.parent_srl);
						$editorDOM.find('input[name="upload_target_srl"]').val('0');
						break;
					default:
						break;
					}
					
					// content 가 존재하면 에디터에 content 추가
					$editorDOM.find('form').find('input[name="content"]').val(content);
					var iframe_contents = $editorDOM.find('iframe:first').contents();
					iframe_contents.find('body:first').html(content);
					
					// 삽입
					$editorDOM.find('form').append(editor);
					
					// 포커스 주기
					editorFocus(ref.upload_target_srl);
				}, function(xhr, textStatus) {
					console.log(xhr);
					console.log(textStatus);
				});
				myCall = null;
			},
			
			
			/**
			 * @function setCategoryList
			 * @brief module_srl을 받아서 select -> #board_category 의 내용을 설정한다.
			 */
			setCategoryList: function(module_srl) {
				var $board_category = $('#board_category');
				
				// 먼저 자식들 다 지우기
				$board_category.children().remove();
				
				if (!module_srl) {
					$board_category.hide();
					return;
				}
				
				// XE에 해당 모듈의 category list 를 받기 요청하기
				var mc = new MyMethodCall('xewall', 'getXewallCategoryList');
				mc.addElement('module_srl', module_srl);
				mc.callAjax(function(data) {
					var $items = $(data).find('category_list').children();
					var $category = $('#board_category');
					if (!$items.length) {
						$category.hide();
						$category.children().remove();
						return;
					}
					// 카테고리 선택 창을 보인다.
					$category.show();
					$items.each(function() {
						$category.append('<option value="' + $(this).find('category_srl').text() + '">' + $(this).find('title').text() + '</option>');
					});
				}, null, false);
			},
			
			
			/**
			 * @function setHeaderFooterText
			 * @brief module_srl을 받아서 게시판에 header_text 와 footer_text가 존재하는지 받아온다.
			 * 존재하면 머릿말, 꼬릿말 출력시키기
			 */
			setHeaderFooterText: function(module_srl) {
				if (!module_srl) {
					$('div.xewall .module_header_text').fadeOut();
					$('div.xewall .module_footer_text').fadeOut();
					return false;
				}
				
				var mc = new MyMethodCall('xewall', 'getXewallHeaderFooterText');
				mc.addElement('module_srl', module_srl);
				mc.callAjax(function(data) {
					var header_text = $(data).find('header_text').text();
					var footer_text = $(data).find('footer_text').text();
					if (!header_text) {
						$('div.xewall .module_header_text').fadeOut();
					} else {
						$('div.xewall .module_header_text').html(header_text).fadeIn();
					}
					if (!footer_text) {
						$('div.xewall .module_footer_text').fadeOut();
					} else {
						$('div.xewall .module_footer_text').html(footer_text).fadeIn();
					}
				});
			},
			
			showLogMsg: function(message) {
				var $log = $('#xewallLog').clone(true);
				$log.id = '';
				$log.addClass('xewall_new_log');
				
				$log.text(message);
				
				// 위치 잡기
				var xewallWidth = $('div.xewall').width();
				var position = $('div.xewall').offset();
				var top = position.top;
				if ($(window).scrollTop() > position.top)
					top = $(window).scrollTop() + 10;
				$log.css('top', top).css('left', xewallWidth - 300 + position.left);
				
				// 문서에 삽입
				$log.show('highlight', null, 500, null);
				$('body').append($log);
				
				// 5초 뒤 사라지게 만들기
				window.setTimeout(function() {
					$log.hide('pulsate', null, 500, function() {
						$(this).remove();
					});
				}, 5000);
			},
			
			
			/**
			 * @function clearOrphant
			 * @brief parent_srl은 있는데 parent에 들어있지 못하는 모든 자식들을 정리한다.
			 */
			clearOrphant: function(document_srl) {
				// 문서에 존재하는 모든 comment들에 대해서
				$('.document_srl_' + document_srl + ':first').find('.comment_box:first').children().each(function() {
					// parent_srl 뽑는다.
					var parent_srl = $(this).attr('parent_srl');
					if (!parent_srl) return true;
					
					// 부모를 못찾았다면 종료
					var $parent = $('.document_srl_' + document_srl + ':first').find('.comment_box:first').find('.comment_srl_' + parent_srl);
					if (!$parent.length) return true;
					
					// 찾은 부모에게 삽입하는데 역시 정렬해서 옮긴다.
					var inserted = false;
					var childRef = $(this);
					$stack = $parent.find('.comm_children:first');
					
					// $stack이 비어있다면 그냥 옮기기
					if (!$stack.children().length) {
						childRef.prependTo($stack);
						return true;
					}
					
					var orphant_srl = childRef.attr('comment_srl');
					
					// $stack이 비어있지 않다면 정렬해서 알맞은 위치로 옮긴다.
					$stack.children().each(function() {
						var comp_srl = $(this).attr('comment_srl');
						if (orphant_srl < comp_srl) {
							$(this).before(childRef);
							inserted = true;
							return false;
						}
					});
					
					// 삽입되지 않았다면 마지막으로 옮기기
					if (!inserted) {
						childRef.appendTo($stack);
						return true;
					}
				});
			},
			
			
			/**
			 * @function insertComment2Document
			 * @brief 해당 문서에 댓글을 삽입한다.
			 * @param opt: Object
			 * opt == 'top : 문서에 prepend() 시킨다.
			 * opt == 'bottom' : 문서에 append() 시킨다.
			 * opt == 'sort' : 문서 삽입시 sorting 하면서 삽입하기
			 */
			insertComment2Document: function($domObj, document_srl, opt) {
				// 정렬 하면서 삽입
				if (!opt || opt == 'sort') {
					// 필요한 값 뽑아내기
					var head = parseInt($domObj.attr('parent_srl'));
					var comment_srl = parseInt($domObj.attr('comment_srl'));
					
					// 이미 존재 한다면 DOM 정보를 업데이트 한다.
					if ($('.document_srl_' + document_srl + ':first').find('.comment_srl_' + comment_srl).length) {
						console.log(comment_srl + ' 이미 존재 한다면 DOM 정보를 업데이트 한다.');
						var $oldComment = $('.document_srl_' + document_srl + ':first').find('.comment_srl_' + comment_srl);
						$oldComment.after($domObj);
						$oldComment.remove();
						$oldComment = null;
						return;
					}
					
					// empty_stack 일 때 그냥 집어넣기
					if ($('.document_srl_' + document_srl + ':first').find('.comment').length === 0) {
						$('.document_srl_' + document_srl + ':first').find('.comment_box:first').append($domObj);
						return;
					}
					
					var inserted = false;
					
					// 집어넣고 정렬할 $stack 정하기
					var $stack = null;
					if (!head) {
						$stack = $('.document_srl_' + document_srl + ':first').children('.right').children('.comment_box');
					} else {
						$stack = $('.document_srl_' + document_srl + ':first').find('.comment_srl_' + head).children('.comm_right').children('.comm_children');
					}
					
					// 이제 $stack 안에서 정렬만 하면 된다.
					// $stack이 empty이면 그냥 집어넣기
					if (!$stack.length) {
						$stack.prepend($domObj);
						return true;
					}
					// $stack 안의 내용을 쭉 비교함.
					$stack.children().each(function() {
						var comp_srl = $(this).attr('comment_srl');
						if (comment_srl < comp_srl) {
							$(this).before($domObj);
							inserted = true;
							return false;
						}
					});
					// 끝까지 삽입되지 않았다면 마지막에 집어넣기
					if (!inserted) {
						$stack.append($domObj);
					}
					
					return;
					
				}
				
				// 하단에 삽입
				else if (opt == 'bottom') {
					$('.document_srl_' + document_srl + ':first').find('.comment_box:first').append($domObj);
				}
				
				// 상단에 삽입
				else if (opt == 'top') {
					$('.document_srl_' + document_srl + ':first').find('.comment_box:first').prepend($domObj);
				}	
			},
			
			
			/**
			 * @function insertDocument2DOM
			 * @brief 문서를 삽입한다.
			 * @param [DOMObject] $docObj : 삽입한 HTML DOM 객체
			 * @param [Object] opt : 옵션
			 * opt == 'top' : 최상단에 추가 (prepend)
			 * opt == 'bottom' : 최하단에 추가 (append)
			 * opt == 'sort' : 정렬하여 삽입
			 */
			insertDocument2DOM: function($docObj, opt) {
				// 정렬하여 삽입
				if (!opt || opt == 'sort') {
					var $stack = $('.xewall').children('.list:first');
					if (!$stack.children().length) {
						$stack.prepend($docObj);
						return true;
					}
					var inserted = false;
					var document_srl = $docObj.attr('document_srl');
					$stack.children().each(function() {
						var comp_srl = $(this).attr('document_srl');
						if (document_srl > comp_srl) {
							$(this).before($docObj);
							inserted = true;
							return false;
						}
					});
					
					if (!inserted) {
						$stack.append($docObj);
					}
					return true;
				}
				
				// 하단에 삽입
				else if (opt == 'bottom') {
					$('.xewall').children('.list:first').append($docObj);
				}
				
				//상단에 삽입
				else if (opt == 'top') {
					$('.xewall').children('.list:first').prepend($docObj);
				}
			},
			
			
			
			/**
			 * @function get_object_vars
			 * @brief PHP의 get_object_vars와 같다. Object를 받아서 Array로 돌려줌
			 * @param [Object]
			 * @return [Array]
			 */
			get_object_vars: function($object) {
				var result = new Array();
				for (var i in $object) {
					if (typeof($object[i]) !== 'function' && i !== 'prototype')
						result[i] = $object[i];
				}
				for (var i in $object.prototype) {
					if (typeof($object.prototype[i]) !== 'function')
						result[i] = $object.prototype[i];
				}
				return result;
			}
	};
	
	/**
	 * 이벤트 핸들러들을 모두 여기에다가 모아둔다.
	 */
	var event_handler = {
			
			
			/**
			 * 타이틀에 마우스 오른쪽을 클릭했으면 내가 정의한 메뉴 불러오기
			 */
			onTitleRightClick: function(event) {
				
				// 어떤 문서인지 확인
				var document_srl = $(this).parents('.document:first').attr('document_srl');
				// 팝업메뉴 띄우기
				// #popup_menu_area 를 body에 추가시키기
				$('#popup_menu_area').remove();
				$('body').append("<div id='popup_menu_area' style='display:none;z-index:999;'></div>");
				
				// dummy 얻어서 적절한 document_srl 정보를 기록한다.
				var $popDummy = $('.dummies:first .move_to').clone(true);
				$popDummy.find('.move_to').attr('document_srl', document_srl);
				$popDummy.find('.move_new').attr('document_srl', document_srl);
				
				// popup을 띄운다.
				var params = new Array();
				var ret_obj = new Array();
				ret_obj['menus'] = null;
				params['menu_id'] = 'xewall';
				params['page_x'] = event.pageX;
				params['page_y'] = event.pageY;
				XE.loaded_popup_menus['xewall'] = $popDummy.html();
				XE.displayPopupMenu(ret_obj, null, params);
				
				// 이벤트 추가
				$('#popup_menu_area .move_to').unbind('click');
				$('#popup_menu_area .move_to').click(function() {
					// 이동하기
					window.location = xewall.def_url + 'index.php?document_srl=' + document_srl;
				});
				$('#popup_menu_area .move_new').unbind('click');
				$('#popup_menu_area .move_new').click(function() {
					// 새 창으로 이동하기
					window.open(xewall.def_url + 'index.php?document_srl=' + document_srl, "_blank");
				});
				return false;
				
			},
			
			
			/**
			 * 요약을 클릭했을 때 문서 내용을 불러온다.
			 */
			onSummaryClick: function(event) {
				// 마우스 가운데 버튼이 눌러졌다면 해당 문서 페이지로 바로 이동
				if ((event.which == 2 || event.shiftKey || event.ctrlKey || event.metaKey) && $(this).hasClass('title')) {
					var document_srl = $(this).parents('.document:first').attr('document_srl');
					
					// 새 창 이동하기
					window.open(xewall.def_url + 'index.php?document_srl=' + document_srl, "_blank");
					return false;
				}
				
				// content가 열려있으면 숨기기. (툴팁 내용도 바꾸기)
				if ($(this).parent().parent().find('.content').css('display') != 'none') {
					$(this).parent().parent().find('.summary').show('clip', {}, 500, null);
					$(this).parent().parent().find('.thumbnail').show('clip', {}, 500, null);
					$(this).parent().parent().find('.content').hide('clip', {}, 500, null);
					$(this).parent().parent().find('.see_simple').hide();
					
					// 스크롤 자동으로 이동시키기
					var position = $(this).parent().parent().find('.title').offset()
					$('html, body').animate({scrollTop:position.top - 100}, 400);
					return;
				}
				
				// 문서 불러오고
				var document_srl = parseInt($(this).attr('document_srl'));
				functions.refresh_document(document_srl, true);
				
				// 요약 가리고 내용 보이고 툴팁 바꾸기
				var $content = $(this).parent().parent().find('.content:first');
				var $see_simple = $(this).parent().parent().find('.see_simple');
				$(this).parent().parent().find('.summary').hide('clip', {}, 200, function() {
					$content.show('slide', {}, 500, function() {
						$see_simple.fadeIn();
						
						// 문서 내의 이미지를 본문의 크기에 맞게 리사이징 하기.
						var contentWidth = $content.width();
						$content.find('img').each(function() {
							var imgWidth = $(this).width();
							var imgHeight = $(this).height();
							if (imgWidth > contentWidth) {
								$(this).width(contentWidth);
								$(this).height(parseInt(imgHeight * contentWidth / imgWidth));
							}
						});
					});
				});
				$(this).parent().parent().find('.thumbnail').hide('clip', {}, 200, null);
			},
			
			/**
			 * 스크롤을 했을 때 일어나는 이벤트
			 * 페이지의 마지막 부분까지 도달하면 다음 페이지를 불러온다.
			 */
			onScroll: function(event) {
				// 페이지의 마지막으로 스크롤 되면.
				if ($(window).scrollTop() + 10 >= $(document).height() - $(window).height()){
					// 중복으로 로딩이 되지 않도록 이벤트 언바인드 시키기
					$(window).unbind('scroll');
					$('div.xewall .loading').show();
					functions.refresh_document_list(Xewall.default_listen, ++page, xewall.list_count_doc);
				} else {
					return false;
				}
			},
			
			/**
			 * 간단히 글쓰기를 클릭했거나 최초 txt_area를 클릭했을 때
			 * txt_area가 존재하면 제거하고 editor_simple이 존재하면 제거하고
			 * editor_full 을 불러와서 삽입한다.
			 * 클래스 적용시키기
			 */
			onSimpleFormFocus: function(event) {
				var $editorDOM = $(this).parent().parent();
				var editor_type = 'SIMPLE';
				var content = $editorDOM.children('form:first').children('input[name="content"]').val();
				
				var document_srl = parseInt($editorDOM.find('input[name="document_srl"]').val());
				if (!document_srl) document_srl = 0;
				
				// 에디터 불러와서 출력하기
				// 새 글 쓰기: upload_target_srl, document_srl, comment_srl, parent_srl = 0
				var ref = {
						upload_target_srl:document_srl,
						document_srl:document_srl,
						comment_srl:0,
						parent_srl:0
				};
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.NEW_DOC);
				
				// 숨어있던 버튼들 보이기
				$editorDOM.siblings('.hidden_by_editor').show('slide', {direction:'up'}, 500);
				$editorDOM.siblings('.hidden_by_editor').find('.simple_form').removeClass('unselected').addClass('selected');
				$editorDOM.siblings('.hidden_by_editor').find('.use_editor').removeClass('selected').addClass('unselected');
				
				// 선택된 게시판의 카테고리 추가시킨다.
				var module_srl = $('#default_listen_array:selected').val();
				if (!module_srl) module_srl = $('#default_listen_array:first').val();
				
				// 카테고리 정보를 얻어서 출력
				functions.setCategoryList(module_srl);
				
			},
			
			
			/**
			 * 게시판이 선택이 될 때마다 해당 게시판의 category들을 로드해 와서 출력시킨다.
			 */
			onDefaultListenChange: function() {
				var module_srl = $(this).val();
				
				$('#board_category').children().remove();
				$('#board_category').hide();
				
				// 카테고리 정보를 얻어서 출력
				functions.setCategoryList(module_srl);
			},
			
			/**
			 * 에디터 사용하기를 클릭했을 때
			 * editor_full이 존재하면 제거하고
			 * editor_simple을 불러와서 삽입한다.
			 * 클래스 적용시키기
			 */
			onEditorClick: function(event) {
				// 클래스 적용시키기
				$(this).removeClass('unselected').addClass('selected');
				$(this).siblings('.simple_form').removeClass('selected').addClass('unselected');
				
				// 에디터 불러와서 적용
				var $editorDOM = $(this).parent().siblings('.editor:first');
				var editor_type = 'FULL';
				
				/*
				var $content = $editorDOM.find('iframe:first').contents();
				var content = $content.find('body:first').html();
				*/
				var editorSeq = $editorDOM.children('form:first').attr('editor_sequence');
				var content = editorGetContent(editorSeq);
				
				var document_srl = parseInt($editorDOM.find('input[name="document_srl"]').val());
				if (!document_srl) document_srl = 0;
				
				// 새 글 쓰기: document_srl, upload_target_srl, comment_srl, parent_srl = 0
				var ref = {
						upload_target_srl:document_srl,
						document_srl:document_srl,
						comment_srl:0,
						parent_srl:0
				};
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.NEW_DOC);
			},
			
			/**
			 * 간단히 글쓰기를 클릭했을 때
			 * 간단한 에디터를 불러와서 적용시킨다.
			 */
			onSimpleFormClick: function(event) {
				// 클래스 적용시키기
				$(this).removeClass('unselected').addClass('selected');
				$(this).siblings('.use_editor').removeClass('selected').addClass('unselected');
				
				// 에디터 불러와서 적용
				var $editorDOM = $(this).parent().siblings('.editor');
				var editor_type = 'SIMPLE';
				var $content = $editorDOM.find('iframe:first').contents();
				var content = $content.find('body:first').html();
				
				var document_srl = parseInt($editorDOM.find('input[name="document_srl"]').val());
				if (!document_srl) document_srl = 0;
				
				// 새 글 쓰기: upload_target_srl, document_srl, comment_srl, parent_srl = 0
				var ref = {
						upload_target_srl:document_srl,
						document_srl:document_srl,
						comment_srl:0,
						parent_srl:0
				};
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.NEW_DOC);
				
			},
			
			/**
			 * 게시 버튼을 클릭했을 때
			 */
			onSubmitClick: function(event) {
				// module_srl 이 없으면 취소
				var module_srl = $('div.xewall div.write_form select.default_listen_array').val();
				if (!module_srl) return;
				
				// title 얻기
				var title = $('div.xewall div.write_form input.doc_title').val();
				
				// Content 얻기
				var editorSeq = parseInt($(this).siblings('.editor').children('form:first').attr('editor_sequence'));
				var content = window.editorGetContent(editorSeq);
				
				// title 과 content 둘 다 없으면 글쓰기 취소로 알고 창 닫기
				if (!title && !content) {
					// 에디터 박스 지우기, 원래의 텍스트 박스 보이기
					$('div.xewall .write_form .editor form').children().each(function() {
						var will_remove = true;
						var inputName = $(this).attr('name');
						if (inputName == 'document_srl') will_remove = false;
						else if (inputName == 'comment_srl') will_remove = false;
						else if (inputName == 'content') will_remove = false;
						else if ($(this).attr('class') == 'txt_area') will_remove = false;
						else will_remove = true;
						if (will_remove) {
							// 에니메이션 효과와 같이 지우기
							var $that  = $(this);
							$(this).hide('slide', {direction:'up'}, 500, function() {
								$that.remove();
							});
						}
					});
					// 에디터 폼의 document_srl 과 comment_srl 등 모두 초기화
					var $editor_form = $('div.xewall .write_form .editor form');
					$editor_form.children('input[name="document_srl"]').val('');
					$editor_form.children('input[name="comment_srl"]').val('');
					$editor_form.children('input[name="content"]').val('');
					
					// content 값을 빈 값으로 만들어 주기
					$('div.xewall .write_form .hidden_by_editor').hide();
					$('div.xewall .write_form .hidden_by_editor .doc_title').val('');
					var txt_area = $('div.xewall .write_form .txt_area').clone(true);
					txt_area.css('display', 'block');
					$('div.xewall .write_form .editor form').append(txt_area);
					
					txt_area = null;
				}
				
				// title이 없으면 취소
				if (!title) {
					$('div.xewall div.write_form input.doc_title').focus();
					return;
				}
				
				// Content 얻은게 없으면 취소
				if (!content) {
					return;
				}
				
				// 게시 버튼 비활성화
				$(this).unbind('click');
				
				// 기다려 주세요... 로 변경
				$(this).text(xewall_lang.please_wait);
				
				// CSS를 기다림으로 변경
				$(this).removeClass('btn_submit_enabled');
				$(this).addClass('btn_submit_disabled');
				
				//var module_srl = $('div.xewall div.write_form select.default_listen_array').val();
				var category_srl = $('#board_category').val();
				//var title = $('div.xewall div.write_form input.doc_title').val();
				var document_srl = $(this).siblings('.editor:first').children('form:first').attr('editor_sequence');
				
				$('div.xewall .loading').show();
				var $that = $(this);
				
				var myCall = new MyMethodCall('xewall', 'procXewallInsertDocument');
				myCall.addElement('module_srl', module_srl);
				myCall.addElement('title', title);
				myCall.addCDATAElement('content', content);
				myCall.addElement('document_srl', document_srl);
				myCall.addElement('category_srl', category_srl);
				
				myCall.callAjax(function(data){
					// 에러 (게시판에 권한이 없거나 등등...) 라면 취소
					if (parseInt($(data).find('error').text())) {
						alert($(data).find('message').text());
						return;
					}
					alert($(data).find('message').text());
					// 에디터 박스 지우기, 원래의 텍스트 박스 보이기
					$('div.xewall .write_form .editor form').children().each(function() {
						var will_remove = true;
						var inputName = $(this).attr('name');
						if (inputName == 'document_srl') will_remove = false;
						else if (inputName == 'comment_srl') will_remove = false;
						else if (inputName == 'content') will_remove = false;
						else if ($(this).attr('class') == 'txt_area') will_remove = false;
						else will_remove = true;
						if (will_remove) {
							// 에니메이션 효과와 같이 지우기
							var $that  = $(this);
							$(this).hide('slide', {direction:'up'}, 500, function() {
								$that.remove();
							});
						}
					});
					// 에디터 폼의 document_srl 과 comment_srl 등 모두 초기화
					var $editor_form = $('div.xewall .write_form .editor form');
					$editor_form.children('input[name="document_srl"]').val('');
					$editor_form.children('input[name="comment_srl"]').val('');
					$editor_form.children('input[name="content"]').val('');
					
					// content 값을 빈 값으로 만들어 주기
					$('div.xewall .write_form .hidden_by_editor').hide();
					$('div.xewall .write_form .hidden_by_editor .doc_title').val('');
					var txt_area = $('div.xewall .write_form .txt_area').clone(true);
					txt_area.css('display', 'block');
					$('div.xewall .write_form .editor form').append(txt_area);
					
					txt_area = null;
					
					$('div.xewall .loading').hide();
					
					// 게시 버튼 활성화
					$that.bind('click', event_handler.onSubmitClick);
					
					// "게시" 로 변경
					$that.text(xewall_lang.write);
					
					// CSS를 기다림으로 변경
					$that.removeClass('btn_submit_disabled');
					$that.addClass('btn_submit_enabled');
					
					// 새로고침
					functions.refresh_document_list(Xewall.default_listen, 1, xewall.list_count_doc);
					
				}, function(a, b, c){
					$('div.xewall .loading').hide();
					
					// 게시 버튼 활성화
					$that.bind('click', event_handler.onSubmitClick);
					
					// "게시" 로 변경
					$that.text(xewall_lang.write);
					
					// CSS를 기다림으로 변경
					$that.removeClass('btn_submit_disabled');
					$that.addClass('btn_submit_enabled');
					
				}, true);
				myCall = null;
			},
			
			/**
			 * 추천 클릭했을 경우
			 * 만약에 내가 이 게시물에 추천을 했으면 추천 취소기능까지 구현하도록
			 */
			onVoteClick: function(event) {
				var document_srl = parseInt($(this).attr('document_srl'));
				var myCall = new MyMethodCall();
				myCall.setModule('xewall').setAct('procXewallDocumentVoteUp').addElement('target_srl', document_srl);
				myCall.callAjax(function(data){
					// 반환된 데이터를 DOM과 Array에 업데이트 시킨다.
					functions.refresh_document(document_srl, false);
				}, function(){
					// TODO 모든 alert을 console.log로 바꾸기
					alert('failed!');
				}, true);
				myCall = null;
			},
			
			/**
			 * 비추천을 클릭했을 경우
			 * 만약에 내가 이 게시물에 비추천을 했으면 비추천 취소기능까지 구현하도록 한다.
			 */
			onBlameClick: function(event) {
				var document_srl = $(this).attr('document_srl');
				var that = $(this);
				var myCall = new MyMethodCall();
				myCall.setModule('xewall').setAct('procXewallDocumentVoteDown').addElement('target_srl', document_srl);
				myCall.callAjax(function(data){
					// 반환된 데이터를 DOM과 Array에 업데이트 시킨다.
					functions.refresh_document(document_srl, false);
				}, function(){
					// TODO 모든 alert을 console.log로 바꾸기
					alert('failed!');
				}, true);
			},
			
			
			/**
			 * "삭제" 를 눌렀을 때 - "삭제하시겠습니까?" 보이기
			 */
			onDeleteClick: function(event) {
				// #popup_menu_area 를 body에 추가시키기
				$('#popup_menu_area').remove();
				$('body').append("<div id='popup_menu_area' style='display:none;z-index:999;'></div>");
				
				// document_srl 얻기
				var document_srl = $(this).attr('document_srl');
				
				// dummy 얻어서 적절한 document_srl 정보를 기록한다.
				var $popDummy = $('.dummies:first .delete_confirm').clone(true);
				$popDummy.find('.delete_confirm_yes').attr('document_srl', document_srl);
				
				// popup을 띄운다.
				var params = new Array();
				var ret_obj = new Array();
				ret_obj['menus'] = null;
				params['menu_id'] = 'xewall';
				params['page_x'] = event.pageX;
				params['page_y'] = event.pageY;
				XE.loaded_popup_menus['xewall'] = $popDummy.html();
				XE.displayPopupMenu(ret_obj, null, params);
				// 이벤트 추가 => 진짜로 삭제 누르면 서버에 삭제 요청을 보낼 수 있도록 이벤트 추가시킨다.
				$('#popup_menu_area .delete_confirm_yes').unbind('click');
				$('#popup_menu_area .delete_confirm_yes').click(event_handler.onDeleteConfirmYesClick);
				return false;
			},
			
			
			/**
			 * "삭제하시겠습니까?" 에서 "예"를 클릭했을 때 삭제 실행
			 */
			onDeleteConfirmYesClick: function() {
				var document_srl = $(this).attr('document_srl');
				
				var myCall = new MyMethodCall('xewall', 'procXewallDeleteDocument');
				myCall.addElement('document_srl', document_srl);
				myCall.callAjax(function(data, textStatus, xhr) {
					console.log(data);
					// 실패시 취소
					if (parseInt($(data).find('error'))) return;
					// 성공시 documentList에서 문서 제거, 그리고 HTML 요소 제거
					documentList[document_srl] = null;
					
					// 사라지는 효과 적용
					$('.document_srl_' + document_srl).hide('slide', {direction:'up'}, 1000, function() {
						$('.document_srl_' + document_srl).remove();
					})					
				}, function(xhr, textStatus) {
					console.log(textStatus);
				}, false);
				myCall = null;
			},
			
			
			/**
			 * "수정" 버튼을 눌렀을 때 - content 가리고
			 * modify_form을 보여준 다음 여기에 에디터 불러와서 수정 내용 넣기
			 * 그리고 화면 자동으로 스크롤 해주기
			 */
			onModifyClick: function(event) {
				var document_srl = $(this).attr('document_srl');
				var module_srl = $(this).attr('module_srl');
				var $modify_form = $('div.xewall .document_srl_' + document_srl + ' .right .middle .modify_form');
				var content = '';
				
				if (!document_srl || !module_srl) return;
				
				// 수정 전의 content 불러오기
				var myCall = new MyMethodCall('xewall', 'getXewallDocumentContent');
				myCall.addElement('document_srl', document_srl);
				myCall.callAjax(function(data, textStatus, xhr) {
					content = $(data).find('content').text();
				}, function(xhr, textStatus) {
					content = '';
				}, false);
				myCall = null;
				
				// 에디터 불러와서 출력
				var $editorDOM = $modify_form.find('.editor:first');
				var editor_type = 'FULL';
				
				// 문서 수정: document_srl, upload_target_srl 필요 (document_srl = upload_target_srl)
				var ref = {
						document_srl: document_srl,
						upload_target_srl: document_srl,
						comment_srl: 0,
						parent_srl:0
				};
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.MOD_COMM);
				$modify_form.fadeIn();
				
				// content, summary, thumbnail 가리기
				$modify_form.siblings('.thumbnail').hide();
				$modify_form.siblings('.summary').hide();
				$modify_form.siblings('.content').hide();
				$modify_form.siblings('.clear').hide();
				
				// title의 내용을 옮겨 적기
				$modify_form.parent().siblings('.title').hide();
				$modify_form.parent().parent().find('.modify_title').val(documentList[document_srl].title);
				
				// 스크롤 자동으로 이동시키기
				var position = $('.document_srl_' + document_srl).offset();
				$('html, body').animate({scrollTop:position.top - 10}, 400);
				return;
			},
			
			
			/**
			 * 진짜 "수정" (go_modify)를 눌렀을 때 실제로 수정하기
			 */
			onGoModifyClick: function() {
				// content 얻기
				var editor_seq = $(this).siblings('form').attr('editor_sequence');
				var content = window.editorGetContent(editor_seq);
				
				// 얻어진 content가 없으면 취소
				if (!content) return;
				
				var title = $(this).siblings('.modify_title').val();
				//return false;
				var document_srl = $(this).attr('document_srl');
				var module_srl = $(this).attr('module_srl');
				
				// 서버에 변경된 내용 보내기
				var myCall = new MyMethodCall('xewall', 'procXewallInsertDocument');
				
				myCall.addElement('document_srl', document_srl).addElement('module_srl', module_srl).addCDATAElement('content', content).addElement('title', title);
				myCall.callAjax(function(data, textStatus, xhr) {
					// 그냥 해당 문서 정보 업데이트 시킨다.
					functions.refresh_document(document_srl, true);
				}, function(xhr, textStatus) {
					
				}, false);
				myCall = null;
				
				// 필요한 엘리먼트들을 보이고 가리고...
				var $docObj = $('.document_srl_' + document_srl);
				$docObj.find('.thumbnail').show();
				$docObj.find('.summary').show();
				$docObj.find('.content').hide();
				$docObj.find('.see_simple').hide();
				$docObj.find('.title').show();
				$docObj.find('.clear').show();
				$docObj.find('.modify_form').hide('slide', {direction:'up'}, 300);
				
				// 스크롤
				var position = $('.document_srl_' + document_srl).offset();
				$('html, body').animate({scrollTop:position.top - 100}, 400);
				
				$(this).parent().removeAttr('editor_sequence');
				$(this).siblings('input[name="document_srl"]').val('');
				$(this).siblings('input[name="content"]').val('');
				$(this).siblings('.editor').children().remove();
			},
			
			
			/**
			 * 수정 "취소" 버튼을 눌렀을 때 에디터 없애고 summary, thumbnail등 보이기
			 */
			onCancelModifyClick: function() {
				// 확인창 띄우기
				if (!confirm(xewall_lang.confirm_cancel)) return;
				
				$(this).parent().parent().siblings('.thumbnail').show();
				$(this).parent().parent().siblings('.summary').show();
				$(this).parent().parent().siblings('.content').hide();
				$(this).parent().parent().siblings('.see_simple').hide();
				$(this).parent().parent().parent().siblings('.title').show();
				$(this).parent().parent().siblings('.clear').show();
				
				// 애니메이션 효과 주기
				$(this).parent().parent().hide('slide', {direction:'up'}, 300);
				
				// 스크롤 자동으로 이동시키기
				var document_srl = $(this).parents('.document').attr('document_srl');
				var position = $('.document_srl_' + document_srl).offset();
				$('html, body').animate({scrollTop:position.top - 100}, 400);
				return;
			},
			
			/**
			 * 수정시 "에디터 사용하기" 버튼을 눌렀을 때 (토글로 에디터를 보였다가 간단히 글쓰기를 보였다가 한다.)
			 */
			/*
			onUseEditorToggle: function() {
				// 에디터 사용하기일 때 에디터 불러옴
				var $editorDOM = $(this).parent();
				var document_srl = $(this).siblings('form').find('input[name="document_srl"]').val();
				var editor_type = $(this).attr('state');
				var content = $(this).siblings('form').children('input[name="content"]').val();
				
				// 문서 수정: document_srl, upload_target_srl 필요. document_srl = upload_target_srl
				var ref = {
						upload_target_srl: document_srl,
						document_srl: document_srl,
						comment_srl:0,
						parent_srl:0
				};
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.MOD_COMM);
				if ($(this).attr('state') == 'FULL') {
					$(this).attr('state', 'SIMPLE');
					$(this).val($(this).attr('lang_simple'));
				} else {
					$(this).attr('state', 'FULL');
					$(this).val($(this).attr('lang_use_editor'));
				}
			},
			*/
			
			
			/**
			 * 댓글 버튼을 눌렀을 때 댓글들의 리스트들을 불러와서 출력시킨다.
			 */
			onLeaveCommentClick: function(event) {
				var document_srl = $(this).attr('document_srl');
				
				// 댓글 창이 토글링 된다.
				var $comment_box = $('.document_srl_' + document_srl).find('.comment_box');
				if ($comment_box.css('display') != 'block') {
					var total_comment_cnt = $comment_box.find('.comment').length;
					var real_total = parseInt($comment_box.prev().attr('total_count'));
					if (total_comment_cnt < real_total)
						$comment_box.prev().show('slide', {direction:'up'}, 500, null);
					$comment_box.show('slide', {direction:'up'}, 500, null);
				} else {
					$comment_box.prev().hide('slide', {direction:'up'}, 500, null);
					$comment_box.hide('slide', {direction:'up'}, 500, null);
				}
				return;
			},
			
			
			/**
			 * 댓글 더 불러오기를 클릭했을 때 이전 페이지의 댓글들을 불러온다.
			 */
			onMorePageClick: function() {
				// 지금껏 불러왔던 댓글 리스트들의 페이지 정보 얻기
				var total_count = parseInt($(this).attr('total_count'));
				var total_page = parseInt($(this).attr('total_page'));
				var cur_page = parseInt($(this).attr('cur_page'));
				var page_count = parseInt($(this).attr('page_count'));
				var first_page = parseInt($(this).attr('first_page'));
				var last_page = parseInt($(this).attr('last_page'));
				
				var document_srl = $(this).parents('.document:first').attr('document_srl');
				var pg = 0;
				var count = xewall.list_count_com * 2;
				
				// -1 값이 있다면 최초 로딩임. 마지막 페이지를 계산해서 넘기기
				if (cur_page < 0) {
					pg = Math.ceil(total_count / count);
					functions.refresh_comment_list(document_srl, count, pg, false);
				} else {
					functions.refresh_comment_list(document_srl, count, cur_page - 1, false);
				}
				
			},
			
			
			/**
			 * 댓글의 summary를 클릭하면 댓글의 content를 불러오고 summary를 가린다.
			 */
			onCommContentClick: function() {
				var comment_srl = parseInt($(this).attr('comment_srl'));
				var document_srl = parseInt($(this).attr('document_srl'));
				var myCall = new MyMethodCall('xewall', 'getXewallComment');
				myCall.addElement('comment_srl', comment_srl).addElement('include_content', true);
				//myCall.addElement('include_content', true);
				myCall.callAjax(function(data, textStatus, xhr) {
					// documentList에 저장
					documentList[document_srl].comments[comment_srl].setCommentObj($(data).find('comment'));
					
					// HTML DOM 에 내역 반영
					var $commentDOM = $('.comment_srl_' + comment_srl);
					documentList[document_srl].comments[comment_srl].setInfoToDomObj($commentDOM);
					
					// summary 가리고 content 보이기
					// 에니메이션 효과 적용
					var $comm = $('.comment_srl_' + comment_srl);
					var $summary = $comm.find('.comm_summary');
					var $content = $comm.find('.comm_content');
					var $see_summary = $comm.find('.comm_see_summary');
					
					$summary.hide('slide', {direction:'up'}, 500, function() {
						$content.show('slide', {direction:'down'}, 500, null);
						$see_summary.show('slide', {direction:'down'}, 500, null);
					});
					
				}, function(xhr, textStatus) {
					console.log(textStatus);
				});
				myCall = null;
			},
			
			/**
			 * 댓글 내용 자세히 보기 했을 때 "간단히 보기"를 클릭했을 경우 내용을 가리고 요약과 "더 보기"을 보여준다.
			 */
			onCommSeeSummaryClick: function() {
				var $see_simple = $(this);
				var $content = $(this).siblings('.comm_content');
				var $summary = $(this).siblings('.comm_summary');
				
				$see_simple.hide();
				$content.hide('slide', {direction:'up'}, 500, function() {
					$summary.show('slide', {direction:'down'}, 500);
				});	
			},
			
			/**
			 * 댓글 쓰기를 클릭했을 때, "댓글을 입력하세요..." 내용 지우기
			 */
			onCommentWriteClick: function() {
				$(this).val('');
			},
			
			/**
			 * 댓글 쓰는 창에서 엔터키를 눌렀을 때 댓글 전송을 하도록 한다.
			 */
			/*
			onCommentKeyUp: function(event) {
				// 엔터키를 눌렀을 때 댓글 전송
				if (event.keyCode == 13) {
					// 댓글 전송
					//event_handler.onCommentSubmitClick();
				}
				// 엔터키가 아니라면 키가 눌러진 것으로 간주하고 에디터의 내용이 변경 되었음을 알린다.
				else {
					$(this).attr('changed', 'true');
				}
			},
			*/
			
			
			/**
			 * 댓글 쓰기(전송)을 눌렀을 때 댓글의 내용을 서버로 전송시킨다.
			 */
			onCommentSubmitClick: function() {
				// 게시버튼 비활성화
				$(this).unbind('click');
				var $that = $(this);
				
				// TODO 기다려 주세요... 아이콘 만들기...
				
				var content = null;
				var document_srl = $(this).attr('document_srl');
				var module_srl = $(this).attr('module_srl');
				var comment_srl = 0;
				
				// 먼저 .class_write 텍스트 박스가 활성화 되어있는지 확인해서 텍스트 박스에서 데이터를 들고오느냐, 에디터에서 들고오느냐 결정
				if ($(this).siblings('.editor').find('.comment_write').length) {
					// 텍스트박스에서 불러오기
					content = $(this).siblings('.editor:first').find('.comment_write').val();
					var tmp = content.split('\n');
					content = tmp.join('<br/>');
					
					// 원래 텍스트 박스 안에 있던 내용 지우기
					$(this).siblings('.editor:first').find('.comment_write').val('');
				} else {
					// 에디터에서 불러오기
					var editorSeq = $(this).siblings('.editor').children('form:first').attr('editor_sequence');
					content = editorGetContent(editorSeq);
					comment_srl = $(this).siblings('.editor:first').find('input[name="comment_srl"]:first').val();
				}
				var $comment_write = $(this).siblings('.editor:first').children('form:first').children('input.comment_write');
				// 만약 보내는 데이터가 없으면 텍스트 박스에 포커스를 주고 취소시켜서 서버와 통신 취소
				if ($comment_write.attr('changed') === 'false') {
					$comment_write.val($comment_write.attr('default_value'));
					$comment_write.focus();
					return false;
				}
				
				// 댓글 내용을 서버에 전송한다.
				var myCall = new MyMethodCall('xewall', 'procXewallInsertComment');
				myCall.addElement('is_new', 'true');
				myCall.addElement('comment_srl', comment_srl);
				myCall.addElement('document_srl', document_srl);
				myCall.addElement('module_srl', module_srl);
				myCall.addCDATAElement('content', content);
				myCall.callAjax(function(data) {
					// 이벤트 재활성화
					$that.bind('click', event_handler.onCommentSubmitClick);
					
					// 에러일 경우 취소
					var error = parseInt($(data).find('error:first').text());
					var message = $(data).find('message:first').text();
					if (error) {
						// 메시지 창 띄우기
						functions.showLogMsg(message);
						return;
					}
					// 새로 삽입된 댓글 문서에 추가하기
					var comment = new Comment();
					comment.setCommentObj($(data).find('comment:first'));
					var $newComDOM = $('.dummies:first').children('.comment_ori').clone(true);
					comment.setInfoToDomObj($newComDOM);
					
					// sorting 하면서 삽입하기
					functions.insertComment2Document($newComDOM, document_srl, 'sort');
					functions.clearOrphant(document_srl);
					
					// 페이지 자동 스크롤 하기
					var position = $newComDOM.offset();
					$('html, body').animate({scrollTop:position.top - 100}, 400);
					
					// 메모리 해제 
					comment = null;
					$newComDom = null;
					
				}, function(xhr, textStatus) {
					// 메시지 창 띄우기
					functions.showLogMsg('Ajax Call Error' + textStatus);
					
					// 이벤트 재활성화
					$that.bind('click', event_handler.onCommentSubmitClick);
					
				}, false);
				
				myCall = null;
				
				// 댓글 창 원위치
				$(this).siblings('.editor').find('.comment_write').val($(this).siblings('.comment_write').attr('default_value'));
				
				// "에디터 사용" 버튼 다시 활성화
				$(this).siblings('.comment_use_editor').show();
				
				// 그리고 에디터 창 닫기 (에니매이션 효과)
				var $that = $(this).siblings('.editor');
				$that.hide('slide', {direction:'up'}, 500, function() {
					$that.remove();
				});
				
				// 에디터 기본 폼 추가
				var $newEditor = $('.document_ori .right .comment_write_form .editor').clone(true);
				$(this).parent().prepend($newEditor);
				$newEditor = null;
			},
			
			/**
			 * 댓글의 "에디터 사용"을 클릭했을 때
			 * 에디터를 불러와서 기존의 댓글 창을 없애고 에디터로 교체.
			 */
			onCommentUseEditorClick: function() {
				var $editorDOM = $(this).siblings('.editor:first');
				var $content = null;
				var content = null;
				var isCommentWrite = $editorDOM.find('.comment_write:first').length;
				// 새 댓글 달기: document_srl만 필요
				var document_srl = $(this).attr('document_srl');
				// Simple Editor 에서 Editor 로 넘어가기
				if (isCommentWrite) {
					// 원래 내용 유지시키기
					content = $editorDOM.find('.comment_write:first').val();
					var tmp = content.split('\n');
					content = tmp.join('<br/>');
					
					// 에디터 불러오기
					var ref = {
							upload_target_srl:0,
							document_srl:document_srl,
							comment_srl:0,
							parent_srl:0
					};
					functions.call_editor($editorDOM, ref, 'FULL', content, CALL_TYPE.NEW_COMM);
					
					// 스크롤 이동
					var position = $editorDOM.offset()
					$('html, body').animate({scrollTop:position.top - 100}, 400);
					
					// 버튼 없애기
					$(this).hide();
				}
				else {
					return false;
				}
			},
			
			
			/**
			 * 댓글의 "삭제"을 클릭했을 때 삭제 확인 창을 띄우기 comm_delete
			 */
			onCommentDeleteClick: function(event) {
				// 먼저 #popup_menu_area body에 추가시키기
				$('#popup_menu_area').remove();
				$('body').append("<div id='popup_menu_area' style='display:none;z-index:999;'></div>");
				
				// comment_srl, document_srl 얻기
				var comment_srl = $(this).attr('comment_srl');
				var document_srl = $(this).attr('document_srl');
				
				// confirm 창 더미 복사하고 알맞은 comment_srl 값 기록하기
				var $delDummy = $('.dummies:first .delete_confirm').clone(true);
				$delDummy.find('.delete_confirm_yes').attr('comment_srl', comment_srl).attr('document_srl', document_srl);
				
				// popup menu 출력
				var params = new Array();
				var ret_obj = new Array();
				ret_obj['menus'] = null;
				params['menu_id'] = 'xewall';
				params['page_x'] = event.pageX;
				params['page_y'] = event.pageY;
				XE.loaded_popup_menus['xewall'] = $delDummy.html();
				XE.displayPopupMenu(ret_obj, null, params);
				
				// 이벤트 추가 => 진짜로 삭제 누르면 서버에 삭제 요청을 보낼 수 있도록 이벤트 추가시킨다.
				$('#popup_menu_area .delete_confirm_yes').unbind('click');
				$('#popup_menu_area .delete_confirm_yes').click(event_handler.onCommentGoDeleteClick);
				return false;
			},
			
			/**
			 * 댓글의 삭제 확인 창에서 진짜 "삭제"를 눌렀을 때 서버에 삭제 요청을 보낸다.
			 */
			onCommentGoDeleteClick: function() {
				var comment_srl = $(this).attr('comment_srl');
				var document_srl = $(this).attr('document_srl');
				var myCall = new MyMethodCall('xewall', 'procXewallDeleteComment');
				myCall.addElement('comment_srl', comment_srl);
				myCall.callAjax(function(data) {
					// 사라지는 효과를 보이도록 한다.
					$('.comment_srl_' + comment_srl).hide('slide', {direction:'up'}, 500, function() {
						
						// 재로딩이 아닌 해당 댓글을 삭제하는 것으로 한다.
						$('.comment_srl_' + comment_srl).remove();
					});
				}, function() {
					console.log(data);
				}, false);
				myCall = null;
			},
			
			/**
			 * 댓글의 추천을 눌렀을 경우 서버에 추천 요청을 보낸다.
			 */
			onCommentVoteUp: function() {
				var comment_srl = $(this).attr('comment_srl');
				var myCall = new MyMethodCall();
				myCall.setModule('xewall').setAct('procXewallVoteComment').addElement('target_srl', comment_srl);
				myCall.callAjax(function(data, textStatus, xhr) {
					functions.refresh_comment(comment_srl, false);
				}, function(xhr, textStatus) {
					console.log(textStatus);
				}, true);
				myCall = null;
			},
			
			/**
			 * 댓글의 비추를 눌렀을 경우 서버에 비추 요청을 보낸다.
			 */
			onCommentVoteDown: function() {
				var comment_srl = $(this).attr('comment_srl');
				var myCall = new MyMethodCall();
				myCall.setModule('xewall').setAct('procXewallBlameComment').addElement('target_srl', comment_srl);
				myCall.callAjax(function(data, textStatus, xhr) {
					functions.refresh_comment(comment_srl, false);
				}, function(xhr, textStatus) {
					console.log(textStatus);
				}, true);
				myCall = null;
			},
			
			
			/**
			 * 댓글의 수정을 눌렀을 때 수정 창을 보여준다.
			 */
			onCommentModify: function() {
				
				var comment_srl = $(this).attr('comment_srl');
				var document_srl = $(this).attr('document_srl');
				var $editorDOM = $('.comment_srl_' + comment_srl).find('.editor:first');
				var content = '';
				
				// 수정 전의 content 불러오기
				if (documentList[document_srl].comments[comment_srl].content == null) {
					functions.refresh_comment(comment_srl, true);
				}
				content = documentList[document_srl].comments[comment_srl].content;
				// 댓글의 수정 document_srl, comment_srl, parent_srl 이 필요. parent_srl = 0, upload_target_srl = comment_srl
				var ref = {
						upload_target_srl: comment_srl,
						document_srl: document_srl,
						comment_srl: comment_srl,
						parent_srl: 0
				};
				functions.call_editor($editorDOM, ref, 'FULL', content, CALL_TYPE.MOD_COMM);
				
				$editorDOM.show();
				$editorDOM.siblings('.comm_summary').hide();
				$editorDOM.siblings('.comm_content').hide();
				$editorDOM.siblings('.comm_see_summary').hide();
			},
			
			
			/**
			 * 댓글 수정창에서 "수청"을 눌렀을 경우 에디터의 내용을 서버에 보내어 댓글을 수정시킨다.
			 */
			onCommentGoModify: function() {
				var $editorDOM = $(this).parent();
				var document_srl = $(this).siblings('form').find('input[name="document_srl"]:first').val();
				var comment_srl = $(this).siblings('form').find('input[name="comment_srl"]:first').val();
				
				// 내용 얻기
				var editor_seq = $editorDOM.children('form:first').attr('editor_sequence');
				var content = window.editorGetContent(editor_seq);
				
				// 내용 얻은게 없으면 취소
				if (!content) return;
				
				// 게시 버튼 비활성화
				$(this).unbind('click');
				var $that = $(this);
				
				var myCall = new MyMethodCall('xewall', 'procXewallInsertComment');
				myCall.addElement('comment_srl', comment_srl);
				myCall.addElement('document_srl', document_srl);
				myCall.addCDATAElement('content', content);
				myCall.callAjax(function(data, textStatus, xhr) {
					
					// 에러일 경우 메시지 표시 후 종료
					var error = parseInt($(data).find('error:first').text());
					var message = $(data).find('message:first').text();
					if (error) {
						functions.showLogMsg(message);
						
						return;
					}
					
					// 수정된 내용을 Document에 반영한다.
					var comment = new Comment();
					comment.setCommentObj($(data).find('comment:first'));
					// 수정이니까 depth가 날라오지 않는다. 그러므로 원래의 depth를 사용하도록 한다.
					comment.depth = documentList[document_srl].comments[comment_srl].depth;
					var $domObj = $('.comment_srl_' + comment_srl);
					comment.setInfoToDomObj($domObj);
					
					// documentList에도 반영한다.
					documentList[document_srl].comments[comment_srl] = null;
					documentList[document_srl].comments[comment_srl] = functions.get_object_vars(comment);
					
					comment = null;
					
					// 자동 스크롤
					var position = $('.comment_srl_' + comment_srl).offset();
					$('html, body').animate({scrollTop:position.top - 100}, 400);
					
				}, function(xhr, textStatus) {
					
					// 에러 메지시 띄우기
					functions.showLogMsg('Ajax call Error : ' + textStatus);
					
				}, false);
				myCall = null;
				
				$editorDOM.siblings('.comm_summary').hide();
				$editorDOM.siblings('.comm_content').show();
				$editorDOM.siblings('.comm_see_summary').show();
				$editorDOM.hide();
				
				// 게시 버튼 다시 활성화
				$that.bind('click', event_handler.onCommentGoModify);
				
			},
			
			
			
			/**
			 * 댓글 수정창에서 "에디터 사용"을 눌렀을 경우 FULL 에디터를 불러와서 적용
			 */
			/*
			onComentUseEditor: function() {
				var $editorDOM = $(this).parent();
				var document_srl = $editorDOM.find('input[name="document_srl"]:first').val();
				var comment_srl = $editorDOM.find('input[name="comment_srl"]:first').val();
				var parent_srl = $editorDOM.find('input[name="parent_srl"]:first').val();
				var ref = {
						document_srl:document_srl,
						comment_srl:comment_srl,
						parent_srl:parent_srl,
						upload_target_srl:comment_srl
				};
				
				var editor_type = "FULL";
				var $content = $editorDOM.find('iframe:first').contents();
				var content = $content.find('body:first').html();
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.MOD_COMM);
				
				// "에디터 사용" 버튼 숨기기
				$(this).hide();
			},
			*/
			
			
			/**
			 * 댓글 수정창에서 취소를 눌렀을 경우 에디터를 숨기고 summary와 content를 보이도록 한다.
			 */
			onComentCancelModify: function() {
				// 확인 창으로 확인하기
				if (!confirm(xewall_lang.confirm_cancel)) return;
				
				var $editorDOM = $(this).parent();
				$editorDOM.siblings('.comm_summary').hide();
				$editorDOM.siblings('.comm_content').show();
				$editorDOM.siblings('.comm_see_summary').show();
				$editorDOM.hide('slide', {direction:'up'}, 1000);
				$editorDOM = null;
				
				// "에디터 사용" 버튼 보이기
				$(this).siblings('.use_editor').show();
				
				// 자동 스크롤
				var comment_srl = $(this).parents('.comment').attr('comment_srl');
				var position = $('.comment_srl_' + comment_srl).offset();
				$('html, body').animate({scrollTop:position.top - 100}, 400);
			},
			
			
			/**
			 * 댓글에 "댓글달기" 버튼을 눌렀을 때 댓글 달기 창을 보여주도록 한다.
			 */
			onComentReply: function() {
				var $comm_reply_box = $(this).parent().siblings('.comm_reply_box');
				// 댓글 달기 창 보였다가 가렸다가 토글하기
				if ($comm_reply_box.css('display') == 'none') {
					var $editorDOM = $comm_reply_box.children('.editor:first');
					var document_srl = $(this).attr('document_srl');
					var comment_srl = $(this).attr('parent_srl');
					var upload_target_srl = 0;
					var editor_type = 'SIMPLE';
					var content = '';
					$comm_reply_box.fadeIn();
					// 새 대댓글 달기: document_srl, parent_srl 필요. upload_target_srl = 0
					var ref = {
							upload_target_srl:0,
							document_srl: document_srl,
							comment_srl:0,
							parent_srl: comment_srl
					};
					functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.NEW_CCOMM);
				} else {
					$comm_reply_box.fadeOut();
					// "에디터 사용" 버튼 보이기
					$comm_reply_box.children('.editor:first').children('.use_editor:first').show();
				}
			}, 
			
			
			/**
			 * 댓글 달기 창에서 취소를 눌렀을 때 에디터를 가린다.
			 */
			onComentReplyCancelModify: function() {
				var $comm_reply_box = $(this).parent().parent();
				$comm_reply_box.fadeOut();
				// "에디터 사용" 버튼 다시 보이기
				$(this).siblings('.use_editor').show();
			},
			
			
			/**
			 * 댓글 달기 창에서 "에디터 사용"을 눌렀을 때 FULL 에디터를 불러오고 버튼 없애기
			 */
			onCommentReplyUseEditor: function() {
				var $editorDOM = $(this).parent();
				var document_srl = $editorDOM.find('input[name="document_srl"]:first').val();
				var comment_srl = $editorDOM.find('input[name="comment_srl"]:first').val();
				var parent_srl = $editorDOM.find('input[name="parent_srl"]:first').val();
				var ref = {
						document_srl:document_srl,
						comment_srl:comment_srl,
						parent_srl:parent_srl,
						upload_target_srl:comment_srl
				};
				var editor_type = "FULL";
				
				var editorSeq = $editorDOM.children('form:first').attr('editor_sequence');
				var content = editorGetContent(editorSeq);
				
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.NEW_CCOMM);
				
				// 자동 스크롤 하기
				var position = $editorDOM.offset()
				$('html, body').animate({scrollTop:position.top - 100}, 400);
				
				// "에디터 사용" 버튼 제거
				$(this).hide();
			},
			
			
			/**
			 * 대댓글 달기 창에서 "전송"을 눌렀을 때 에디터의 내용을 서버에 전송하고 댓글 창 리프레쉬 시킨다.
			 */
			onCommentReplyGoModify: function() {
				// 필요 정보 얻기.
				var $editorDOM = $(this).parent();
				var document_srl = $editorDOM.find('input[name="document_srl"]:first').val();
				var comment_srl = $editorDOM.find('input[name="comment_srl"]:first').val();
				var parent_srl = $editorDOM.find('input[name="parent_srl"]:first').val();
				
				var $that = $(this);
				
				// 내용 얻기
				var editor_seq = $editorDOM.children('form').attr('editor_sequence');
				var content = window.editorGetContent(editor_seq);
				
				// 보낼 내용이 없으면 취소
				if (!content) return;
				
				// 게시버튼 비활성화
				$(this).unbind('click');
				
				// 요청.
				var myCall = new MyMethodCall('xewall', 'procXewallInsertComment');
				myCall.addElement('is_new', 'true');
				myCall.addElement('document_srl', document_srl);
				myCall.addElement('comment_srl', comment_srl);
				myCall.addElement('parent_srl', parent_srl);
				myCall.addCDATAElement('content', content);
				myCall.callAjax(function(data, textStatus, xhr) {
					// 에러인지 아닌지 확인
					var error = parseInt($(data).find('error:first').text());
					var message = $(data).find('message:first').text();
					if (error) {
						functions.showLogMsg(message);
						return;
					}
					
					// 새로 삽입 
					var comment = new Comment();
					comment.setCommentObj($(data).find('comment:first'));
					var $domObj = $('.comment_ori').clone(true);
					comment.setInfoToDomObj($domObj);
					functions.insertComment2Document($domObj, document_srl, 'sort');
					functions.clearOrphant(document_srl);
					
					// documentList 에 삽입
					documentList[document_srl].comments[comment_srl] = null;
					documentList[document_srl].comments[comment_srl] = functions.get_object_vars(comment);
					comment = null;
					$domObj = null;
					
					
				}, function(xhr, textStatus) {
					
					// 에러 메지시 띄우기
					functions.showLogMsg(textStatus);
					
				}, false);

				myCall = null;
				
				// 게시버튼 다시 활성화
				$that.bind('click', event_handler.onCommentReplyGoModify);
				
				// 수정 창 가리기
				$('.comment_srl_' + parent_srl).find('.comm_reply_box').hide();
				
				// 자동 스크롤
				var position = $('.comment_srl_' + comment_srl).offset();
				$('html, body').animate({scrollTop:position.top - 100}, 400);
			},
			
			
			/**
			 * 게시판을 선택했을 때 (버튼으로 표현된 게시판을 눌렀을 때)
			 */
			onBoardListClick: function(evt) {
				// 클릭된 게시판의 value 가 무엇인지 파악한다.
				var module_srl = parseInt($(this).attr('value'));
				if (!module_srl) {
					module_srl = $(this).parents('.document:first').attr('module_srl');
				}
				
				// 만약 설정 버튼이라면 실행하지 않는다.
				if (module_srl == 2 || module_srl == 3) {
					return true;
				}
				
				// 기다려 주세요... 아이콘 보이기
				$('.loading').show();
				
				// 스크롤 이벤트 언바인드 시키기 (로딩 도중 다음 페이지가 로딩 되지 않도록 한다..)
				$(window).unbind('scroll');
				
				// 전역변수 default_listen 설정
				if (module_srl == 1) {
					Xewall.default_listen = Xewall.default_listen_init;
					functions.setCategoryList(null);
					functions.setHeaderFooterText(null);
				}
				// Shift, Control, Meta key를 눌러 다중 선택을 하고자 했을 때
				else if (evt.shiftKey || evt.ctrlKey || evt.metaKey) {
					//var tmpSet = new Array();
					var tmpArr = Xewall.default_listen + '';
					tmpArr = tmpArr.split(',');
					
					if ($.inArray(module_srl + '', tmpArr) < 0)
						tmpArr.push(module_srl);
					
					Xewall.default_listen = tmpArr.join(',');
				}
				else {
					Xewall.default_listen = module_srl;
					// 클릭된 게시판을 .default_listen_array 에 적용시킨다.
					$('.default_listen_array').children().each(function() {
						if (module_srl == this.value) {
							$(this).attr('selected', 'selected');
						} else {
							$(this).removeAttr('selected');
						}
					});
					// #board_category의 내용 업데이트 한다.
					functions.setCategoryList(module_srl);
					
					// 각 게시판의 머릿말과 꼬릿말을 출력한다.
					functions.setHeaderFooterText(module_srl);
				}
				
				// 페이지 초기화
				page = 1;
				
				// documentList 변수 초기화 TODO 생각하기: 이 변수 계속 사용할 것인지??? 괜히 더 복잡해지는 것 같다.
				documentList = null;
				documentList = new Array();
				
				// HTML 요소들 제거
				$('.document').remove();
				
				// 재로딩
				functions.refresh_document_list(Xewall.default_listen, page, xewall.list_count_doc);
				
				// 클릭된 버튼의 색깔 토글 시키기
				// 모든 li에 대해서...
				// 게시판 버튼들의 색깔도 관리자가 맞춰놓은 색으로 바꿔주기
				$('li.default_listen_array, li.my_module_list').each(function() {
					if (module_srl == $(this).attr('value')) {
						$(this).css('background-color', 'white');
						$(this).children('a').css('border-color', '#6d6d6d');
					}
					else {
						$(this).css('background-color', '#' + xewall.colors[$(this).attr('value')]);
						$(this).children('a').css('border-color', 'silver');
					}
				});
				
				$('.loading').show();
				
				// <a> 태그의 내용이 실행되지 않도록 막기
				return false;
			},
			dummy: 0
	};
	
	/**
	 * 페이지 로딩 완료시
	 * 최근 문서 목록을 불러온다. (xewall.model.php로 요청)
	 */
	$(document).ready(function() {
		
		// 전역변수 초기화
		Xewall.default_listen = $('div.xewall').attr('default_listen');
		Xewall.default_listen_init = Xewall.default_listen;
		
		page = 1;
		$('div.xewall').removeAttr('default_listen');
		
		// 새로 고침 주기를 할당한다. 매 초마다 카운트 가감하고 0이 되면 새로고침 => 카운트 원위치
		// 만약에 notifycra 와 연동되어 있다면 새로고침 대신 $presence() 를 보내도록 해야한다.
		setInterval(function() {
			if (--xewall.refresh_freq_1 === 0) {
				// xmpp가 사용중이 아닐 경우 새로고침
				if (xewall.use_xmpp != 'Y') {
					functions.refresh_document_list(Xewall.default_listen, 1, page * xewall.list_count_doc);
				}
				// xmpp가 사용중일 경우 $pres() 스탠자 날리기
				else {
					xewallFunc.sendPres();
				}
				xewall.refresh_freq_1 = xewall.refresh_freq_0;
			}
		}, 1000);
		
		// 게시판 버튼들의 색깔도 관리자가 맞춰놓은 색으로 바꿔주기
		$('li.default_listen_array, li.my_module_list').each(function() {
			var module_srl = $(this).attr('value');
			$(this).css('background-color', '#' + xewall.colors[module_srl]);
		});
		
		
		// 이벤트 할당
		// 새로고침을 눌렀을 때
		$('div.xewall .refresh').click(function() {
			functions.refresh_document_list(Xewall.default_listen, 1, page * xewall.list_count_doc);
		});
		
		
		// 간단히 글쓰기를 클릭했을 때 간단한 에디터를 불러와 출력
		$('div.xewall .write_form .txt_area').click(event_handler.onSimpleFormFocus);
		
		// 행여나 제목 쓰다가 엔터 눌렀을 때 submit 안되도록 한다.
		$('div.xewall form').submit(function() {return false;});
		
		// 에디터 사용 글쓰기를 클릭했을 때 에디터를 불러와 출력(기존의 간단 에디터 제거)
		$('div.xewall .write_form .use_editor').click(event_handler.onEditorClick);
		
		// 게시판이 선택이 될 때마다 해당 게시판의 category들을 로드해 와서 출력시킨다.
		$('#default_listen_array').change(event_handler.onDefaultListenChange);
		
		// "간단히 글쓰기" 를 클릭했을 때 간단한 에디터를 불러와서 출력
		$('div.xewall .write_form .simple_form').click(event_handler.onSimpleFormClick);
		
		// 에디터에서 글을 다 쓰고 "게시" 버튼을 클릭했을 때 정보를 서버에 보내기
		$('div.xewall .write_form .btn_submit').click(event_handler.onSubmitClick);
		
		// 타이틀을, 또는 thumbnail을 눌렀을 때 summary와 thumbnail을 가리고 content를 보여주자.
		$('.document_ori .title .title').click(event_handler.onSummaryClick);
		$('.document_ori .middle .thumbnail').click(event_handler.onSummaryClick);
		$('.document_ori .middle .summary').click(event_handler.onSummaryClick);
		$('.document_ori .middle .see_simple').click(event_handler.onSummaryClick);
		
		// 타이틀을 우클릭 했을 때 서브메뉴 띄우기 => 게시물로 이동 기능
		$('.document_ori .title .title').bind('contextmenu', event_handler.onTitleRightClick);
		
		// 브라우저 제목(타이틀)을 눌렀을 때 눌러진 게시판을 기준으로 재정렬 하도록 한다.
		$('.document_ori .browser_title').click(event_handler.onBoardListClick);
		
		// 추천을 눌렀을 때
		$('.document_ori .right .bottom .voted_count').click(event_handler.onVoteClick);
		
		// 비추를 눌렀을 때
		$('.document_ori .right .bottom .blamed_count').click(event_handler.onBlameClick);
		
		// 삭제를 눌렀을 때 - 일단 "삭제하시겠습니까?
		$('.document_ori .right .bottom .delete').click(event_handler.onDeleteClick);
		
		// "수정" 버튼을 눌렀을 때 - content 가리고 modify_form을 보여준 다음 여기에 에디터 불러와서 수정 내용 넣기
		$('.document_ori .right .bottom .modify').click(event_handler.onModifyClick);
		
		// 진짜 "수정" (go_modify)를 눌렀을 때 실제로 수정하기
		$('.document_ori .right .middle .go_modify').click(event_handler.onGoModifyClick);
		
		// 수정 "취소" 버튼을 눌렀을 때 에디터 없애고 summary, thumbnail등 보이기
		$('.document_ori .right .middle .cancel_modify').click(event_handler.onCancelModifyClick);
		
		// 수정시 "에디터 사용하기" 버튼을 눌렀을 때 (토글로 에디터를 보였다가 간단히 글쓰기를 보였다가 한다.)
		//$('.document_ori .right .middle .use_editor').click(event_handler.onUseEditorToggle);
		
		// 댓글 쓰기을 눌렀을 때 댓글 리스트 불러오기(토글)
		$('.document_ori .right .bottom .leave_comment').click(event_handler.onLeaveCommentClick);
		
		// 댓글 더 불러오기를 눌렀을 때 댓글 더 불러오기
		$('.document_ori .right .more_page').click(event_handler.onMorePageClick);
		
		// 댓글의 summary를 눌렀을 때 summary는 가리고 content를 보인다.
		$('.comment_ori .comm_summary').click(event_handler.onCommContentClick);
		
		// 댓글 내용 "간단히 보기"를 클릭했을 경우 내용을 가리고 요약을 보여준다.
		$('.comment_ori .comm_see_summary').click(event_handler.onCommSeeSummaryClick);
		
		// 댓글 창에서 엔터를 눌렀을 때 댓글 내용 전송
		//$('.document_ori .right .comment_write_form .comment_write').keyup(event_handler.onCommentKeyUp);
		
		// 댓글 쓰기 창을 클릭했을 때 "댓글을 입력하세요..." 메시지 없애기
		$('.document_ori .right .comment_write_form .comment_write').click(event_handler.onCommentWriteClick);
		
		// 댓글 달기 버튼을 클릭했을 때 댓글의 내용을 서버에 전송해서 댓글을 달고 삽입된 내용/업데이트 된 내용을 반영한다.
		$('.document_ori .right .comment_write_form .comment_submit').click(event_handler.onCommentSubmitClick);
		
		// 댓글 쓰기에서 "에디터 사용"을 클릭했을 때 에디터를 불러와 배치하기
		$('.document_ori .right .comment_write_form .comment_use_editor').click(event_handler.onCommentUseEditorClick);
		
		// 댓글의 "삭제"을 클릭했을 때 삭제 확인 창을 띄우기
		$('.comment_ori .comm_right .comm_bottom .comm_delete').click(event_handler.onCommentDeleteClick);
		
		// 댓글의 추천을 눌렀을 때 추천을 실행한다.
		$('.comment_ori .comm_right .comm_bottom .comm_voted_count').click(event_handler.onCommentVoteUp);
		
		// 댓글의 비추를 눌렀을 때 비추를 실행한다.
		$('.comment_ori .comm_right .comm_bottom .comm_blamed_count').click(event_handler.onCommentVoteDown);
		
		// 댓글의 수정을 눌렀을 때 수정 창을 보여준다.
		$('.comment_ori .comm_right .comm_bottom .comm_modify').click(event_handler.onCommentModify);
		
		// 댓글 수정창에서 "수청"을 눌렀을 경우 에디터의 내용을 서버에 보내어 댓글을 수정시킨다.
		$('.comment_ori .comm_right .comm_middle .editor .go_modify').click(event_handler.onCommentGoModify);
		
		// 댓글 수정창에서 "에디터 사용"을 눌렀을 경우 에디터를 FULL 에디터로 불러온다.
		//$('.comment_ori .comm_right .comm_middle .editor .use_editor').click(event_handler.onComentUseEditor);
		
		// 댓글 수정창에서 취소를 눌렀을 경우 에디터를 숨기고 summary와 content를 보이도록 한다.
		$('.comment_ori .comm_right .comm_middle .editor .cancel_modify').click(event_handler.onComentCancelModify);
		
		// 댓글에 "댓글달기" 버튼을 눌렀을 때 댓글 달기 창을 보여주도록 한다.
		$('.comment_ori .comm_right .comm_bottom .comm_reply').click(event_handler.onComentReply);
		
		// 대댓글 달기 창에서 "취소"를 눌렀을 때 에디터를 가린다.
		$('.comment_ori .comm_right .comm_reply_box .editor .cancel_modify').click(event_handler.onComentReplyCancelModify);
		
		// 대댓글 달기 창에서 "에디터 사용"을 눌렀을 때 에디터를 보여준다.
		$('.comment_ori .comm_right .comm_reply_box .editor .use_editor').click(event_handler.onCommentReplyUseEditor);
		
		// 대댓글 달기 창에서 "전송" 을 눌렀을 때 에디터의 내용을 서버에 전송시키고 댓글 창 리프레쉬 시킨다.
		$('.comment_ori .comm_right .comm_reply_box .editor .go_modify').click(event_handler.onCommentReplyGoModify);
		
		// browser_title 을 클릭했을 때 자바스크립트로 막아주고 마우스 가운데 버튼으로 클릭하면 창이 뜨도록 하기.
		$('.document_ori .right .top .browser_title').click(function() {return false;});
		
		// 게시판을 선택했을 때
		$('div.xewall .board_list_box .board_list_ul li').click(event_handler.onBoardListClick);
		
		// 테스트
		$('.test').click(function() {
			console.log(Xewall.default_listen);
		});
		
		// 문서 목록 불러오기
		functions.refresh_document_list(Xewall.default_listen_init, page, xewall.list_count_doc);
		
		// 함수 빼기
		Xewall.functions = functions;
		
	});
});