var xewallConn = null;

var xewallFunc = {
		sendPres: null
};

jQuery(function($) {
	
	var connected = false;
	var msgHandler = null;
	var functions = {
			// 접속
			connect: function(jabber_id, jabber_pw) {
				var server_str = '';
				xewallConn = null;
				
				// localhost 로 접속할 경우
				if (CONNINFO.server === '127.0.0.1' || CONNINFO.server.toLowerCase() === 'localhost') {
					server_str = '/' + CONNINFO.http_bind;
				}
				// localhost 가 아닌 곳으로 접속할 경우 port, path까지 넣기
				else {
					server_str = CONNINFO.server + ':' + CONNINFO.http_binding_port + '/' + CONNINFO.http_bind;
				}
				
				// 접속 아이디 파악
				var con_jid = jabber_id + '@' + CONNINFO.server_name;
				
				xewallConn = new Strophe.Connection(server_str);
				xewallConn.connect(con_jid, jabber_pw, function(status) {
					console.log(status);
					if (status === Strophe.Status.CONNECTED) {
						// presence 를 보낸다.
						xewallConn.send($pres());
						
						connected = true;
						var src = $('#blinker_green').attr('src');
						$('.blinker').attr('src', src).attr('title', xewall_lang.xmpp_connected);
					}
					// 연결 실패 시 트리거 실행
					else if (status === Strophe.Status.CONNFAIL || status === Strophe.Status.AUTHFAIL) {
						var src = $('#blinker_red').attr('src');
						$('.blinker').attr('src', src).attr('title', xewall_lang.xmpp_disconnected);
						connected = false;
					}
					// 접속중 상황을 보여준다.
					else if (status === Strophe.Status.CONNECTING) {
						var src = $('#blinker_yellow').attr('src');
						$('.blinker').attr('src', src).attr('title', xewall_lang.xmpp_connecting);
					}
					// 인증중 상황을 보여준다.
					else if (status === Strophe.Status.AUTHENTICATING) {
						var src = $('#blinker_yellow').attr('src');
						$('.blinker').attr('src', src).attr('title', xewall_lang.xmpp_connecting);
					}
				});
			},
			
			// 접속정보 얻어내기
			getJabberId: function() {
				var mc = new MyMethodCall('notifycra', 'getNotifycraJabberUserPass');
				mc.callAjax(function(data) {
					// 접속
					var jabber_id = $(data).find('jabber_id').text();
					var jabber_pw = $(data).find('jabber_pw').text();
					if (!jabber_id) {
						use_xmpp = 'N';
						console.log('This user is not registered to XMPP server. Please contact site administrator...');
						return;
					}
					functions.connect(jabber_id, jabber_pw);
				}, function(textStatus, xhr) {
					console.log(textStatus);
				}, false);
			},
			
			
			// $pres() 데이터를 날린다.
			sendPres: function() {
				xewallConn.send($pres());
			}
	};
	
	var event_handler = {
			// 새로운 댓글 삽입
			new_comment: function(iq) {
				// 해당 문서의 댓글 창을 새로고침 한다.
				var document_srl = $(iq).find('document_srl').text();
				if (documentList[document_srl])
					Xewall.functions.refresh_comment_list(document_srl);
				
				// 알림 창을 띄운다.
				// iq에서 정보 빼내기
				var summary = $(iq).find('summary').text();
				var member_srl = $(iq).find('member_srl').text();
				var user_id = $(iq).find('user_id').text();
				var user_name = $(iq).find('user_name').text();
				var nick_name = $(iq).find('nick_name').text();
				var comment_srl = $(iq).find('comment_srl').text();
				var parent_srl = $(iq).find('parent_srl').text();
				var profile_image = $(iq).find('profile_image').text();
				var published = $(iq).find('published').text();
				
				// DOM object 복사
				var $inform = $('#xewallInform').clone(true);
				
				// 알맞은 정보 집어넣기
				if (profile_image)
					$inform.find('.profile_img').children('img').attr('src', profile_image).attr('alt', nick_name);
				$inform.find('.nick_name').text(nick_name).addClass('member_' + member_srl);
				$inform.find('.where').text('게시물');
				$inform.find('.what').text('댓글');
				$inform.find('.xewallInform_body').text(summary);
				
				// 날짜 계산
				$inform.find('.tail').text(
						published.substr(0, 4) + '-' +
						published.substr(4, 2) + '-' +
						published.substr(6, 2) + ' ' +
						published.substr(8, 2) + ':' + 
						published.substr(10, 2) + ':' +
						published.substr(12, 2)
				);
				
				// 새로운 class 부여하고 ID 삭제
				$inform.addClass('xewall_new_inform');
				$inform.id = '';
				
				// 위치 잡기
				var xewallWidth = $('div.xewall').width();
				var position = $('div.xewall').offset();
				var top = position.top;
				if ($(window).scrollTop() > position.top)
					top = $(window).scrollTop() + 10;
				$inform.css('top', top).css('left', xewallWidth - 300 + position.left);
				
				// 문서 삽입
				$inform.show();
				$('body').append($inform);
				
				// 사라지게 만들기.
				$(document).trigger('hide_inform');
				
				return true;
			},
			
			
			
			
			// 새로운 문서 삽입
			new_doc: function(iq) {
				// 정보 뽑아내기
				var title = $(iq).find('title').text();
				var summary = $(iq).find('summary').text();
				var member_srl = $(iq).find('member_srl').text();
				var user_id = $(iq).find('user_id').text();
				var user_name = $(iq).find('user_name').text();
				var nick_name = $(iq).find('nick_name').text();
				var document_srl = $(iq).find('document_srl').text();
				var module_srl = $(iq).find('module_srl').text();
				var browser_title = $(iq).find('browser_title').text();
				var profile_image = $(iq).find('profile_image').text();
				var published = $(iq).find('published').text();
				
				// 새로 추가된 문서가 지금 출력되고 있는 게시판에 속한 것인지 아닌지 판단.
				// 속해 있다면 새로운 문서를 띄워야 할 것이고 속해있지 않다면 알림창만 띄워야 한다.
				var tmp_arr = Xewall.default_listen.toString();
				tmp_arr = tmp_arr.split(",");
				var is_displayed = false;
				for (var i in tmp_arr) {
					if (tmp_arr[i] == module_srl) {
						is_displayed = true;
						break;
					}
				}
				// 지금 새로 들어온 문서의 게시판이 출력이 되는 상태라면... => 문서를 새로 띄우기
				if (is_displayed) {
					// 그냥 짧게 새로고침 하기.
					Xewall.functions.refresh_document_list(Xewall.default_listen, 1, 3);
				}
				// 새로 들어온 문서의 게시판이 출력이 되지 않고 있는 상태라면... => 알림창만 띄우기
				else {
					// DOM object 복사
					var $inform = $('#xewallInform').clone(true);
					
					// 알맞은 정보 집어넣기
					if (profile_image)
						$inform.find('.profile_img').children('img').attr('src', profile_image).attr('alt', nick_name);
					$inform.find('.nick_name').text(nick_name).addClass('member_' + member_srl);
					$inform.find('.where').text(browser_title);
					$inform.find('.what').text('게시물');
					$inform.find('.xewallInform_body').text(summary);
					
					// 날짜 계산
					$inform.find('.tail').text(
							published.substr(0, 4) + '-' +
							published.substr(4, 2) + '-' +
							published.substr(6, 2) + ' ' +
							published.substr(8, 2) + ':' + 
							published.substr(10, 2) + ':' +
							published.substr(12, 2)
					);
					
					// 새로운 class 부여하고 ID 삭제
					$inform.addClass('xewall_new_inform');
					$inform.id = '';
					
					// 위치 잡기
					var xewallWidth = $('div.xewall').width();
					var position = $('div.xewall').offset();
					var top = position.top;
					if ($(window).scrollTop() > position.top)
						top = $(window).scrollTop() + 10;
					$inform.css('top', top).css('left', xewallWidth - 300 + position.left);
					
					// 문서 삽입
					$inform.show();
					$('body').append($inform);
					
					// 사라지게 만들기.
					$(document).trigger('hide_inform');
				}
				return true;
				
			},
			// message 스탠자를 받았을 때
			message: function(iq) {
				// iq 분석
				var mtype = $(iq).find('mtype').text();
				// mtype에 따라서 다른 action을 취한다.
				// 새로운 문서일 때
				if (mtype === 'new_doc') {
					event_handler.new_doc(iq);
					return true;
				}
				// 새로운 댓글을 때
				else if (mtype === 'new_comment') {
					event_handler.new_comment(iq);
					return true;
				}
				//
				//else if () {
				//	
				//}
				return true;
			}
	};
	
	// 문서 로딩 완료시
	$(document).ready(function() {
		// JabberID를 XE에서 받아오고 XMPP 서버에 접속
		// getJabberId()->(chain)->connect()
		functions.getJabberId();
		
		// 들어오는 모든 xmpp 스탠자에 대하여 이벤트 핸들러 등록
		if (use_xmpp == 'Y') {
			msgHandler = xewallConn.addHandler(event_handler.message, "jabber:client", "message");
			// 다음 트리거는 inform 창이 서서히 사라지도록 하고 결국 문서에서 제거 
			$(document).bind('hide_inform', function() {
				window.setTimeout(function() {
					$('.xewall_new_inform').fadeOut(5000, function() {
						$('.xewall_new_inform').remove();
					});
				}, 5000);
			});
		}
		
		// 전역변수로 빼 놓을 함수들 빼기
		xewallFunc.sendPres = functions.sendPres();
		
		// inform박스는 클릭하면 없어지는 걸로...
		$('#xewallInform').click(function() {
			$(this).remove();
		});
	});
});