jQuery(function($) {
	/**
	 * 문서 로딩 다 되었을시 변수, 폼 초기화, 이벤트 할당
	 */
	$(document).ready(function() {
		
		// Modal Form을 정의한다.
		$('#settingWindow').dialog({
			resizable: false,
			autoOpen: false,
			height: 300,
			width: 350,
			modal: true
		});
		
		// 각 게시판 아이템들의 색깔을 설정한다.
		$('.items').each(function() {
			$(this).css('background-color', '#' + $(this).attr('color-code'));
		});
		
		// 색을 선택할 수 있도록 한다.
		$('input.background-color').ColorPicker({
			onSubmit: function(hsb, hex, rgb, el) {
				$(el).val(hex);
				$(el).ColorPickerHide();
				$(el).parent().siblings('.col3').children('.background-color').css('background-color', '#' + hex);
			},
			onBeforeShow: function() {
				$(this).ColorPickerSetColor(this.value);
			}
		});
		
		// 게시판 세팅의 "저장" 버튼이 눌러졌을 때
		// 배경 색과 배경 이미지 정보를 기록한다.
		$('#settingWindow').find('.btnSave').click(function() {
			// 게시판 색 정보를 기록
			var module_srl = $('#settingWindow').children('.selected_module_srl').val();
			var color_val = $('#settingWindow').find('.background-color').val();
			$('.item_' + module_srl).attr('color-code', color_val).css('background-color', '#' + color_val);
			
			// 창 닫기
			$('#settingWindow').dialog('close');
		});
		
		
		// 각 게시판 설정 버튼이 눌러졌을 때 설정 창을 모달로 띄운다.
		$('div.module_select_box .items').click(function(event) {
			// 설정 모달 창에 클릭된 게시판의 값 집어넣기
			var module_srl = $(this).attr('module_srl');
			var color_code = $(this).attr('color-code');
			$('#settingWindow').children('.selected_module_srl').val(module_srl);
			$('#settingWindow .col2 .background-color').val(color_code);
			$('#settingWindow .col3 .background-color').css('background-color', '#' + color_code);
			
			// 모달 창 띄우기
			$('#settingWindow').dialog("open");
		});
		
		
		// 모듈 리스트 저장 버튼이눌러졌을 때 해당 사항이 저장되어야 한다.
		// 필수로 보여지는 모듈은 -1 이 듣는 것으로 해두자.
		$('div.module_select_box .btnSave').click(function() {
			
			var responses = [];
			var $lists = $('#sortable2').children();
			
			// 사용자가 듣기로 설정 가능한 게시판들 저장
			var available_module_list = new Array();
			$lists.each(function() {
				available_module_list.push($(this).attr('module_srl'));
			});
			
			// 사용자들이 무조건 듣도록 지정된 게시판들 저장
			$list = $('#sortable3').children();
			var default_module_list = new Array();
			$list.each(function() {
				default_module_list.push($(this).attr('module_srl'));
			});
			
			// 각 게시판들의 설정 값들
			var colors = '';
			$('.items').each(function() {
				colors += $(this).attr('module_srl');
				colors += '=';
				colors += $(this).attr('color-code');
				colors += '&';
			});
			colors = colors.substring(0, colors.length - 1);
			
			var params = {
					available_module_list: available_module_list.join(),
					default_module_list: default_module_list.join(),
					colors: colors
			};
			exec_xml('xewall', 'procXewallAdminSaveModuleList', params, function(ret_obj) {
				alert(ret_obj['message']);
				location.reload(true);
			}, responses, params);
		});
		
		// 게시판 초기화 버튼
		$('div.module_select_box .initialize').click(function() {
			if (confirm(xewall_lang.confirm_init)) {
				var responses = [];
				var params = {};
				exec_xml('xewall', 'procXewallAdminInitBoard', params, function(ret_obj) {
					alert(ret_obj['message']);
					location.reload(true);
				}, responses, params);
			}
			
		});
		
		// 네비게이션 관련 설정사항 저장
		$('div.document_navi_box .btnSave').click(function() {
			var responses = [];
			var params = {
					doc_sort_index: $('.doc_sort_index').val(),
					doc_order_type: $('.doc_order_type').val(),
					doc_list_count: $('input[name="doc_list_count"]').val()
			};
			exec_xml('xewall', 'procXewallAdminSaveNavi', params, function(ret_obj) {
				alert(ret_obj['message']);
				location.reload(true);
			}, responses, params);
		});
		
		// 에디터와 관련된 사항들을 저장
		$('div.editor_config .btnSave').click(function() {
			var params = {};
			var responses = [];
			params = {
					allow_fileupload: $('#allow_fileupload').is(':checked'),
					enable_autosave: $('#enable_autosave').is(':checked'),
					enable_default_component: $('#enable_default_component').is(':checked'),
					enable_component: $('#enable_component').is(':checked'),
					resizable: $('#resizable').is(':checked'),
					disable_html: $('#disable_html').is(':checked'),
					height: $('#height').val(),
					skin: $('#skin').val()
			};
			exec_xml('xewall', 'procXewallAdminSaveEditor', params, function(ret_obj) {
				alert(ret_obj['message']);
				location.reload(true);
			}, responses, params);
		});
		
		// 동작과 관련된 사항들을 저장
		$('div.action_config .btnSave').click(function() {
			var responses = [];
			var params = {
					refresh_rate: $('#refresh_rate').val(),
					doc_summary: $('#doc_summary').val(),
					doc_more: $('#doc_more').val(),
					com_summary: $('#com_summary').val(),
					com_more: $('#com_more').val()
			};
			// TODO 유효성 검사
			exec_xml('xewall', 'procXewallAdminSaveAction', params, function(ret_obj) {
				alert(ret_obj['message']);
				location.reload(true);
			}, responses);
		});
		
		// 문서 로드가 완성되었을 시
		$("#sortable1, #sortable2, #sortable3").sortable({
            connectWith: ".connectedSortable",
            cursor:"move"
        }).disableSelection();
	});
});