<?php
/**
 * @class  xewallModel
 * @author 바람꽃 (wndflwr@gmail.com)
 * @brief  xewall 모듈의 Model class
 **/

class xewallModel extends xewall {
	/**
	 * @brief 초기화
	 **/
	function init() {
		$response_type = strtoupper(Context::get('response_type'));
		// 기본 response를 xml로 던진다.
		if ($response_type == "JSON")
			Context::setRequestMethod('JSON');
		else
			Context::setRequestMethod('XMLRPC');
	}
	
	/**
	 * @function getXewallDocumentList
	 * @brief 문서 목록을 불러온다.
	 */
	function getXewallDocumentList() {
		// 목록을 구하기 위한 대상 모듈/ 페이지 수/ 목록 수/ 페이지 목록 수에 대한 옵션 설정
		$args->module_srl = Context::get('module_srl');
		$args->page = Context::get('page');
		$args->list_count = Context::get('list_count');
		$args->sort_index = Context::get('sort_index');
		$args->page_count = Context::get('page_count');
		$args->order_type = 'asc';
		$args->division = -2100000000;
		$args->last_division = 0;
		
		$queryColumnList = array('document_srl');
		$columnList = array('document_srl', 'module_srl', 'category_srl', 'lang_code', 'is_notice', 'title', 'content', 'readed_count', 'voted_count', 'blamed_count', 'comment_count', 'uploaded_count', 'user_id', 'user_name', 'nick_name', 'member_srl', 'regdate', 'last_update', 'last_updater', 'ipaddress', 'status', 'comment_status');
		$moduleColumnList = array('module_srl', 'module', 'mid', 'browser_title');
		
		$output = executeQueryArray('xewall.getDocumentList', $args, $queryColumnList);
		
		if (!$output->toBool())
			return $output;
		$logged_info = Context::get('logged_info');
		$oDocumentModel = &getModel('document');
		$oModuleModel = &getModel('module');
		$oModuleAdminModel = &getAdminModel('module');
		$documentList = array();
		
		foreach ($output->data as $key => $val) {
			$documentItem = $oDocumentModel->getDocument($val->document_srl, false, false, $columnList);
			// 권한이 없거나, 존재하지 않거나, 비밀글일 경우 정보 표시하지 않는다.
			$module_info = $oModuleModel->getModuleInfoByModuleSrl($documentItem->get('module_srl'), $moduleColumnList);
			$grant = $oModuleModel->getGrant($module_info, $logged_info);
			if (!$grant->view || !$documentItem->isExists() || $documentItem->isSecret()) {
				continue;
			}
			// 카테고리(분류)가 있다면 추가시켜주기
			if ($documentItem->get('category_srl')) {
				$category_list = $oDocumentModel->getCategoryList($documentItem->get('module_srl'));
				$documentList[$key]['category'] = $category_list[$documentItem->get('category_srl')]->title;
			}
			// documentItem의 isGranted 못 믿겠다. 직접 만들기
			if ($documentItem->get('member_srl') == $logged_info->member_srl || $logged_info->is_admin == 'Y')
				$documentList[$key]['isGranted'] = 1;
			else 
				$documentList[$key]['isGranted'] = 0;
			//$documentList[$key]['isGranted'] = (integer)$documentItem->isGranted();
			$documentList[$key]['isAccessible'] = (integer)$documentItem->isAccessible();
			$documentList[$key]['isEditable'] = (integer)$documentItem->isEditable();
			$documentList[$key]['ipaddress'] = $documentItem->getIpAddress();
			//$documentList[$key]['summary'] = $documentItem->getSummary(500);
			$documentList[$key]['summary'] = $this->getSummary($documentItem->getContent(false, false), 500);
			$documentList[$key]['user_name'] = $documentItem->getUserName();
			$documentList[$key]['user_id'] = $documentItem->getUserID();
			$documentList[$key]['nick_name'] = $documentItem->getNickName();
			$documentList[$key]['title'] = $documentItem->getTitleText();
			$documentList[$key]['permanent_url'] = $documentItem->getPermanentUrl();
			$documentList[$key]['profile_image'] = $documentItem->getProfileImage();
			$documentList[$key]['extraImages'] = $documentItem->getExtraImages();
			if ($documentList[$key]['profile_image'] == '')
				$documentList[$key]['profile_image'] = $this->module_path.'skins/default/img/anonymous.jpg';
			if ($documentItem->thumbnailExists()) {
				$documentList[$key]['thumbnailExists'] = 1;
				$documentList[$key]['thumbnail'] = $documentItem->getThumbnail();
			} else {
				$documentList[$key]['thumbnailExists'] = 0;
			}
			if (substr($module_info->browser_title, 0, 12) == '$user_lang->') {
				$tmp = $oModuleAdminModel->getLangCode(0, $module_info->browser_title);
				$documentList[$key]['browser_title'] = $tmp[Context::getLangType()];
			} else {
				$documentList[$key]['browser_title'] = $module_info->browser_title;
			}
			unset($documentItem->variables['content']);
			unset($documentItem->variables['title']);
			unset($documentItem->variables['ipaddress']);
			unset($documentItem->variables['user_name']);
			unset($documentItem->variables['nick_name']);
			unset($documentItem->variables['user_id']);
			foreach ($documentItem->variables as $k => $v) {
				$documentList[$key][$k] = $documentItem->get($k);
			}
		}
		$this->add('documentList', $documentList);
		$this->add('page', $args->page);
		return;
	}
	
	/**
	 * @function getXewallDocument
	 * @param document_srl[int]
	 * @brief getXewallDocumentList가 문서의 목록을 가지고 왔다면
	 * getXewallDocument는 하나의 문서 객체를 받아서 리턴한다.
	 * 시간 나면 getXewallDocumentList를 getXewallDocument를 이용하여 구현하도록 한다.
	 */
	function getXewallDocument() {
		$document_srl = Context::get('document_srl');
		if (Context::get('include_content') == 'true') {
			$include_content = true;
		}
		elseif (Context::get('include_content') == 'false') {
			$include_content = false;
		} else {
			$include_content = false;
		}
		$output = $this->_getXewallDocument($document_srl, $include_content);
		$this->add('document', $output->variables);
	}
	
	/**
	 * @function _getXewallDocument
	 * @brief getXewallDocument의 core함수
	 * 다른 모듈에서도 쓸 수 있도록 여지를 남기기
	 */
	function _getXewallDocument($document_srl, $include_content = false) {
		$columnList = array('document_srl', 'module_srl', 'category_srl', 'lang_code', 'is_notice', 'title', 'content', 'readed_count', 'voted_count', 'blamed_count', 'comment_count', 'uploaded_count', 'user_id', 'user_name', 'nick_name', 'member_srl', 'regdate', 'last_update', 'last_updater', 'ipaddress', 'status', 'comment_status');
		$logged_info = Context::get('logged_info');
		$oDocumentModel = &getModel('document');
		$moduleColumnList = array('module', 'mid', 'module_srl', 'browser_title');
		$output = new Object();
		$is_admin = false;
		
		if ($logged_info->is_admin == 'Y') $is_admin = true;
		$documentItem = $oDocumentModel->getDocument($document_srl, $is_admin, false, $columnList);
		
		// 권한 검사
		if (!$documentItem->isAccessible() || !$documentItem->isExists() || $documentItem->isSecret()) {
			return new Object(-1, 'msg_not_permitted');
		}
		
		// content를 불러오는 거라면 readed_count 올리기
		if ($include_content) {
			$documentItem->updateReadedCount();
		}
		
		// 카테고리(분류)가 있다면 추가시켜주기
		if ($documentItem->get('category_srl')) {
			$category_list = $oDocumentModel->getCategoryList($documentItem->get('module_srl'));
			$output->add('category', $category_list[$documentItem->get('category_srl')]->title);
		}
		
		// isGranted 못 믿겠음.
		if ($logged_info->member_srl == $documentItem->get('member_srl') || $logged_info->is_admin == 'Y')
			$output->add('isGranted', 1);
		else
			$output->add('isGranted', 0);
		//$output->add('isGranted', (integer)$documentItem->isGranted());
		$output->add('isAccessible', (integer)$documentItem->isAccessible());
		$output->add('isEditable', (integer)$documentItem->isEditable());
		$output->add('ipaddress', $documentItem->getIpAddress());
		//$output->add('summary', $documentItem->getSummary(500));
		$output->add('summary', $this->getSummary($documentItem->getContent(false, false), 500));
		$output->add('title', $documentItem->getTitleText());
		$output->add('user_name', $documentItem->getUserName());
		$output->add('user_id', $documentItem->getUserID());
		$output->add('nick_name', $documentItem->getNickName());
		$output->add('permanent_url', $documentItem->getPermanentUrl());
		$output->add('profile_image', $documentItem->getProfileImage());
		$output->add('extraImages', $documentItem->getExtraImages());
		if ($output->get('profile_image') == '')
			$output->add('profile_image', $this->module_path.'skins/default/img/anonymous.jpg');
		if ($documentItem->thumbnailExists()) {
			$output->add('thumbnailExists', 1);
			$output->add('thumbnail', $documentItem->getThumbnail());
		} else {
			$output->add('thumbnailExists', 0);
		}
		if ($include_content) {
			$output->add('content', $documentItem->getContent(false, false, false, true, false));
		}
		$oModuleModel = &getModel('module');
		$oModuleAdminModel = &getAdminModel('module');
		$module_info = $oModuleModel->getModuleInfoByModuleSrl($documentItem->get('module_srl'), $moduleColumnList);
		if (substr($module_info->browser_title, 0, 12) == '$user_lang->') {
			$tmp = $oModuleAdminModel->getLangCode(0, $module_info->browser_title);
			$output->add('browser_title', $tmp[Context::getLangType()]);
		} else {
			$output->add('browser_title', $module_info->browser_title);
		}
		unset($documentItem->variables['content']);
		unset($documentItem->variables['title']);
		unset($documentItem->variables['ipaddress']);
		unset($documentItem->variables['user_name']);
		unset($documentItem->variables['nick_name']);
		unset($documentItem->variables['user_id']);
		
		foreach ($documentItem->variables as $k => $v) {
			$output->add($k, $documentItem->get($k));
		}
		
		return $output;
	}

	
	/**
	 * @function getXewallDocumentContent
	 * @param[int] document_srl
	 * @brief document_srl을 받아서 해당 document의 content를 받는다.
	 */
	function getXewallDocumentContent() {
		$document_srl = Context::get('document_srl');
		$oDocumentModel = &getModel('document');
		$logged_info = Context::get('logged_info');
		$columnList = array('document_srl', 'content');
		$oDocument = $oDocumentModel->getDocument($document_srl, $logged_info->is_admin, false, $columnList);
		$this->add('content', $oDocument->getContent(false, false, false, false, false));
		return;
	}
	
	
	/**
	 * @function getXewallNextSequence
	 * @brief 단순히 getNextSequence() 함수 결과 값을 돌려준다.
	 * TODO(생각해 보기): 단순히 이 함수를 메크로 등을 사용해서 무한으로 부르는 해킹 수법이 있을수도 있다. 막는 방법 강구해보기
	 */
	function getXewallNextSequence() {
		$sequence = getNextSequence();
		$this->add('sequence', $sequence);
	}
	
	
	/**
	 * @function getXewallEditor
	 * @param[string] editor_type = SIMPLE || FULL
	 * @param[int] document_srl
	 * @param[int] editor_sequence
	 * @brief module_srl을 받아서 해당 모듈에 글을 쓸 수 있는 모듈을 생성한다.
	 * document_srl이 존재할 경우 수정작업
	 */
	function getXewallEditor() {
		$editor_type = Context::get('editor_type');
		$call_type = Context::get('call_type');
		$option = null;
		$upload_target_srl = Context::get('upload_target_srl');
		if (!$upload_target_srl || $upload_target_srl == 0) {
			$upload_target_srl = getNextSequence();
		}
		$option->editor_sequence = $upload_target_srl;
		$oEditorModel = &getModel('editor');
		
		// primary_key_name을 정한다.
		if ((int)$call_type == 0 || (int)$call_type == 1) {
			$option->primary_key_name = 'document_srl';
		} else {
			$option->primary_key_name = 'comment_srl';
		}
		
		// 풀 에디터를 불러올 경우
		if ($editor_type == 'FULL') {
			$oModuleModel = &getModel('module');
			$config = $oModuleModel->getModuleConfig('xewall');
			$option->content_key_name = 'content';
			$option->allow_fileupload = $config->allow_fileupload;
			$option->enable_autosave = false; // TODO autosave를 사용 못하게 할 것이 아니라 글을 저장할 때에도 autosave 된 데이터를 처리할 수 있도록 바꾸기
			$option->enable_default_component = $config->enable_default_component;
			$option->enable_component = $config->enable_component;
			$option->resizable = $config->resizable;
			$option->disable_html = $config->disable_html;
			$option->height = $config->height;
			$option->skin = $config->skin;
			$option->colorset = $config->colorset;
			//$option->editor_sequence = $editor_sequence;
			$editor = $oEditorModel->getEditor($upload_target_srl, $option);
		}
		// 간단한 에디터를 불러올 경우
		else {
			$option->skin = 'xpresseditor';
			$option->content_style = 'default';
			$option->content_key_name = 'content';
			$option->allow_fileupload = false;
			$option->enable_autosave = false;
			$option->enable_default_component = false;
			$option->enable_component = false;
			$option->resizable = false;
			$option->disable_html = true;
			$option->height = 60;
			$option->colorset = "white_text_nohtml";
			//$option->editor_sequence = $editor_sequence;
			$editor = $oEditorModel->getEditor($upload_target_srl, $option);
		}
		// CDATA 태그 문자열 제거
		$editor = str_replace("//<![CDATA[", "", $editor);
		$editor = str_replace("//]]>", "", $editor);
		$this->add('editor', $editor);
		
		// TODO 새로 만들어진 것이라면 upload_target_srl을 리턴값으로 보내준다.
		$this->add('upload_target_srl', $upload_target_srl);
		
		// TODO dreditor 에 대한 대응도 마련한다.
	}
	
	
	/**
	 * @function getDefaultListen
	 * @brief 기본으로 듣는 게시판들의 리스트들과 현재 로그인 한 사용자가 듣는 게시판들을 불러온다.
	 * @return Array()
	 */
	function getDefaultListen() {
		$listenList = array();
		$args->type1 = 'D';
		$output = executeQueryArray('xewall.getFavouriteByType', $args);
		foreach ($output->data as $key => $val) {
			array_push($listenList, $val->target_srl);
		}
		return $listenList;
	}
	
	
	/**
	* @function getAvailableListen
	* @brief 사용자가 선택한 게시판의 리스트들을 불러온다.
	* @return Array()
	*/
	function getAvailableListen() {
		$listenList = array();
		$args->type1 = 'A';
		$output = executeQueryArray('xewall.getFavouriteByType', $args);
		foreach ($output->data as $key => $val) {
			array_push($listenList, $val->target_srl);
		}
		return $listenList;
	}
	
	
	/**
	 * @function getMyListen
	 * @brief 사용자가 듣고자 설정한 게시판의 리스트를 불러온다.
	 * @return Array()
	 */
	function getMyListen() {
		$logged_info = Context::get('logged_info');
		$args->member_srl = $logged_info->member_srl;
		$args->type = "U";
		$output = executeQueryArray('xewall.getFavouriteOfMe', $args);
		$listenList = array();
		foreach ($output->data as $key => $val) {
			array_push($listenList, $val->target_srl);
		}
		return $listenList;
	}
	
	
	/**
	 * @function getXewallUpdateList
	 * @brief 최근 문서목록을 불러온다. 리턴되는 값은 document_srl, last_update이다.
	 * sort_index와 order_type, list_count 들은 추후 관리자 페이지에서 설정할 수 있도록 한다.
	 */
	function getXewallUpdateList() {
		$args->sort_index = 'list_order';
		$args->order = 'asc';
		$args->page = 1;
		$args->list_count = Context::get('list_count');
		$args->module_srl = Context::get('module_srl');
		// 최적의 속도를 위해서 원래의 쿼리 대신 새 쿼리를 만들어서 사용
		$output = executeQueryArray('xewall.getDocumentUpdateList', $args);
		if ($output->error) return $output;
		$this->add('update_list', $output->data);
	}
	
	
	/**
	 * @function getXewallCommentList
	 * @param document_srl[int]
	 * @brief 해당 document_srl의 댓글들의 리스트들을 불러온다.
	 */
	function getXewallCommentList() {
		$document_srl = Context::get('document_srl');
		$logged_info = Context::get('logged_info');
		$oModuleModel = &getModel('module');
		
		$commentList = array();
		
		// 권한 확인, 권한이 없으면 취소
		$module_info = $oModuleModel->getModuleInfoByDocumentSrl($document_srl);
		$grant = $oModuleModel->getGrant($module_info, $logged_info);
		if (!$grant->view) return new Object(-1, 'msg_not_permitted');
		
		$oDocumentModel = &getModel('document');
		$oDocument = $oDocumentModel->getDocument($document_srl);
		$comment_list = $oDocument->getComments();
		
		if (!is_array($comment_list)) return new Object(-1, 'msg_empty_comment');
		
		// 데이터 정제하고 $commentList 에 집어넣기
		foreach ($comment_list as $key => &$val) {
			// 비밀댓글은 content 제거
			if ($val->isSecret()) $val->variables->content = Context::getLang('thisissecret');
			$commentList[$key]['isAccessible'] = (integer)$val->isAccessible();
			// isGranted 못 믿겠다.
			if ($logged_info->member_srl == $val->get('member_srl') || $logged_info->is_admin == 'Y')
				$commentList[$key]['isGranted'] = 1;
			else
				$commentList[$key]['isGranted'] = 0;
			//$commentList[$key]['isGranted'] = (integer)$val->isGranted();
			$commentList[$key]['isEditable'] = (integer)$val->isEditable();
			$commentList[$key]['isSecret'] = (integer)$val->isSecret();
			$commentList[$key]['useNotify'] = (integer)$val->useNotify();
			$commentList[$key]['user_id'] = $val->getUserID();
			$commentList[$key]['user_name'] = $val->getUserName();
			$commentList[$key]['nick_name'] = $val->getNickName();
			$commentList[$key]['content_text'] = $val->getContentText();
			$commentList[$key]['permanent_url'] = $val->getPermanentUrl();
			$commentList[$key]['profile_image'] = $val->getProfileImage();
			$commentList[$key]['ipaddress'] = $val->getIpAddress();
			//$commentList[$key]['summary'] = $val->getSummary(250);
			$commentList[$key]['summary'] = $this->getSummary($val->getContent(false, false), 500);
			unset($val->variables->user_id);
			unset($val->variables->user_name);
			unset($val->variables->nick_name);
			unset($val->variables->ipaddress);
			unset($val->variables->content);
			unset($val->variables->password);
			foreach ($val->variables as $k => $v) {
				$commentList[$key][$k] = $v;
			}
		}
		unset($val);
		// 댓글이 페이징이 되어서 넘어간다면 "댓글 더 보기" 메뉴가 있어야 한다.
		$this->add('cpage', Context::get('cpage'));
		$this->add('comments', $commentList);
	}
	
	/**
	 * @function getXewallComment
	 * @brief 댓글 하나의 정보를 불러온다.
	 * @param[int] $comment_srl
	 * @param[boolean] $include_content : true 이면 content 내용까지 같이 보내기
	 */
	function getXewallComment() {
		if (Context::get('include_content') == 'true') {
			$include_content = true;
		} elseif (Context::get('include_content') == 'false') {
			$include_content = false;
		} else {
			$include_content = false;
		}
		$comment_srl = Context::get('comment_srl');
		$oCommentModel = &getModel('comment');
		$logged_info = Context::get('logged_info');
		
		if ($logged_info->is_admin != 'N')
			$logged_info->is_admin = true;
		else
			$logged_info->is_admin = false;
		// commentItem 불러오기
		$oComment = $oCommentModel->getComment($comment_srl, $logged_info->is_admin);
		$output;
		// $output에 commentItem의 값들을 집어넣는다.
		
		// 비밀댓글은 content 제거
		if ($oComment->isSecret())
			$oComment->variables->content = Context::getLang('thisissecret');
		$output['isAccessible'] = (integer)$oComment->isAccessible();
		// isGranted 못 믿겠다.
		if ($logged_info->member_srl == $oComment->get('member_srl') || $logged_info->is_admin == 'Y')
			$output['isGranted'] = 1;
		else
			$output['isGranted'] = 0;
		//$output['isGranted'] = (integer)$oComment->isGranted();
		$output['isEditable'] = (integer)$oComment->isEditable();
		$output['isSecret'] = (integer)$oComment->isSecret();
		$output['useNotify'] = (integer)$oComment->useNotify();
		$output['user_id'] = $oComment->getUserID();
		$output['user_name'] = $oComment->getUserName();
		$output['nick_name'] = $oComment->getNickName();
		//$output['content_text'] = $oComment->getContentText();
		$output['permanent_url'] = $oComment->getPermanentUrl();
		$output['profile_image'] = $oComment->getProfileImage();
		$output['ipaddress'] = $oComment->getIpAddress();
		//$output['summary'] = $oComment->getSummary(250);
		$output['summary'] = $this->getSummary($oComment->getContent(false, false, false), 250);
		// $include_content가 true일 경우 content 포함시키기
		if ($include_content) {
			$output['content'] = htmlspecialchars($oComment->getContent(true, true, true));
		}
		unset($oComment->variables->user_id);
		unset($oComment->variables->user_name);
		unset($oComment->variables->nick_name);
		unset($oComment->variables->ipaddress);
		unset($oComment->variables->content);
		unset($oComment->variables->password);
		foreach ($oComment->variables as $k => $v) {
			$output[$k] = $v;
		}
		
		$this->add('comment', $output);
	}
	
	function _getXewallComment($comment_srl, $include_content = false) {
		
	}
	
	
	/**
	 * @function getXewallCategoryList
	 * @brief module_srl을 받아서 해당 게시판의 분류 리스트들을 받아온다.
	 */
	function getXewallCategoryList() {
		$module_srl = Context::get('module_srl');
		if (!$module_srl) {
			$this->setError(-1);
			$this->setMessage('msg_invalid_request');
			return false;
		}
		$oDocumentModel = &getModel('document');
		$category_list = $oDocumentModel->getCategoryList($module_srl);
		$this->add('category_list', $category_list);
	}
	
	
	/**
	 * @function getSummary
	 * @brief 기존의 document.item.php -> getSummary를 나름 수정했음.
	 * 기존과 다른 점은 엔터키 등을 whitespace 가 아닌 <br/>로 대체한다.
	 */
	private function getSummary($content, $str_size = 50, $tail = '(more...)') {
		// For a newlink, inert a <br/>
		$content = preg_replace('!(<br[\s]*/{0,1}>[\s]*)+!is', "&NewLine;", $content);
		// Replace tags such as </p> , </div> , </li> and others to a <br/>
		$content = str_replace(array('</p>', '</div>', '</li>'), "&NewLine;", $content);
		// Remove Tags
		$content = preg_replace('!<([^>]*?)>!is','', $content);
		// Replace < , >, "
		$content = str_replace(array('&lt;','&gt;','&quot;','&nbsp;'), array('<','>','"',' '), $content);
		// Delete  a series of whitespaces
		$content = preg_replace('/ ( +)/is', ' ', $content);
		// delete a series of <br/>s to one <br/>
		//$content = preg_replace('/ (&NewLine;+)/is', '<br/>', $content);
		
		// Truncate string
		$content = trim(cut_str($content, $str_size, $tail));
		// Replace back < , <, "
		$content = str_replace(array('<','>','"'),array('&lt;','&gt;','&quot;'), $content);
		// 최성원이 정규식 짬.
		$content = preg_replace('/(&NewLine;(\s*))+/', '<br/>', $content);
		return $content;
	}
}
?>