// 밖에서도 쓸 수 있는 함수 빼놓기
var Xewall = {
		functions: null,
		default_listen: null,
		default_listen_init: null
};

var documentList = new Array();

jQuery(function($) {
	/**
	 * 필요한 전역변수들 선언
	 */
	var list_count;
	var page = 1;
	
	
	/**
	 * 문서의 모든 내용은 HTML DOM객체로 가지고 있음과 동시에 documentList 변수에도 함께 가지고 있는다.
	 */
	//var documentList = new Array();
	
	/**
	 * 상수 선언 CALL_TYPE
	 * 에디터를 부를 때 종류를 정의한다.
	 */
	var CALL_TYPE = {
			NEW_DOC : 0,	// 새로운 문서 만들 때
			MOD_DOC : 1,	// 문서 수정할 때
			NEW_COMM : 2,	// 새로운 댓글 만들 때
			MOD_COMM : 3,	// 댓글 수정할 때
			NEW_CCOMM : 4,	// 새로운 대댓글 만들 때
			MOD_CCOMM : 5	// 대댓글 수정할 때
	};
	
	/**
	 * 기본 함수 목록들을 모아둔다. => common functions
	 */
	var functions = {
			
			/**
			 * @param[int] document_srl
			 * @param[boolean] include_content = false: content도 함께 불러올 것인가 결정
			 * @brief document_srl에 해당하는 문서의 내용을 최신으로 업데이트 시킨다.
			 * (include_content == true)일 경우 content도 함께 불러온다.
			 * (include_content == false)일 경우 content는 불러오지 않는다. 
			 */
			refresh_document: function(document_srl, include_content) {
				var myCall = new MyMethodCall('xewall', 'getXewallDocument');
				myCall.addElement('document_srl', document_srl).addElement('include_content', include_content);
				myCall.callAjax(function(data, textStatus, xhr) {
					documentList[document_srl].setDocumentObj($(data).find('document'));
					var $domObj = $('.document_srl_' + document_srl);
					documentList[document_srl].setInfoToDomObj($domObj);
					$domObj = null;
				}, function(xhr, textStatus){
					console.log(textStatus);
				});
				myCall = null;
			},
			
			
			/**
			 * 새로고침을 눌렀을 때
			 * 서버에서 각 문서의 document_srl, last_update 정보를 불러온다.
			 * 그리고 메모리(documentList)에 있는 해당하는 document_srl의 last_update를 비교해서 차이가 있다면
			 * 해당 문서에 대한 정보를 따로 받아와서 업데이트를 실행한다.
			 */
			refresh_document_list: function(listen, page, list_count) {
				
				var myCall = new MyMethodCall('xewall', 'getXewallDocumentList');
				myCall.addElement('module_srl', listen);
				myCall.addElement('page', page);
				if (list_count) myCall.addElement('list_count', list_count);
				myCall.callAjax(function(data, textStatus, xhr) {
					var recv_page = parseInt($(data).children('response').children('page').text());
					var $documentList = $(data).children('response').children('documentList').children();
					// 불러져온 모든 document 정보를 html로 만들어서 문서에 삽입
					if (recv_page == 1)
						$documentList = $documentList.get().reverse();
					else
						$documentList = $documentList.get();
					$($documentList).each(function() {
						// documentList[받은 document_srl] 에 값이 존재하지 않을 경우만 실행
						var recv_document_srl = parseInt($(this).children('document_srl').text());
						if (typeof(documentList[recv_document_srl]) != 'undefined') return;
						
						// 더미를 복사
						var $document = $('.dummies .document_ori:first').clone(true);
						
						// 더미의 class 적절하게 만지기
						$document.removeClass('document_ori').addClass('document');
						
						// Document() 클래스를 이용하여 값 받고 적절한 값을 DOM에 삽입한 다음 문서에 삽입한다.
						var doc = new Document();
						doc.setDocumentObj($(this));
						doc.setInfoToDomObj($document);
						
						// 전역 array 에 삽입
						documentList[doc.document_srl] = doc;
						
						// 문서에 삽입
						if (recv_page == 1)
							$('div.xewall .list').prepend($document);
						else
							$('div.xewall .list').append($document);
						
						$document.fadeIn();
						
						$document = null;
					});
					
					$('div.xewall .loading').hide();
					
					// scroll 이벤트를 바인딩 시킨다.
					$(window).scroll(event_handler.onScroll);
					
					// refresh_freq 초기화
					refresh_freq_1 = refresh_freq_0;
					
				}, function() {
					console.log('Sever error.');
					refresh_freq_1 = refresh_freq_0;
				});
				myCall = null;
				return false;
			},
			
			/**
			 * @param[int] document_srl
			 * @param[boolean] include_content = false : content도 함께 불러올 것인가 결정
			 */
			refresh_comment: function(comment_srl, include_content) {
				var myCall = new MyMethodCall();
				myCall.setModule('xewall').setAct('getXewallComment');
				myCall.addElement('comment_srl', comment_srl);
				myCall.addElement('include_content', include_content);
				myCall.callAjax(function(data, textStatus, xhr) {
					//console.log(data);
					// 받은 데이터를 documentList[]에 적용한다.
					var comment = new Comment();
					// 받은 정보를 저장
					comment.setCommentObj($(data).find('comment'));
					// DOM 객체를 레퍼런스 하기
					var $commentDOM = $('.dummy .comment_srl_' + comment_srl);
					// 서버에서 받은 데이터 HTML DOM에 집어넣기
					comment.setInfoToDomObj($commentDOM);
					// DOM의 class나 attribute 설정, 보이기
					$commentDOM.removeClass('comment_ori').addClass('comment');
					$commentDOM = null;
				}, function(xhr, textStatus) {
					console.log(xhr);
				}, true);
				myCall = null;
			},
			
			/**
			 * @param[int] document_srl
			 * @param[int] module_srl
			 * @brief 해당하는 document_srl을 받아서 해당하는 문서의 댓글리스트들을 refresh 시킨다.
			 */
			refresh_comment_list: function(document_srl) {
				// 서버에 댓글 리스트들을 요청
				var myCall = new MyMethodCall('xewall', 'getXewallCommentList');
				myCall.addElement('document_srl', document_srl);
				//myCall.addElement('cpage', cpage);
				myCall.callAjax(function(data, textStatus, xhr) {
					// 원래 있던 comment들 제거
					$('div.xewall .document_srl_' + document_srl).find('.comment_box').children('.comment').remove();
					
					// 불러와진 댓글 수가 0이면 취소.
					if ($(data).find('comments').children().length == 0) return false;
					
					// 불러와진 댓글이 1페이지가 아니라면 "댓글 더 보기" 메뉴를 보이도록 한다.
					// TODO
					/*
					var cpage = parseInt($(data).find('cpage').text());
					if (cpage != 1) {
						$('div.xewall .document_srl_' + document_srl + ' > .comment_box').attr('cpage', cpage);
						$('div.xewall .document_srl_' + document_srl + ' > .comment_box > .comment_see_more').show();
					}
					*/
					
					// 각각의 코멘트들에 대하여
					var $comments = $(data).find('comments').children();
					$comments.each(function() {
						var comment_srl = parseInt($(this).find('comment_srl').text());
						
						// Comment() 클래스를 이용해 처리한다.
						var comment = new Comment();
						
						// 받은 정보를 저장
						comment.setCommentObj($(this));
						
						// 더미 객체를 복사
						var $commentDOM = $('.dummies .comment_ori').clone(true);
						
						// 서버에서 받은 데이터 HTML DOM에 집어넣기
						comment.setInfoToDomObj($commentDOM);
						
						// DOM의 class나 attribute 설정, 보이기
						$commentDOM.removeClass('comment_ori').addClass('comment');
						
						// 전역 변수 DocumentList에 추가시키기
						documentList[comment.document_srl].comments[comment.comment_srl] = null;
						documentList[comment.document_srl].comments[comment.comment_srl] = comment;
						
						// 문서에 추가시키기
						$('div.xewall .document_srl_' + comment.document_srl).find('.comment_box').append($commentDOM);
						$commentDOM = null;
						comment = null;
					});
				}, function(xhr, textStatus) {
					console.log(textStatus);
				}, true);
				myCall = null;
			},
			
			
			/**
			 * @param[DOM Object] editorDOM
			 * @param[Object] ref
			 * 
			 * @param[int] ref.upload_target_srl
			 * @param[int] ref.document_srl
			 * @param[int] ref.comment_srl
			 * @param[int] ref.parent_srl
			 * 
			 * @param[String] editor_type : FULL || SIMPLE
			 * @param[String] content : 글을 쓰다가 에디터로 바꿀 경우 글의 내용을 content에 보존해서 넘겨주세요.
			 * @param[CALL_TYPE] call_type : 에디터 부르는 종류 (상수 CALL_TYPE 참조)
			 * @brief 에디터를 불러와서 해당 HTML DOM 객체에 적용시킨다.
			 * editorDOM 변수는 "editor" 를 class로 가지는 <div> 태그여야 하고 <form> 태그를 내포하고 있어야만 합니다.
			 */
			call_editor: function($editorDOM, ref, editor_type, content, call_type) {
				
				// editorDOM의 유효성 검사
				if (typeof($editorDOM) == 'undefined') return;
				if ($editorDOM.find('form').length == 0) return;
				if ($editorDOM.attr('class') != 'editor') return;
				
				if (call_type === null) return;
				
				// upload_target_srl == null 이라면 0으로 바꿔준다.
				if (ref.upload_target_srl === null || !ref.upload_target_srl) {
					ref.upload_target_srl = 0;
				}
				
				// 에디터를 불러와서 적용시킨다.
				var myCall = new MyMethodCall();
				myCall.setModule('xewall').setAct('getXewallEditor');
				myCall.addElement('upload_target_srl', ref.upload_target_srl);
				myCall.addElement('editor_type', editor_type);
				myCall.addElement('call_type', call_type);
				myCall.addElement('editor_sequence', $editorDOM.children('form:first').attr('editor_sequence'));
				myCall.callAjax(function(data, textStatus, xhr) {
					//  받은 데이터를 HTML 에 적용
					var editor = $(data).find('editor').text();
					
					// 버그있다. 버그. 버그 고치고 가자.
					// <!-- 여기서 --> 찾아서 모조리 지우기
					var textCopy = '';
					var length = editor.length;
					var start = 0;
					var end = 0;
					do {
						end = editor.indexOf('<!--', start);
						textCopy += editor.slice(start, end);
						start = editor.indexOf('-->', end) + 3;
					} while(end > -1);
					//textCopy += '>';
					editor = textCopy;
					
					// 원래 에디터에 내용이 있었다면 내용 제거 TODO
					// document_srl과 comment_srl을 제외한 모든 자식 요소들 제거
					$editorDOM.find('form').children().each(function() {
						var will_remove = true;
						var inputName = $(this).attr('name');
						if (inputName === 'document_srl') will_remove = false;
						else if (inputName === 'comment_srl') will_remove = false;
						else if (inputName === 'content') will_remove = false;
						else if (inputName === 'parent_srl') will_remove = false;
						else will_remove = true;
						if (will_remove)
							$(this).remove();
					});
					
					// editor_sequence 따내기
					var editor_sequence = $(data).find('upload_target_srl').text();
					
					// $editorDOM 의 editor_sequence 초기화
					$editorDOM.find('form').removeAttr('editor_sequence');
					
					// call_type에 따라 다른 action 취한다.
					switch (call_type) {
					// 새 문서를 만드는 것이라면 document_srl = 새로 할당받은 srl
					case CALL_TYPE.NEW_DOC:
						$editorDOM.find('input[name="document_srl"]').val(editor_sequence);
						$editorDOM.find('input[name="comment_srl"]').val('0');
						$editorDOM.find('input[name="parent_srl"]').val('0');
						$editorDOM.find('input[name="upload_target_srl"]').val('0');
						break;
					// 문서를 수정하는 경우라면 document_srl = parameter로 받은 srl
					case CALL_TYPE.MOD_DOC:
						$editorDOM.find('input[name="document_srl"]').val(ref.document_srl);
						$editorDOM.find('input[name="comment_srl"]').val('0');
						$editorDOM.find('input[name="parent_srl"]').val('0');
						$editorDOM.find('input[name="upload_target_srl"]').val('0');
						break;
					// 새 댓글을 다는 경우라면 document_srl = parameter로 받은 srl
					// comment_srl = 새로 할당받은 srl
					case CALL_TYPE.NEW_COMM:
						$editorDOM.find('input[name="document_srl"]').val(ref.document_srl);
						$editorDOM.find('input[name="comment_srl"]').val(editor_sequence);
						$editorDOM.find('input[name="parent_srl"]').val('0');
						$editorDOM.find('input[name="upload_target_srl"]').val('0');
						break;
					// 댓글을 수정하는 경우라면 document_srl = parameter 로 받은 srl
					// comment_srl = parameter로 받은 srl
					case CALL_TYPE.MOD_COMM:
						$editorDOM.find('input[name="document_srl"]').val(ref.document_srl);
						$editorDOM.find('input[name="comment_srl"]').val(ref.comment_srl);
						$editorDOM.find('input[name="parent_srl"]').val('0');
						$editorDOM.find('input[name="upload_target_srl"]').val('0');
						break;
					// 새로운 대댓글을 다는 경우라면 document_srl = parameter로 받은 srl
					// comment_srl = 새로 할당받은 srl
					// parent_srl = parameter로 받은 srl
					case CALL_TYPE.NEW_CCOMM:
						$editorDOM.find('input[name="document_srl"]').val(ref.document_srl);
						$editorDOM.find('input[name="comment_srl"]').val(editor_sequence);
						$editorDOM.find('input[name="parent_srl"]').val(ref.parent_srl);
						$editorDOM.find('input[name="upload_target_srl"]').val('0');
						break;
					// 대댓글을 수정하는 경우라면 document_srl = parameter로 받은 srl
					// comment_srl = parameter 로 받은 srl
					// parent_srl = parameter 로 받은 srl
					case CALL_TYPE.MOD_CCOMM:
						$editorDOM.find('input[name="document_srl"]').val(ref.document_srl);
						$editorDOM.find('input[name="comment_srl"]').val(ref.comment_srl);
						$editorDOM.find('input[name="parent_srl"]').val(ref.parent_srl);
						$editorDOM.find('input[name="upload_target_srl"]').val('0');
						break;
					default:
						break;
					}
					
					// content 가 존재하면 에디터에 content 추가
					$editorDOM.find('form').find('input[name="content"]').val(content);
					var iframe_contents = $editorDOM.find('iframe:first').contents();
					iframe_contents.find('body:first').html(content);
					// 삽입
					$editorDOM.find('form').append(editor);
					// 포커스 주기
					editorFocus(ref.upload_target_srl);
				}, function(xhr, textStatus) {
					console.log(xhr);
					console.log(textStatus);
				});
				myCall = null;
			},
			
			
			/**
			 * @function setCategoryList
			 * @brief module_srl을 받아서 select -> #board_category 의 내용을 설정한다.
			 */
			setCategoryList: function(module_srl) {
				var $board_category = $('#board_category');
				// 먼저 자식들 다 지우기
				$board_category.children().remove();
				// XE에 해당 모듈의 category list 를 받기 요청하기
				var mc = new MyMethodCall('xewall', 'getXewallCategoryList');
				mc.addElement('module_srl', module_srl);
				mc.callAjax(function(data) {
					var $items = $(data).find('category_list').children();
					var $category = $('#board_category');
					if (!$items.length) {
						$category.hide();
						$category.children().remove();
						return;
					}
					// 카테고리 선택 창을 보인다.
					$category.show();
					$items.each(function() {
						$category.append('<option value="' + $(this).find('category_srl').text() + '">' + $(this).find('title').text() + '</option>');
					});
				}, null, false);
			}
	};
	
	/**
	 * 이벤트 핸들러들을 모두 여기에다가 모아둔다.
	 */
	var event_handler = {
			
			/**
			 * 요약을 클릭했을 때 문서 내용을 불러온다.
			 */
			onSummaryClick: function() {
				
				// content가 열려있으면 숨기기. (툴팁 내용도 바꾸기)
				if ($(this).parent().parent().find('.content').css('display') != 'none') {
					$(this).parent().parent().find('.summary').show('clip', {}, 500, null);
					$(this).parent().parent().find('.thumbnail').show('clip', {}, 500, null);
					$(this).parent().parent().find('.content').hide('clip', {}, 500, null);
					return;
				}
				
				// 문서 불러오고
				var document_srl = parseInt($(this).attr('document_srl'));
				functions.refresh_document(document_srl, true);
				
				// 요약 가리고 내용 보이고 툴팁 바꾸기
				var $content = $(this).parent().parent().find('.content');
				$(this).parent().parent().find('.summary').hide('clip', {}, 200, function() {
					$content.show('slide', {}, 500, null);
				});
				$(this).parent().parent().find('.thumbnail').hide('clip', {}, 200, null);
				
			},
			
			/**
			 * 스크롤을 했을 때 일어나는 이벤트
			 * 페이지의 마지막 부분까지 도달하면 다음 페이지를 불러온다.
			 */
			onScroll: function(event) {
				// 페이지의 마지막으로 스크롤 되면.
				if ($(window).scrollTop() == $(document).height() - $(window).height()){
					// 다불로 스크롤이 되지 않도록 이벤트 언바인드 시키기
					$(window).unbind('scroll');
					$('div.xewall .loading').show();
					functions.refresh_document_list(Xewall.default_listen, ++page, list_count);
				} else {
					return false;
				}
			},
			
			/**
			 * 간단히 글쓰기를 클릭했거나 최초 txt_area를 클릭했을 때
			 * txt_area가 존재하면 제거하고 editor_simple이 존재하면 제거하고
			 * editor_full 을 불러와서 삽입한다.
			 * 클래스 적용시키기
			 */
			onSimpleFormFocus: function(event) {
				var $editorDOM = $(this).parent().parent();
				var editor_type = 'SIMPLE';
				var content = $editorDOM.children('form:first').children('input[name="content"]').val();
				
				var document_srl = parseInt($editorDOM.find('input[name="document_srl"]').val());
				if (!document_srl) document_srl = 0;
				
				// 에디터 불러와서 출력하기
				// 새 글 쓰기: upload_target_srl, document_srl, comment_srl, parent_srl = 0
				var ref = {
						upload_target_srl:document_srl,
						document_srl:document_srl,
						comment_srl:0,
						parent_srl:0
				};
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.NEW_DOC);
				
				// 숨어있던 버튼들 보이기
				$editorDOM.siblings('.hidden_by_editor').show();
				$editorDOM.siblings('.hidden_by_editor').find('.simple_form').removeClass('unselected').addClass('selected');
				$editorDOM.siblings('.hidden_by_editor').find('.use_editor').removeClass('selected').addClass('unselected');
				
				// 선택된 게시판의 카테고리 추가시킨다.
				var module_srl = $('.default_listen_array:first').val();
				if (!module_srl) return;
				
				$('#board_category').children().remove();
				$('#board_category').hide();
				
				// 카테고리 정보를 얻어서 출력
				functions.setCategoryList(module_srl);
				
			},
			
			
			/**
			 * 게시판이 선택이 될 때마다 해당 게시판의 category들을 로드해 와서 출력시킨다.
			 */
			onDefaultListenChange: function() {
				var module_srl = $(this).val();
				
				$('#board_category').children().remove();
				$('#board_category').hide();
				
				// 카테고리 정보를 얻어서 출력
				functions.setCategoryList(module_srl);
			},
			
			/**
			 * 에디터 사용하기를 클릭했을 때
			 * editor_full이 존재하면 제거하고
			 * editor_simple을 불러와서 삽입한다.
			 * 클래스 적용시키기
			 */
			onEditorClick: function(event) {
				// 클래스 적용시키기
				$(this).removeClass('unselected').addClass('selected');
				$(this).siblings('.simple_form').removeClass('selected').addClass('unselected');
				
				// 에디터 불러와서 적용
				var $editorDOM = $(this).parent().siblings('.editor:first');
				var editor_type = 'FULL';
				var $content = $editorDOM.find('iframe:first').contents();
				var content = $content.find('body:first').html();
				
				var document_srl = parseInt($editorDOM.find('input[name="document_srl"]').val());
				if (!document_srl) document_srl = 0;
				
				// 새 글 쓰기: document_srl, upload_target_srl, comment_srl, parent_srl = 0
				var ref = {
						upload_target_srl:document_srl,
						document_srl:document_srl,
						comment_srl:0,
						parent_srl:0
				};
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.NEW_DOC);
			},
			
			/**
			 * 간단히 글쓰기를 클릭했을 때
			 * 간단한 에디터를 불러와서 적용시킨다.
			 */
			onSimpleFormClick: function(event) {
				// 클래스 적용시키기
				$(this).removeClass('unselected').addClass('selected');
				$(this).siblings('.use_editor').removeClass('selected').addClass('unselected');
				
				// 에디터 불러와서 적용
				var $editorDOM = $(this).parent().siblings('.editor');
				var editor_type = 'SIMPLE';
				var $content = $editorDOM.find('iframe:first').contents();
				var content = $content.find('body:first').html();
				
				var document_srl = parseInt($editorDOM.find('input[name="document_srl"]').val());
				if (!document_srl) document_srl = 0;
				
				// 새 글 쓰기: upload_target_srl, document_srl, comment_srl, parent_srl = 0
				var ref = {
						upload_target_srl:document_srl,
						document_srl:document_srl,
						comment_srl:0,
						parent_srl:0
				};
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.NEW_DOC);
				
			},
			
			/**
			 * 게시 버튼을 클릭했을 때
			 */
			onSubmitClick: function(event) {
				// Content 얻기
				var editorSeq = parseInt($(this).siblings('.editor').children('form:first').attr('editor_sequence'));
				var content = window.editorGetContent(editorSeq);
				// Content 얻은게 없으면 취소
				if (!content) return;
				
				// 게시 버튼 비활성화
				$(this).unbind('click');
				
				// 기다려 주세요... 로 변경
				$(this).text(xewall_lang.please_wait);
				
				// CSS를 기다림으로 변경
				$(this).removeClass('btn_submit_enabled');
				$(this).addClass('btn_submit_disabled');
				
				var module_srl = $('div.xewall div.write_form select.default_listen_array').val();
				var category_srl = $('#board_category').val();
				var title = $('div.xewall div.write_form input.doc_title').val();
				var document_srl = $(this).siblings('.editor:first').children('form:first').attr('editor_sequence');
				
				$('div.xewall .loading').show();
				var $that = $(this);
				
				var myCall = new MyMethodCall('xewall', 'procXewallInsertDocument');
				myCall.addElement('module_srl', module_srl).addElement('title', title).addCDATAElement('content', content);
				myCall.addElement('document_srl', document_srl);
				//if (category_srl)
				myCall.addElement('category_srl', category_srl);
				myCall.callAjax(function(data){
					if (parseInt($(data).find('error').text())) {
						console.log(data);
						return false;
					}
					// 에디터 박스 지우기, 원래의 텍스트 박스 보이기
					$('div.xewall .write_form .editor form').children().each(function() {
						var will_remove = true;
						var inputName = $(this).attr('name');
						if (inputName == 'document_srl') will_remove = false;
						else if (inputName == 'comment_srl') will_remove = false;
						else if (inputName == 'content') will_remove = false;
						else if ($(this).attr('class') == 'txt_area') will_remove = false;
						else will_remove = true;
						if (will_remove)
							$(this).remove();
					});
					// 에디터 폼의 document_srl 과 comment_srl 등 모두 초기화
					var $editor_form = $('div.xewall .write_form .editor form');
					$editor_form.children('input[name="document_srl"]').val('');
					$editor_form.children('input[name="comment_srl"]').val('');
					$editor_form.children('input[name="content"]').val('');
					
					// content 값을 빈 값으로 만들어 주기
					$('div.xewall .write_form .hidden_by_editor').hide();
					$('div.xewall .write_form .hidden_by_editor .doc_title').val('');
					var txt_area = $('div.xewall .write_form .txt_area').clone(true);
					txt_area.css('display', 'block');
					$('div.xewall .write_form .editor form').append(txt_area);
					txt_area = null;
					$('div.xewall .loading').hide();
					
					// 게시 버튼 활성화
					$that.bind('click', event_handler.onSubmitClick);
					// "게시" 로 변경
					$that.text(xewall_lang.write);
					// CSS를 기다림으로 변경
					$that.removeClass('btn_submit_disabled');
					$that.addClass('btn_submit_enabled');
					
					// 새로고침
					functions.refresh_document_list(Xewall.default_listen, 1, list_count);
					
				}, function(a, b, c){
					$('div.xewall .loading').hide();
					
					// 게시 버튼 활성화
					$that.bind('click', event_handler.onSubmitClick);
					// "게시" 로 변경
					$that.text(xewall_lang.write);
					// CSS를 기다림으로 변경
					$that.removeClass('btn_submit_disabled');
					$that.addClass('btn_submit_enabled');
					
				}, false);
				myCall = null;
			},
			
			/**
			 * 추천 클릭했을 경우
			 * 만약에 내가 이 게시물에 추천을 했으면 추천 취소기능까지 구현하도록
			 */
			onVoteClick: function(event) {
				var document_srl = parseInt($(this).attr('document_srl'));
				var myCall = new MyMethodCall();
				myCall.setModule('xewall').setAct('procXewallDocumentVoteUp').addElement('target_srl', document_srl);
				myCall.callAjax(function(data){
					// 반환된 데이터를 DOM과 Array에 업데이트 시킨다.
					functions.refresh_document(document_srl, false);
				}, function(){
					// TODO 모든 alert을 console.log로 바꾸기
					alert('failed!');
				}, true);
				myCall = null;
			},
			
			/**
			 * 비추천을 클릭했을 경우
			 * 만약에 내가 이 게시물에 비추천을 했으면 비추천 취소기능까지 구현하도록 한다.
			 */
			onBlameClick: function(event) {
				var document_srl = $(this).attr('document_srl');
				var that = $(this);
				var myCall = new MyMethodCall();
				myCall.setModule('xewall').setAct('procXewallDocumentVoteDown').addElement('target_srl', document_srl);
				myCall.callAjax(function(data){
					console.log(data);
					// 반환된 데이터를 DOM과 Array에 업데이트 시킨다.
					functions.refresh_document(document_srl, false);
				}, function(){
					// TODO 모든 alert을 console.log로 바꾸기
					alert('failed!');
				}, true);
			},
			
			
			/**
			 * "삭제" 를 눌렀을 때 - "삭제하시겠습니까?" 보이기
			 */
			onDeleteClick: function(event) {
				// #popup_menu_area 를 body에 추가시키기
				$('#popup_menu_area').remove();
				$('body').append("<div id='popup_menu_area' style='display:none;z-index:999;'></div>");
				
				// document_srl 얻기
				var document_srl = $(this).attr('document_srl');
				
				// dummy 얻어서 적절한 document_srl 정보를 기록한다.
				var $popDummy = $('.dummies .delete_confirm').clone(true);
				$popDummy.find('.delete_confirm_yes').attr('document_srl', document_srl);
				
				// popup을 띄운다.
				var params = new Array();
				var ret_obj = new Array();
				ret_obj['menus'] = null;
				params['menu_id'] = 'xewall';
				params['page_x'] = event.pageX;
				params['page_y'] = event.pageY;
				XE.loaded_popup_menus['xewall'] = $popDummy.html();
				XE.displayPopupMenu(ret_obj, null, params);
				// 이벤트 추가 => 진짜로 삭제 누르면 서버에 삭제 요청을 보낼 수 있도록 이벤트 추가시킨다.
				$('#popup_menu_area .delete_confirm_yes').unbind('click');
				$('#popup_menu_area .delete_confirm_yes').click(event_handler.onDeleteConfirmYesClick);
				return false;
			},
			
			
			/**
			 * "삭제하시겠습니까?" 에서 "예"를 클릭했을 때 삭제 실행
			 */
			onDeleteConfirmYesClick: function() {
				var document_srl = $(this).attr('document_srl');
				
				var myCall = new MyMethodCall('xewall', 'procXewallDeleteDocument');
				myCall.addElement('document_srl', document_srl);
				myCall.callAjax(function(data, textStatus, xhr) {
					console.log(data);
					// 실패시 취소
					if (parseInt($(data).find('error'))) return;
					// 성공시 documentList에서 문서 제거, 그리고 HTML 요소 제거
					documentList[document_srl] = null;
					
					// 사라지는 효과 적용
					$('.document_srl_' + document_srl).hide('slide', {direction:'up'}, 1000, function() {
						$('.document_srl_' + document_srl).remove();
					})					
				}, function(xhr, textStatus) {
					console.log(textStatus);
				}, false);
				myCall = null;
			},
			
			
			/**
			 * "수정" 버튼을 눌렀을 때 - content 가리고
			 * modify_form을 보여준 다음 여기에 에디터 불러와서 수정 내용 넣기
			 */
			onModifyClick: function(event) {
				var document_srl = $(this).attr('document_srl');
				var module_srl = $(this).attr('module_srl');
				var $modify_form = $('div.xewall .document_srl_' + document_srl + ' .right .middle .modify_form');
				var content = '';
				
				if (!document_srl || !module_srl) return;
				
				// 수정 전의 content 불러오기
				var myCall = new MyMethodCall('xewall', 'getXewallDocumentContent');
				myCall.addElement('document_srl', document_srl);
				myCall.callAjax(function(data, textStatus, xhr) {
					content = $(data).find('content').text();
				}, function(xhr, textStatus) {
					content = '';
				}, false);
				myCall = null;
				
				// 에디터 불러와서 출력
				var $editorDOM = $modify_form.find('.editor:first');
				var editor_type = 'SIMPLE';
				
				// 문서 수정: document_srl, upload_target_srl 필요 (document_srl = upload_target_srl)
				var ref = {
						document_srl: document_srl,
						upload_target_srl: document_srl,
						comment_srl: 0,
						parent_srl:0
				};
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.MOD_COMM);
				$modify_form.fadeIn();
				// content, summary, thumbnail 가리기
				$modify_form.siblings('.thumbnail').hide();
				$modify_form.siblings('.summary').hide();
				$modify_form.siblings('.content').hide();
				$modify_form.siblings('.clear').hide();
				// title의 내용을 옮겨 적기
				$modify_form.parent().siblings('.title').hide();
				$modify_form.parent().parent().find('.modify_title').val(documentList[document_srl].title);
			},
			
			
			/**
			 * 진짜 "수정" (go_modify)를 눌렀을 때 실제로 수정하기
			 */
			onGoModifyClick: function() {
				// content 얻기
				var editor_seq = $(this).siblings('form').attr('editor_sequence');
				var content = window.editorGetContent(editor_seq);
				
				// 얻어진 content가 없으면 취소
				if (!content) return;
				
				var title = $(this).siblings('.modify_title').val();
				//return false;
				var document_srl = $(this).attr('document_srl');
				var module_srl = $(this).attr('module_srl');
				
				// 서버에 변경된 내용 보내기
				var myCall = new MyMethodCall('xewall', 'procXewallInsertDocument');
				
				myCall.addElement('document_srl', document_srl).addElement('module_srl', module_srl).addCDATAElement('content', content).addElement('title', title);
				myCall.callAjax(function(data, textStatus, xhr) {
					// 그냥 해당 문서 정보 업데이트 시킨다.
					functions.refresh_document(document_srl, true);
				}, function(xhr, textStatus) {
					
				}, false);
				myCall = null;
				$(this).parent().parent().siblings('.thumbnail').show();
				$(this).parent().parent().siblings('.summary').show();
				$(this).parent().parent().siblings('.content').hide();
				$(this).parent().parent().siblings('.clear').show();
				$(this).parent().parent().hide();
				$(this).parent().parent().parent().siblings('.title').show();
				
				$(this).parent().removeAttr('editor_sequence');
				$(this).siblings('input[name="document_srl"]').val('');
				$(this).siblings('input[name="content"]').val('');
				$(this).siblings('.editor').children().remove();
			},
			
			
			/**
			 * 수정 "취소" 버튼을 눌렀을 때 에디터 없애고 summary, thumbnail등 보이기
			 */
			onCancelModifyClick: function() {
				$(this).parent().parent().siblings('.thumbnail').show();
				$(this).parent().parent().siblings('.summary').show();
				$(this).parent().parent().siblings('.content').hide();
				$(this).parent().parent().parent().siblings('.title').show();
				$(this).parent().parent().siblings('.clear').show();
				$(this).parent().parent().hide();
			},
			
			/**
			 * 수정시 "에디터 사용하기" 버튼을 눌렀을 때 (토글로 에디터를 보였다가 간단히 글쓰기를 보였다가 한다.)
			 */
			onUseEditorToggle: function() {
				// 에디터 사용하기일 때 에디터 불러옴
				var $editorDOM = $(this).parent();
				var document_srl = $(this).siblings('form').find('input[name="document_srl"]').val();
				var editor_type = $(this).attr('state');
				var content = $(this).siblings('form').children('input[name="content"]').val();
				
				// 문서 수정: document_srl, upload_target_srl 필요. document_srl = upload_target_srl
				var ref = {
						upload_target_srl: document_srl,
						document_srl: document_srl,
						comment_srl:0,
						parent_srl:0
				};
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.MOD_COMM);
				if ($(this).attr('state') == 'FULL') {
					$(this).attr('state', 'SIMPLE');
					$(this).val($(this).attr('lang_simple'));
				} else {
					$(this).attr('state', 'FULL');
					$(this).val($(this).attr('lang_use_editor'));
				}
			},
			
			/**
			 * 댓글 버튼을 눌렀을 때 댓글들의 리스트들을 불러와서 출력시킨다.
			 */
			onLeaveCommentClick: function(event) {
				var document_srl = $(this).attr('document_srl');
				
				// 댓글 달기 창은 토글링 한다.
				var $comment_block = $('.document_srl_' + document_srl).find('.comment_write_form');
				
				if ($comment_block.css('display') == 'block') {
					$comment_block.hide('slide', {direction:"up"}, 500, null);
					$('.document_srl_' + document_srl).find('.comment_box').hide('slide', {direction:"up"}, 1000, null);
					return;
				}
				
				// 댓글 리프레쉬 시키면 댓글들의 리스트들이 출력된다.
				functions.refresh_comment_list(document_srl);
				
				// eotrmf 달기 창 나타내기
				$comment_block.show('bounce', {}, 500, null);
				
				$('.document_srl_' + document_srl).find('.comment_box').show('slide', {direction:"up"}, 1000, null);
				
				return;
			},
			
			
			/**
			 * 댓글의 summary를 클릭하면 댓글의 content를 불러오고 summary를 가린다.
			 */
			onCommContentClick: function() {
				var comment_srl = parseInt($(this).attr('comment_srl'));
				var document_srl = parseInt($(this).attr('document_srl'));
				var myCall = new MyMethodCall('xewall', 'getXewallComment');
				myCall.addElement('comment_srl', comment_srl).addElement('include_content', true);
				//myCall.addElement('include_content', true);
				myCall.callAjax(function(data, textStatus, xhr) {
					// documentList에 저장
					documentList[document_srl].comments[comment_srl].setCommentObj($(data).find('comment'));
					
					// HTML DOM 에 내역 반영
					var $commentDOM = $('.comment_srl_' + comment_srl);
					documentList[document_srl].comments[comment_srl].setInfoToDomObj($commentDOM);
					
					// summary 가리고 content 보이기
					// 에니메이션 효과 적용
					var $comm = $('.comment_srl_' + comment_srl);
					var $summary = $comm.find('.comm_summary');
					var $content = $comm.find('.comm_content');
					var $see_summary = $comm.find('.comm_see_summary');
					
					$summary.hide('slide', {direction:'up'}, 500, function() {
						$content.show('slide', {direction:'down'}, 500, null);
						$see_summary.show('slide', {direction:'down'}, 500, null);
					});
					
				}, function(xhr, textStatus) {
					console.log(textStatus);
				});
				myCall = null;
			},
			
			/**
			 * 댓글 내용 자세히 보기 했을 때 "간단히 보기"를 클릭했을 경우 내용을 가리고 요약과 "더 보기"을 보여준다.
			 */
			onCommSeeSummaryClick: function() {
				var $see_simple = $(this);
				var $content = $(this).siblings('.comm_content');
				var $summary = $(this).siblings('.comm_summary');
				
				$see_simple.hide();
				$content.hide('slide', {direction:'up'}, 500, function() {
					$summary.show('slide', {direction:'down'}, 500);
				});	
			},
			
			/**
			 * 댓글 쓰기를 클릭했을 때, "댓글을 입력하세요..." 내용 지우기
			 */
			onCommentWriteClick: function() {
				$(this).val('');
			},
			
			/**
			 * 댓글 쓰는 창에서 엔터키를 눌렀을 때 댓글 전송을 하도록 한다.
			 */
			onCommentKeyUp: function(event) {
				// 엔터키를 눌렀을 때 댓글 전송
				if (event.keyCode == 13) {
					// 댓글 전송
					//event_handler.onCommentSubmitClick();
				}
				// 엔터키가 아니라면 키가 눌러진 것으로 간주하고 에디터의 내용이 변경 되었음을 알린다.
				else {
					$(this).attr('changed', 'true');
				}
			},
			
			/**
			 * 댓글 쓰기(전송)을 눌렀을 때 댓글의 내용을 서버로 전송시킨다.
			 */
			onCommentSubmitClick: function() {
				// 게시버튼 비활성화
				$(this).unbind('click');
				var $that = $(this);
				
				// TODO 기다려 주세요... 아이콘 만들기...
				
				var $content = null;
				var content = null;
				var document_srl = $(this).attr('document_srl');
				var module_srl = $(this).attr('module_srl');
				var comment_srl = 0;
				
				// 먼저 .class_write 텍스트 박스가 활성화 되어있는지 확인해서 텍스트 박스에서 데이터를 들고오느냐, 에디터에서 들고오느냐 결정
				if ($(this).siblings('.editor').find('.comment_write').length) {
					// 텍스트박스에서 불러오기
					content = $(this).siblings('.editor:first').find('.comment_write').val();
				} else {
					// 에디터에서 불러오기
					$content = $(this).siblings('.editor:first').find('iframe:first').contents();
					// TODO editorRelKeys[] 에는 어떤 값이 들어가는가?
					content = $content.find('body:first').html();
					comment_srl = $(this).siblings('.editor:first').find('input[name="comment_srl"]:first').val();
				}
				var $comment_write = $(this).siblings('.editor:first').children('form:first').children('input.comment_write');
				// 만약 보내는 데이터가 없으면 텍스트 박스에 포커스를 주고 취소시켜서 서버와 통신 취소
				if ($comment_write.attr('changed') === 'false') {
					$comment_write.val($comment_write.attr('default_value'));
					$comment_write.focus();
					return false;
				}
				
				// 댓글 내용을 서버에 전송한다.
				var myCall = new MyMethodCall('xewall', 'procXewallInsertComment');
				myCall.addElement('is_new', 'true');
				myCall.addElement('comment_srl', comment_srl);
				myCall.addElement('document_srl', document_srl);
				myCall.addElement('module_srl', module_srl);
				myCall.addCDATAElement('content', content);
				myCall.callAjax(function(data) {
					// 이벤트 재활성화
					$that.bind('click', event_handler.onCommentSubmitClick);
					functions.refresh_comment_list(document_srl);
				}, function(xhr, textStatus) {
					// 이벤트 재활성화
					$that.bind('click', event_handler.onCommentSubmitClick);
					functions.refresh_comment_list(document_srl);
				}, false);
				myCall = null;
				// 댓글 창 원위치
				$(this).siblings('.editor').find('.comment_write').val($(this).siblings('.comment_write').attr('default_value'));
				// "에디터 사용" 버튼 다시 활성화
				$(this).siblings('.comment_use_editor').show();
				// 그리고 에디터 창 닫기
				$(this).siblings('.editor').remove();
				var $newEditor = $('.document_ori .right .comment_write_form .editor').clone(true);
				$(this).parent().prepend($newEditor);
				$newEditor = null;
			},
			
			/**
			 * 댓글의 "에디터 사용"을 클릭했을 때
			 * 에디터를 불러와서 기존의 댓글 창을 없애고 에디터로 교체.
			 */
			onCommentUseEditorClick: function() {
				var $editorDOM = $(this).siblings('.editor:first');
				var $content = null;
				var content = null;
				var isCommentWrite = $editorDOM.find('.comment_write:first').length;
				// 새 댓글 달기: document_srl만 필요
				var document_srl = $(this).attr('document_srl');
				// Simple Editor 에서 Editor 로 넘어가기
				if (isCommentWrite) {
					// 원래 내용 유지시키기
					content = $editorDOM.find('comment_write:first').val();
					// 에디터 불러오기
					var ref = {
							upload_target_srl:0,
							document_srl:document_srl,
							comment_srl:0,
							parent_srl:0
					};
					functions.call_editor($editorDOM, ref, 'FULL', content, CALL_TYPE.NEW_COMM);
					// 버튼 없애기
					$(this).hide();
				}
				else {
					return false;
				}
			},
			
			
			/**
			 * 댓글의 "삭제"을 클릭했을 때 삭제 확인 창을 띄우기 comm_delete
			 */
			onCommentDeleteClick: function(event) {
				// 먼저 #popup_menu_area body에 추가시키기
				$('#popup_menu_area').remove();
				$('body').append("<div id='popup_menu_area' style='display:none;z-index:999;'></div>");
				
				// comment_srl, document_srl 얻기
				var comment_srl = $(this).attr('comment_srl');
				var document_srl = $(this).attr('document_srl');
				
				// confirm 창 더미 복사하고 알맞은 comment_srl 값 기록하기
				var $delDummy = $('.dummies .delete_confirm').clone(true);
				$delDummy.find('.delete_confirm_yes').attr('comment_srl', comment_srl).attr('document_srl', document_srl);
				
				// popup menu 출력
				var params = new Array();
				var ret_obj = new Array();
				ret_obj['menus'] = null;
				params['menu_id'] = 'xewall';
				params['page_x'] = event.pageX;
				params['page_y'] = event.pageY;
				XE.loaded_popup_menus['xewall'] = $delDummy.html();
				XE.displayPopupMenu(ret_obj, null, params);
				
				// 이벤트 추가 => 진짜로 삭제 누르면 서버에 삭제 요청을 보낼 수 있도록 이벤트 추가시킨다.
				$('#popup_menu_area .delete_confirm_yes').unbind('click');
				$('#popup_menu_area .delete_confirm_yes').click(event_handler.onCommentGoDeleteClick);
				return false;
			},
			
			/**
			 * 댓글의 삭제 확인 창에서 진짜 "삭제"를 눌렀을 때 서버에 삭제 요청을 보낸다.
			 */
			onCommentGoDeleteClick: function() {
				var comment_srl = $(this).attr('comment_srl');
				var document_srl = $(this).attr('document_srl');
				var myCall = new MyMethodCall('xewall', 'procXewallDeleteComment');
				myCall.addElement('comment_srl', comment_srl);
				myCall.callAjax(function(data) {
					// 사라지는 효과를 보이도록 한다.
					$('.comment_srl_' + comment_srl).hide('slide', {direction:'up'}, 500, function() {
						// comment_list 재로딩
						functions.refresh_comment_list(document_srl);
					});
				}, function() {
					console.log(data);
				}, false);
				myCall = null;
			},
			
			/**
			 * 댓글의 추천을 눌렀을 경우 서버에 추천 요청을 보낸다.
			 */
			onCommentVoteUp: function() {
				var comment_srl = $(this).attr('comment_srl');
				var myCall = new MyMethodCall();
				myCall.setModule('xewall').setAct('procXewallVoteComment').addElement('target_srl', comment_srl);
				myCall.callAjax(function(data, textStatus, xhr) {
					functions.refresh_comment(comment_srl, false);
				}, function(xhr, textStatus) {
					console.log(textStatus);
				}, true);
				myCall = null;
			},
			
			/**
			 * 댓글의 비추를 눌렀을 경우 서버에 비추 요청을 보낸다.
			 */
			onCommentVoteDown: function() {
				var comment_srl = $(this).attr('comment_srl');
				var myCall = new MyMethodCall();
				myCall.setModule('xewall').setAct('procXewallBlameComment').addElement('target_srl', comment_srl);
				myCall.callAjax(function(data, textStatus, xhr) {
					functions.refresh_comment(comment_srl, false);
				}, function(xhr, textStatus) {
					console.log(textStatus);
				}, true);
				myCall = null;
			},
			
			
			/**
			 * 댓글의 수정을 눌렀을 때 수정 창을 보여준다.
			 */
			onCommentModify: function() {
				
				var comment_srl = $(this).attr('comment_srl');
				var document_srl = $(this).attr('document_srl');
				var $editorDOM = $('.comment_srl_' + comment_srl).find('.editor:first');
				var content = '';
				
				// 수정 전의 content 불러오기 // TODO 약간의 문제가 있음. async 문제인듯.
				if (documentList[document_srl].comments[comment_srl].content == null) {
					functions.refresh_comment(comment_srl, true);
				}
				content = documentList[document_srl].comments[comment_srl].content;
				// 댓글의 수정 document_srl, comment_srl, parent_srl 이 필요. parent_srl = 0, upload_target_srl = comment_srl
				var ref = {
						upload_target_srl: comment_srl,
						document_srl: document_srl,
						comment_srl: comment_srl,
						parent_srl: 0
				};
				functions.call_editor($editorDOM, ref, 'SIMPLE', content, CALL_TYPE.MOD_COMM);
				
				$editorDOM.show();
				$editorDOM.siblings('.comm_summary').hide();
				$editorDOM.siblings('.comm_content').hide();
				$editorDOM.siblings('.comm_see_summary').hide();
			},
			
			
			/**
			 * 댓글 수정창에서 "수청"을 눌렀을 경우 에디터의 내용을 서버에 보내어 댓글을 수정시킨다.
			 */
			onComentGoModify: function() {
				var $editorDOM = $(this).parent();
				var document_srl = $(this).siblings('form').find('input[name="document_srl"]:first').val();
				var comment_srl = $(this).siblings('form').find('input[name="comment_srl"]:first').val();
				
				// 내용 얻기
				var editor_seq = $editorDOM.children('form:first').attr('editor_sequence');
				var content = window.editorGetContent(editor_seq);
				
				// 내용 얻은게 없으면 취소
				if (!content) return;
				
				// 게시 버튼 비활성화
				$(this).unbind('click');
				var $that = $(this);
				
				var myCall = new MyMethodCall('xewall', 'procXewallInsertComment');
				myCall.addElement('comment_srl', comment_srl);
				myCall.addElement('document_srl', document_srl);
				myCall.addCDATAElement('content', content);
				myCall.callAjax(function(data, textStatus, xhr) {
					//functions.refresh_comment(comment_srl, false);
					functions.refresh_comment_list(document_srl);
					$editorDOM.siblings('.comm_summary').hide();
					$editorDOM.siblings('.comm_content').show();
					$editorDOM.siblings('.comm_see_summary').show();
					$editorDOM.hide();
					// 게시 버튼 다시 활성화
					$that.bind('click', event_handler.onComentGoModify);
				}, function(xhr, textStatus) {
					functions.refresh_comment(comment_srl, false);
					$editorDOM.siblings('.comm_summary').hide();
					$editorDOM.siblings('.comm_content').show();
					$editorDOM.siblings('.comm_see_summary').show();
					$editorDOM.hide();
					// 게시 버튼 다시 활성화
					$that.bind('click', event_handler.onComentGoModify);
				}, true);
				myCall = null;
			},
			
			
			
			/**
			 * 댓글 수정창에서 "에디터 사용"을 눌렀을 경우 FULL 에디터를 불러와서 적용
			 */
			onComentUseEditor: function() {
				var $editorDOM = $(this).parent();
				var document_srl = $editorDOM.find('input[name="document_srl"]:first').val();
				var comment_srl = $editorDOM.find('input[name="comment_srl"]:first').val();
				var parent_srl = $editorDOM.find('input[name="parent_srl"]:first').val();
				var ref = {
						document_srl:document_srl,
						comment_srl:comment_srl,
						parent_srl:parent_srl,
						upload_target_srl:comment_srl
				};
				
				var editor_type = "FULL";
				var $content = $editorDOM.find('iframe:first').contents();
				var content = $content.find('body:first').html();
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.MOD_COMM);
				
				// "에디터 사용" 버튼 숨기기
				$(this).hide();
			},
			
			
			/**
			 * 댓글 수정창에서 취소를 눌렀을 경우 에디터를 숨기고 summary와 content를 보이도록 한다.
			 */
			onComentCancelModify: function() {
				var $editorDOM = $(this).parent();
				$editorDOM.siblings('.comm_summary').hide();
				$editorDOM.siblings('.comm_content').show();
				$editorDOM.siblings('.comm_see_summary').show();
				$editorDOM.hide();
				$editorDOM = null;
				
				// "에디터 사용" 버튼 보이기
				$(this).siblings('.use_editor').show();
			},
			
			
			/**
			 * 댓글에 "댓글달기" 버튼을 눌렀을 때 댓글 달기 창을 보여주도록 한다.
			 */
			onComentReply: function() {
				var $comm_reply_box = $(this).parent().siblings('.comm_reply_box');
				// 댓글 달기 창 보였다가 가렸다가 토글하기
				if ($comm_reply_box.css('display') == 'none') {
					var $editorDOM = $comm_reply_box.children('.editor:first');
					var document_srl = $(this).attr('document_srl');
					var comment_srl = $(this).attr('parent_srl');
					var upload_target_srl = 0;
					var editor_type = 'SIMPLE';
					var content = '';
					$comm_reply_box.fadeIn();
					// 새 대댓글 달기: document_srl, parent_srl 필요. upload_target_srl = 0
					var ref = {
							upload_target_srl:0,
							document_srl: document_srl,
							comment_srl:0,
							parent_srl: comment_srl
					};
					functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.NEW_CCOMM);
				} else {
					$comm_reply_box.fadeOut();
					// "에디터 사용" 버튼 보이기
					$comm_reply_box.children('.editor:first').children('.use_editor:first').show();
				}
			}, 
			
			
			/**
			 * 댓글 달기 창에서 취소를 눌렀을 때 에디터를 가린다.
			 */
			onComentReplyCancelModify: function() {
				var $comm_reply_box = $(this).parent().parent();
				$comm_reply_box.fadeOut();
				// "에디터 사용" 버튼 다시 보이기
				$(this).siblings('.use_editor').show();
			},
			
			
			/**
			 * 댓글 달기 창에서 "에디터 사용"을 눌렀을 때 FULL 에디터를 불러오고 버튼 없애기
			 */
			onCommentReplyUseEditor: function() {
				var $editorDOM = $(this).parent();
				var document_srl = $editorDOM.find('input[name="document_srl"]:first').val();
				var comment_srl = $editorDOM.find('input[name="comment_srl"]:first').val();
				var parent_srl = $editorDOM.find('input[name="parent_srl"]:first').val();
				var ref = {
						document_srl:document_srl,
						comment_srl:comment_srl,
						parent_srl:parent_srl,
						upload_target_srl:comment_srl
				};
				var editor_type = "FULL";
				var $content = $editorDOM.find('iframe:first').contents();
				var content = $content.find('body:first').html();
				
				functions.call_editor($editorDOM, ref, editor_type, content, CALL_TYPE.NEW_CCOMM);
				
				// "에디터 사용" 버튼 제거
				$(this).hide();
			},
			
			
			/**
			 * 댓글 달기 창에서 "전송"을 눌렀을 때 에디터의 내용을 서버에 전송하고 댓글 창 리프레쉬 시킨다.
			 */
			onComentReplyGoModify: function() {
				// 필요 정보 얻기.
				var $editorDOM = $(this).parent();
				var document_srl = $editorDOM.find('input[name="document_srl"]:first').val();
				var comment_srl = $editorDOM.find('input[name="comment_srl"]:first').val();
				var parent_srl = $editorDOM.find('input[name="parent_srl"]:first').val();
				
				var $that = $(this);
				
				// 내용 얻기
				var editor_seq = $editorDOM.children('form').attr('editor_sequence');
				var content = window.editorGetContent(editor_seq);
				
				// 보낼 내용이 없으면 취소
				if (!content) return;
				
				// 게시버튼 비활성화
				$(this).unbind('click');
				
				// 요청.
				var myCall = new MyMethodCall('xewall', 'procXewallInsertComment');
				myCall.addElement('is_new', 'true');
				myCall.addElement('document_srl', document_srl);
				myCall.addElement('comment_srl', comment_srl);
				myCall.addElement('parent_srl', parent_srl);
				myCall.addCDATAElement('content', content);
				myCall.callAjax(function(data, textStatus, xhr) {
					//console.log(data);
					functions.refresh_comment_list(document_srl);
					// 게시버튼 다시 활성화
					$that.bind('click', event_handler.onComentReplyGoModify);
				}, function(xhr, textStatus) {
					//console.log(data);
					functions.refresh_comment_list(document_srl);
					// 게시버튼 다시 활성화
					$that.bind('click', event_handler.onComentReplyGoModify);
				}, false);
				myCall = null;
			},
			
			
			/**
			 * 게시판을 선택했을 때 (버튼으로 표현된 게시판을 눌렀을 때)
			 */
			onBoardListClick: function() {
				// 클릭된 게시판의 value 가 무엇인지 파악한다.
				var module_srl = parseInt($(this).attr('value'));
				
				// 만약 설정 버튼이라면 실행하지 않는다.
				if (module_srl == 2 || module_srl == 3) {
					return true;
				}
				
				// 기다려 주세요... 아이콘 보이기
				$('.loading').show();
				
				// 스크롤 이벤트 언바인드 시키기 (로딩 도중 다음 페이지가 로딩 되지 않도록 한다..)
				$(window).unbind('scroll');
				
				// 전역변수 default_listen 설정
				if (module_srl == 1) {
					Xewall.default_listen = Xewall.default_listen_init;
				}
				else {
					Xewall.default_listen = module_srl;
					// 클릭된 게시판을 .default_listen_array 에 적용시킨다.
					$('.default_listen_array').children().each(function() {
						if (module_srl == this.value) {
							$(this).attr('selected', 'selected');
						} else {
							$(this).removeAttr('selected');
						}
					});
					// #board_category의 내용 업데이트 한다.
					functions.setCategoryList(module_srl);
				}
				
				// 페이지 초기화
				page = 1;
				
				// documentList 변수 초기화 TODO 생각하기: 이 변수 계속 사용할 것인지??? 괜히 더 복잡해지는 것 같다.
				documentList = null;
				documentList = new Array();
				
				// HTML 요소들 제거
				$('.document').remove();
				
				// 재로딩
				functions.refresh_document_list(Xewall.default_listen, page, list_count);
				
				// 클릭된 버튼의 색깔 토글 시키기
				// 모든 li에 대해서...
				$('div.xewall .board_list_box .board_list_ul li').each(function() {
					// 만약 이 li 가 선택된 놈이라면 style 인위로 넣기
					if (this.value == module_srl) {
						$(this).css('background-color', 'white');
					} else {
						$(this).attr('style', '');
					}
				});
				
				$('.loading').show();
				
				// <a> 태그의 내용이 실행되지 않도록 막기
				return false;
			},
			dummy: 0
	};
	
	/**
	 * 페이지 로딩 완료시
	 * 최근 문서 목록을 불러온다. (xewall.model.php로 요청)
	 */
	$(document).ready(function() {
		
		// 전역변수 초기화
		list_count = $('div.xewall').attr('list_count');
		Xewall.default_listen = $('div.xewall').attr('default_listen');
		Xewall.default_listen_init = Xewall.default_listen;
		
		page = 1;
		$('div.xewall').removeAttr('list_count');
		$('div.xewall').removeAttr('default_listen');
		
		// 새로 고침 주기를 할당한다. 매 초마다 카운트 가감하고 0이 되면 새로고침 => 카운트 원위치
		// 만약에 notifycra 와 연동되어 있다면 새로고침을 할 필요가 없다.
		if (use_xmpp != 'Y') {
			setInterval(function() {
				if (--refresh_freq_1 === 0) {
					//event_handler.onRefreshClick();
					functions.refresh_document_list(Xewall.default_listen, 1, page * list_count);
					refresh_freq_1 = refresh_freq_0;
				}
			}, 1000);
		}
		
		
		// 이벤트 할당
		// 새로고침을 눌렀을 때
		$('div.xewall .refresh').click(function() {
			functions.refresh_document_list(Xewall.default_listen, 1, page * list_count);
		});
		
		
		// 간단히 글쓰기를 클릭했을 때 간단한 에디터를 불러와 출력
		$('div.xewall .write_form .txt_area').click(event_handler.onSimpleFormFocus);
		
		// 행여나 제목 쓰다가 엔터 눌렀을 때 submit 안되도록 한다.
		$('div.xewall form').submit(function() {return false;});
		
		// 에디터 사용 글쓰기를 클릭했을 때 에디터를 불러와 출력(기존의 간단 에디터 제거) // TODO 에디터 변환시 내용 유지시키기
		$('div.xewall .write_form .use_editor').click(event_handler.onEditorClick);
		
		// 게시판이 선택이 될 때마다 해당 게시판의 category들을 로드해 와서 출력시킨다.
		$('#default_listen_array').change(event_handler.onDefaultListenChange);
		
		// "간단히 글쓰기" 를 클릭했을 때 간단한 에디터를 불러와서 출력
		$('div.xewall .write_form .simple_form').click(event_handler.onSimpleFormClick);
		
		// 에디터에서 글을 다 쓰고 "게시" 버튼을 클릭했을 때 정보를 서버에 보내기
		$('div.xewall .write_form .btn_submit').click(event_handler.onSubmitClick);
		
		// 타이틀을, 또는 thumbnail을 눌렀을 때 summary와 thumbnail을 가리고 content를 보여주자.
		$('.document_ori .title .title').click(event_handler.onSummaryClick);
		$('.document_ori .middle .thumbnail').click(event_handler.onSummaryClick);
		$('.document_ori .middle .summary').click(event_handler.onSummaryClick);
		
		// 추천을 눌렀을 때
		$('.document_ori .right .bottom .voted_count').click(event_handler.onVoteClick);
		
		// 비추를 눌렀을 때
		$('.document_ori .right .bottom .blamed_count').click(event_handler.onBlameClick);
		
		// 삭제를 눌렀을 때 - 일단 "삭제하시겠습니까?
		$('.document_ori .right .bottom .delete').click(event_handler.onDeleteClick);
		
		// "수정" 버튼을 눌렀을 때 - content 가리고 modify_form을 보여준 다음 여기에 에디터 불러와서 수정 내용 넣기
		$('.document_ori .right .bottom .modify').click(event_handler.onModifyClick);
		
		// 진짜 "수정" (go_modify)를 눌렀을 때 실제로 수정하기
		$('.document_ori .right .middle .go_modify').click(event_handler.onGoModifyClick);
		
		// 수정 "취소" 버튼을 눌렀을 때 에디터 없애고 summary, thumbnail등 보이기
		$('.document_ori .right .middle .cancel_modify').click(event_handler.onCancelModifyClick);
		
		// 수정시 "에디터 사용하기" 버튼을 눌렀을 때 (토글로 에디터를 보였다가 간단히 글쓰기를 보였다가 한다.)
		$('.document_ori .right .middle .use_editor').click(event_handler.onUseEditorToggle);
		
		// 댓글을 눌렀을 때 댓글 리스트 불러오기(토글)
		$('.document_ori .right .bottom .leave_comment').click(event_handler.onLeaveCommentClick);
		
		// 댓글의 summary를 눌렀을 때 summary는 가리고 content를 보인다.
		$('.comment_ori .comm_summary').click(event_handler.onCommContentClick);
		
		// 댓글 내용 "간단히 보기"를 클릭했을 경우 내용을 가리고 요약을 보여준다.
		$('.comment_ori .comm_see_summary').click(event_handler.onCommSeeSummaryClick);
		
		// 댓글 창에서 엔터를 눌렀을 때 댓글 내용 전송
		$('.document_ori .right .comment_write_form .comment_write').keyup(event_handler.onCommentKeyUp);
		
		// 댓글 쓰기 창을 클릭했을 때 "댓글을 입력하세요..." 메시지 없애기
		$('.document_ori .right .comment_write_form .comment_write').click(event_handler.onCommentWriteClick);
		
		// 댓글 달기 버튼을 클릭했을 때 댓글의 내용을 서버에 전송해서 댓글을 달고 삽입된 내용/업데이트 된 내용을 반영한다.
		$('.document_ori .right .comment_write_form .comment_submit').click(event_handler.onCommentSubmitClick);
		
		// 댓글 쓰기에서 "에디터 사용"을 클릭했을 때 에디터를 불러와 배치하기
		$('.document_ori .right .comment_write_form .comment_use_editor').click(event_handler.onCommentUseEditorClick);
		
		// 댓글의 "삭제"을 클릭했을 때 삭제 확인 창을 띄우기
		$('.comment_ori .comm_right .comm_bottom .comm_delete').click(event_handler.onCommentDeleteClick);
		
		// 댓글의 추천을 눌렀을 때 추천을 실행한다.
		$('.comment_ori .comm_right .comm_bottom .comm_voted_count').click(event_handler.onCommentVoteUp);
		
		// 댓글의 비추를 눌렀을 때 비추를 실행한다.
		$('.comment_ori .comm_right .comm_bottom .comm_blamed_count').click(event_handler.onCommentVoteDown);
		
		// 댓글의 수정을 눌렀을 때 수정 창을 보여준다.
		$('.comment_ori .comm_right .comm_bottom .comm_modify').click(event_handler.onCommentModify);
		
		// 댓글 수정창에서 "수청"을 눌렀을 경우 에디터의 내용을 서버에 보내어 댓글을 수정시킨다.
		$('.comment_ori .comm_right .comm_middle .editor .go_modify').click(event_handler.onComentGoModify);
		
		// 댓글 수정창에서 "에디터 사용"을 눌렀을 경우 에디터를 FULL 에디터로 불러온다.
		$('.comment_ori .comm_right .comm_middle .editor .use_editor').click(event_handler.onComentUseEditor);
		
		// 댓글 수정창에서 취소를 눌렀을 경우 에디터를 숨기고 summary와 content를 보이도록 한다.
		$('.comment_ori .comm_right .comm_middle .editor .cancel_modify').click(event_handler.onComentCancelModify);
		
		// 댓글에 "댓글달기" 버튼을 눌렀을 때 댓글 달기 창을 보여주도록 한다.
		$('.comment_ori .comm_right .comm_bottom .comm_reply').click(event_handler.onComentReply);
		
		// 대댓글 달기 창에서 "취소"를 눌렀을 때 에디터를 가린다.
		$('.comment_ori .comm_right .comm_reply_box .editor .cancel_modify').click(event_handler.onComentReplyCancelModify);
		
		// 대댓글 달기 창에서 "에디터 사용"을 눌렀을 때 에디터를 보여준다.
		$('.comment_ori .comm_right .comm_reply_box .editor .use_editor').click(event_handler.onCommentReplyUseEditor);
		
		// 대댓글 달기 창에서 "전송" 을 눌렀을 때 에디터의 내용을 서버에 전송시키고 댓글 창 리프레쉬 시킨다.
		$('.comment_ori .comm_right .comm_reply_box .editor .go_modify').click(event_handler.onComentReplyGoModify);
		
		// browser_title 을 클릭했을 때 자바스크립트로 막아주고 마우스 가운데 버튼으로 클릭하면 창이 뜨도록 하기.
		$('.document_ori .right .top .browser_title').click(function() {return false;});
		
		// 게시판을 선택했을 때
		$('div.xewall .board_list_box .board_list_ul li').click(event_handler.onBoardListClick);
		
		// 테스트
		$('.test').click(function() {
			console.log(Xewall.default_listen);
		});
		
		// 문서 목록 불러오기
		functions.refresh_document_list(Xewall.default_listen_init, page, list_count);
		
		// 함수 빼기
		Xewall.functions = functions;
		
	});
});