jQuery(function($) {
	/**
	 * 문서 로딩 다 되었을시 변수, 폼 초기화, 이벤트 할당
	 */
	$(document).ready(function() {
		
		// module_list 와 available_module_list 사이의 오른쪽 화살표(->)를 눌렀을 때 moduleList에서 선택된 아이템은
		// 우측 available_module_list로 옮겨야 한다.
		$('#mod_move_right').click(function() {
			var selected_value = $('#module_list_s').val();
			$('#module_list_s').children().each(function() {
				if ($(this).val() == selected_value) {
					// 중복 내용이 있으면 취소
					var duplicated = false;
					$('#available_module_list_s').children().each(function() {
						if (selected_value == $(this).val())
							duplicated = true;
					});
					$('#default_module_list_s').children().each(function() {
						if (selected_value == $(this).val())
							duplicated = true;
					});
					if (duplicated) return;
					var copy = $(this).clone();
					$('#available_module_list_s').append(copy);
				}
			});
			return false;
		});
		
		// module_select_box 와 available_module_list 사이의 왼쪽 화살표(<-)를 눌렀을 때 selectedModuleList에 선택되어있는
		// 아이템들을 삭제한다.
		$('#mod_move_left').click(function() {
			var selected_value = $('#available_module_list_s').val();
			$('#available_module_list_s').children().each(function() {
				if (selected_value == $(this).val())
					$(this).remove();
			});
		});
		
		
		// available_module_list 와 default_module_list 사이의 오른쪽 화살표(->)를 눌렀을 때 available_module_list에 선택
		// 되어있는 아이템을 default_module_list에 옮기도록 한다.
		$('#ava_move_right').click(function() {
			var selected_value = $('#available_module_list_s').val();
			$('#available_module_list_s').children().each(function() {
				if ($(this).val() == selected_value) {
					// 우측 default_module_list 에 중복 내용이 있으면 취소
					var duplicated = false;
					$('#default_module_list_s').children().each(function() {
						if (selected_value == $(this).val())
							duplicated = true;
					});
					if (duplicated) return;
					var copy = $(this).clone();
					$('#default_module_list_s').append(copy);
					$(this).remove();
				}
			});
			return false;
		});
		
		// available_module_list 와 default_module_list 사이의 왼쪽 화살표(<-)를 눌렀을 때 default_module_list에 선택되어
		// 있는 아이템을 available_module_list에 옮기도록 한다.
		$('#ava_move_left').click(function() {
			var selected_value = $('#default_module_list_s').val();
			$('#default_module_list_s').children().each(function() {
				if ($(this).val() == selected_value) {
					// 좌측 available_module_list에 중복 내용이 있으면 취소
					var duplicated = false;
					$('#available_module_list_s').children().each(function() {
						if (selected_value == $(this).val())
							duplicated = true;
					});
					if (duplicated) return;
					var copy = $(this).clone();
					$('#available_module_list_s').append(copy);
					$(this).remove();
				}
			});
			return false;
		});
		
		
		// available_module_list 박스의 아래 화살표를 눌렀을 때 선택된 available_module_list의 priority 내리기
		$('#ava_move_down').click(function() {
			var selected_value = $('#available_module_list_s').val();
			var $item = null;
			var place = 0;
			
			// 맨 아래 아이템이라면 취소
			var cancel = false;
			$('#available_module_list_s').children().each(function(idx) {
				if (selected_value == $(this).val() && idx == $('#available_module_list_s').children().length - 1) {
					cancel = true;
				}
			});
			if (cancel) return;
			
			// 복사, 삭제
			$('#available_module_list_s').children().each(function(idx) {
				if (selected_value == $(this).val()) {
					$item = $(this).clone();
					$(this).remove();
					place = idx;
				}
			});
			
			// 삽입
			$('#available_module_list_s').children().each(function(idx) {
				if (idx == place) {
					$(this).after($item);
				}
			});
			
			return false;
		});
		
		// available_module_list 의 위로 화살표를 눌렀을 때 선택된 available_module_list의 priority 올리기
		$('#ava_move_up').click(function() {
			var selected_value = $('#available_module_list_s').val();
			var $item = null;
			var place = 0;
			
			// 맨 위 아이템이라면 취소
			var cancel = false;
			$('#available_module_list_s').children().each(function(idx) {
				if (selected_value == $(this).val() && idx == 0) {
					cancel = true;
				}
			});
			if (cancel) return;
			
			// 복사, 삭제
			$('#available_module_list_s').children().each(function(idx) {
				
				if (selected_value == $(this).val()) {
					$item = $(this).clone();
					$(this).remove();
					place = idx;
				}
			});
			
			// 삽입
			$('#available_module_list_s').children().each(function(idx) {
				if (idx == place - 1) {
					$(this).before($item);
				}
			});
			
		});
		
		// default_module_list 박스의 아래 화살표를 눌렀을 때 선택된 default_module_list_s 의 priority 내리기
		$('#def_move_down').click(function() {
			var selected_value = $('#default_module_list_s').val();
			var $item = null;
			var place = 0;
			
			// 맨 아래 아이템이라면 취소
			var cancel = false;
			$('#default_module_list_s').children().each(function(idx) {
				if (selected_value == $(this).val() && idx == $('#default_module_list_s').children().length - 1) {
					cancel = true;
				}
			});
			if (cancel) return;
			
			// 복사, 삭제
			$('#default_module_list_s').children().each(function(idx) {
				if (selected_value == $(this).val()) {
					$item = $(this).clone();
					$(this).remove();
					place = idx;
				}
			});
			
			// 삽입
			$('#default_module_list_s').children().each(function(idx) {
				if (idx == place) {
					$(this).after($item);
				}
			});
			
			return false;
		});
		
		// default_module_list 의 위로 화살표를 눌렀을 때 선택된 default_module_list_s 의 priority 올리기
		$('#def_move_up').click(function() {
			var selected_value = $('#default_module_list_s').val();
			var $item = null;
			var place = 0;
			
			// 맨 위 아이템이라면 취소
			var cancel = false;
			$('#default_module_list_s').children().each(function(idx) {
				if (selected_value == $(this).val() && idx == 0) {
					cancel = true;
				}
			});
			if (cancel) return;
			
			// 복사, 삭제
			$('#default_module_list_s').children().each(function(idx) {
				
				if (selected_value == $(this).val()) {
					$item = $(this).clone();
					$(this).remove();
					place = idx;
				}
			});
			
			// 삽입
			$('#default_module_list_s').children().each(function(idx) {
				if (idx == place - 1) {
					$(this).before($item);
				}
			});
			
		});
		
		// 모듈 리스트 저장 버튼이눌러졌을 때 해당 사항이 저장되어야 한다.
		// 필수로 보여지는 모듈은 -1 이 듣는 것으로 해두자.
		$('div.module_select_box .btnSave').click(function() {
			var responses = [];
			var $lists = $('#available_module_list_s').children();
			var available_module_list = new Array();
			$lists.each(function() {
				available_module_list.push($(this).val());
			});
			
			$list = $('#default_module_list_s').children();
			var default_module_list = new Array();
			$list.each(function() {
				default_module_list.push($(this).val());
			});
			var params = {
					available_module_list: available_module_list.join(),
					default_module_list: default_module_list.join()
			};
			exec_xml('xewall', 'procXewallAdminSaveModuleList', params, function(ret_obj) {
				alert(ret_obj['message']);
				location.reload(true);
			}, responses, params);
		});
		
		// 네비게이션 관련 설정사항 저장
		$('div.document_navi_box .btnSave').click(function() {
			var responses = [];
			var params = {
					doc_sort_index: $('.doc_sort_index').val(),
					doc_order_type: $('.doc_order_type').val(),
					doc_list_count: $('input[name="doc_list_count"]').val()
			};
			exec_xml('xewall', 'procXewallAdminSaveNavi', params, function(ret_obj) {
				alert(ret_obj['message']);
				location.reload(true);
			}, responses, params);
		});
		
		// 에디터와 관련된 사항들을 저장
		$('div.editor_config .btnSave').click(function() {
			var params = {};
			var responses = [];
			params = {
					allow_fileupload: $('#allow_fileupload').is(':checked'),
					enable_autosave: $('#enable_autosave').is(':checked'),
					enable_default_component: $('#enable_default_component').is(':checked'),
					enable_component: $('#enable_component').is(':checked'),
					resizable: $('#resizable').is(':checked'),
					disable_html: $('#disable_html').is(':checked'),
					height: $('#height').val(),
					skin: $('#skin').val()
			};
			exec_xml('xewall', 'procXewallAdminSaveEditor', params, function(ret_obj) {
				alert(ret_obj['message']);
				location.reload(true);
			}, responses, params);
		});
	});
});