/**
 * @file MyMethodCall.js
 * @author 바람꽃 (wndflwr@gmail.com)
 * @brief XE에게 ajax 요청을 보낸다. 요청을 보내기 전 반드시 setModule()과 setAct()를 사용해
 * 요청을 보낼 서버의 모듈과 act를 지정하도록 한다.
 * 필요한 변수들은 addElement로 넣고 CDATA 형식의 데이터는 addCDATAElement()를 사용하도록 하자.
 * @returns this
 */
function MyMethodCall(module, act) {
	this.xmlString = '<?xml version="1.0" encoding="utf-8"?><methodCall><params><module>';
	if (module) {
		this.xmlString += module;
	}
	this.xmlString += '</module><act>';
	if (act) {
		this.xmlString += act;
	}
	this.xmlString += '</act></params></methodCall>';
}

MyMethodCall.prototype.setModule = function(moduleName) {
	var indexStart = this.xmlString.indexOf('<module>');
	var indexEnd = this.xmlString.indexOf('</module>');
	var left = this.xmlString.slice(0, indexStart);
	var right = this.xmlString.slice(indexEnd + 9, this.xmlString.length);
	this.xmlString = left + '<module>' + moduleName + '</module>' + right;
	return this;
};

MyMethodCall.prototype.setAct = function(actName) {
	var indexStart = this.xmlString.indexOf('<act>');
	var indexEnd = this.xmlString.indexOf('</act>');
	var left = this.xmlString.slice(0, indexStart);
	var right = this.xmlString.slice(indexEnd + 6, this.xmlString.length);
	this.xmlString = left + '<act>' + actName + '</act>' + right;
	return this;
};

MyMethodCall.prototype.addElement = function(tagName, value) {
	var index = this.xmlString.indexOf('</params>');
	var left = this.xmlString.slice(0, index);
	var right = this.xmlString.slice(index, this.xmlString.length);
	this.xmlString = left + '<' + tagName + '>' + value + '</' + tagName + '>' + right;
	return this;
}

MyMethodCall.prototype.addCDATAElement = function(tagName, value) {
	var index = this.xmlString.indexOf('</params>');
	var left = this.xmlString.slice(0, index);
	var right = this.xmlString.slice(index, this.xmlString.length);
	this.xmlString = left + '<' + tagName + '><![CDATA[' + value + ']]></' + tagName + '>' + right;
	return this;
}

MyMethodCall.prototype.callAjax = function(callback_success, callback_error, async, method, timeout) {
	// TODO: 먼저 act와 module 항목이 차있는지 확인한다.
	if (async == null)
		async = true;
	else
		async = false;
	
	var opt = {};
	
	// method 의 기본 값은 POST
	if (!method) {
		opt['method'] = 'POST';
	} else {
		opt['method'] = method;
	}
	// timeout은 기본값으로 10초
	if (!timeout) {
		opt['timeout'] = 10000;
	} else {
		opt['timeout'] = timeout;
	}
	
	jQuery.ajax({
		url: 'index.php',
		type: opt['method'],
		timeout: opt['timeout'],
		dataType: 'xml',
		data: this.xmlString,
		async:async,
		contentType: 'text/plain',
		success: callback_success,
		error: callback_error
	});
	return this;
}