jQuery(function($) {
	var conn = null;
	
	var event_handler = {
			// XMPP 연동 체크박스를 눌렀을 때 정보를 서버에 보내고 페이지 재로딩 한다.
			onUseXMPPChange: function() {
				var status = $(this).is(':checked');
				var statusString = '';
				// 체크가 된 상태라면 
				if (status) {
					statusString = 'true';
				} else {
					statusString = 'false';
				}
				var params = {
						status: statusString
				};
				var responses = [];
				
				exec_xml('xewall', 'procXewallAdminUseXMPP', params, function() {
					// 페이지 재로딩
					location.reload(true);
				}, responses, params);
			},
			// testStrophe를 눌렀을 때 Strophe를 이용하여 테스트한다.
			onTestStropheClick: function() {
				event_handler.connect();
			},
			// testJAXL 버튼을 눌렀을 때 JAXL 테스트 한다.
			onTestJAXLClick: function() {
				// 버튼 비활성화
				var $that = $(this);
				$that.attr('disabled', 'disabled');
				$that.unbind('click');
				
				var params = {
						server: CONNINFO.server,
						http_bind: CONNINFO.http_bind,
						http_binding_port: CONNINFO.http_binding_port,
						c2s_port: CONNINFO.c2s_port,
						jid: CONNINFO.jid,
						jpw: CONNINFO.jpw,
						host: CONNINFO.host
				};
				var responses = [];
				
				exec_xml('notifycra', 'getNotifycraAdminCheckJAXL', params, function(ret_obj) {
					console.log(ret_obj['message']);
					if (parseInt(ret_obj['error'])) {
						$('#test_result').append('<span>' + my_lang.jaxl_fail + '</span><br/>');
						$('#test_result').append('<span>' + ret_obj['message'] + '</span><br/>');
					} else {
						$('#test_result').append('<span>' + my_lang.jaxl_success + '</span><br/>');
					}
					// 비활성화 된 버튼 재활성화
					$that.removeAttr('disabled');
					$that.bind('click', event_handler.onTestJAXLClick);
				}, responses);
			},
			
			// Strophe 를 이용한 XMPP 접속 동작
			connect: function() {
				// 접속
				var server_str = '';
				// localhost 로 접속할 경우
				if (CONNINFO.server === '127.0.0.1' || CONNINFO.server.toLowerCase() === 'localhost') {
					server_str = '/' + CONNINFO.http_bind;
				}
				// localhost 가 아닌 곳으로 접속할 경우 port, path까지 넣기
				else {
					server_str = CONNINFO.server + ':' + CONNINFO.http_binding_port + '/' + CONNINFO.http_bind;
				}
				
				// 접속 아이디 파악
				var con_jid = CONNINFO.jid + '@' + CONNINFO.host;
				
				// 접속하기
				conn = null;
				conn = new Strophe.Connection(server_str);
				conn.connect(con_jid, CONNINFO.jpw, function(status) {
					// 연결 성공 시 트리거 실행
					if (status === Strophe.Status.CONNECTED) {
						alert(my_lang.connected);
						$('#test_result').append('<span>' + my_lang.connected + '</span><br/>');
						conn.disconnect();
					}
					// 연결 실패 시 트리거 실행
					else if (status === Strophe.Status.CONNFAIL || status === Strophe.Status.AUTHFAIL) {
						alert(my_lang.authfail);
						$('#test_result').append('<span>' + my_lang.authfail + '</span><br/>');
						conn.disconnect();
					}
					// 접속중 상황을 보여준다.
					else if (status === Strophe.Status.CONNECTING) {
						$('#test_result').append('<span>' + my_lang.connecting + '</span><br/>');
					}
					// 인증중 상황을 보여준다.
					else if (status === Strophe.Status.AUTHENTICATING) {
						$('#test_result').append('<span>' + my_lang.authenticating + '</span><br/>');
					}
				});
			}
	};
	
	// 문서 로딩 완료시
	$(document).ready(function() {
		// 이벤트 핸들러 추가
		// XMPP 연동 체크박스를 눌렀을 때 정보를 서버에 보내고 페이지 재로딩 한다.
		$('#use_xmpp').change(event_handler.onUseXMPPChange);
		
		// testStrophe를 눌렀을 때 Strophe를 이용하여 테스트한다.
		$('#testStrophe').click(event_handler.onTestStropheClick);
		
		// testJAXL 버튼을 눌렀을 때 JAXL 테스트 한다.
		$('#testJAXL').click(event_handler.onTestJAXLClick);
		
	});
});