<?php
/**
 * @class  xewallView
 * @author 바람꽃 (wndflwr@gmail.com)
 * @brief  xewall 모듈의 View class
 **/

class xewallView extends xewall {
	 
	/**
	 * @brief 초기화
	 * board 모듈은 일반 사용과 관리자용으로 나누어진다.\n
	 **/
	function init() {
	}
	
	
	/**
	 * @function dispXewallPersonalConfig
	 * @brief 개인 설정을 할 수 있는 창을 띄워준다.
	 */
	function dispXewallPersonalConfig() {
		
		$oNotifycraModel = &getModel('notifycra');
		
		// 모듈 설정 값을 적용시키기
		$oModuleModel = &getModel('module');
		$module_info = $oModuleModel->getModuleInfoByMid('xewall');
		$this->module_info = $module_info;
		ModuleModel::syncModuleToSite($module_info);
		
		// 헤더 텍스트 적용 시키기
		Context::set('header', $module_info->header_text);
		
		// 브라우저 타이틀을 설정
		Context::setBrowserTitle($module_info->browser_title." - Personal Configuration");
		
		// 로그인 안했으면 로그인 안한 페이지 보여주기
		$is_logged = Context::get('is_logged');
		$template_path = sprintf("%sskins/%s/", $this->module_path, "default");
		if (!$is_logged) {
			$this->setTemplatePath($template_path);
			$this->setTemplateFile('not_logged');
			return;
		}
		
		// XMPP 사용 여부를 알아본다.
		$moduleConfig = $oModuleModel->getModuleConfig('xewall');
		if ($moduleConfig->use_xmpp == 'Y') {
			// 접속 정보 불러오기
			$server_info = $oNotifycraModel->getJabberServerInfo();
			
		} else {
			$server_info = new Object();
		}
		Context::set('server_info', $server_info);
		Context::set('module_config', $moduleConfig);
		
		// 현재 사용자가 XMPP 사용 가능한지, 즉 xe_notifycra_member 에 등록되어있는 사용자인지 확인한다.
		if ($moduleConfig->use_xmpp == 'Y') {
			$jabber_info = $oNotifycraModel->getJabberUserPass();
			Context::set('jabber_id', $jabber_info->get('jabber_id'));
		}
		
		// 관리자가 사용자가 등록할 수 있도록 허용한 게시판 리스트를 불러오기
		$oXewallModel = &getModel('xewall');
		$oModuleAdminModel = &getAdminModel('module');
		
		$available_list = $oXewallModel->getAvailableListen();
		$available_list_array = array();
		$available_node = array();
		
		foreach ($available_list as $key => $val) {
			//$tmp = $oModuleModel->getModuleInfoByModuleSrl($val); 성능 이유로 이 함수 쓰지 말고 쿼리 만들어서 한다.
			$args->module_srl = $val;
			$tmp = executeQueryArray('xewall.getModuleInfoByModuleSrl', $args);
			// 다중언어로 지정된 browser_title 이라면 변환시켜주기
			if (substr($tmp->data[0]->browser_title, 0, 12) == '$user_lang->') {
				$ttmp = $oModuleAdminModel->getLangCode(0, $tmp->data[0]->browser_title);
				$tmp->data[0]->browser_title = $ttmp[Context::getLangType()];
			}
			$available_list_array[$key] = $tmp->data[0];
			// 만약 XMPP 사용 하도록 되어있다면 게시판에 pubsub node 이름을 불러온다.
			if ($moduleConfig->use_xmpp == 'Y') {
				$available_node[$val] = $oNotifycraModel->getPubsubNodeName($args);
			}
		}
		Context::set('available_module_list', $available_list_array);
		
		// 기본적으로 듣는 게시판 리스트들도 불러온다.
		$default_listen = $oXewallModel->getDefaultListen();
		// module_info를 갖는 array 형식으로 보내주기
		$def_module_info = array();
		foreach($default_listen as $key => $val) {
			$args->module_srl = $val;
			$tmp = executeQueryArray('xewall.getModuleInfoByModuleSrl', $args);
			// 다중언어로 지정된 browser_title 이라면 변환시켜주기
			if (substr($tmp->data[0]->browser_title, 0, 12) == '$user_lang->') {
				$ttmp = $oModuleAdminModel->getLangCode(0, $tmp->data[0]->browser_title);
				$tmp->data[0]->browser_title = $ttmp[Context::getLangType()];
			}
			$def_module_info[$key] = $tmp->data[0];
			if ($moduleConfig->use_xmpp == 'Y') {
				$available_node[$val] = $oNotifycraModel->getPubsubNodeName($args);
			}
		}
		Context::set('def_module_info', $def_module_info);
		
		// XMPP 사용하도록 허용되어 있다면 각 게시판의 노드 이름을 불러오기
		if ($moduleConfig->use_xmpp == 'Y') {
			Context::set('available_node', $available_node);
		}
		
		// 사용자가 듣기로 등록한 게시판 리스트를 불러오기.
		$output = $oXewallModel->getMyListen();
		$my_module_list = array();
		foreach ($output as $val) {
			$my_module_list[$val] = $val;
		}
		
		Context::set('my_module_list', $my_module_list);
		
		$template_path = sprintf("%sskins/%s/", $this->module_path, "default");
		$this->setTemplatePath($template_path);
		$this->setTemplateFile('personalConfig');
	}
	
	
	/**
	 * @function dispXewallWall
	 * @brief 담벼락을 보여준다.
	 */
	function dispXewallWall() {
		// 모듈의 기본적인 설정을 세팅한다. (로그인 하지 않은 녀석들도 적용되는 항목들)
		// 모듈 설정 값을 적용시키기
		$oModuleModel = &getModel('module');
		$module_info = $oModuleModel->getModuleInfoByMid('xewall');
		$this->module_info = $module_info;
		ModuleModel::syncModuleToSite($module_info);
		
		// 헤더 텍스트 적용 시키기
		Context::set('header', $module_info->header_text);
		
		// 브라우저 타이틀을 설정
		Context::setBrowserTitle($module_info->browser_title);
		
		// 로그인 안했으면 로그인 안한 페이지 보여주기
		$is_logged = Context::get('is_logged');
		$template_path = sprintf("%sskins/%s/", $this->module_path, "default");
		if (!$is_logged) {
			$this->setTemplatePath($template_path);
			$this->setTemplateFile('not_logged');
			return;
		}
		
		// doc_sort_index, doc_order_type, doc_list_count 정보 던지기
		$moduleConfig = $oModuleModel->getModuleConfig('xewall');
		Context::set('module_config', $moduleConfig);
		$oModuleAdminModel = &getAdminModel('module');
		
		$server_info = null;
		// XMPP 사용 여부를 알아본다.
		if ($moduleConfig->use_xmpp == 'Y') {
			// 접속 정보 불러오기
			$oNotifycraModel = &getModel('notifycra');
			$server_info = $oNotifycraModel->getJabberServerInfo();
		} else {
			$server_info = new Object();
		}
		Context::set('server_info', $server_info);
		// 기본으로 듣는 게시판들의 리스트들을 불러오기
		$oXewallModel = &getModel('xewall');
		$default_listen = $oXewallModel->getDefaultListen();
		// module_info를 갖는 array 형식으로 보내주기
		$def_module_info = array();
		foreach($default_listen as $key => $val) {
			$args->module_srl = $val;
			$tmp = executeQueryArray('xewall.getModuleInfoByModuleSrl', $args);
			// 다중언어로 지정된 browser_title 이라면 변환시켜주기
			if (substr($tmp->data[0]->browser_title, 0, 12) == '$user_lang->') {
				$ttmp = $oModuleAdminModel->getLangCode(0, $tmp->data[0]->browser_title);
				$tmp->data[0]->browser_title = $ttmp[Context::getLangType()];
			}
			$def_module_info[$key] = $tmp->data[0];
		}
		Context::set('def_module_info', $def_module_info);
		
		// 사용자가 듣기로 등록한 게시판 리스트를 불러오기
		$my_module = $oXewallModel->getMyListen();
		$my_module_list = array();
		foreach ($my_module as $key => $val) {
			$args->module_srl = $val;
			$tmp = executeQueryArray('xewall.getModuleInfoByModuleSrl', $args);
			if (substr($tmp->data[0]->browser_title, 0, 12) == '$user_lang->') {
				$ttmp = $oModuleAdminModel->getLangCode(0, $tmp->data[0]->browser_title);
				$tmp->data[0]->browser_title = $ttmp[Context::getLangType()];
			}
			$my_module_list[$key] = $tmp->data[0];
		}
		Context::set('my_module_list', $my_module_list);
		
		// 기본으로 듣는 게시판과 사용자가 등록한 게시판들의 module_srl을 콤마(,)로 연결시켜서 보내준다.
		$tmp = array();
		foreach ($def_module_info as $val) {
			$tmp[] = $val->module_srl;
		}
		foreach ($my_module_list as $val) {
			$tmp[] = $val->module_srl;
		}
		Context::set('default_listen', implode(',', $tmp));
		
		// BETA: 익스플로러에서 불러오는 경우 경고 메시지 보낸다.
		if (isset($_SERVER['HTTP_USER_AGENT']) && (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false))
			Context::set('msie', true);
		
		// 현재 사용자가 XMPP 사용 가능한지, 즉 xe_notifycra_member 에 등록되어있는 사용자인지 확인한다.
		if ($moduleConfig->use_xmpp == 'Y') {
			$jabber_info = $oNotifycraModel->getJabberUserPass();
			Context::set('jabber_id', $jabber_info->get('jabber_id'));
		}
		
		// 템플릿 파일 세팅
		$this->setTemplatePath($template_path);
		$this->setTemplateFile('wall');
	}
}
?>
