<?php
/**
 * @class  xewall
 * @author 바람꽃 (wndflwr@gmail.com)
 * @brief  xewall 모듈의 high class
 **/

class xewall extends ModuleObject {
	
	var $MODULE_NAME = 'xewall';
	
	/**
	 * @brief 설치시 추가 작업이 필요할시 구현
	 * 설치시 모듈 등록, 트리거 등록을 진행한다.
	 **/
	function moduleInstall() {
		// 모듈 설치
		$this->_insertModule();
		return new Object();
	}
	
	/**
	 * @brief 설치가 이상이 없는지 체크하는 method
	 **/
	function checkUpdate() {
		// 모듈이 제대로 설치되었는지 확인
		if (!$this->_checkModuleExists()) return true;
		return false;
	}
	
	
	/**
	 * @brief 업데이트 실행
	 **/
	function moduleUpdate() {
		// 모듈 테이블에 업데이트 또는 삽입
		$this->_insertModule();
		return new Object();
	}
	
	/**
	 * @brief 삭제시 동작
	 */
	function moduleUninstall() {
		// modules 테이블에서 삭제
		$this->_deleteModule();
	}
	
	/**
	 * @brief 캐시 파일 재생성
	 */
	function recompileCache() {
	}
	
/****************************************************************************/
	
	/**
	* @brief 모듈이 존재하는지 안하는지 확인하는 함수
	* Enter description here ...
	*/
	function _checkModuleExists() {
		$oModuleModel = &getModel('module');
		$module_info = $oModuleModel->getModuleInfoByMid($this->MODULE_NAME);
		if ($module_info) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * @brief modules 테이블에 모듈을 등록/업데이트시킨다.
	 */
	function _insertModule($args = null) {
		$oModuleModel = &getModel('module');
		$oModuleController = &getController('module');
		
		// 모듈의 기본적인 설정 결정
		if (!$args) {
			$args->module = $this->MODULE_NAME;
			$args->browser_title = $this->MODULE_NAME;
			$args->mid = $this->MODULE_NAME;
		}
		
		// 모듈이 존재하는지 확인한다.
		$module_info = $oModuleModel->getModuleInfoByMid($this->MODULE_NAME);
		// 존재한다면 수정작업
		if ($module_info) {
			$output = $oModuleController->updateModule($args);
		}
		// 존재하지 않는다면 삽입작업
		else {
			$output = $oModuleController->insertModule($args);
		}
		return $output;
	}
	
	/**
	 * @brief modules 테이블에서 모듈을 삭제시킨다.
	 */
	function _deleteModule() {
		$oModuleModel = &getModel('module');
		$oModuleController = &getController('module');
		
		$module_info = $oModuleModel->getModuleInfoByMid($this->MODULE_NAME);
		$output = $oModuleController->deleteModule($module_info->module_srl);
		return $output;
	}
	
	
}
?>