jQuery(function($) {
	// TODO 게시판 순서도 조정할 수 있도록 한다.
	
	var conn = null;
	
	var CONST = {
			PUBSUB_FROM: "",
			PUBSUB_TO: ""
	};
	
	var functions = {
			
			// xmpp 체크박스를 초기화 한다.
			init: function() {
				// 일단 내가 subscribe한 모든 node 들의 리스트들을 불러온다.
				var iq = $iq({type:'set', from:CONST.PUBSUB_FROM, to:CONST.PUBSUB_TO})
				.c('pubsub', {xmlns:'http://jabber.org/protocol/pubsub'})
					.c('subscriptions');
				// iq 핸들러 등록
				conn.addHandler(function(iq) {
					var $subscriptions = $(iq).find('subscription');
					
					// 각각의 subscription 들에 대해서 check_xmpp 여부를 결정한다.
					$subscriptions.each(function() {
						var node = $(this).attr('node');
						var jid = $(this).attr('jid');
						var subscription = $(this).attr('subscription');
						if (subscription == 'subscribed') {
							$('.node_' + node).removeAttr('disabled').attr('checked', 'checked');
						}
					});
					
					$('.check_xmpp').removeAttr('disabled');
					
					// 1회용 핸들러임.
					return false;
				}, "jabber:client", "iq", "result");
				
				conn.sendIQ(iq);
				// 받은 node 리스트를 기반으로 checkbox 체크 여부 결정하는 것은 iq 핸들러에서 하도록 한다.
			},
			
			
			// XMPP 서버에 연결
			connect: function(jabber_id, jabber_pw) {
				var server_str = '';
				conn = null;
				
				// localhost 로 접속할 경우
				if (CONNINFO.server === '127.0.0.1' || CONNINFO.server.toLowerCase() === 'localhost') {
					server_str = '/' + CONNINFO.http_bind;
				}
				
				// localhost 가 아닌 곳으로 접속할 경우 port, path까지 넣기
				else {
					server_str = CONNINFO.server + ':' + CONNINFO.http_binding_port + '/' + CONNINFO.http_bind;
				}
				
				// 접속 아이디 파악
				var con_jid = jabber_id + '@' + CONNINFO.server_name;
				
				conn = new Strophe.Connection(server_str);
				conn.connect(con_jid, jabber_pw, function(status) {
					console.log(status);
					if (status === Strophe.Status.CONNECTED) {
						// pubsub 관련 상수 결정하기
						var tmp = conn.jid.split("/");
						CONST.PUBSUB_FROM = tmp[0];
						CONST.PUBSUB_TO = 'pubsub.' + conn.domain;
						
						// 신호등 초록색으로.
						$('#blinker').attr('src', $('#blinker_green').attr('src')).attr('title', my_lang.connected);
						
						// 체크박스 초기화
						functions.init();
					}
					// 연결 실패 시 트리거 실행
					else if (status === Strophe.Status.CONNFAIL || status === Strophe.Status.AUTHFAIL) {
						$('.check_xmpp').attr('disabled', 'disabled');
						
						// 신호등 빨간색으로
						$('#blinker').attr('src', $('#blinker_red').attr('src'));
						if (status === Strophe.Status.CONNFAIL) {
							$('#blinker').attr('title', my_lang.authfail);
						}
						if (status === Strophe.Status.AUTHFAIL) {
							$('#blinker').attr('title', my_lang.authfail);
						}
					}
					// 접속중 상황을 보여준다.
					else if (status === Strophe.Status.CONNECTING) {
						// 신호등 주황색으로
						$('#blinker').attr('src', $('#blinker_yellow').attr('src')).attr('title', my_lang.connecting);
					}
					// 인증중 상황을 보여준다.
					else if (status === Strophe.Status.AUTHENTICATING) {
						// 신호등 주황색으로
						$('#blinker').attr('src', $('#blinker_yellow').attr('src')).attr('title', my_lang.authenticating);
					}
					// 연결이 부득이하게 끊어졌을 경우
					else if (status === Strophe.Status.DISCONNECTED) {
						// 신호등 빨간색으로
						$('#blinker').attr('src', $('#blinker_red').attr('src')).attr('title', my_lang.disconnected);
					}
				});
			}
	};
	
	
	
	/********************************************************************************************/
	
	
	
	$(document).ready(function() {
		
		// 체크박스들을 눌렀을 때 설정들을 Ajax로 저장하도록 한다.
		// XE 담벼락에 받아보는 게시판들
		$('.check_available').click(function() {
			// 체크가 되었는지 안되었는지 확인
			var checked = $(this).is(':checked');
			
			var params = {module_srl:$(this).val(), target_srl:$(this).val()};
			var responses = [];
			
			// 체크가 된 상태라면 저장하기
			if (checked) {
				exec_xml('xewall', 'procXewallInsertMyFavourite', params, function(ret_obj) {
					console.log(ret_obj['message']);
				}, responses);
			}
			// 체크가 안된 상태라면 지우기
			else {
				exec_xml('xewall', 'procXewallDeleteMyFavourite', params, function(ret_obj) {
					console.log(ret_obj['message']);
				}, responses);
			}
		});
		
		
		// XMPP 를 이용하여 알림을 받아보는 게시판들
		$('.check_xmpp').click(function() {
			// 체크 여부 확인
			var checked = $(this).is(':checked');
			
			// 체크가 된 상태라면
			if (checked) {
				// XMPP 서버에 subscription 요청
				// iq 스탠자 생성
				var iq = $iq({type:'set', from:CONST.PUBSUB_FROM, to:CONST.PUBSUB_TO})
					.c('pubsub', {xmlns: 'http://jabber.org/protocol/pubsub'})
						.c('subscribe', {node: $(this).val(), jid: CONST.PUBSUB_FROM});
				// XMPP 서버에 요청 노드 생성 요청
				conn.sendIQ(iq);
			}
			// 체크가 안된 상태라면
			else {
				// XMPP 서버에 upsubsription 요청
				// iq 스탠자 생성
				var iq = $iq({type:'set', from:CONST.PUBSUB_FROM, to:CONST.PUBSUB_TO})
				.c('pubsub', {xmlns:'http://jabber.org/protocol/pubsub'})
					.c('unsubscribe', {node: $(this).val(), jid: CONST.PUBSUB_FROM});
				conn.sendIQ(iq);
			}
		});
		
		
		
		// 취소를 눌렀을 때
		$('#cancel').click(function() {
			//var redirect_url = $('input[name="redirect_url"]').val();
			//window.location = redirect_url;
			history.go(-1);
		});
		
		
		
		// 문서가 로딩이 되면 XMPP 서버에 연결하여 각 node 들에게 subscription 이 되어있는지 안되어있는지 확인한다.
		if (use_xmpp != 'Y') return; // XMPP 연동 안했다면 취소
		
		// 연결
		var jabber_id = "";
		var jabber_pw = "";
		var mc = new MyMethodCall('notifycra', 'getNotifycraJabberUserPass');
		mc.callAjax(function(data) {
			jabber_id = $(data).find('jabber_id').text();
			jabber_pw = $(data).find('jabber_pw').text();
		}, function(textStatus, xhr) {
			console.log(textStatus);
		}, false);
		
		// 접속하기
		functions.connect(jabber_id, jabber_pw);
		mc = null;
		
	});
	
});