<?php
/**
 * @class  xewallAdminView
 * @author 바람꽃 (wndflwr@gmail.com)
 * @brief  xewall 모듈의 admin view class
 **/

class xewallAdminView extends xewall {

	/**
	 * @brief 초기화
	 *
	 * board 모듈은 일반 사용과 관리자용으로 나누어진다.\n
	 **/
	function init() {
		$this->setTemplatePath($this->module_path.'tpl');
	}
	
	/**
	 * @function dispXewallAdminModuleSetup
	 * @brief 기본적인 모듈들의 정보를 설정할 수 있다.
	 */
	function dispXewallAdminModuleSetup() {
		// $module_info 던지기
		$oModuleModel = &getModel('module');
		$module_info = $oModuleModel->getModuleInfoByMid('xewall');
		Context::set('module_info', $module_info);
		
		// $module_category 던지기
		$module_category = $oModuleModel->getModuleCategories();
		Context::set('module_category', $module_category);
		
		// $layout_list (레이아웃 목록) 던지기
		$oLayoutModel = &getModel('layout');
		$layout_list = $oLayoutModel->getLayoutList();
		Context::set('layout_list', $layout_list);
		
		// $mlayout_list (모바일 레이아웃 목록) 던지기
		$mobile_layout_list = $oLayoutModel->getLayoutList(0, "M");
		Context::set('mlayout_list', $mobile_layout_list);
		
		// $skin_list (스킨 목록) 던지기
		$skin_list = $oModuleModel->getSkins($this->module_path);
		Context::set('skin_list', $skin_list);
		
		// 템플릿 파일 설정
		$this->setTemplateFile('module_config');
	}
	
	
	/**
	 * @function dispXewallADminGeneralSetup
	 * @brief 일반적인 설정을 설정하는 창
	 */
	function dispXewallAdminGeneralSetup() {
		// module_categories 정보 불러와서 뿌리기
		$oModuleModel = &getModel('module');
		$category_list = $oModuleModel->getModuleCategories();
		Context::set('category_list', $category_list);
		
		// 존재하는 모든 게시판 모듈들을 불러와서 뿌리기 (board, bodex, beluxe)
		$args->modules = "'bodex','beluxe','board'";
		$board_list = executeQueryArray('xewall.getModulesByModuleName', $args);
		Context::set('module_list', $board_list->data);
		
		// 관리자가 사용자에게 듣기 선택을 허용한 게시판 불러오기
		$args->type1 = "A";
		$available_module_list = executeQueryArray('xewall.getFavouriteByType', $args);
		foreach ($available_module_list->data as $key => &$val) {
			foreach($board_list->data as $bkey => $bval) {
				if ($bval->module_srl == $val->target_srl) {
					$val = $bval;
					break;
				}
			}
		}
		Context::set('available_module_list', $available_module_list->data);
		unset($val);
		
		// 기본으로 듣기로 설정되어 있는 게시판 모듈들을 불러와서 뿌리기
		$args->type1 = "D";
		$default_module_list = executeQueryArray('xewall.getFavouriteByType', $args);
		foreach ($default_module_list->data as $key => &$val) {
			// 먼저 module_srl에서 해당 정보 얻어오기
			foreach ($board_list->data as $bkey => $bval) {
				if ($bval->module_srl == $val->target_srl) {
					$val = $bval;
					break;
				}
			}
		}
		unset($val);
		Context::set('default_module_list', $default_module_list->data);
		
		// 모듈 설정값 불러오기 (module_config)
		$moduleConfig = $oModuleModel->getModuleConfig('xewall');
		Context::set('module_config', $moduleConfig);
		
		// 에디터 스킨 정보 던지기
		$oEditorModel = &getModel('editor');
		$editor_skin_list = $oEditorModel->getEditorSkinList();
		Context::set('editor_skin_list', $editor_skin_list);
		
		// 템플릿 파일 설정
		$this->setTemplateFile('general_config');
	}
	
	
	/**
	 * @function dispXewallAdminXMPPSetup
	 * @brief XMPP 관련된 사항들을 설정한다.
	 * 주요 역할은 XE에 있는 모든 member들을 open fire의 사용자 데이터로 export 할 수 있도록 한다.
	 * 데이터 방식은 XML로 보내도록 하고 XML의 자세한 형식은 다음 url을 참조한다.
	 * http://www.igniterealtime.org/projects/openfire/plugins/userimportexport/readme.html
	 * 
	 * 옮기는 사용자의 데이터는 Username 과 Password 이다.
	 * Username은 [XE사용자아이디.싸이트도메인] 형식으로 하고
	 * Password는 [md5(XE사용자 암호)] 로 하도록 한다. (꼭 hash 시킬 것)
	 */
	function dispXewallAdminXMPPSetup() {
		// 템플릿 파일 설정
		
		$this->setTemplateFile('xmpp_config');
	}
}
?>
