<?php
	/**
	 * @class  sejin7940_commentView
	 * @author sejin7940 (sejin7940@nate.com)
	 * @brief  sejin7940_comment 모듈의 View class
	 **/

	class sejin7940_commentView extends sejin7940_comment {

		/**
		 * @brief Initialization
		 **/
		function init() {

            // Get teh configuration information
            $oModuleModel = &getModel('module');
            $this->config = $config = $oModuleModel->getModuleConfig('sejin7940_comment');
            // Set the configuration variable
            Context::set('module_config', $config);		

			$template_path = sprintf("%sskins/%s/",$this->module_path, $config->skin);
            if(!is_dir($template_path)||!$config->skin) {
                $config->skin = 'default';
                $template_path = sprintf("%sskins/%s/",$this->module_path, $config->skin);
            }
            $this->setTemplatePath($template_path);			

			$oLayoutModel = &getModel('layout');
			$layout_info = $oLayoutModel->getLayout($config->layout_srl);
			if($layout_info)
			{
				$this->module_info->layout_srl = $config->layout_srl;
				$this->setLayoutPath($layout_info->path);
			}
		}

        /**
         * @brief Display documents written by the member
         **/
        function dispSejin7940_commentOwnComment() {

            $oMemberModel = &getModel('member');
            // A message appears if the user is not logged-in
            if(!$oMemberModel->isLogged()) return $this->stop('msg_not_logged');

            $logged_info = Context::get('logged_info');

//			if(Context::get('annoymous')=='Y') $member_srl = (-1)*$logged_info->member_srl;
//          else $member_srl = $logged_info->member_srl;

			$member_srl = $logged_info->member_srl;

            $module_srl = Context::get('module_srl');
            Context::set('module_srl',Context::get('selected_module_srl'));
            Context::set('search_target','member_srl');
            Context::set('search_keyword',$member_srl);

//          $oCommentAdminView = &getAdminView('comment');
//          $oCommentAdminView->dispCommentAdminList();

			// 출력 수 등을 조절하기 위해 CommentAdmin 에서 끌어오던걸 그냥 바로 정의함

            // option to get a list
            $args->page = Context::get('page'); // /< Page
            $args->list_count = 20; // / the number of postings to appear on a single page
            $args->page_count = 10; // / the number of pages to appear on the page navigation

            $args->sort_index = 'list_order'; // /< Sorting values

            $args->module_srl = Context::get('module_srl');
			/*
			$search_target = Context::get('search_target');
			$search_keyword = Context::get('search_keyword');
			if ($search_target == 'is_published' && $search_keyword == 'Y')
			{
				$args->status = 1;
			}
			if ($search_target == 'is_published' && $search_keyword == 'N')
			{
				$args->status = 0;
			}
			*/
				
            // get a list by using comment->getCommentList. 
            $oCommentModel = &getModel('comment');
			$secretNameList = $oCommentModel->getSecretNameList();
			$columnList = array('comment_srl', 'document_srl', 'is_secret', 'status', 'content', 'comments.member_srl', 'comments.nick_name', 'comments.regdate', 'ipaddress', 'voted_count', 'blamed_count');
            $output = $oCommentModel->getTotalCommentList($args, $columnList);



			$oCommentModel = &getModel("comment");
			$modules = $oCommentModel->getDistinctModules();
			$modules_list = $modules;

            // set values in the return object of comment_model:: getTotalCommentList() in order to use a template.
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('comment_list', $output->data);
            Context::set('modules_list', $modules_list);
            Context::set('page_navigation', $output->page_navigation);
            Context::set('secret_name_list', $secretNameList);

			// set the template 
//			$this->setTemplatePath($this->module_path.'tpl');
//            $this->setTemplateFile('comment_list');


            Context::set('module_srl', $module_srl);
            $this->setTemplateFile('comment_list');
        }



	}
?>