<?php
	/**
	 * @class  sejin7940_commentView
	 * @author sejin7940 (sejin7940@nate.com)
	 * @brief  sejin7940_comment 모듈의 View class
	 **/

	class sejin7940_commentView extends sejin7940_comment {

		/**
		 * @brief Initialization
		 **/
		function init() {
            /**
             * 스킨 경로를 미리 template_path 라는 변수로 설정함
             * 스킨이 존재하지 않는다면 default로 변경
             **/
            $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
            if(!is_dir($template_path)||!$this->module_info->skin) {
                $this->module_info->skin = 'default';
                $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
            }
            $this->setTemplatePath($template_path);			
		}

        /**
         * @brief Display documents written by the member
         **/
        function dispSejin7940_commentOwnComment() {
            $oMemberModel = &getModel('member');
            // A message appears if the user is not logged-in
            if(!$oMemberModel->isLogged()) return $this->stop('msg_not_logged');

            $logged_info = Context::get('logged_info');
            $member_srl = $logged_info->member_srl;

            $module_srl = Context::get('module_srl');
            Context::set('module_srl',Context::get('selected_module_srl'));
            Context::set('search_target','member_srl');
            Context::set('search_keyword',$member_srl);

            $oCommentAdminView = &getAdminView('comment');
            $oCommentAdminView->dispCommentAdminList();

            Context::set('module_srl', $module_srl);
            $this->setTemplateFile('comment_list');
        }
	}
?>