/**
 * popup으로 열렸을 경우 부모창의 위지윅에디터에 select된 멀티미디어 컴포넌트 코드를 체크하여
 * 있으면 가져와서 원하는 곳에 삽입
 **/
jQuery(function($){

(function(){
	if(!is_def(opener)) return;

	var $node = $(opener.editorPrevNode).filter('img'), attrs;
	if(!$node.length) return;

	attrs = {
		url        : $node.attr('simple_jw_src'),
		width      : $node.width(),
		height     : $node.height(),
		image_src  : $node.attr('image_src') || "",
		custom_skin: $node.attr('custom_skin') || "",
	};

	$.each(attrs, function(key, val) {
		get_by_id('simple_jw_'+key).value = val;
	});

	// auto start?
	get_by_id('simple_jw_auto_start').checked = ($node.attr('auto_start') == 'true');

})();

$('.btnArea button').click(function(){
	if(!is_def(opener)) return;

	var attrs = {
		width  : get_by_id('simple_jw_width').value || 400,
		height : get_by_id('simple_jw_height').value || 300,
		auto_start : get_by_id('simple_jw_auto_start').checked?'true':'false',
		simple_jw_src : get_by_id('simple_jw_url').value.replace(request_uri, ''),
		image_src  : get_by_id('simple_jw_image_src').value,
		custom_skin  : get_by_id('simple_jw_custom_skin').value,
	};

	if(!attrs['simple_jw_src']) {
	  window.close();
	  return;
	}

	var html = '<img src="../common/img/blank.gif" editor_component="simple_jw" simple_jw_src="" image_src="" style="display:block;width:'+attrs.width+'px;height:'+attrs.height+'px;border:2px dotted #4371B9;background:url(./modules/editor/components/simple_jw/tpl/simple_jw_component.gif) no-repeat center" auto_start="" custom_skin="" />';

	html = html.replace(/(\w+)=""/g, function(m0,m1) {
		return attrs[m1] ? (m1+'="'+attrs[m1]+'"') : '';
	});

	opener.editorFocus(opener.editorPrevSrl);

	var iframe_obj = opener.editorGetIFrame(opener.editorPrevSrl)

	opener.editorReplaceHTML(iframe_obj, html);
	opener.editorFocus(opener.editorPrevSrl);

	window.close();
});

});
