<?php
    /**
     * @class  simple_jw
     * @author Retaw
     * @brief The components connected to the body of simple_jw data
     **/

    class simple_jw extends EditorHandler { 
        // editor_sequence from the editor must attend mandatory wearing ....
        var $editor_sequence = 0;
        var $component_path = '';

        /**
         * @brief editor_sequence and components out of the path
         **/
        function simple_jw($editor_sequence, $component_path) {
            $this->editor_sequence = $editor_sequence;
            $this->component_path = $component_path;
        }

        /**
         * @brief popup window to display in popup window request is to add content
         **/
        function getPopupContent() {
            // Pre-compiled source code to compile template return to
            $tpl_path = $this->component_path.'tpl';
            $tpl_file = 'popup.html';

            Context::set("tpl_path", $tpl_path);

            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }

        /**
         * @brief Editor of the components separately if you use a unique code to the html code for a method to change
         *
         * Images and simple_jw, seolmundeung unique code is required for the editor component added to its own code, and then
         * DocumentModule:: transContent() of its components transHtml() method call to change the html code for your own
         **/
        function transHTML($xml_obj) {
            $src = $xml_obj->attrs->simple_jw_src;
            $style = $xml_obj->attrs->style;

            preg_match_all('/(width|height)([^[:digit:]]+)([0-9]+)/i',$style,$matches);
            $width = trim($matches[3][0]);
            $height = trim($matches[3][1]);
            if(!$width) $width = 400;
            if(!$height) $height = 300;

            $auto_start = $xml_obj->attrs->auto_start;
            if($auto_start!="true") $auto_start = "false";
            else $auto_start = "true";

            
            $src = str_replace(array('&','"'), array('&amp;','&qout;'), $src);
            $src = str_replace('&amp;amp;', '&amp;', $src);
            return sprintf("<script type=\"text/javascript\" src=\"%sjwplayer.js\"></script><div id=\"%s\">Loading the player ...</div><script type=\"text/javascript\">jwplayer(\"%s\").setup({flashplayer: \"%splayer.swf\",file: \"%s\", width: %s, height: %s, autostart: %s, plugins:{\"hd-2\":{state : \"true\"}}});</script>", $this->component_path, $src, $src, $this->component_path, $src, $width, $height, $auto_start, $this->component_path);

        }
    }
?>
