/* 즐겨찾기 추가 */
function bookmark(title,url,obj){
  if(window.sidebar) window.sidebar.addPanel(title, url, "");
  else if(document.all) window.external.AddFavorite(url, title);
  else if(window.opera){
    obj.setAttribute('href',url);
    obj.setAttribute('title',title);
    obj.setAttribute('rel','sidebar');
    return true;
  }
  else alert('Ctrl + D 를 눌러주세요.');
}

jQuery(function($){
  /* BackGround Resize Function */
  function resizeImg(){
    winw = $(window).width();
    winh = $(window).height();
    imgw = $("#layout_bg").width();
    imgh = $("#layout_bg").height();
    if(winw/imgw*imgh>winh) $("#layout_bg").css({width:winw,height:winw/imgw*imgh});
    else $("#layout_bg").css({width:winh/imgh*imgw,height:winh});
  }
  
  /* Load BackGround Resize */
  $(window).bind("load resize",function(){
    resizeImg();
  });
  
  $(window).scroll(function(){
    pos = $(window).scrollTop();
    $("#layout_quick").stop().animate({"top":pos+200}, 1000,"easeOutBack");
  });
  
  /* GNB Setting */
  $("#layout_gnb").find(">li").each(function(){
    $(this).find("a.hover").css("left",$(this).find(">.menu_area").width()*-1);
  });
  
  /* GNB Drop Down */
  $("#layout_gnb").find(">li").hover(function(){
    $(this).find(">ul").stop().css({"display":"block","opacity":0}).animate({"opacity":1}, 300);
    $(this).find(".menu_area>a.normal").stop().animate({"left":$(this).width()},300);
    $(this).find(".menu_area>a.hover").stop().animate({"left":0},300);
  },function(){
    $(this).find(">ul").stop().animate({"opacity":"hide"}, 300);
    $(this).find(".menu_area>a.normal").stop().animate({"left":0},300);
    $(this).find(".menu_area>a.hover").stop().animate({"left":-$(this).width()},300);
  });
  
  
  /* Quick Menu Hover Effect */
  $("#layout_quick li").hover(function(){
    var a = $(this).find("img").attr("src").split(".");
    var b = "";
    for(i=0;i<a.length-1;i++) b = b + a[i];
    $(this).find("img").attr("src", b+"_focus."+a[a.length-1]);
  },function(){
    var a = $(this).find("img").attr("src").replace(/_focus/,'');
    $(this).find("img").attr("src", a);
  });
  
  $("#layout_quick #layout_search_opener a").click(function(){
    $("#layout_search:not(:animated)").animate({"width":"toggle"},500);
  });
  $("#layout_quick #layout_login_opener a").click(function(){
    $(".layout_layer").animate({"opacity":"show"},600);
  });
  $("#layout_login .close, .layout_layer .out_area").click(function(){
    $(".layout_layer").animate({"opacity":"hide"},600);
  });
    
  /* LNB Setting */
  $("#layout_lnb").find(">ul>li").each(function(){
    $(this).find(">ul>li:first").css("border","none");
    $(this).find(">a>span").attr("jquery_height", $(this).find(">ul").height());
  });
  
  /* Lnb Toggle */
  $("#layout_lnb").find(">ul>li>a>span").click(function(){
    if($(this).hasClass("down")){
      $(this).parent().siblings().stop().css("display","block").animate({"height":$(this).attr("jquery_height")}, 500);
    }
    else{
      $(this).parent().siblings().stop().animate({"height":0}, 500, function(){
        $(this).css("display","none");
      });
    }
    $(this).toggleClass("down");
    return false;
  });
});