<?php
class xestream extends WidgetHandler {
	function proc($args) {
// 스트리밍 설정
		if(!in_array($args->stream_type, array('rtmp','http'))) $args->stream_type = 'rtmp';
// 스트리밍 URL
		if(!$args->stream_url) $args->stream_url = '';
		if($args->stream_url=='') return Context::getLang('스트리밍 URL은 반드시 입력해야 합니다.');
// 인스턴스 이름
		if(!$args->instance_name) $args->instance_name = '';
		if($args->instance_name=='' && $args->stream_type == 'rtmp') return Context::getLang('RTMP일때는 인스턴스 이름은 반드시 입력해야 합니다.');
// 아이폰 계열
		if(!$args->html5_src) $args->html5_src = '';
// 미디어 유형
		if(!$args->media_type) $args->media_type = 'sound';
// 미디어 가로 넓이
		if(!$args->media_width) $args->media_width = 240;
		$args->media_width = (int)$args->media_width;
// 미디어 세로 높이
		if(!$args->media_height) $args->media_height = 180;
		$args->media_height = (int)$args->media_height;
// 미디어 포스터
		if(!$args->preview_image) $args->preview_image = '';
// 라이브 스트림
		if(!$args->live_streams) $args->live_streams = 'Y';
// 자동 재생
		if(!$args->auto_play) $args->auto_play = 'false';
// 제어 버튼
		if(!$args->control_btn) $args->control_btn = 'none';
// 제어버튼 자동 숨기기
		if(!$args->control_hide) $args->control_hide = 'true';
// 제어버튼 전체화면
		if(!$args->fullscreen) $args->fullscreen = 'true';
// wmode 설정
		if(!$args->wmode) $args->wmode = 'window';
// Scaling
		if(!in_array($args->scaling, array('scale','fit','orig','half'))) $args->scaling = 'scale';
// 컨트롤바 배경색
		if(!$args->ctl_bgcolor) $args->ctl_bgcolor = '#000000';
// 컨트롤바 버튼색
		if(!$args->ctl_btncolor) $args->ctl_btncolor = '#ffffff';

		if($args->stream_type!="rtmp") $media_url = $args->stream_url;
		else $media_url = $args->instance_name; 

		$mimeinfo = $this->getMediaInfo($media_url,'MimeInfo');
		if($mimeinfo!='') $args->mimeinfo = $mimeinfo;

		$stream_info->stream_type = $args->stream_type;
		$stream_info->stream_url = $args->stream_url;
		$stream_info->instance_name = $args->instance_name;
		$stream_info->html5_src = $args->html5_src;
		$stream_info->media_type = $args->media_type;
		$stream_info->media_width = $args->media_width;
		$stream_info->media_height = $args->media_height;
		$stream_info->preview_image = $args->preview_image;
		$stream_info->live_streams = $args->live_streams;
		$stream_info->auto_play = $args->auto_play;
		$stream_info->control_btn = $args->control_btn;
		$stream_info->control_hide = $args->control_hide;
		$stream_info->fullscreen = $args->fullscreen;
		$stream_info->wmode = $args->wmode;
		$stream_info->scaling = $args->scaling;
		$stream_info->ctl_bgcolor = $args->ctl_bgcolor;
		$stream_info->ctl_btncolor = $args->ctl_btncolor;
		$stream_info->mimeinfo = $args->mimeinfo;

		// html 파일에 $stream_info 의 내용을 전달하는 기본 구문
		$tpl_path = sprintf('%sskins/%s', $this->widget_path, $args-> skin);
		$tpl_file = "stream";
		Context::set ('colorset', $args->colorset);
		Context::set('stream_info', $stream_info);
		$oTemplate = &TemplateHandler::getInstance();
		// 템플릿 컴파일하여 html로 return
		$act = Context::get('act');
		if($act == "dispPageAdminContentModify" || $act == "procWidgetGenerateCodeInPage")
			return $oTemplate->compile($tpl_path, "edit");
		return $oTemplate->compile($tpl_path, $tpl_file);
	}

	function getMediaInfo($media_is,$info_is)
	{
		$nPlayerInfo = null;
		$MimeInfo = null;
		$LinkType = null;

		if(preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'image';
			$MimeInfo = 'image';
			$LinkType = 'image';
		}
		elseif (preg_match("/youtube.com\/(v\/|watch\?|embed\/)/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'application/x-shockwave-flash';
			$LinkType = 'video';
		}
		else if(preg_match("/youtu.be/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'application/x-shockwave-flash';
			$LinkType = 'video';
		}
		else if(preg_match("/vimeo.com/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'vimeo';
			$MimeInfo = 'application/x-shockwave-flash';
			$LinkType = 'video';
		}
		else if (preg_match("/(tvpot|flvs).daum.net/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'daum';
			$MimeInfo = 'application/x-shockwave-flash';
			$LinkType = 'video';
		}
		else if (preg_match("/serviceapi.nmv.naver.com/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'naver';
			$MimeInfo = 'application/x-shockwave-flash';
			$LinkType = 'video';
		}
		else if (preg_match("/(channel|flvr).pandora.tv/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'pandora';
			$MimeInfo = 'application/x-shockwave-flash';
			$LinkType = 'video';
		}
		else if (preg_match("/(player|static).youku.com/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'embed';
			$MimeInfo = 'application/x-shockwave-flash';
			$LinkType = 'video';
		}
		else if (preg_match("/(afbbs).afreeca.com/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'embed';
			$MimeInfo = 'application/x-shockwave-flash';
			$LinkType = 'video';
		}
		else if (preg_match("/^rtmp:\/\//i",strtolower($media_is)))
		{
			$nPlayerInfo = 'stream';
			$MimeInfo = 'application/x-shockwave-flash';
			$LinkType = 'video';
		}
		else if(preg_match("/\.(3gp|3gpp|3gpp2|3g2)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'video/3gpp';
			$LinkType = 'video';
		}
		else if(preg_match("/\.(flv|swf)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'video/flv';
			$LinkType = 'video';
		}
		else if(preg_match("/\.(f4v|m4v|mp4)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'video/mp4';
			$LinkType = 'video';
		}
		else if(preg_match("/\.(mov)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'video/quicktime';
			$LinkType = 'video';
		}
		else if(preg_match("/\.(qt)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'quicktime';
			$MimeInfo = 'video/quicktime';
			$LinkType = 'video';
		}
		else if(preg_match("/\.(ogv)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'video/ogg';
			$LinkType = 'video';
		}
		else if(preg_match("/\.(webm)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'video/webm';
			$LinkType = 'video';
		}
		else if(preg_match("/\.(f4a|f4b|m4a|m4b|m4p)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'audio/mp4';
			$LinkType = 'audio';
		}
		else if(preg_match("/\.(ogg|oga)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'audio/ogg';
			$LinkType = 'audio';
		}
		else if(preg_match("/\.(aac)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'audio/aac';
			$LinkType = 'audio';
		}
		else if(preg_match("/\.(mp3)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'audio/mpeg';
			$LinkType = 'audio';
		}
		else if(preg_match("/\.(m3u8)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'audio/x-mpegurl';
			$LinkType = 'audio';
		}
		else if(preg_match("/\.(wav)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'audio/x-wav';
			$LinkType = 'audio';
		}
		else if(preg_match("/\.(rbs)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'jwplayer';
			$MimeInfo = 'audio/rbs';
			$LinkType = 'audio';
		}
		else if(preg_match("/\.(divx|mkv)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'divx';
			$MimeInfo = 'video/divx';
			$LinkType = 'video';
		}
		else if(preg_match("/\.(wmv|avi)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'wmplayer';
			$MimeInfo = 'application/x-mplayer2';
			$LinkType = 'video';
		}
		else if(preg_match("/\.(asf|asx)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'wmplayer';
			$MimeInfo = 'video/x-ms-asf';
			$LinkType = 'video';
		}
		else if(preg_match("/\.(wma)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'wmplayer';
			$MimeInfo = 'audio/x-ms-wma';
			$LinkType = 'audio';
		}
		else if(preg_match("/\.(mpg|mpeg)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'quicktime';
			$MimeInfo = 'video/mpeg';
			$LinkType = 'video';
		}
		else if(preg_match("/\.(mid|midi)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'quicktime';
			$MimeInfo = 'audio/midi';
			$LinkType = 'audio';
		}
		else if(preg_match("/\.(aif|aiff)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'quicktime';
			$MimeInfo = 'audio/x-aiff';
			$LinkType = 'audio';
		}
		else if(preg_match("/\.(au|snd)$/i",strtolower($media_is)))
		{
			$nPlayerInfo = 'quicktime';
			$MimeInfo = 'audio/basic';
			$LinkType = 'audio';
		}

		if($info_is=='mPlayer') return $nPlayerInfo;
		else if($info_is=='MimeInfo') return $MimeInfo;
		else if($info_is=='meDiatype') return $LinkType;
	}

}
?>