<?php

/**
 * @author UKeypad <webmaster@ukeypad.com>
 * @link http://ukeypad.com/
**/

class umessageController extends umessage
{
	function triggerAfterInsertDocument(&$obj)
	{
		if($obj->status == 'TEMP') return new Object();

		$this->setNotify($obj, 'DOCUMENT');
	}

	function triggerAfterInsertComment(&$obj)
	{
		$this->setNotify($obj, 'COMMENT');
	}

	function setNotify($obj, $type)
	{
		$logged_info = Context::get('logged_info');
		$oModuleModel = &getModel('module');
		$umessage_config = $oModuleModel->getModuleConfig('umessage');
		$current_module_info = Context::get('current_module_info');
		
		if(!$umessage_config->umessage_userid || !$umessage_config->umessage_userpw ) return;
		if(count($umessage_config->mid_list) && !in_array($current_module_info->module_srl, $umessage_config->mid_list)) return;

		$args->_type = $type;
		$args->document_srl = $obj->document_srl;
		$args->comment_srl = $obj->comment_srl;
		$args->name = $obj->nick_name;
		//$args->title = cut_str(trim(strip_tags($obj->title)), 100);
		//$args->content = cut_str(trim(strip_tags($obj->content)), 100);
		$args->title = trim(strip_tags($obj->title));
		$args->content = trim(strip_tags($obj->content));
		$args->uri = getNotEncodedFullUrl('', 'document_srl', $obj->document_srl);
		if($type == 'COMMENT') $args->uri .=  '#comment_' . $obj->comment_srl;
		$this->notify($args);
	}

	function isAnonymous($triggerObj)
	{
		if($triggerObj->member_srl < 0) return TRUE;

		return FALSE;
	}

	function notify($args)
	{
		require_once('Umessage_API.php');
		$oModuleModel = &getModel('module');
		$umessage_config = $oModuleModel->getModuleConfig('umessage');

		$module_info = Context::get('current_module_info');

		$args->content = trim(str_replace('&nbsp;', ' ', $args->content));

		if($this->isAnonymous($args) == TRUE)
		{
			$args->name = '익명';
		}

		$oUmessage = new Umessage_API($umessage_config->umessage_userid, $umessage_config->umessage_userpw);

		$umessage_title = ($args->_type == 'COMMENT') ? '새 댓글' : '새 글';

		$msg = array();
		if($args->_type == 'COMMENT')
		{
			$oDocumentModel = &getModel('document');
			$oDocument = $oDocumentModel->getDocument($args->document_srl);
			$args->title = $oDocument->getTitleText();
			$msg[] = $args->name . ' 님이 ' . $args->title. ' 글에 댓글을 남겼습니다.';
			$msg[] = "접속: ".$args->uri;
		}
		else
		{
			$msg[] = $args->name . ' 님이 ' . $module_info->browser_title . ' 게시판에 새 글을 남겼습니다.';
			$msg[] = "접속: ".$args->uri;
			$msg[] = '제목 : ' . $args->title;
		}

		$msg[] = $args->content;


		$oUmessage->send_umessage($umessage_config->umessage_userid,$umessage_config->umessage_userpw,'',implode(PHP_EOL, $msg));
	}
}

?>
