<?php

/**
 * @author UKeypad <webmaster@ukeypad.com>
 * @link http://ukeypad.com/
**/

class umessage extends ModuleObject
{
	var $triggers = array(
		array('document.insertDocument', 'umessage', 'controller', 'triggerAfterInsertDocument', 'after'),
		array('comment.insertComment', 'umessage', 'controller', 'triggerAfterInsertComment', 'after')
	);

	function moduleInstall()
	{
		return new Object();
	}

	function checkUpdate()
	{
		$oModuleModel = &getModel('module');
		$oDB = &DB::getInstance();

		foreach($this->triggers as $trigger)
		{
			if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])) return true;
		}

		return false;
	}

	function moduleUpdate()
	{
		$oModuleModel = &getModel('module');
		$oModuleController = &getController('module');

		foreach($this->triggers as $trigger)
		{
			if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]))
			{
				$oModuleController->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
			}
		}
		return new Object(0, 'success_updated');
	}

	function moduleUninstall()
	{
		$oModuleController = &getController('module');

		foreach($this->triggers as $trigger)
		{
			$oModuleController->deleteTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
		}
		return new Object();
	}
}

?>
