<?php
/**
 * @class refererModel
 * @author haneul (haneul0318@gmail.com)
 * @enhanced by KnDol (kndol@kndol.net)
 * @brief referer 모듈의 Model class
 **/

class refererModel extends referer {
    function init() {
    }

    function isInsertedRemote($remote) {
        $args->remote = $remote;
        $output = executeQuery('referer.getRemoteStatus', $args);
        return $output->data->count?true:false;
    }

    function isInsertedHost($host) {
        $args->host = $host;
        $output = executeQuery('referer.getHostStatus', $args);
        return $output->data->count?true:false;
    }

    function getLogList($obj) {
		if ($obj->remote) {
			$args->remote = $obj->remote;
            $query_id = 'referer.getRefererLogListRemote';
		}
		else if ($obj->host) {
			$args->host = $obj->host;
            $query_id = 'referer.getRefererLogListHost';
		}
		else {
	        $query_id = 'referer.getRefererLogList';
		}

        $args->sort_index = 'regdate';
        $args->page = $obj->page?$obj->page:1;

        $args->list_count = $obj->list_count?$obj->list_count:20;
        $args->page_count = $obj->page_count?$obj->page_count:10;

        $output = executeQuery($query_id, $args);

        // 결과가 없거나 오류 발생시 그냥 return
        if(!$output->toBool()||!count($output->data)) return $output;

        return $output;
    }

	function getRecentRefererList()
	{
        $output = executeQuery('referer.getRecentRefererLog');

        // 결과가 없거나 오류 발생시 그냥 return
        if(!$output->toBool()||!count($output->data)) return;

        return $output->data;
	}

    function getRefererStatus($obj) {
        return ($obj->isRemote ? executeQuery("referer.getRemoteStatistics", $obj) : executeQuery("referer.getRefererStatistics", $obj));
    }
}
/* End of file referer.controller.php */
/* Location: ./modules/referer/referer.model.php */