<?php
    /**
     * @class  referer2AdminView
     * @author haneul (haneul0318@gmail.com)
	 * @enhanced by KnDol (kndol@kndol.net)
     * @brief  referer2 모듈의 Admin view class
     **/

    class referer2AdminView extends referer2 {

        /**
         * @brief 초기화
         **/
        function init() {
            // 템플릿 경로 지정 
            $this->setTemplatePath($this->module_path.'tpl');
        }

        /**
         * @brief 관리자 페이지 초기화면
         **/
        function dispReferer2AdminIndex() {
            $this->dispReferer2AdminList();
        }

		function dispReferer2AdminDeleteStat () {
		    if(!Context::get('host')) return $this->dispReferer2AdminIndex();
		    $this->setTemplateFile('delete_stat');
		}

		function dispReferer2AdminResetData () {
		    $this->setTemplateFile('reset_data');
		}
		
        function dispReferer2AdminList() {
	    
            // 목록을 구하기 위한 옵션
            $args->host = Context::get('host'); ///< 선택한 호스트
            $args->page = Context::get('page'); ///< 페이지
            $args->sort_index = 'regdate'; ///< 소팅 값

            $oRefererModel = &getModel('referer2');
            $output = $oRefererModel->getLogList($args);

            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('referer2_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);

            $args2->sort_index = 'cnt';
            $output2 = $oRefererModel->getReferer2Status($args2);
            Context::set('referer2_status', $output2->data);

            // 템플릿 지정
            $this->setTemplatePath($this->module_path.'tpl');
            $this->setTemplateFile('referer2_list');
		}
    }
?>
