<?php
    /**
     * @class  referer2Controller
     * @author haneul (haneul0318@gmail.com) 
	 * @enhanced by KnDol (kndol@kndol.net)
     * @brief  referer2 모듈의 controller class
     **/

    class referer2Controller extends referer2 {
        /**
         * @brief initialization
         **/
        function init() {
        }

		function procReferer2Execute() {
		    if(empty($_SERVER["HTTP_REFERER"])) return;
	
		    // Log only from different hosts
		    $referer = parse_url($_SERVER["HTTP_REFERER"]);
		    if($referer['host'] == $_SERVER['HTTP_HOST']) return;
	
			//if (strpos($_SERVER["HTTP_USER_AGENT"], "Daumoa") > -1) return;

		    $oDB = &DB::getInstance();
		    $oDB -> begin();
		    $this->insertReferer2Log($referer['host'], removeHackTag($_SERVER["HTTP_REFERER"]), $_SERVER["HTTP_USER_AGENT"]);
		    $this->deleteOlddatedReferer2Logs();
		    $this->updateReferer2Statistics($referer['host']);
		    $oDB -> commit();
		}
	
		function updateReferer2Statistics($host)
		{
		    $oRefererModel = &getModel('referer2');
		    $args->host = $host;
		    if($oRefererModel->isInsertedHost($host))
		    {
				$output = executeQuery('referer2.updateReferer2Statistics', $args);
		    }
		    else
		    {
				$output = executeQuery('referer2.insertReferer2Statistics', $args);
		    }
	
		    return $output;
		}
	
		function insertReferer2Log($host, $url, $uagent)
		{
		    $recent = &getModel('referer2')->getRecentReferer2List();
		    if ($recent->url == $url && $recent->uagent == $uagent)
		    {
			    $args->regdate_last = date("YmdHis");
		    	$args->regdate      = $recent->regdate;
		    	$args->url          = $recent->url;
		    	$args->uagent       = $recent->uagent;

			    return executeQuery('referer2.updateReferer2Log', $args);
		    }
			else
			{
			    $args->regdate = $args->regdate_last = date("YmdHis");
			    $args->host = $host;
			    $args->url = $url;
			    $args->uagent = $uagent;

			    return executeQuery('referer2.insertReferer2Log', $args);
		    }
		}
	
		function deleteOlddatedReferer2Logs()
		{
		    $args->regdate = date("YmdHis", strtotime("-1 week"));
		    return executeQuery('referer2.deleteOlddatedLogs', $args);
		}
    }
?>
