
(function($){
	var response_tags = ["error", "message"];

	$(function(){
		var act = $("#dispLisenseAdminList, #dispLisenseAdminPermitList").attr("id");

		// 모달 창 띄우기
		$(".modalAnchor").click(function(){
			// 초기화
			$("#modalWindow input[type=text], textarea").val("");
			$("#modalWindow input[type=radio]").removeAttr("checked")
				.filter(":first").attr("checked", "checked");
			// lisense
			$("#modalWindow p.license_srl, #modalWindow p.permit_srl").text("-");

			// 레이어 처리
			$("#modalWindow .layer").hide();
			$("#modalWindow .layer .table tbody").remove();

			var td = $(this).parents("td");
			// 추가
			if(td.length < 1) return;

			// 수정
			$("input, textarea", td).each(function(){
				var name = $(this).attr("name");
				var value = $(this).val();

				// license_srl
				if(act=="dispLisenseAdminList" && name=="license_srl"){
					$("#modalWindow form input[name="+name+"]").remove();
					$("#modalWindow form").append('<input type="hidden" name="'+name+'" value="'+value+'" />');
					$("#modalWindow p."+name).text(value);
					return;
				}
				// permit_srl
				if(act=="dispLisenseAdminPermitList" && name=="permit_srl"){
					$("#modalWindow form input[name="+name+"]").remove();
					$("#modalWindow form").append('<input type="hidden" name="'+name+'" value="'+value+'" />');
					$("#modalWindow p."+name).text(value);
					return;
				}

				// target_type 따로 설정
				if(name=="target_type" || name=="permit_type"){
					$("input[name="+name+"]").removeAttr("checked");
					$("input[name="+name+"][value="+value+"]").attr("checked","checked");
					return;
				}

				if(name=="description"){
					value = $(this).text();
				}

				$("#" + name).val(value);
			});
		});

		// 삭제하기
		var tr;
		$(".procLisenseAdminDelete").click(function(){
			var ask = confirm(lisense_confirm_delete);
			if(!ask) return;

			tr = $(this).parents("tr");
			var td = $(this).parents("td");

			var params = {};
			params.license_srl = $("input[name=license_srl]", td).val();
			params.permit_srl = $("input[name=permit_srl]", td).val();

			if(act=="dispLisenseAdminList") exec_xml("lisense", "procLisenseAdminDelete", params, procLisenseAdminDeleteReturn);
			if(act=="dispLisenseAdminPermitList") exec_xml("lisense", "procLisenseAdminPermitDelete", params, procLisenseAdminDeleteReturn);
		});

		function procLisenseAdminDeleteReturn(data){
			$("td", tr).fadeOut("fast", function(){
				tr.remove();
			});
		}

		// 등록하시겠습니까?
		$("#modalWindow form").submit(function(){
			var ask = confirm(lisense_confirm_submit);
			if(!ask) return false;
		});

		/**
		 * target_srl 선택하기
		 **/
		$("#target_srl, #license_srl").focus(function(){
			var args = {};
			args.id = $(this).attr("id");
			getLisenseAdminTargetSrlsList(args);
		});

		$("#modalWindow input[name=target_type]").click(function(){
			$("#target_srl").focus();
		});

		// 대상 layer가 여러개일 수 있으니까
		var layer;
		function getLisenseAdminTargetSrlsList(args){
			var params = args;
			params.view = act;

			if(args.id=="target_srl") {
				var target_type = $("#modalWindow form input:checked[name=target_type]").val();
				if(typeof(target_type)=="undefined") return false;
				params.target_type = target_type;
			}

			layer = $("#"+params.id).parents("li:has(.layer)").children(".layer")[0];

			$("#modalWindow .layer").hide("normal");
			$.exec_json("lisense.getLisenseAdminTargetSrlsList", params, getLisenseAdminTargetSrlsListReturn);
		}

		function getLisenseAdminTargetSrlsListReturn(params){
			$("table tbody", layer).remove();
			$(".table caption", layer).text(
				params.target_type + " (" + params.data.length + "/" + params.total_count +")"
			);
			$(".table th.target_srl").text(params.target_type);
			var tbody = $("<tbody/>");
			var td;
			var tr;
			if(params.data.length < 1) {
				var colspan = $("#modalWindow .layer .table thead th").length;
				tbody.append('<tr target_srl=""><td style="text-align:center;" colspan="'+colspan+'">-</td></tr>');
			} else {
				if(act=="dispLisenseAdminList"){
					for(i in params.data){
						td = "<td>";
						td += params.data[i].target_srl + "</td><td>";
						td += params.data[i].browser_title + "</td><td>";
						td += params.data[i].title + "</td><td>";
						td += params.data[i].nick_name + "</td><td>";
						td += params.data[i].regdate + "</td>";
						tr = $("<tr/>",{
							"target_srl": params.data[i].target_srl
							,"title": params.data[i].title
							,"style": "cursor:pointer;"
							,"html": td
						});
						tbody.append(tr);
					}
				}
				else if(act=="dispLisenseAdminPermitList"){
					if(params.target_type=="license_srl") for(i in params.data){
						td = "<td>";
						td += params.data[i].target_srl + "</td><td>";
						td += params.data[i].target + "</td><td>";
						td += params.data[i].title + "</td><td>";
						td += params.data[i].desc + "</td><td>";
						td += params.data[i].regdate + "</td>";
						tr = $("<tr/>",{
							"target_srl": params.data[i].target_srl
							,"title": params.data[i].title
							,"style": "cursor:pointer;"
							,"html": td
						});
						tbody.append(tr);
					}
					else for(i in params.data){
						td = "<td>";
						td += params.data[i].target_srl + "</td><td>";
						td += params.data[i].title + "</td><td>";
						td += params.data[i].regdate + "</td>";
						tr = $("<tr/>",{
							"target_srl": params.data[i].target_srl
							,"title": params.data[i].title
							,"style": "cursor:pointer;"
							,"html": td
						});
						tbody.append(tr);
					}
				}
			}
			$("table", layer).append(tbody);
			$(layer).show("normal");

			ajaxTargetSrlSelect(layer);
/*
			// pagination 뽀큐머겅 두번머겅
			if(params.total_count > 1){
				var page = parseInt(params.page);
				var page_count = page==1? params.page_navigation.page_count : page-1+params.page_navigation.page_count;
				var a = "";
				for(i=page; i<=page_count;i++){
					if(i==page) a += '<strong>'+i+'</strong>';
					else a += '<a href="#page' + i + '">' + i + '</a>';
				}
				if(page_count < params.total_page) a += '<a href="#page' + (page_count+1) + '">...</a>';
				$("#modalWindow .layer .pagination").append(a);

				$("#modalWindow .layer .pagination a").click(function(){
					var args = {};
					args.page = $(this).attr("href").replace("#page", "");
					getLisenseAdminTargetSrlsList(args);
					return false;
				});
			}
*/
		}
		// search
		$("#modalWindow .layer button.search").click(function(){
			var layer = $(this).parents(".layer");
			var args = {};
			args.search_target = layer.find(".search_target").val();
			args.id = layer.find(".search_target").attr("id_");
			getLisenseAdminTargetSrlsList(args);
		});
		$('#modalWindow .layer input.search_target').live('keydown', function(e){
			var key = e.keyCode || e.which;
			if (key === 13) {
				var args = {};
				args.search_target = $(this).val();
				args.id = $(this).attr("id_");
				getLisenseAdminTargetSrlsList(args);

				return false;
			}
		});

		function ajaxTargetSrlSelect(layer){
			$("tbody tr", layer).click(function(){
				var target_srl = $(this).attr("target_srl");
				$(layer).parent("li").find("p.a > input[type=text]").val(target_srl);
				$(layer).hide("normal");

				var title = $(this).attr("title");
				$("#title").val( title );
			});
		}

		$("#modalWindow .close").click(function(){
			$("#modalWindow .layer").hide("normal");
		});

	});
})(jQuery);