(function($){

	//Get URL Parameters Using Javascript
	function gup( url,name )
	{
	  name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
	  var regexS = "[\\?&]"+name+"=([^&#]*)";
	  var regex = new RegExp( regexS );
	  var results = regex.exec( url );
	  if( results == null )
		return "";
	  else
		return results[1];
	}

	$(function(){
		var file_srls = new Array();

		// get targets
		var a = $("a[href*='act=procFileDownload'][href*='file_srl='][href*='sid=']")
		.filter("[href^='"+default_url+"'], :not([href^='http://'])");

		// get file_srls
		a.each(function(i){
			var href = $(this).attr("href");
			var act = gup(href, "act");
			if(act!="procFileDownload") return;

			var file_srl = gup(href, "file_srl");
			file_srls[i] = file_srl;
		});

		// ajax
		var params = {};
		params.file_srl = file_srls.join(",");
		$.exec_json("lisense.getCheckPermitBeforeDownload", params, checkPermitReturn);

		function checkPermitReturn(params)
		{
			// 1. 라이센스가 걸려있지 않다면 그대로 진행
			if(params.data.length==0) return;
			var permit = {};

			// 2. 권한 검사
			$.each(params.data, function(key, val){
				if(typeof(val.permit_srl)!="undefined" && val.permit_srl!="" ) permit[val.file_srl] = true;
				else if(permit[val.file_srl]!==true) permit[val.file_srl] = false;
			});

			// 3. 다운로드 제한
			$.each(permit, function(file_srl, permit){
				if(permit) return;
				a.filter("[href*='file_srl=" + file_srl + "']").click(function(){
					alert( params.message );
					return false;
				});
			});
		}

	});
})(jQuery);
