<?php
/**
 * @class lisenseModel
 * @author Elkha (support@elkha.kr)
 * @brief ^^
 **/

class lisenseModel extends lisense
{

	/**
	 * @brief 초기화
	 **/
	function init()
	{
	}

	/**
	 * @brief 라이센스 체크
	 **/
	function checkLicense($file_srl)
	{
		$args->file_srl = $file_srl?$file_srl:Context::get("file_srl");

		// 비 회원
		if(!Context::get("is_logged"))
		{
			if(is_dir("./modules/resource")) $output = executeQueryArray("lisense.getLicenseListByFileSrl", $args);
			else $output = executeQueryArray("lisense.getLicenseListByFileSrl2", $args);
		}

		// 회원
		else
		{
			$logged_info = Context::get("logged_info");
			$args->member_srl = $logged_info->member_srl;
			$args->group_srl = implode(array_keys($logged_info->group_list), ",");

			if(is_dir("./modules/resource")) $output = executeQueryArray("lisense.getPermitListByFileSrl", $args);
			else $output = executeQueryArray("lisense.getPermitListByFileSrl2", $args);

		}
		return $output->data;
	}

	/**
	 * @brief 다운로드 전에 권한이 있나 체크해줌
	 **/
	function getCheckPermitBeforeDownload($file_srl=NULL)
	{

		$file_srl = $file_srl?$file_srl:Context::get("file_srl");

		// 공격방지
		$file_srl = preg_replace("/[^0-9\,]/", "", $file_srl);
		$file_srl = preg_replace("/[\,\,]/", ",", $file_srl);
		$file_srl = substr($file_srl, 0 , 700); // 약 70개까지만 받음

		$oLisenseModel = &getModel("lisense");
		$data = $oLisenseModel->checkLicense($file_srl);

		$this->setMessage('msg_not_permitted');
		$this->add("data", $data);
		$this->add("is_logged", Context::get("is_logged"));
		return $data;
	}

	/**
	 * @brief 권한 체크를 위해 target_srl 목록을 가져옴
	 **/
/*
	function getTargetSrls($file_srl)
	{
		// $file_srl
		$obj->file_srl = $file_srl?$file_srl:Context::get("file_srl");
		$obj->list_count = $args->list_count = 99;

		// $module_srl
		$files = executeQueryArray("file.getFile", $obj);
		if($files->toBool() && count($files->data) > 0)
		{
			foreach($files->data as $key => $val)
			{
				$obj->module_srl = $obj->module_srl? $obj->module_srl.",".$files->data[$key]->module_srl : $files->data[$key]->module_srl;
				// $args 변수는 getComments, getComments 쿼리
				$args->document_srls = $args->comment_srls = $args->document_srls? $args->document_srls.",".$files->data[$key]->upload_target_srl : $files->data[$key]->upload_target_srl;
			}
		}

		// $package_srl | $document_srl
		if(is_dir("./modules/resource"))
		{
			$resource_items = executeQueryArray("lisense.getPackageByFileSrl", $obj);
			if($resource_items->toBool() && count($resource_items->data) > 0)
			{
				foreach($resource_items->data as $key => $val)
				{
					$obj->package_srl = $obj->package_srl? $obj->package_srl.",".$resource_items->data[$key]->package_srl : $resource_items->data[$key]->package_srl;
					$obj->document_srl = $obj->document_srl? $obj->document_srl.",".$resource_items->data[$key]->document_srl : $resource_items->data[$key]->document_srl;
				}
			}
		}

		// $comment_srl | $document_srl
		if(!$obj->package_srl)
		{
			$comments = executeQueryArray("comment.getComments", $args);
			if($comments->toBool() && count($comments->data) > 0)
			{
				foreach($comments->data as $key => $val)
				{
					$obj->comment_srl = $obj->comment_srl? $obj->comment_srl.",".$comments->data[$key]->comment_srl : $comments->data[$key]->comment_srl;
					$obj->document_srl = $obj->document_srl? $obj->document_srl.",".$comments->data[$key]->document_srl : $comments->data[$key]->document_srl;
				}
			}
		}

		// $document_srl
		if(!$obj->document_srl)
		{
			$documents = executeQueryArray("document.getDocuments", $args);

			if($documents->toBool() && count($documents->data) > 0)
			{
				foreach($documents->data as $key => $val)
				{
					$obj->document_srl = $obj->document_srl? $obj->document_srl.",".$documents->data[$key]->document_srl : $documents->data[$key]->document_srl;
				}
			}
		}

		return $obj;
	}
*/
	/**
	 * @brief 내가 가진 라이센스 가져오기
	 **/
/*
	function myLicense($member_info)
	{
		// 문자열 or 쿼리가 안되서 foreach
		$outputs = array();
		$args->member_srl = $member_info->member_srl;
		$args->group_srl = implode(array_keys($member_info->group_list), ",");
		$output = executeQueryArray("lisense.getMyLicense", $args);

		return $output->data;
	}
*/
}
?>
