<?php
/**
 * @class lisenseAdminView
 * @author Elkha (support@elkha.kr)
 * @brief ^^
 **/

class lisenseAdminView extends lisense
{

	/**
	 * @brief 초기화
	 **/
	function init()
	{
	}

	/**
	 * @brief 관리자 - 라이센스 목록
	 **/
	function dispLisenseAdminList()
	{
		// 목록 변수
		$args->target_type = Context::get("idx_target_type");
		//$args->license_srl = Context::get("idx_license_srl");
		$args->target_srl = Context::get("idx_target_srl");

		$args->page = Context::get("page");
		$args->sort_index = Context::get("sort_index");
		$args->order_type = Context::get("order_type")?Context::get("order_type"):"desc";

		// 목록 가져오기
		$oLisenseAdminModel = &getAdminModel("lisense");
		$output = executeQueryArray("lisense.getLicenseList", $args);

		// 목록 변수 - set
		Context::set('list', $output->data);
		Context::set('total_count', $output->total_count);
		Context::set('total_page', $output->total_page);
		Context::set('page', $output->page);
		Context::set('page_navigation', $output->page_navigation);

		// $target_type 변수 가져오기
		$oLisenseModel = &getModel("lisense");
		Context::set("target_type", $oLisenseModel->target_type);

		// 템플릿 컴파일
		$this->setTemplatePath($this->module_path.'tpl');
		$this->setTemplateFile('dispLisenseAdminList');

	}

	/**
	 * @brief 관리자 - 권한 목록
	 **/
	function dispLisenseAdminPermitList()
	{
		// 목록 변수
		$args->target_type = Context::get("idx_target_type");
		$args->license_srl = Context::get("idx_license_srl");
		$args->target_srl = Context::get("idx_target_srl");

		$args->page = Context::get("page");
		$args->sort_index = Context::get("sort_index");
		$args->order_type = Context::get("order_type")?Context::get("order_type"):"desc";

		// 목록 가져오기
		$oLisenseAdminModel = &getAdminModel("lisense");
		$output = executeQueryArray("lisense.getPermitList", $args);

		// 목록 변수 - set
		Context::set('list', $output->data);
		Context::set('total_count', $output->total_count);
		Context::set('total_page', $output->total_page);
		Context::set('page', $output->page);
		Context::set('page_navigation', $output->page_navigation);

		// $target_type 변수 가져오기
		$oLisenseModel = &getModel("lisense");
		Context::set("target_type", $oLisenseModel->permit_type);

		// 템플릿 컴파일
		$this->setTemplatePath($this->module_path.'tpl');
		$this->setTemplateFile('dispLisenseAdminPermitList');
	}

	/**
	 * @brief license_srl|permit_srl 에 따라 목록 가져오기
	 **/
	function dispLisenseAdminLicenseSrlsList()
	{
		// 변수 set
		$permit_type = $this->permit_type[Context::get("type")];
		$args->search_target = Context::get("search_target");
		$args->list_count = 30;

		// member_srl
		if($permit_type=="member_srl") $output = executeQueryArray("lisense.getPackageList", $args);
		if($permit_type=="group_srl") $output = executeQueryArray("lisense.getPackageList", $args);
		if($permit_type=="license_srl") $output = executeQueryArray("lisense.getLicenseList", $args);

		foreach($output->data as $key => $val)
		{
		}

		$this->add("permit_type", $permit_type);

		$this->add("data", $output->data);
		$this->add('total_count', $output->total_count);
		$this->add('total_page', $output->total_page);
		$this->add('page', $output->page);
		$this->add('page_navigation', $output->page_navigation);
	}

}
?>
