<?php
/**
 * @class  lisenseAdminModel
 * @author Elkha (support@elkha.kr)
 * @brief ^^
 **/

class lisenseAdminModel extends lisense
{
	/**
	 * @brief 초기화
	 **/
	function init()
	{
	}

	/**
	 * @brief target_srl 에 따라 목록 가져오기
	 **/
	function getLisenseAdminTargetSrlsList()
	{
		// 변수 set
		$args = Context::getRequestVars("search_target", "id", "view");
		$args->list_count = 30;


		if($args->view=="dispLisenseAdminList")
		{
			$target_type = $this->target_type[Context::get("target_type")];

			// getPackageList
			if($target_type=="package_srl") $output = executeQueryArray("lisense.getPackageList", $args);

			// getDocumentList
			else if($target_type=="document_srl") $output = executeQueryArray("lisense.getDocumentList", $args);

			// getCommentList
			else if($target_type=="comment_srl")
			{
				$output = executeQueryArray("lisense.getCommentList", $args);
				foreach($output->data as $key => $val) $output->data[$key]->title = cut_str(strip_tags($val->content), 30, "...");
			}

			// file_srl
			else if($target_type=="file_srl")
			{
				$output = executeQueryArray("lisense.getFileList", $args);
				foreach($output->data as $key => $val) $output->data[$key]->title = $output->data[$key]->source_filename;
			}

			// module_srl
			else if($target_type=="module_srl")
			{
				$output = executeQueryArray("lisense.getModuleList", $args);
				foreach($output->data as $key => $val) $output->data[$key]->title = $output->data[$key]->browser_title;
			}

			foreach($output->data as $key => $val)
			{
				// mid 넣어주고
				if($target_type=="module_srl") $output->data[$key]->browser_title = $output->data[$key]->module . " (".$output->data[$key]->mid.")";
				else $output->data[$key]->browser_title .= " (".$output->data[$key]->mid.")";

				// nick_name
				if($target_type=="module_srl") $output->data[$key]->nick_name = "-";
				else $output->data[$key]->nick_name .= " (".$output->data[$key]->user_id.")";
			}
		}
		else if($args->view=="dispLisenseAdminPermitList")
		{
			$target_type = $this->permit_type[Context::get("target_type")];

			// license_srl
			if($args->id=="license_srl")
			{
				$target_type = "license_srl";
				$args->order_type = "desc";
				$output = executeQueryArray("lisense.getLicenseList", $args);
				foreach($output->data as $key => $val)
				{
					$output->data[$key]->target = $this->target_type[$output->data[$key]->target_type] . " (".$output->data[$key]->target_srl.")";
					$output->data[$key]->desc = cut_str(strip_tags($output->data[$key]->description), 30, "...");
				}
			}
			else if($target_type=="member_srl")
			{
				$args->s_nick_name = $args->search_target;
				$args->s_user_id = $args->search_target;
				$output = executeQueryArray("member.getMemberList", $args);
				foreach($output->data as $key => $val)
				{
					$output->data[$key]->title = $output->data[$key]->nick_name . " (" . $output->data[$key]->user_id .")";
				}
			}
			else if($target_type=="group_srl")
			{
				$output = executeQueryArray("lisense.getGroupList", $args);
			}
		}

		foreach($output->data as $key => $val)
		{
			// target_srl 넣어주고
			$output->data[$key]->target_srl = $output->data[$key]->{$target_type};
			// date
			$output->data[$key]->regdate = zdate($output->data[$key]->regdate, "Y-m-d H:i:s");
		}

		$this->add("target_type", $target_type);

		$this->add("data", $output->data);
		$this->add('total_count', $output->total_count);
		$this->add('total_page', $output->total_page);
		$this->add('page', $output->page);
		$this->add('page_navigation', $output->page_navigation);
	}
}
?>