<?php
/**
 * @class lisenseAdminController
 * @author Elkha (support@elkha.kr)
 * @brief ^^
 **/

class lisenseAdminController extends lisense
{

	/**
	 * @brief Initialization
	 **/
	function init()
	{
	}

	/**
	 * @brief 관리자가 라이센스 추가
	 **/
	function procLisenseAdminInsert()
	{
		$args = Context::gets("license_srl", "target_srl", "target_type", "title", "description");

		if(!$args->license_srl)
		{
			// insertLicense
			$args->regdate = date('YmdHis');
			$args->license_srl = getNextSequence();
			$output = executeQuery("lisense.insertLicense", $args);
		}
		else
		{
			// updateLicense
			if(!$args->title) $args->title="";
			if(!$args->description) $args->description="";
			$output = executeQuery("lisense.updateLicense", $args);
		}
		if(!$output->toBool()) return $output;


		// 새로고침
		$redirectUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispLisenseAdminList');
		$this->setRedirectUrl($redirectUrl);

	}

	/**
	 * @brief 관리자가 라이센스 삭제
	 **/
	function procLisenseAdminDelete()
	{
		$args->license_srl = Context::get("license_srl");

		$output = executeQuery("lisense.deleteLicense", $args);
		if(!$output->toBool()) return $output;

		$this->setMessage('success_deleted');
	}

	/**
	 * @brief 관리자가 권한 삭제
	 **/
	function procLisenseAdminPermitDelete()
	{
		$args->permit_srl = Context::get("permit_srl");

		$output = executeQuery("lisense.deletePermit", $args);
		if(!$output->toBool()) return $output;

		$this->setMessage('success_deleted');
	}

	/**
	 * @brief 관리자가 권한 추가
	 **/
	function procLisenseAdminPermitInsert()
	{
		$args = Context::gets("permit_srl", "license_srl", "target_srl", "target_type", "description");

		if(!$args->permit_srl)
		{
			// insertPermit
			$args->regdate = date('YmdHis');
			$args->permit_srl = getNextSequence();
			$output = executeQuery("lisense.insertPermit", $args);
		}
		else
		{
			// updatePermit
			if(!$args->description) $args->description="";
			$output = executeQuery("lisense.updatePermit", $args);
		}
		if(!$output->toBool()) return $output;

		// 새로고침
		$redirectUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispLisenseAdminPermitList');
		$this->setRedirectUrl($redirectUrl);
	}

}
?>
