<?php
    /**
     * @class widget_kgmedia
     * @author xenara (kolaskks@naver.com)
     * @brief widget to display media
     * @version 0.1
     **/

    class widget_kgmedia extends WidgetHandler {

        function proc($args) {

            // 기본설정 I
            if(!$args->content_type) $args->content_type = 'document';
            if(!$args->list_count) $args->list_count = 5;
            if(!$args->page_count) $args->page_count = 1;
            if(!$args->page_count2) $args->page_count2 = null;
            if(!$args->new_window) $args->new_window = 'self';
            if(!in_array($args->order_target, array('list_order','update_order','regdate','readed_count','voted_count'))) $args->order_target = 'list_order';
            if(!in_array($args->order_type, array('asc','desc'))) $args->order_type = 'asc';

            // 기본설정 II
            if(!$args->font_family) $args->font_family = null;
            if(!$args->font_size) $args->font_size = 12;
            if(!$args->font_color) $args->font_color = null;
            if(!$args->colorset_num) $args->colorset_num = 1;

            // 제목과 더보기 설정
            if(!$args->show_document_title) $args->show_document_title='Y';
            if(!$args->document_title) $args->document_title = null;
            if(!$args->document_subtitle) $args->document_subtitle = null;
            if(!$args->show_more) $args->show_more='Y';
            if(!$args->more_window) $args->more_window = 'self';

            // 게시물 미디어 설정
            if(!$args->show_media) $args->show_media='Y';
            if(!$args->media_width) $args->media_width = 200;
            if(!$args->media_height) $args->media_height = 150;
            if(!$args->media_height) $args->media_all='N';
            if(!$args->media_height) $args->youtube_player='youtube';

            // 게시물 썸네일 설정
            if(!$args->show_thumbnail) $args->show_thumbnail='Y';
            if(!$args->image_type) $args->image_type = 'flie_image';
            if(!$args->thumbnail_type) $args->thumbnail_type='ratio';
            if(!$args->thumbnail_width) $args->thumbnail_width = 100;
            if(!$args->thumbnail_height) $args->thumbnail_height = 75;

            // 게시물 목록 제목설정
            if(!$args->show_titlearea) $args->show_titlearea='Y';
            if(!$args->show_list_number) $args->show_list_number='Y';
            if(!$args->show_browser_title) $args->show_browser_title='Y';
            if(!$args->show_category) $args->show_category='Y';
            if(!$args->show_title) $args->show_title='Y';
            if(!$args->subject_cut_size) $args->subject_cut_size = 0;
            if(!$args->show_comment_count) $args->show_comment_count='Y';
            if(!$args->show_trackback_count) $args->show_trackback_count='Y';
            if(!$args->show_icon) $args->show_icon='Y';
            if(!$args->duration_new) $args->duration_new = 12;
            if(!$args->show_author) $args->show_author='Y';
            if(!$args->show_date) $args->show_date='Y';
            if(!$args->show_readed_count) $args->show_readed_count='N';
            if(!$args->show_voted_count) $args->show_voted_count='N';

            // 게시물 목록 내용설정
            if(!$args->show_content) $args->show_content='Y';
            if(!$args->content_cut_size) $args->content_cut_size = 100;


            //'module'객체 생성 및 정보구함
            $oModuleModel = &getModel('module');
            $module_srls = $args->modules_info = $args->module_srls_info = $args->mid_lists = array();
            $site_module_info = Context::get('site_module_info');


            if($args->content_type == 'rss'){
                $args->rss_urls = array();
                $rss_urls = array_unique(array($args->rss_url0,$args->rss_url1,$args->rss_url2,$args->rss_url3,$args->rss_url4));
                for($i=0,$c=count($rss_urls);$i<$c;$i++) {
                    if($rss_urls[$i]) $args->rss_urls[] = $rss_urls[$i];
                }
            } else {
                if(!$args->module_srls){
                    unset($obj);
                    $obj->site_srl = (int)$site_module_info->site_srl;
                    $output = executeQueryArray('widgets.widget_kgmedia.getMids', $obj);
                    if($output->data) {
                        foreach($output->data as $key => $val) {
                            $args->modules_info[$val->mid] = $val;
                            $args->module_srls_info[$val->module_srl] = $val;
                            $args->mid_lists[$val->module_srl] = $val->mid;
                            $module_srls[] = $val->module_srl;
                        }
                    }
                    $args->modules_info = $oModuleModel->getMidList($obj);
                } else {
                    $obj->module_srls = $args->module_srls;
                    $output = executeQueryArray('widgets.widget_kgmedia.getMids', $obj);
                    if($output->data) {
                        foreach($output->data as $key => $val) {
                            $args->modules_info[$val->mid] = $val;
                            $args->module_srls_info[$val->module_srl] = $val;
                            $module_srls[] = $val->module_srl;
                        }
                        $idx = explode(',',$args->module_srls);
                        for($i=0,$c=count($idx);$i<$c;$i++) {
                            $srl = $idx[$i];
                            if(!$args->module_srls_info[$srl]) continue;
                            $args->mid_lists[$srl] = $args->module_srls_info[$srl]->mid;
                        }
                    }
                }
                if(!count($args->modules_info)) return Context::get('msg_not_founded');
                $args->module_srl = implode(',',$module_srls);
            }
            switch($args->content_type){
                case 'comment':
                    $content_items = $this->getCommentItems($args);
                    break;
                case 'rss':
                    $content_items = $this->getRssItems($args);
                    break;
                default:
                    $content_items = $this->getDocumentItems($args);
                    break;
            }

            $output = $this->_compile($args,$content_items);
            return $output;
        }



        // 게시물 내용 중 이미지를 출력하는 함수
        function getImageItems($srl,$object){
            $oFileModel = &getModel('file');
            $all_filename = array();
            $image_type = '(jpg|png|gif|bmp)';

            //게시물 내용 중 첨부파일이 있을 경우 첨부파일주소반환
            $file_list = $oFileModel->getFiles($srl);
            if(count($file_list)) {
              foreach($file_list as $file) {
                if(preg_match("/\.".$image_type."/i",$file->source_filename)) {
                  $all_filename[$srl][] = $file->uploaded_filename;
                }
              }
            }

            //게시물 내용 중 링크파일이 있을 경우 링크주소반환
            $docu_summary = $object->getContent();
            $docu_summary = preg_replace('/<[^(i)].*?>/i', ' ', $docu_summary);
            $docu_summary = preg_replace('/\&lt\;[^i].*?\&gt\;/i', ' ', $docu_summary);
            $docu_summary = preg_replace('/http/i', ' http', $docu_summary);
            $pattern_code = "/";
            $pattern_code = $pattern_code."((http:\/\/|https:\/\/).+?\s)";
            $pattern_code = $pattern_code."/i";
            preg_match_all($pattern_code, $docu_summary, $link_file);

            for($k=1;$k<=count($link_file[0]);$k++) {
              $link_file[0][$k-1] = preg_replace('/("|\')/i', '', $link_file[0][$k-1]);
              if(preg_match("/((http:\/\/|https:\/\/).+?\.".$image_type.")/i", $link_file[0][$k-1])){
                $all_filename[$srl][] = $link_file[0][$k-1];
              }
              else{
                //(jpg|png|gif|bmp) 등이 아닌 링크일경우 추가부분
              }
            }

            if(count($all_filename[$srl])) $image_items = $all_filename[$srl];
            else $image_items = null;
            return $image_items;
        }



        // 게시물 내용 중 미디어를 출력하는 함수
        function getMediaItems($srl,$object){
            $oFileModel = &getModel('file');
            $all_filename = array();
            $media_type = '(avi|wmv|mpg|swf|flv|mp4)';

            //게시물 내용 중 첨부파일이 있을 경우 첨부파일주소반환
            $file_list = $oFileModel->getFiles($srl);
            if(count($file_list)) {
              foreach($file_list as $file) {
                if(preg_match("/\.".$media_type."/i",$file->source_filename)) {
                  $all_filename[$srl][] = $file->uploaded_filename;
                }
              }
            }

            //게시물 내용 중 링크파일이 있을 경우 링크주소반환
            $docu_summary = $object->getContent();
            $docu_summary = preg_replace('/<[^ei].*?>/i', ' ', $docu_summary);
            $docu_summary = preg_replace('/\&lt\;[^ei].*?\&gt\;/i', ' ', $docu_summary);
            $docu_summary = preg_replace('/http/i', ' http', $docu_summary);
            $docu_summary = preg_replace('/mms/i', ' mms', $docu_summary);
            $pattern_code = "/";
            $pattern_code = $pattern_code."((http:\/\/|https:\/\/|mms:\/\/).+?\s)";
            $pattern_code = $pattern_code."/i";
            preg_match_all($pattern_code, $docu_summary, $link_file);

            for($k=1;$k<=count($link_file[0]);$k++) {
              $link_file[0][$k-1] = preg_replace('/("|\')/i', '', $link_file[0][$k-1]);
              if(preg_match("/((http:\/\/|https:\/\/|mms:\/\/).+?\.".$media_type.")/i", $link_file[0][$k-1])){
                $last_chr = substr($link_file[0][$k-1], -1);
                if($last_chr==' ') $link_file[0][$k-1] = substr($link_file[0][$k-1], 0, -1);
                $all_filename[$srl][] = $link_file[0][$k-1];
              }
              else if(preg_match("/(http:\/\/www.youtube.com|http:\/\/youtube.com|http:\/\/youtu.be)/i", $link_file[0][$k-1])){
                //youtube code part
                $link_file[0][$k-1] = preg_replace('/(http:\/\/www.youtube.co|http:\/\/youtube.co|http:\/\/youtu.b).+?\//i', 'youtube', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(watch\?v\=)/i', '', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(amp\;)/i', '', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(embed\/)/i', '', $link_file[0][$k-1]);
                $last_chr = substr($link_file[0][$k-1], -1);
                if($last_chr==' ') $link_file[0][$k-1] = substr($link_file[0][$k-1], 0, -1);
                $all_filename[$srl][] = $link_file[0][$k-1];
              }
              else if(preg_match("/(http:\/\/player.vimeo.com)/i", $link_file[0][$k-1])){
                //vimeo code part
                $link_file[0][$k-1] = preg_replace('/(http:\/\/player.vimeo.co).+?\//i', 'vimeopl', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(video\/)/i', '', $link_file[0][$k-1]);
                $last_chr = substr($link_file[0][$k-1], -1);
                if($last_chr==' ') $link_file[0][$k-1] = substr($link_file[0][$k-1], 0, -1);
                $all_filename[$srl][] = $link_file[0][$k-1];
              }
              else if(preg_match("/(http:\/\/flvs.daum.net|http:\/\/tvpot.daum.net)/i", $link_file[0][$k-1])){
                //daumtvpot code part
                $link_file[0][$k-1] = preg_replace('/(http:\/\/flvs.daum.ne|http:\/\/tvpot.daum.ne).+?\//i', 'daumtvp', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(flvPlayer\.swf\?vid\=)/i', '', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(clip\/)/i', '', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(ClipViewByVid\.do\?vid\=)/i', '', $link_file[0][$k-1]);
                $last_chr = substr($link_file[0][$k-1], -1);
                if($last_chr==' ') $link_file[0][$k-1] = substr($link_file[0][$k-1], 0, -1);
                $all_filename[$srl][] = $link_file[0][$k-1];
              }
              else if(preg_match("/(http:\/\/channel.pandora.tv|http:\/\/flvr.pandora.tv)/i", $link_file[0][$k-1])){
                //pandoratv code part
                $link_file[0][$k-1] = preg_replace('/(http:\/\/channel.pandora.t|http:\/\/flvr.pandora.t).+?\//i', 'pandora', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(channel\/)/i', '', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(video\.ptv\?ch_userid\=)/i', '', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(\&prgid)/i', '&amp;prgid', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(flv2pan\/)/i', '', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(flvmovie\.dll\/userid\=)/i', '', $link_file[0][$k-1]);
                $last_chr = substr($link_file[0][$k-1], -1);
                if($last_chr==' ') $link_file[0][$k-1] = substr($link_file[0][$k-1], 0, -1);
                $all_filename[$srl][] = $link_file[0][$k-1];
              }
              else if(preg_match("/(http:\/\/channel.jjanglive.com|http:\/\/www.jjanglive.com)/i", $link_file[0][$k-1])){
                //jjanglive code part <embed>코드가 2개이상으면 에러발생
                $link_file[0][$k-1] = preg_replace('/(http:\/\/channel.jjanglive.co|http:\/\/www.jjanglive.co).+?\//i', 'jjangli', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(flash\/)/i', '', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(webClient\.swf\?widgetseq\=)/i', '', $link_file[0][$k-1]);
                $link_file[0][$k-1] = preg_replace('/(\/)/i', '&movieseq=', $link_file[0][$k-1]);
                $last_chr = substr($link_file[0][$k-1], -1);
                if($last_chr==' ') $link_file[0][$k-1] = substr($link_file[0][$k-1], 0, -1);
                $all_filename[$srl][] = $link_file[0][$k-1];
              }
            }

            if(count($all_filename[$srl])) $media_items = $all_filename[$srl];
            else $media_items = null;
            return $media_items;
        }



        // 'document'를 출력하는 함수
        function getDocumentItems($args){
            // 해당 모듈의 model 객체를 받아서 결과를 객체화 시킴
            $oDocumentModel = &getModel('document');
            $oCommentModel = &getModel('comment');

            // 분류 구함
            $obj->module_srl = $args->module_srl;
            $output = executeQueryArray('widgets.widget_kgmedia.getCategories',$obj);
            if($output->toBool() && $output->data) {
                foreach($output->data as $key => $val) {
                    $category_lists[$val->module_srl][$val->category_srl] = $val;
                }
            }

            // 글 목록을 구함
            $obj->module_srl = $args->module_srl;
            $obj->category_srl = $args->category_srl;
            $obj->sort_index = $args->order_target;
            $obj->order_type = $args->order_type=="desc"?"asc":"desc";
            if($args->page_count2==null) $obj->list_count = $args->list_count * $args->page_count;
            else $obj->list_count = $args->list_count * $args->page_count2;
//      			$obj->statusList = array('PUBLIC');
            $output = executeQueryArray('widgets.widget_kgmedia.getNewestDocuments', $obj);
            if(!$output->toBool() || !$output->data) return;

            // 결과가 있으면 각 문서 객체화를 시킴
            $content_items = array();
            if(count($output->data)) {
                foreach($output->data as $key => $attribute) {
                    $oDocument = new documentItem();
                    $oDocument->setAttribute($attribute, false);
                    $GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
                    $document_srls[] = $oDocument->document_srl;
                }
                $oDocumentModel->setToAllDocumentExtraVars();

                for($i=0,$c=count($document_srls);$i<$c;$i++) {
                    $oDocument = $GLOBALS['XE_DOCUMENT_LIST'][$document_srls[$i]];
                    $comment_srl = null;
                    $document_srl = $oDocument->document_srl;
                    $module_srl = $oDocument->get('module_srl');
                    $category_srl = $oDocument->get('category_srl');

                    if($args->show_media=='Y') {
                      $media_items = $this->getMediaItems($document_srl,$oDocument);
                      $all_media = $media_items;
                    }

                    if($args->show_thumbnail=='Y') {
                      $image_items = $this->getImageItems($document_srl,$oDocument);
                      $all_thumbnail = $image_items;
                    }

                    $content_item = new kgmediaItem( $args->module_srls_info[$module_srl]->browser_title );
                    $content_item->adds($oDocument->getObjectVars());
                    $content_item->add('original_content', $oDocument->get('content'));
                    $content_item->setTitle($oDocument->getTitle());
                    $content_item->setCategory( $category_lists[$module_srl][$category_srl]->title );
                    $content_item->setDomain( $args->module_srls_info[$module_srl]->domain );
                    $content_item->setContent($oDocument->getSummary($args->content_cut_size));
                    $content_item->setLink( getSiteUrl($domain,'','document_srl',$document_srl) );
                    $content_item->setAllMedia($all_media);
                    $content_item->setAllThumbnail($all_thumbnail);
                    $content_item->setExtraImages($oDocument->printExtraImages($args->duration_new * 60 * 60));
                    $content_item->setComment($oDocument->getComments());
                    $content_item->add('mid', $args->mid_lists[$module_srl]);
                    $content_item->add('document_srl', $document_srl);
                    $content_item->add('comment_srl', $comment_srl);

                    $content_items[] = $content_item;
                }
            }
            return $content_items;
        }




        function _compile($args,$content_items){
            $oTemplate = &TemplateHandler::getInstance();

            // 기본설정 I
            $widget_info->content_type = $args->content_type;
            $widget_info->list_count = $args->list_count;
            $widget_info->page_count = $args->page_count;
            $widget_info->page_count2 = $args->page_count2;
            $widget_info->new_window = $args->new_window;
            $widget_info->order_target = $args->order_target;
            $widget_info->order_type = $args->order_type;

            // 기본설정 II
            $widget_info->font_family = $args->font_family;
            $widget_info->font_size = $args->font_size;
            $widget_info->font_color = $args->font_color;
            $widget_info->colorset_num = $args->colorset_num;

            // 제목과 더보기 설정
            $widget_info->show_document_title = $args->show_document_title;
            $widget_info->document_title = $args->document_title;
            $widget_info->document_subtitle = $args->document_subtitle;
            $widget_info->show_more = $args->show_more;
            $widget_info->more_window = $args->more_window;

            // 게시물 미디어 설정
            $widget_info->show_media = $args->show_media;
            $widget_info->media_width = $args->media_width;
            $widget_info->media_height = $args->media_height;
            $widget_info->media_all = $args->media_all;
            $widget_info->youtube_player = $args->youtube_player;

            // 게시물 썸네일 설정
            $widget_info->show_thumbnail = $args->show_thumbnail;
            $widget_info->image_type = $args->image_type;
            $widget_info->thumbnail_type = $args->thumbnail_type;
            $widget_info->thumbnail_width = $args->thumbnail_width;
            $widget_info->thumbnail_height = $args->thumbnail_height;

            // 게시물 목록 제목설정
            $widget_info->show_titlearea = $args->show_titlearea;
            $widget_info->show_list_number = $args->show_list_number;
            $widget_info->show_browser_title = $args->show_browser_title;
            $widget_info->show_category = $args->show_category;
            $widget_info->show_title = $args->show_title;
            $widget_info->subject_cut_size = $args->subject_cut_size;
            $widget_info->show_comment_count = $args->show_comment_count;
            $widget_info->show_trackback_count = $args->show_trackback_count;
            $widget_info->show_icon = $args->show_icon;
            $widget_info->duration_new = $args->duration_new;
            $widget_info->show_author = $args->show_author;
            $widget_info->show_date = $args->show_date;
            $widget_info->show_readed_count = $args->show_readed_count;
            $widget_info->show_voted_count = $args->show_voted_count;

            // 게시물 목록 내용설정
            $widget_info->show_content = $args->show_content;
            $widget_info->content_cut_size = $args->content_cut_size;

            // $content_items 설정
            $widget_info->content_items = $content_items;

            unset($args->option_view_arr);
            unset($args->modules_info);

            Context::set('colorset', $args->colorset);
            Context::set('widget_info', $widget_info);

            //위젯스킨 폴더명 설정
            $widget_skin_name = $args->skin;
            $widget_skin_name = str_replace(".","_",$widget_skin_name);
            $widget_skin_name = str_replace("(","_",$widget_skin_name);
            $widget_skin_name = str_replace(")","",$widget_skin_name);
            $widget_skin_name = str_replace("/","",$widget_skin_name);
            Context::set('widget_skin_name', $widget_skin_name);

            //위젯 설치경로 설정
            Context::set('widget_path', $this->widget_path);

            //위젯스킨 설치경로 설정
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);

            //위젯스킨 css파일 생성
            $kgmedia_css = FileHandler::readFile($tpl_path.'/kgmedia_css.html');
            $kgmedia_css = str_replace('";?>','',$kgmedia_css);
            $kgmedia_css = str_replace('<?php $widget_skin_css = "','@charset "utf-8";',$kgmedia_css);
            $kgmedia_css = str_replace('widget_kgmedia',$widget_skin_name,$kgmedia_css);
            FileHandler::writeFile($tpl_path.'/css/kgmedia.css', $kgmedia_css, 'w');

            //위젯 템플릿 컴파일 설정
            return $oTemplate->compile($tpl_path, "kgmedia");

        }
    }



    class kgmediaItem extends Object {

        var $browser_title = null;
        var $contents_link = null;
        var $domain = null;

        function kgmediaItem($browser_title=''){
            $this->browser_title = $browser_title;
        }

        function setCategory($category){
            $this->add('category',$category);
        }
        function setTitle($title){
            $this->add('title',$title);
        }
        function setExtraImages($extra_images){
            $this->add('extra_images',$extra_images);
        }
        function setNickName($nick_name){
            $this->add('nick_name',$nick_name);
        }
        function setRegdate($regdate){
            $this->add('regdate',$regdate);
        }
        function setLink($url){
            $this->add('url',$url);
        }
        function setMedia($media){
            $this->add('media',$media);
        }
        function setAllMedia($all_media){
            $this->add('all_media',$all_media);
        }
        function setThumbnail($thumbnail){
            $this->add('thumbnail',$thumbnail);
        }
        function setAllThumbnail($all_thumbnail){
            $this->add('all_thumbnail',$all_thumbnail);
        }
        function setContent($content){
            $this->add('content',$content);
        }
        function setContentsLink($link){
            $this->contents_link = $link;
        }
        function setComment($comment_items){
            $this->add('comment_items',$comment_items);
        }
        function setDomain($domain) {
            static $default_domain = null;
            if(!$domain) {
                if(is_null($default_domain)) $default_domain = Context::getDefaultUrl();
                $domain = $default_domain;
            }
            $this->domain = $domain;
        }
        // Save author's homepage url. By misol
        function setAuthorSite($site_url){
            $this->add('author_site',$site_url);
        }


        function getBrowserTitle(){
            return $this->browser_title;
        }
        function getCategory(){
            return $this->get('category');
        }
        function getTitle($cut_size = 0, $tail='...'){
            $title = strip_tags($this->get('title'));

            if($cut_size) $title = cut_str($title, $cut_size, $tail);

            $attrs = array();
            if($this->get('title_bold') == 'Y') $attrs[] = 'font-weight:bold';
            if($this->get('title_color') && $this->get('title_color') != 'N') $attrs[] = 'color:#'.$this->get('title_color');

            if(count($attrs)) $title = sprintf("<span style=\"%s\">%s</span>", implode(';', $attrs), htmlspecialchars($title));

            return $title;
        }
        function getCommentCount(){
            $comment_count = $this->get('comment_count');
            return $comment_count>0 ? $comment_count : '';
        }
        function getTrackbackCount(){
            $trackback_count = $this->get('trackback_count');
            return $trackback_count>0 ? $trackback_count : '';
        }
        function printExtraImages() {
            return $this->get('extra_images');
        }
        function getNickName(){
            return $this->get('nick_name');
        }
        function getRegdate($format = 'Y.m.d H:i:s') {
            return zdate($this->get('regdate'), $format);
        }
        function getLink(){
            return $this->get('url');
        }
        function getMedia(){
            return $this->get('media');
        }
        function getAllMedia(){
            return $this->get('all_media');
        }
        function getThumbnail(){
            return $this->get('thumbnail');
        }
        function getAllThumbnail(){
            return $this->get('all_thumbnail');
        }
        function getContent(){
            return $this->get('content');
        }
        function getContentsLink(){
            return $this->contents_link;
        }
        function getComment(){
            return $this->get('comment_items');
        }
        function getDomain() {
            return $this->domain;
        }
        function getModuleSrl(){
            return $this->get('module_srl');
        }
        function getMemberSrl() {
            return $this->get('member_srl');
        }
        function getAuthorSite(){
            return $this->get('author_site');
        }
        function getReadedCount(){
            $readed_count = $this->get('readed_count');
            return $readed_count>0 ? $readed_count : '0';
        }
        function getVotedCount(){
            $voted_count = $this->get('voted_count');
            return $voted_count>0 ? $voted_count : '0';
        }

    }
?>
