<?php
	/**
	* @class  column_change
	* @author largeden (cbrghost@gmail.com)
	* @brief  column_change class
	**/

	class column_change {

		var $filename;
		var $version_help;

		/**
		* @brief 기본 기능
		**/
		function init() {

			$filename = explode('/',$_SERVER['SCRIPT_FILENAME']);
			$this->filename = $filename[count($filename)-1];

			define('_XE_PATH_', str_replace($this->filename, "", str_replace("\\", "/", __FILE__)));
			define('__XE__', true);
			define('__ZBXE__', true);

			require_once(_XE_PATH_.'config/config.inc.php');
			if(!preg_match('/^1.5/',__ZBXE_VERSION__)) $this->version_help = 1;

			$oContext = &Context::getInstance();
			$oContext->context = &$GLOBALS['__Context__'];
			$oContext->context->lang = &$GLOBALS['lang'];
			$oContext->context->_COOKIE = $_COOKIE;
			$oContext->setRequestMethod('');
			$oContext->_setXmlRpcArgument();
			$oContext->_setJSONRequestArgument();
			$oContext->_setRequestArgument();
			$oContext->_setUploadedArgument();
			$oContext->loadDBInfo();
			$this->procColumnChange();
		}

		/**
		* @brief 유일한 column_change 객체를 반환 (Singleton)
		* column_change는 어디서든 객체 선언없이 사용하기 위해서 static 하게 사용
		**/
		function &getInstance() {
			static $theInstance;
			if(!isset($theInstance)) $theInstance = new column_change();
			return $theInstance;
		}

		function procColumnChange() {
			if($this->version_help) {
				echo "(구버전에서는 사용하실 수 없습니다. 1.5.x 이상 이용 가능)";
				return;
			}

			switch(Context::get('type')) {
				case 'procStep': $this->procStep(); break;
				default: break;
			}

			if(!Context::get('xe')) $this->html();
		}

		function procStep() {
			$oDB = &DB::getInstance();

			//1. documents 테이블의 구조를 확인한다.
			$table_name = $oDB->prefix."documents";

			//2. documents 테이블에 status라는 column이 있는지 확인한다.
			$result = $oDB->_query("show columns from ".$table_name." where field = 'status';");
			if($oDB->isError()) {
				echo "DB수행에 문제가 있습니다.(error)";
				return false;
			}

			if(!$oDB->_fetch($result)) {
				$result = $oDB->_query("show columns from ".$table_name." where field = 'is_secret';");
				if($oDB->isError()) {
					echo "DB수행에 문제가 있습니다.(error)";
					return false;
				}

				//3. 기존 비밀글 컬럼을 status로 옮겨 줍니다.
				if($oDB->_fetch($result)) {
					$oDB->_query("ALTER TABLE ".$table_name." ADD COLUMN `status` VARCHAR(20) DEFAULT 'PUBLIC';");
					if($oDB->isError()) $oDB->rollback();

					$oDB->_query("UPDATE ".$table_name." SET status='SECRET' WHERE is_secret='Y';");
					if($oDB->isError()) $oDB->rollback();

					//4. is_secret column을 삭제 합니다.
					$oDB->_query("ALTER TABLE ".$table_name." DROP COLUMN `is_secret`;");
					if($oDB->isError()) $oDB->rollback();
				} else {
					echo "is_secret가 존재하지 않습니다.";
					return false;
				}
			} else {
				echo "status가 이미 존재합니다.";
				return false;
			}

			//5. comment_status column을 추가 합니다.(하기전에 있는지 봐야죠.)
			$result = $oDB->_query("show columns from ".$table_name." where field = 'comment_status';");
			if($oDB->isError()) {
				echo "DB수행에 문제가 있습니다.(error)";
				return false;
			}

			if(!$oDB->_fetch($result)) {
				$result = $oDB->_query("show columns from ".$table_name." where field in('allow_comment','lock_comment');");
				if($oDB->isError()) {
					echo "DB수행에 문제가 있습니다.(error)";
					return false;
				}

				//5. comment_status column을 추가 합니다.
				if($oDB->_fetch($result)) {
					$oDB->_query("ALTER TABLE ".$table_name." ADD COLUMN `comment_status` VARCHAR(20) DEFAULT 'ALLOW';");
					if($oDB->isError()) $oDB->rollback();

					//6. comment_status의 값을 업데이트 합니다.
					$oDB->_query("UPDATE ".$table_name." SET comment_status='DENY' WHERE allow_comment='Y' AND lock_comment='Y';");
					if($oDB->isError()) $oDB->rollback();

					$oDB->_query("UPDATE ".$table_name." SET comment_status='DENY' WHERE allow_comment='N' AND lock_comment='Y'; ");
					if($oDB->isError()) $oDB->rollback();

					$oDB->_query("UPDATE ".$table_name." SET comment_status='DENY' WHERE allow_comment='N' AND lock_comment='N';");
					if($oDB->isError()) $oDB->rollback();
					
					//7. allow_comment column과 lock_comment column을 삭제 합니다.
					$oDB->_query("ALTER TABLE ".$table_name." DROP COLUMN `allow_comment`; ");
					if($oDB->isError()) $oDB->rollback();

					$oDB->_query("ALTER TABLE ".$table_name." DROP COLUMN `lock_comment`;");
					if($oDB->isError()) $oDB->rollback();
				} else {
					echo "allow_comment,lock_comment가 존재하지 않습니다.";
					return false;
				}
			} else {
				echo "comment_status가 이미 존재합니다.";
				return false;
			}

			//8. 마지막으로 status 관련 index를 추가 합니다.(하기전에 있는지 봐야죠.)
			$result = $oDB->_query("show index from ".$table_name." where Key_name = 'idx_module_status';");
			if($oDB->isError()) {
				echo "DB수행에 문제가 있습니다.(error)";
				return false;
			}

			//8. 마지막으로 status 관련 index를 추가 합니다.
			if(!$oDB->_fetch($result)) {
				$oDB->_query("ALTER TABLE `".$table_name."` ADD INDEX `idx_module_status` (module_srl, status);");
				if($oDB->isError()) $oDB->rollback();
			} else {
				echo "idx_module_status(module_srl, status)가 이미 존재합니다.";
				return false;
			}

			echo "처리가 완료되었습니다.\n확인 작업등은 phpMyAdmin 등으로 확인해주세요.";
		}

		function html() {
			if($this->version_help) $help = "(구버전에서는 사용하실 수 없습니다. 1.5.x 이상 이용 가능)";
			$html = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
			<html lang="ko" xml:lang="ko" xmlns="http://www.w3.org/1999/xhtml">
			<head>
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
			<title>XE column_change</title>
			<script type="text/javascript" src="common/js/jquery.js"></script>
			<script type="text/javascript">
			function column_change(type) {
			if(type == \'procStep\') { if (!confirm(confirm_run)) return; }
			var act = \'\';
			switch(type) {
			case \'procStep\': act = \'procStep\'; break;
			default: break;
			}

			jQuery.ajax({url: \''.$this->filename.'?xe=1&type=\'+act,success: function(data) {alert(data);}});}</script>
			</head>
			<body>
			<div style="font-size:3em;">XE column_change</div>
			<div style="color:orangered;font-size:1.5em;">현재 XE버전 '.__ZBXE_VERSION__.$help.'</div>
			<div>
			<ol>
			<li><button type="button" '.$step_1.' class="text" onclick="column_change(\'procStep\');">Step 실행</button>
			<p><a href="http://www.xpressengine.com/blog/textyle/20350952" target="_blank">http://www.xpressengine.com/blog/textyle/20350952</a>에 소개되어있는 <br />
			Document Module 업데이트 후 알수 없는 오류에 대한 해결 방법을 수행하기 위한 툴입니다.<br />
			이 툴은 xe_documents테이블에 미 수행된 컬럼 변경과 index처리를 수행하는 기능이 포함되어있습니다.<br />
			작업을 시도하기 전에는 반드시 데이터베이스를 백업하시기 바랍니다.<br />
			백업을 어떻게해야할지 모르시는분들은 본인이 웹호스팅 사용자이시라면 해당 호스팅회사 전문자에게 문의해주세요.
			</p>
			</li>
			</ol>
			</div>
			<script type="text/javascript">confirm_run = \'문제 발생에 대해서는 책임지지 않습니다.\n꼭! 데이터베이스 자료를 백업하시고 진행하시기 바랍니다.\n실행하시겠습니까?\';</script>
			<div class="wfsr"></div></body></html>';

			echo $html;
		}
	}

	$column_change = &column_change::getInstance();
	$column_change->init();
?>