<?php
    /**
     * @class  boardauctionView
     * @author PSY (www.userpin.org)
     * @brief  boardauction 모듈의 View class
     **/

    class boardauctionView extends boardView {
		var $listConfig;
		var $columnList;

        /**
         * @brief 초기화
         * board 모듈은 일반 사용과 관리자용으로 나누어진다.\n
         **/
        function init() {        	
            $class_path = ModuleHandler::getModulePath('board');
            $this->setModulePath($class_path);
            parent::init();
        }


        /**
         * @brief 자동입찰 페이지 출력
         **/
        function dispBoardauctionTenderForm(){
            // 요청된 변수 값들을 정리
            $document_srl = Context::get('document_srl');
            $page = Context::get('page');

            // document model 객체 생성 
            $oDocumentModel = &getModel('document');

            /**
             * 요청된 문서 번호가 있다면 문서를 구함
             **/
            if($document_srl) {
                $oDocument = $oDocumentModel->getDocument($document_srl, false, true); 

                // 해당 문서가 존재할 경우 필요한 처리를 함
                if($oDocument->isExists()) {

                    // 글과 요청된 모듈이 다르다면 오류 표시
                    if($oDocument->get('module_srl')!=$this->module_info->module_srl ) return $this->stop('msg_invalid_request');

                    // 관리 권한이 있다면 권한을 부여
                    if($this->grant->manager) $oDocument->setGrant();

                    // 상담기능이 사용되고 공지사항이 아니고 사용자의 글도 아니면 무시
                    if($this->consultation && !$oDocument->isNotice()) {
                        $logged_info = Context::get('logged_info');
                        if($oDocument->get('member_srl')!=$logged_info->member_srl) $oDocument = $oDocumentModel->getDocument(0);
                    }

                // 요청된 문서번호의 문서가 없으면 document_srl null 처리 및 경고 메세지 출력
                } else {
                    Context::set('document_srl','',true);
                    $this->alertMessage('msg_not_founded');
                }

            /**
             * 요청된 문서 번호가 아예 없다면 빈 문서 객체 생성
             **/
            } else {
                $oDocument = $oDocumentModel->getDocument(0);
            }

            /**
             * 글 보기 권한을 체크해서 권한이 없으면 오류 메세지 출력하도록 처리
             **/
            if($oDocument->isExists()) {
                if(!$this->grant->view && !$oDocument->isGranted()) {
                    $oDocument = $oDocumentModel->getDocument(0);
                    Context::set('document_srl','',true);
                    $this->alertMessage('msg_not_permitted');
                } else {
                    // 브라우저 타이틀에 글의 제목을 추가
                    Context::addBrowserTitle($oDocument->getTitleText());

                    // 조회수 증가 (비밀글일 경우 권한 체크)
                    if(!$oDocument->isSecret() || $oDocument->isGranted()) $oDocument->updateReadedCount();

                    // 비밀글일때 컨텐츠를 보여주지 말자.
                    if($oDocument->isSecret() && !$oDocument->isGranted()) $oDocument->add('content',Context::getLang('thisissecret'));
                }
            }

            // 스킨에서 사용할 oDocument 변수 세팅
            $oDocument->add('module_srl', $this->module_srl);
            Context::set('oDocument', $oDocument);

			$this->setTemplateFile('tender_form');
        }


		function dispBoardauctionTenderList(){
			            
            // 요청된 변수 값들을 정리
            $document_srl = Context::get('document_srl');
            $page = Context::get('page');

            // document model 객체 생성 
            $oDocumentModel = &getModel('document');

            /**
             * 요청된 문서 번호가 있다면 문서를 구함
             **/
            if($document_srl) {
                $oDocument = $oDocumentModel->getDocument($document_srl, false, true); 

                // 해당 문서가 존재할 경우 필요한 처리를 함
                if($oDocument->isExists()) {

                    // 글과 요청된 모듈이 다르다면 오류 표시
                    if($oDocument->get('module_srl')!=$this->module_info->module_srl ) return $this->stop('msg_invalid_request');

                    // 관리 권한이 있다면 권한을 부여
                    if($this->grant->manager) $oDocument->setGrant();
                 
					//document module의 controller 객체 생성
		            $oDocumentController = &getController('document');
		

		          	//경매 문서의 확장변수 추출
					$getExtraVars = $oDocumentModel->getExtraVars($oDocument->module_srl,$oDocument->document_srl);
					foreach($getExtraVars as $idx => $key) {
						$extra_eid[$key->eid] = $key;
					}
			

                // 요청된 문서번호의 문서가 없으면 document_srl null 처리 및 경고 메세지 출력
                } else {
                    Context::set('document_srl','',true);
                    $this->alertMessage('msg_not_founded');
                }

            /**
             * 요청된 문서 번호가 아예 없다면 빈 문서 객체 생성
             **/
            } else {
                $oDocument = $oDocumentModel->getDocument(0);
                //return $this->stop('msg_invalid_request');
            }   
                         
            
            //경매 상태와 경매 제목을 셋팅
   			$tenderStatus = $extra_eid['status']->value;
   			$documentTitle = $oDocument->getTitle();
			

			/**
			 * 입찰 목록을 구하기 위한 args 설정
			 */
            // 목록을 구하기 위한 대상 모듈/ 페이지 수/ 목록 수/ 페이지 목록 수에 대한 옵션 설정
            $args->module_srl = $this->module_srl; 
            $args->page = Context::get('page');
            $args->list_count = $this->list_count; 
            $args->page_count = $this->page_count; 

            // 검색과 정렬을 위한 변수 설정
            $args->search_target = Context::get('search_target'); 
            $args->search_keyword = Context::get('search_keyword');
            
            // 지정된 정렬값이 없다면 스킨에서 설정한 정렬 값을 이용함
            $args->sort_index = Context::get('sort_index');
            $args->order_type = Context::get('order_type');
                                    
			$oBoardModel = &getModel('boardauction');
					
			$args->document_srl = $document_srl;
			$output = $oBoardModel->getBoardauctionTenderList($args);
			
            Context::set('documentTitle', $documentTitle);
            Context::set('tenderStatus', $tenderStatus);
            Context::set('tender_list', $output->data);
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('page_navigation', $output->page_navigation);
                        
	        $this->setTemplateFile('tender_list');			
		}
    
    }
?>
