<?php
    /**
     * @class  boardauctionController
     * @author PSY (www.userpin.org)
     * @brief  boardauction module의 Controller class
     **/
    require_once(_XE_PATH_.'modules/board/board.controller.php');

    class boardauctionController extends boardController {
        /**
         * @brief 초기화
         **/
        function init() {
            $class_path = ModuleHandler::getModulePath('board');
            $this->setModulePath($class_path);
            parent::init();
        }


        /**
         * @brief 입찰 포인트 입력
         **/
        function procBoardauctionInsertTenderNumber() {
            // 권한 체크
			if($this->module_info->module != "board") return new Object(-1, "msg_invalid_request");
            if(!$this->grant->write_document) return new Object(-1, 'msg_not_permitted');
            $logged_info = Context::get('logged_info');            

            // 경매참여에 필요한 변수를 세팅
            $obj = Context::getRequestVars();
        
        	if(!Context::get('is_logged') || $obj->document_srl =='' || $obj->module_srl =='' ) return new Object(-1,'msg_not_logged');
			if($obj->tender_number =='')return new Object(-1, 'msg_tender_number_empty');
        
            // document module의 model 객체 생성
            $oDocumentModel = &getModel('document');

            // document module의 controller 객체 생성
            $oDocumentController = &getController('document');

            //경매 문서를 가져온다
            $oDocument = $oDocumentModel->getDocument($obj->document_srl, $this->grant->manager);
        
          	//경매 문서의 확장변수 추출
			$getExtraVars = $oDocumentModel->getExtraVars($obj->module_srl,$oDocument->document_srl);
			foreach($getExtraVars as $idx => $key) {
				$extra_eid[$key->eid] = $key;
			}
						    
			$limit = $extra_eid['limit']->value;
            $cost = $extra_eid['cost']->value;
            $status =$extra_eid['status']->value;
            $openDateTime = $extra_eid['open_datetime']->value;
            $closeDateTime = $extra_eid['close_datetime']->value;                                            
		                              
            //경매 상태 체크 OPEN이 아니면 리턴
            if($status == 'REVIEW' )return new Object(-1, 'msg_review_auction');
            if($status == 'PENDING' )return new Object(-1, 'msg_pending_auction');
            if($status == 'CANCEL' )return new Object(-1, 'msg_cancel_auction');
            if($status == 'CLOSE' )return new Object(-1, 'msg_close_auction');
            if($status != 'OPEN' )return new Object(-1, 'msg_invalid_request');
            

            //경매 시작일 마감일 체크 : 시작전 / 마감후  에러
            $nowDateTime = date("YmdHi");
            if($nowDateTime < $openDateTime )return new Object(-1,'msg_standby_auction');
            if($nowDateTime > $closeDateTime )return new Object(-1,'msg_close_auction');


			//회원 포인트 추출
            $oModuleModel = &getModel('module');  
			$config = $oModuleModel->getModuleConfig('point'); 
			
			$oPointModel = &getModel('point'); 			
			$oPointController = &getController('point');
			$point = $oPointModel->getPoint($logged_info->member_srl);
			
			// 자동 입찰이라면 입찰번호 분리
			if($obj->is_multi =='Y'){ 	
				$tenderArray = explode('|@|', $obj->tender_number);
			}
			
			//소수, 마이너스 인지 체크
			if($obj->is_multi =='Y'){ 	
				$tenderArray ;
				foreach($tenderArray as $key => $val){
					if(!is_numeric($val)) return new Object(-1,'msg_validate_number');
					$num = (int)trim($val); //형변환
					if($num < 1 ) return new Object(-1,'msg_validate_do_not_zero');
				}
				
			}else{
				if(!is_numeric($obj->tender_number)) return new Object(-1,'msg_validate_number');
				$num = (int)trim($obj->tender_number); //형변환
				if($num < 1 ) return new Object(-1,'msg_validate_do_not_zero');
			}
			
			
			//보유한 포인트라 입찰가능한 포인트인지 체크
			if($tenderArray){// 자동입찰							
				//보유 포인트가 차감 포인트 작으면 return
				$totalCost = count($tenderArray) * $cost; 
				if($totalCost > $point)
				{					
					return new Object(-1,  sprintf(Context::getLang('msg_disallow_auction_point'), abs($totalCost), abs($point) ));
				}	
				
			}else{
				//보유 포인트가 차감 포인트 작으면 return
				if($cost > $point )return new Object(-1,  sprintf(Context::getLang('msg_disallow_auction_point'), abs($cost), abs($point) ));				
			}					
			
            // 입찰로그에 입력할 데이터 공통 데이터 준비
            $args->module_srl = $obj->module_srl;          
	        $args->member_srl = $logged_info->member_srl;
	        $args->nick_name = $logged_info->nick_name;	        
	        $args->mid = $obj->mid;            
	        $args->title = $obj->title;
	        $args->document_srl = $obj->document_srl; 
			$args->expense_point = $cost;
			$args->sRegdate = date("Ymd");
			
            //오늘 입찰한 횟수와 경매에 설정된 입할 횟수를 가져와 비교
			$oBoardModel = &getModel('boardauction');
			$todayCount = $oBoardModel->getBoardauctionTenderLogTodayCount($args);
			
			// 입찰제한 횟수 만큼 입찰했다면 return
			if($tenderArray){// 자동입찰
				//입찰가능 횟수를 확인해주세요 \ln 오늘 입찰가능 횟수 0회
				if($limit < $todayCount + count($tenderArray)){
					$tCount = $limit-$todayCount;
					return new Object(-1,  sprintf(Context::getLang('msg_limit_over_auto'), abs($tCount)));
				}
			}else{
				if($limit <= $todayCount)return new Object(-1,'msg_limit_over');
			}
			
			if($tenderArray){ //자동입찰												
				$tenderCount = 0;
				foreach($tenderArray as $key => $val){					
					$args->tender_number = $val;
					
					//중복입찰 번호 체크 중복이면 패스
					$output = executeQuery('boardauction.getTenderNumber', $args);
					if($output->data){
						continue; 
					}
						
		            //DB에 입력할 데이터 정리
		            $args->tender_srl = getNextSequence();
		            
					//DB 입력
					$output = executeQuery('boardauction.insertTenderNumber', $args);					
					if(!$output->toBool()) {
						$oDB->rollback();
						return $output;
					}
					
		            //포인트 차감		            
		            $oPointController->setPoint($logged_info->member_srl, $cost, 'minus');

					//TODO 루프를 돌고나서 업데이트해도 될것 같은데?  100번 입찰이면 100번 쿼리 일어남
					//경매 참여횟수 증가
					$this->updateDocumentExtraVarParticipateCount($args);
					++$tenderCount;
				}
				
			}else{ //일반 입찰

				// 입찰제한 횟수 만큼 입찰했다면 return
				if($limit <= $todayCount)return new Object(-1,'msg_close_auction');


	            //DB에 입력할 데이터 정리
	            $args->tender_srl = getNextSequence();            
	            $args->tender_number = $obj->tender_number;
	            	            
				//중복입찰 번호 체크
				$output = executeQuery('boardauction.getTenderNumber', $args);
				if($output->data){ 												
					return new Object(-1,'msg_duplication_tender_number');
				}

				//DB 입력
				$output = executeQuery('boardauction.insertTenderNumber', $args);
				if(!$output->toBool()) {
					$oDB->rollback();
					return $output;
				}

	            //포인트 차감
	            $oPointController->setPoint($logged_info->member_srl, $cost, 'minus');
				
				//경매 참여횟수 증가
				$this->updateDocumentExtraVarParticipateCount($args);
			}

			if($obj->is_multi =='Y'){ //자동입찰 메시지
				$this->setMessage(sprintf(Context::getLang('msg_success_tender_auto'), $tenderCount) );
			}else{
				$this->setMessage(sprintf(Context::getLang('msg_success_tender_one'), $args->tender_number) );			
			}	

        }

		
        /**
         * @brief 당첨자 추첨
         * @Param args(document_srl)
         **/
        function procBoardauctionCastLots($document_srl) {        	
       	
        	//MYSQL용 Query HAVING 을 사용할 수 없는 관계로 배열로 처리함. SQL 로 당첨자 체크할 때 아래 구문 사용 (document_srl 변경)
        	//SELECT * FROM  xe_auction_log WHERE document_srl='541' GROUP BY tender_number HAVING COUNT(tender_number)=1  ORDER BY tender_number LIMIT 1

  			$args->document_srl = $document_srl;  			
  			$output = executeQuery('boardauction.getTenderNumberGroupBy', $args);
  			$resultArray = $output->data;

			if(count($resultArray) == 0){ // 입찰기록이  없을 때
				//입찰 내역이 없다면 유찰
				$args->tender_number = '0'; 				
	        	$args->member_srl = '0';
	        	$args->nick_name = 'failure_of_auction';
	        	$args->winner_number = '0';
	        	$args->status = "FAILURE";
			}

			if(count($resultArray) == 1){ // 입찰기록이 하나 뿐일 때		
						
	   			//당첨번호 입찰자 정보를 가져옴
	   			$args->tender_number = $resultArray->tender_number[0];   			   			
	        	$output = executeQuery('boardauction.getTenderWinner', $args);	        	
	        	$resultWinner = $output->data;
	        	
	        	$args->member_srl = $resultWinner->member_srl;
	        	$args->nick_name = $resultWinner->nick_name;
	        	$args->tender_number = $resultWinner->tender_number;
	        	$args->winner_number = $args->tender_number;
	        	$args->status = "CLOSE";
			}
			
			if(count($resultArray) > 1){ // 입찰기록이 하나 이상일 때			
			
	  			// 쿼리결과를 배열로 정리  			
	  			$dataArray = array();
	  			foreach($resultArray as $tmpArray) {
					foreach($tmpArray as $idx => $key) {
						array_push($dataArray, $key);					
					}
	  			}			
	
	 			// 배열 값의 수를 셉니다
	 			$countArray = array_count_values($dataArray);
	 			
				// 배열에서 값이 하나인 것만 남기고 제거
				foreach($countArray as $key => $val) {					
					if($val > 1){
						unset($countArray[$key]);
					}					           
				}
	
				// 배열의 모든 키를 반환
				$transArray = array_keys($countArray);
	 			
 				// 남은 번호가 있는가?
				if(count($transArray) > 0){
	 				$winnerNumber = min($transArray); //최소번호
				}	 			
	 			
	 			// 당첨자가 있다면 
	 			if($winnerNumber){		   			
		   			//당첨번호 입찰자 정보를 가져옴
		   			$args->tender_number = $winnerNumber;   			   			
		        	$output = executeQuery('boardauction.getTenderWinner', $args);	        	
		        	$resultWinner = $output->data;
		        	
		        	$args->member_srl = $resultWinner->member_srl;
		        	$args->nick_name = $resultWinner->nick_name;
		        	$args->tender_number = $resultWinner->tender_number;
		        	$args->winner_number = $winnerNumber;
		        	$args->status = "CLOSE";
	        	
	 			}else{ //당첨자가 없다면 유찰
					$args->tender_number = '0'; 				
		        	$args->member_srl = '0';
		        	$args->nick_name = 'failure_of_auction';
		        	$args->winner_number = '0';
		        	$args->status = "FAILURE"; 	        	 				
	 			}
			} 				       
        	
        	// 해당 경매의 당첨자 업데이트
        	$this->updateDocumentExtraVarWinner($args);
        	
        	// 당첨 포인트 업데이트
        	$this->updateDocumentExtraVarWinNumber($args);
        	
        	// 경매 상태 변경(CLOSE)        	
        	$this->updateDocumentExtraVarStatus($args);        	
        }

        /**
         * @brief 입찰 로그삭제 - 입찰 포인트 반환하지 않음 (게시물 삭제전 실행해야함)
         * @param mid, document_srl
         **/
		function procBoardauctionDeleteTenderLogAll(){
									
			$obj = Context::getRequestVars();					
			$args->document_srl = $obj->document_srl;
			$args->module_srl = $obj->module_srl;
			$args->mid = $obj->mid;

            // 문서 번호, 모듈시리얼이  없다면 에러
            if(!$args->document_srl || !$args->module_srl){
            	return new Object(-1,  sprintf(Context::getLang('msg_invalid_request')));            	
            }

			//입찰로그 갯수를 가져옴
			$oBoardModel = &getModel('boardauction');
			$tenderCount = $oBoardModel->getBoardauctionTenderLogCount($args);
			
			//입찰 로그삭제
			$output = executeQuery('boardauction.deleteTenderLogAll', $args);
			
			// 메시지 반환			
			$this->setMessage( sprintf(Context::getLang('msg_success_delete_tender_log_all'), $tenderCount) );			
    	}
    	
        /**
         * @brief 입찰 포인트 반환 && 로그삭제 (게시물 삭제전 실행해야함)
         * @param mid, document_srl
         **/    	
		function procBoardauctionTenderPointReturnAll(){
			
			$obj = Context::getRequestVars();					
			$args->document_srl = $obj->document_srl;
			$args->module_srl = $obj->module_srl;
			$args->mid = $obj->mid;


            // 문서 번호, 모듈시리얼이  없다면 에러
            if(!$args->document_srl || !$args->module_srl){
            	return new Object(-1,  sprintf(Context::getLang('msg_invalid_request')));            	
            }

			//입찰로그 갯수를 가져옴
			$oBoardModel = &getModel('boardauction');
			$tenderCount = $oBoardModel->getBoardauctionTenderLogCount($args);

			global $delCount;
			$resultCount = $this->doTenderPointReturnAll($args);

			// 메시지 반환			
			$this->setMessage( sprintf(Context::getLang('msg_success_delete_tender_log_all'), $delCount) );			

    	}

        /**
         * @brief 경매 참여자 업데이트
         **/
		function updateDocumentExtraVarParticipateCount($args){
			$args->eid = 'tender_count';
			$output = executeQuery('boardauction.updateDocumentExtraVarParticipateCount', $args);
    	}

        /**
         * @brief 당첨자 업데이트
         **/
		function updateDocumentExtraVarWinner($args){
			$args->eid = 'winner';
			$output = executeQuery('boardauction.updateDocumentExtraVarWinner', $args);
    	}
        
        /**
         * @brief 당첨 포인트 업데이트
         **/
		function updateDocumentExtraVarWinNumber($args){
			$args->eid = 'winner_number';
			$output = executeQuery('boardauction.updateDocumentExtraVarWinnerNumber', $args);
    	}
    	
        /**
         * @brief 경매 상태변경
         **/
		function updateDocumentExtraVarStatus($args){
			$args->eid = 'status';
			$output = executeQuery('boardauction.updateDocumentExtraVarStatus', $args);
    	}
    	
    	function doTenderPointReturnAll($args){
    		global $delCount;
    		
			//입찰로그 갯수를 가져옴
			$oBoardModel = &getModel('boardauction');
			$tenderCount = $oBoardModel->getBoardauctionTenderLogCount($args);
			
			//입찰 내역이 있으면 리스트를 20개 가져와서 포인트를 반환고 삭제
			if($tenderCount != 0){
				$oBoardModel = &getModel('boardauction');
				$output = $oBoardModel->getBoardauctionTenderListPart($args);
				
				foreach($output->data as $data){
					for($i=0; $i < count($data); $i++){					

				        //포인트 반환(증가)							
						$oPointController = &getController('point');				        
	            		$oPointController->setPoint($data->member_srl, $data->expense_point, 'add');

						//입찰 로그삭제 (해당하는 것만)
						$args->tender_srl = $data->tender_srl;
						$output = executeQuery('boardauction.deleteTenderLog', $args);
						$delCount++;
					}
				}
				$this->doTenderPointReturnAll($args);
			}else{
				return (int)$delCount;
			}			
    	}
        
    }
?>
