<?php
    /**
     * @class autoredirect
     * @author EPMakes (support@epmakes.com)
     * @brief 자동으로 원하는 페이지로 이동시켜 주는 위젯
     **/

    class autoredirect extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         *
         * ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/

        function proc($args) {
			// 변수 초기화
			if(!$args->redirect_title) $args->redirect_title = 'Redirecting...';
			if(!$args->redirect_type) $args->redirect_type = 'windowlocation';

            // 내부적으로 쓰이는 변수 설정
            $oTemplate = &TemplateHandler::getInstance();

            // 위젯에 넘기기 위한 변수 설정
            $widget_info->redirect_title = $args->redirect_title;
            $widget_info->redirect_type = $args->redirect_type;
            $widget_info->redirect_src = $args->redirect_src;

            Context::set('colorset', $args->colorset);
            Context::set('widget_info', $widget_info);

            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
			Context::set('skin_path', $tpl_path);
			$act = Context::get('act');
			if($act == "dispPageAdminContentModify" || $act == "procWidgetGenerateCodeInPage")
	            return $oTemplate->compile($tpl_path, "editor");
            return $oTemplate->compile($tpl_path, "list");
        }
	}
?>
