<?php
	/**
	* @class  restore
	* @author largeden (cbrghost@gmail.com)
	* @brief  restore class
	**/

	class restore {

		var $filename;
		var $version_help;

		/**
		* @brief 기본 기능
		**/
		function init() {

			$filename = explode('/',$_SERVER['SCRIPT_FILENAME']);
			$this->filename = $filename[count($filename)-1];

			define('_XE_PATH_', str_replace($this->filename, "", str_replace("\\", "/", __FILE__)));
			define('__XE__', true);
			define('__ZBXE__', true);

			require_once(_XE_PATH_.'config/config.inc.php');
			if(!preg_match('/^1.5/',__ZBXE_VERSION__)) $this->version_help = 1;

			$oContext = &Context::getInstance();
			$oContext->context = &$GLOBALS['__Context__'];
			$oContext->context->lang = &$GLOBALS['lang'];
			$oContext->context->_COOKIE = $_COOKIE;
			$oContext->setRequestMethod('');
			$oContext->_setXmlRpcArgument();
			$oContext->_setJSONRequestArgument();
			$oContext->_setRequestArgument();
			$oContext->_setUploadedArgument();
			$oContext->loadDBInfo();

			$this->procRestore();
		}

		/**
		* @brief 유일한 restore 객체를 반환 (Singleton)
		* restore는 어디서든 객체 선언없이 사용하기 위해서 static 하게 사용
		**/
		function &getInstance() {
			static $theInstance;
			if(!isset($theInstance)) $theInstance = new restore();
			return $theInstance;
		}

		function procRestore() {
			if(!Context::get('xe')) $this->html();

			if($this->version_help) {
				echo "(구버전에서는 사용하실 수 없습니다. 1.5.x 이상 이용 가능)";
				return;
			}

			switch(Context::get('type')) {
				case 'procAdminRecompileCacheFile': $this->procAdminRecompileCacheFile(); break;
				case 'procMemberAdminInsertConfig': $this->procMemberAdminInsertConfig(); break;
				case 'procAdminMenuReset': $this->procAdminMenuReset(); break;
				default: break;
			}
		}

		function html() {
			if($this->version_help) $help = "(구버전에서는 사용하실 수 없습니다. 1.5.x 이상 이용 가능)";
			$html = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html lang="ko" xml:lang="ko" xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><title>XE Restore</title><script type="text/javascript" src="common/js/jquery.js"></script><script type="text/javascript">function restore(type) {if(type == \'procAdminRecompileCacheFile\') { if (!confirm(confirm_run)) return; }var act = \'\';switch(type) {case \'procAdminRecompileCacheFile\': act = \'procAdminRecompileCacheFile\'; break;case \'procMemberAdminInsertConfig\': act = \'procMemberAdminInsertConfig\'; break;case \'procAdminMenuReset\': act = \'procAdminMenuReset\'; break;default: break;}jQuery.ajax({url: \''.$this->filename.'?xe=1&type=\'+act,success: function(data) {alert(data);}});}</script></head><body><div style="font-size:3em;">XE Restore</div><div style="color:orangered;font-size:1.5em;">현재 XE버전 '.__ZBXE_VERSION__.$help.'</div><div><ol><li><button type="button" class="text" onclick="restore(\'procAdminRecompileCacheFile\');">캐시파일 재생성</button><p>관리자페이지 로그인 없이 캐시 재생성을 시도 합니다. 모듈 설치에 따라서 응답시간이 다소 늦어질 수 있습니다.</p></li><li><button type="button" class="text" onclick="restore(\'procMemberAdminInsertConfig\');">user_id로 로그인 방식 변경</button><p>업데이트나 새로설치하면서 user_id가 아니라 email_address로 변경될 경우 이를 다시 uesr_id로 변경시켜줍니다.</p></li><li><button type="button" class="text" onclick="restore(\'procAdminMenuReset\');">관리자 메뉴 설정 초기화</button><p>관리자페이지 상단의 메뉴들이 제대로 주소를 표시하지 못할 경우 관리자 메뉴 설정을 초기화 시켜 줍니다.</p></li></ol></div><script type="text/javascript">confirm_run = \'오랜 시간이 걸릴 수 있습니다. 실행하시겠습니까?\';</script><div class="wfsr"></div></body></html>';

			echo $html;
		}

		function procMemberAdminInsertConfig() {
			$oModuleModel = &getModel('module');
			$oModuleController = &getController('module');
			$member_info = $oModuleModel->getModuleConfig('member');

			$member_info->identifier = 'user_id';

			$member_list = $member_info->signupForm;

			foreach($member_list as $key => $val) {
				if($val->name == 'email_address') {
					$val->isIdentifier = 1;
					$val->isDefaultForm = 1;
					$val->name = 'user_id';
					$val->title = '아이디';
					$val->mustRequired = '';
					$val->imageType = '';
					$val->required = 1;
					$val->isUse = 1;
				} elseif($val->name == 'user_id') {
					$val->isIdentifier = '';
					$val->isDefaultForm = 1;
					$val->name = 'email_address';
					$val->title = '이메일 주소';
					$val->mustRequired = 1;
					$val->imageType = '';
					$val->required = 1;
					$val->isUse = 1;
				}

				$member[] = $val;
			}

			$member_info->signupForm = $member;

			$oMemberAdminController = &getAdminController('member');

			// create Ruleset
			@$oMemberAdminController->_createSignupRuleset($member_info->signupForm);
			@$oMemberAdminController->_createLoginRuleset($member_info->identifier);
			@$oMemberAdminController->_createFindAccountByQuestion($member_info->identifier);

			$output = $oModuleController->updateModuleConfig('member', $member_info);

			echo "로그인 방식이 user_id로 변경되었습니다.";
		}

		function procAdminMenuReset() {
			$oMenuAdminModel = &getAdminModel('menu');
			$output = $oMenuAdminModel->getMenuByTitle('__XE_ADMIN__');

			$menuSrl = $output->menu_srl;
			if (!$menuSrl) return $this->stop('msg_invalid_request');

			$oMenuAdminController = &getAdminController('menu');
			$output = $oMenuAdminController->deleteMenu($menuSrl);
			if (!$output->toBool()) return $output;

			FileHandler::removeDir('./files/cache/menu/admin_lang/');

			echo "관리자 메뉴가 초기화 되었습니다.";
		}

		/**
		* @brief Regenerate all cache files
		* @return none
		**/
		function procAdminRecompileCacheFile() {
			// rename cache dir
			$temp_cache_dir = './files/cache_'. time();
			FileHandler::rename('./files/cache', $temp_cache_dir);
			FileHandler::makeDir('./files/cache');

			// remove debug files
			FileHandler::removeFile(_XE_PATH_.'files/_debug_message.php');
			FileHandler::removeFile(_XE_PATH_.'files/_debug_db_query.php');
			FileHandler::removeFile(_XE_PATH_.'files/_db_slow_query.php');

			$oModuleModel = &getModel('module');
			$module_list = $oModuleModel->getModuleList();

			// call recompileCache for each module
			foreach($module_list as $module) {
				$oModule = null;

				$oModule = &getClass($module->module);

				if(method_exists($oModule, 'recompileCache')) {
					$oModule->recompileCache();
				}
			}

			// remove cache
			$truncated = array();
			$oObjectCacheHandler = &CacheHandler::getInstance('object');
			$oTemplateCacheHandler = &CacheHandler::getInstance('template');

			if($oObjectCacheHandler->isSupport()){
				$truncated[] = $oObjectCacheHandler->truncate();
			}

			if($oTemplateCacheHandler->isSupport()){
				$truncated[] = $oTemplateCacheHandler->truncate();
			}

			if(count($truncated) && in_array(false,$truncated)){
				return new Object(-1,'msg_self_restart_cache_engine');
			}

			// remove cache dir
			$tmp_cache_list = FileHandler::readDir('./files','/(^cache_[0-9]+)/');
			if($tmp_cache_list){
				foreach($tmp_cache_list as $tmp_dir){
					if($tmp_dir) FileHandler::removeDir('./files/'.$tmp_dir);
				}
			}

			echo '캐시 재생성이 완료 되었습니다.';
		}

	}

	$restore = &restore::getInstance();
	$restore->init();
?>