<?php
	if(!defined("__ZBXE__")) exit();
	
	/**
	 * @file elkha_packer.addon.php
	 * @author Elkha (elkha1914@hotmail.com)
	 **/

	// 모듈 객체 생성 이전
	if($called_position != before_module_init) return;

	// 기본 변수
	$logged_info = Context::get("logged_info");
	$addon_name = ereg_replace(".addon.php", "", basename(__FILE__));

	// 로그인 아이디 검사
	if($addon_info->id) {
		$id = explode(",", $addon_info->id);
		$user_id = $logged_info->user_id;
		if(in_array($user_id, $id)) $permission = true;
	}

	// 관리자 모드
	if($logged_info->is_admin=="Y") $permission = true;

	// 권한이 있는지 검사
	if(!$permission) return;
	if(!$addon_info->input || !$addon_info->output) return;

	// 배열로 전환
	$input_arr = explode("\n", $addon_info->input);
	$output_arr = explode("\n", $addon_info->output);

	// 파일갯수가 맞는지 확인
	if(count($input_arr)!=count($output_arr)) return;

	// 로드
	require "packer.php-1.1/class.JavaScriptPacker.php";
	require "csstidy-1.3/class.csstidy.php";

	for($i=0; $i<count($input_arr); $i++){
		// 경로 조정
		$input = "addons/$addon_name/" . $input_arr[$i];
		$output = $output_arr[$i];

		// 파일이 있는지 확인
		if(!is_file($input)) return;

		// 로드
		$script = FileHandler::readFile($input);

		// @ 함수 처리가 깔끔하겠지만 그냥 나열하자 ㅜㅜ
		if(preg_match("/.js$/", $input)) {
			$packer = new JavaScriptPacker($script, 'Normal', true, false);
			$packed = $packer->pack();
		} else if(preg_match("/.css$/", $input)) {
			$css = new csstidy();
			$css->set_cfg("remove_last_;",TRUE);
//			$css->set_cfg("case_properties", 2);
			$css->set_cfg("merge_selectors", 1);
			$css->set_cfg("timestamp", TRUE);
			$css->set_cfg("remove_bslash", TRUE);
			$css->set_cfg("template", 4);
			$css->parse($script);
			$css->print->formatted();
			$packed = $css->print->output_css_plain;

			// 대체 줄바꿈은 어떻게 없애는지 몰라서 그냥 직접 처리 (젠장 결과물이 무식해 -_-);
			$packed = ereg_replace("\n","", $packed);
		}
		FileHandler::writeFile($output, $packed);
	}
?>