<?php
    /**
     * @class widget_kgcontent
     * @author xenara (kolaskks@naver.com)
     * @brief widget to display content
     * @version 0.1
     **/

    class widget_kgcontent extends WidgetHandler {

        function proc($args) {

            // 기본설정 I
            if(!$args->content_type) $args->content_type = 'document';
            if(!$args->list_count) $args->list_count = 5;
            if(!$args->page_count) $args->page_count = 1;
            if(!$args->new_window) $args->new_window = 'self';
            if(!in_array($args->order_target, array('list_order','update_order','regdate','readed_count','voted_count'))) $args->order_target = 'list_order';
            if(!in_array($args->order_type, array('asc','desc'))) $args->order_type = 'asc';

            // 기본설정 II
            if(!$args->font_family) $args->font_family = null;
            if(!$args->font_size) $args->font_size = 12;
            if(!$args->font_color) $args->font_color = null;
            if(!$args->colorset_num) $args->colorset_num = 1;

            // 제목과 더보기 설정
            if(!$args->show_document_title) $args->show_document_title='Y';
            if(!$args->document_title) $args->document_title = null;
            if(!$args->document_subtitle) $args->document_subtitle = null;
            if(!$args->show_more) $args->show_more='Y';
            if(!$args->more_window) $args->more_window = 'self';

            // 게시물 목록 제목설정
            if(!$args->show_titlearea) $args->show_titlearea='Y';
            if(!$args->show_list_number) $args->show_list_number='Y';
            if(!$args->show_browser_title) $args->show_browser_title='Y';
            if(!$args->show_category) $args->show_category='Y';
            if(!$args->show_title) $args->show_title='Y';
            if(!$args->subject_cut_size) $args->subject_cut_size = 0;
            if(!$args->show_comment_count) $args->show_comment_count='Y';
            if(!$args->show_trackback_count) $args->show_trackback_count='Y';
            if(!$args->show_icon) $args->show_icon='Y';
            if(!$args->duration_new) $args->duration_new = 12;
            if(!$args->show_author) $args->show_author='Y';
            if(!$args->show_date) $args->show_date='Y';

            // 게시물 확장변수 설정
            if(!$args->show_extra_keyvars) $args->show_extra_keyvars='Y';
            if(!$args->extra_keys_eid) $args->extra_keys_eid = null;
            if(!$args->show_extra_keys) $args->show_extra_keys='Y';
            if(!$args->show_extra_vars) $args->show_extra_vars='Y';

            // 게시물 썸네일 설정
            if(!$args->show_thumbnail) $args->show_thumbnail='Y';
            if(!$args->image_type) $args->image_type = 'flie_image';
            if(!$args->thumbnail_type) $args->thumbnail_type='ratio';
            if(!$args->thumbnail_width) $args->thumbnail_width = 100;
            if(!$args->thumbnail_height) $args->thumbnail_height = 75;

            // 게시물 미디어 설정
            if(!$args->show_media) $args->show_media='Y';
            if(!$args->media_type) $args->media_type = 'movie';
            if(!$args->media_width) $args->media_width = 200;
            if(!$args->media_height) $args->media_height = 150;
            if(!$args->show_media_thumb) $args->show_media_thumb='Y';
            if(!$args->media_image_type) $args->media_image_type = 'flie_image';
            if(!$args->media_thumb_type) $args->media_thumb_type='ratio';
            if(!$args->media_thumb_width) $args->media_thumb_width = 200;
            if(!$args->media_thumb_height) $args->media_thumb_height = 150;

            // 게시물 목록 내용설정
            if(!$args->show_content) $args->show_content='Y';
            if(!$args->content_cut_size) $args->content_cut_size = 100;

            // 게시물 목록 아래 댓글 설정
            if(!$args->show_subcomment) $args->show_subcomment='Y';
            if(!$args->subcomment_count) $args->subcomment_count = 5;

            // RSS 설정
            if(!$args->rss_url0) $args->rss_url0=null;
            if(!$args->rss_url1) $args->rss_url1=null;
            if(!$args->rss_url2) $args->rss_url2=null;
            if(!$args->rss_url3) $args->rss_url3=null;
            if(!$args->rss_url4) $args->rss_url4=null;
            
            // 'content' 위젯 호환변수 설정('content' 위젯 호환용)------------------------------------------//
            if(!$args->content_widget) $args->content_widget = 'no_content';
            if(!$args->content_type2) $args->content_type2 = 'document';
            if(!$args->markup_type) $args->markup_type = 'table';
            if(!$args->cols_list_count) $args->cols_list_count = 5;
            $args->option_view_arr = explode(',',$args->option_view);
            //------------------------------------------------------------------------------------------------//


            //'module'객체 생성 및 정보구함
            $oModuleModel = &getModel('module');
            $module_srls = $args->modules_info = $args->module_srls_info = $args->mid_lists = array();
            $site_module_info = Context::get('site_module_info');


          // 'content' 스킨이 아닐 경우 module_srls, content_type 등 설정
          if($args->content_widget == 'no_content') {
            if($args->content_type == 'rss'){
                $args->rss_urls = array();
                $rss_urls = array_unique(array($args->rss_url0,$args->rss_url1,$args->rss_url2,$args->rss_url3,$args->rss_url4));
                for($i=0,$c=count($rss_urls);$i<$c;$i++) {
                    if($rss_urls[$i]) $args->rss_urls[] = $rss_urls[$i];
                }
            } else {
                if(!$args->module_srls){
                    unset($obj);
                    $obj->site_srl = (int)$site_module_info->site_srl;
                    $output = executeQueryArray('widgets.widget_kgcontent.getMids', $obj);
                    if($output->data) {
                        foreach($output->data as $key => $val) {
                            $args->modules_info[$val->mid] = $val;
                            $args->module_srls_info[$val->module_srl] = $val;
                            $args->mid_lists[$val->module_srl] = $val->mid;
                            $module_srls[] = $val->module_srl;
                        }
                    }
                    $args->modules_info = $oModuleModel->getMidList($obj);
                } else {
                    $obj->module_srls = $args->module_srls;
                    $output = executeQueryArray('widgets.widget_kgcontent.getMids', $obj);
                    if($output->data) {
                        foreach($output->data as $key => $val) {
                            $args->modules_info[$val->mid] = $val;
                            $args->module_srls_info[$val->module_srl] = $val;
                            $module_srls[] = $val->module_srl;
                        }
                        $idx = explode(',',$args->module_srls);
                        for($i=0,$c=count($idx);$i<$c;$i++) {
                            $srl = $idx[$i];
                            if(!$args->module_srls_info[$srl]) continue;
                            $args->mid_lists[$srl] = $args->module_srls_info[$srl]->mid;
                        }
                    }
                }
                if(!count($args->modules_info)) return Context::get('msg_not_founded');
                $args->module_srl = implode(',',$module_srls);
            }
            switch($args->content_type){
                case 'comment':
                    $content_items = $this->_getCommentItems($args);
                    break;
                case 'rss':
                    $content_items = $this->getRssItems($args);
                    break;
                default:
                    $content_items = $this->_getDocumentItems($args);
                    break;
            }
          }

          // 'content' 스킨일 경우 module_srls, content_type2 등 설정('content' 위젯 호환용)  ----------------//
          else {
            // List URLs if a type is RSS
            if($args->content_type2 == 'rss'){
                $args->rss_urls = array();
                $rss_urls = array_unique(array($args->rss_url0,$args->rss_url1,$args->rss_url2,$args->rss_url3,$args->rss_url4));
                for($i=0,$c=count($rss_urls);$i<$c;$i++) {
                    if($rss_urls[$i]) $args->rss_urls[] = $rss_urls[$i];
                }
            // Get module information after listing module_srls if the module is not RSS
            } else {
                // Apply to all modules in the site if a target module is not specified
                if(!$args->module_srls){
                    unset($obj);
                    $obj->site_srl = (int)$site_module_info->site_srl;
                    $output = executeQueryArray('widgets.widget_kgcontent.getMids', $obj);
                    if($output->data) {
                        foreach($output->data as $key => $val) {
                            $args->modules_info[$val->mid] = $val;
                            $args->module_srls_info[$val->module_srl] = $val;
                            $args->mid_lists[$val->module_srl] = $val->mid;
                            $module_srls[] = $val->module_srl;
                        }
                    }
                    $args->modules_info = $oModuleModel->getMidList($obj);
                // Apply to the module only if a target module is specified
                } else {
                    $obj->module_srls = $args->module_srls;
                    $output = executeQueryArray('widgets.widget_kgcontent.getMids', $obj);
                    if($output->data) {
                        foreach($output->data as $key => $val) {
                            $args->modules_info[$val->mid] = $val;
                            $args->module_srls_info[$val->module_srl] = $val;
                            $module_srls[] = $val->module_srl;
                        }
                        $idx = explode(',',$args->module_srls);
                        for($i=0,$c=count($idx);$i<$c;$i++) {
                            $srl = $idx[$i];
                            if(!$args->module_srls_info[$srl]) continue;
                            $args->mid_lists[$srl] = $args->module_srls_info[$srl]->mid;
                        }
                    }
                }
                // Exit if no module is found
                if(!count($args->modules_info)) return Context::get('msg_not_founded');
                $args->module_srl = implode(',',$module_srls);
            }
            /**
             * Method is separately made because content extraction, articles, comments, trackbacks, RSS and other elements exist
             **/
            // If not a tab type
            if($args->tab_type == 'none' || $args->tab_type == '') {
                switch($args->content_type2){
                    case 'comment':
                            $content_items = $this->_getCommentItems($args);
                        break;
                    case 'image':
                            $content_items = $this->_getImageItems($args);
                        break;
                    case 'rss':
                            $content_items = $this->getRssItems($args);
                        break;
                    case 'trackback':
                            $content_items = $this->_getTrackbackItems($args);
                        break;
                    default:
                            $content_items = $this->_getDocumentItems($args);
                        break;
                }
            // tab type
            } else {
                $content_items = array();
                switch($args->content_type2){
                    case 'comment':
                            foreach($args->mid_lists as $module_srl => $mid){
                                $args->module_srl = $module_srl;
                                $content_items[$module_srl] = $this->_getCommentItems($args);
                            }
                        break;
                    case 'image':
                            foreach($args->mid_lists as $module_srl => $mid){
                                $args->module_srl = $module_srl;
                                $content_items[$module_srl] = $this->_getImageItems($args);
                            }
                        break;
                    case 'rss':
                            $content_items = $this->getRssItems($args);
                        break;
                    case 'trackback':
                            foreach($args->mid_lists as $module_srl => $mid){
                                $args->module_srl = $module_srl;
                                $content_items[$module_srl] = $this->_getTrackbackItems($args);
                            }
                        break;
                    default:
                            foreach($args->mid_lists as $module_srl => $mid){
                                $args->module_srl = $module_srl;
                                $content_items[$module_srl] = $this->_getDocumentItems($args);
                            }
                        break;
                }
            }
          }
          //-------------------------------------------------------------------------------------------------//

            $output = $this->_compile($args,$content_items);
            return $output;
        }



        // 게시물 내용 중 이미지를 출력하는 함수
        function getImageItems($srl,$object){
            $oFileModel = &getModel('file');
            $all_filename = array();

            //게시물 내용 중 첨부파일이 있을 경우 첨부파일주소반환
            $file_list = $oFileModel->getFiles($srl);
            if(count($file_list)) {
              foreach($file_list as $file) {
                if(preg_match("/\.(jpg|png|jpeg|gif|bmp)/i",$file->source_filename)) {
                  $all_filename[$srl][] = $file->uploaded_filename;
                }
              }
            }

            //게시물 내용 중 링크파일이 있을 경우 링크주소반환
            $docu_summary = $object->getContent();
            if(preg_match('/<a.*?>/i',$docu_summary)) {
              $docu_summary = preg_replace('/<a.*?>/i', ' ', $docu_summary);
            }
            preg_match_all("/(http:\/\/|https:\/\/).+?\.(jpg|png|jpeg|gif|bmp)/i", $docu_summary, $link_file);
            for($k=1;$k<=count($link_file[0]);$k++) {
              $link_file[0][$k-1] = strrchr($link_file[0][$k-1], 'http');
              //링크파일주소가 첨부파일 중에 있을 경우 중복방지
              $exist_file = 0;
              for($m=1;$m<=count($all_filename[$srl]);$m++) {
                if($link_file[0][$k-1]==$all_filename[$srl][$m-1]) {
                  $exist_file = 1;
                  break;
                }
              }
              if($exist_file!=1) {
                $all_filename[$srl][] = $link_file[0][$k-1];
              }
            }

            if(count($all_filename[$srl])) $image_items = $all_filename[$srl];
            else $image_items = null;
            return $image_items;
        }


        // 게시물 내용 중 미디어를 출력하는 함수
        function getMediaItems($srl,$object,$media_type){
            $oFileModel = &getModel('file');
            $all_filename = array();

            //게시물 내용 중 첨부파일이 있을 경우 첨부파일주소반환
            $file_list = $oFileModel->getFiles($srl);
            if(count($file_list)) {
              foreach($file_list as $file) {
                if($media_type == 'movie') {
                  if(preg_match("/\.(avi|wmv|mpg|mpeg|swf|flv|mp4)/i",$file->source_filename)) {
                    $all_filename[$srl][] = $file->uploaded_filename;
                  }
                }
                else if($args->media_type == 'audio') {
                  if(preg_match("/\.(mp3|wav)/i",$file->source_filename)) {
                    $all_filename[$srl][] = $file->uploaded_filename;
                  }
                }
                if(preg_match("/\.(jpg|png|jpeg|gif|bmp)/i",$file->source_filename)) {
                  $all_thumbname[$srl][] = $file->uploaded_filename;
                }
              }
            }

            //게시물 내용 중 링크파일이 있을 경우 링크주소반환
            $docu_summary = $object->getContent();
            if(preg_match('/<a.*?>/i', $docu_summary)){
              $docu_summary = preg_replace('/<a.*?>/i', ' ', $docu_summary);
            }
            if($media_type == 'movie') {
              preg_match_all("/(http:\/\/|https:\/\/).+?\.(avi|wmv|mpg|mpeg|swf|flv|mp4)/i", $docu_summary, $link_file);
            }
            else if($media_type == 'audio') {
              preg_match_all("/(http:\/\/|https:\/\/).+?\.(mp3|wav)/i", $docu_summary, $link_file);
            }
            for($k=1;$k<=count($link_file[0]);$k++) {
              $link_file[0][$k-1] = strrchr($link_file[0][$k-1], 'http');
              //링크파일주소가 첨부파일 중에 있을 경우 중복방지
              $exist_file = 0;
              for($m=1;$m<=count($all_filename[$srl]);$m++) {
                if($link_file[0][$k-1]==$all_filename[$srl][$m-1]) {
                  $exist_file = 1;
                  break;
                }
              }
              if($exist_file!=1) {
                $all_filename[$srl][] = $link_file[0][$k-1];
              }
            }
            preg_match_all("/(http:\/\/|https:\/\/).+?\.(jpg|png|jpeg|gif|bmp)/i", $docu_summary, $link_thumbfile);
            for($k=1;$k<=count($link_thumbfile[0]);$k++) {
              $link_thumbfile[0][$k-1] = strrchr($link_thumbfile[0][$k-1], 'http');
              //링크파일주소가 첨부파일 중에 있을 경우 중복방지
              $exist_thumbfile = 0;
              for($m=1;$m<=count($all_thumbname[$srl]);$m++) {
                if($link_thumbfile[0][$k-1]==$all_thumbname[$srl][$m-1]) {
                  $exist_thumbfile = 1;
                  break;
                }
              }
              if($exist_thumbfile!=1) {
                $all_thumbname[$srl][] = $link_thumbfile[0][$k-1];
              }
            }

            if(count($all_filename[$srl])) $media_items->media = $all_filename[$srl];
            else $media_items->media = null;
            if(count($all_thumbname[$srl])) $media_items->thumb = $all_thumbname[$srl];
            else $media_items->thumb = null;
            return $media_items;
        }



        // 'document'를 출력하는 함수
        function _getDocumentItems($args){
            // 해당 모듈의 model 객체를 받아서 결과를 객체화 시킴
            $oDocumentModel = &getModel('document');
            $oCommentModel = &getModel('comment');

            // 분류 구함
            $obj->module_srl = $args->module_srl;
            $output = executeQueryArray('widgets.widget_kgcontent.getCategories',$obj);
            if($output->toBool() && $output->data) {
                foreach($output->data as $key => $val) {
                    $category_lists[$val->module_srl][$val->category_srl] = $val;
                }
            }

            // 글 목록을 구함
            $obj->module_srl = $args->module_srl;
            $obj->category_srl = $args->category_srl;
            $obj->sort_index = $args->order_target;
            $obj->order_type = $args->order_type=="desc"?"asc":"desc";
            $obj->list_count = $args->list_count * $args->page_count;
//      			$obj->statusList = array('PUBLIC');
            $output = executeQueryArray('widgets.widget_kgcontent.getNewestDocuments', $obj);
            if(!$output->toBool() || !$output->data) return;

            // 결과가 있으면 각 문서 객체화를 시킴
            $content_items = array();
            if(count($output->data)) {
                foreach($output->data as $key => $attribute) {
                    $oDocument = new documentItem();
                    $oDocument->setAttribute($attribute, false);
                    $GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
                    $document_srls[] = $oDocument->document_srl;
                }
                $oDocumentModel->setToAllDocumentExtraVars();

                $first_thumbnail_idx = -1; //'content' 위젯 호환용
                for($i=0,$c=count($document_srls);$i<$c;$i++) {
                    $oDocument = $GLOBALS['XE_DOCUMENT_LIST'][$document_srls[$i]];
                    $comment_srl = null;
                    $document_srl = $oDocument->document_srl;
                    $module_srl = $oDocument->get('module_srl');
                    $category_srl = $oDocument->get('category_srl');

                    if($args->show_thumbnail=='Y') {
                      $image_items = $this->getImageItems($document_srl,$oDocument);
                      $thumbnail = $image_items[0];
                      $all_thumbnail = $image_items;
                    }

                    if($args->show_media=='Y') {
                      $media_items = $this->getMediaItems($document_srl,$oDocument,$args->media_type);
                      $media = $media_items->media[0];
                      $media_thumb = $media_items->thumb[0];
                      $all_media = $media_items->media;
                      $all_media_thumb = $media_items->thumb;
                    }

                    $content_item = new kgcontentItem( $args->module_srls_info[$module_srl]->browser_title );
                    $content_item->adds($oDocument->getObjectVars());
                    $content_item->add('original_content', $oDocument->get('content'));
                    $content_item->setTitle($oDocument->getTitle());
                    $content_item->setCategory( $category_lists[$module_srl][$category_srl]->title );
                    $content_item->setDomain( $args->module_srls_info[$module_srl]->domain );
                    $content_item->setContent($oDocument->getSummary($args->content_cut_size));
                    $content_item->setLink( getSiteUrl($domain,'','document_srl',$document_srl) );
                    $content_item->setThumbnail($thumbnail);
                    $content_item->setAllThumbnail($all_thumbnail);
                    $content_item->setMedia($media);
                    $content_item->setMediaThumbnail($media_thumb);
                    $content_item->setAllMedia($all_media);
                    $content_item->setAllMediaThumbnail($all_media_thumb);
                    $content_item->setExtraImages($oDocument->printExtraImages($args->duration_new * 60 * 60));
                    $content_item->setComment($oDocument->getComments());
                    $content_item->add('mid', $args->mid_lists[$module_srl]);
                    $content_item->add('document_srl', $document_srl);
                    $content_item->add('comment_srl', $comment_srl);

                    //확장변수 키값을 '$content_item' 추가
                    $content_item->extra_keys = $oDocumentModel->getExtraKeys($module_srl);
                    $content_item->extra_vars = $oDocumentModel->getExtraVars($module_srl,$document_srl);

                    if($first_thumbnail_idx==-1 && $thumbnail) $first_thumbnail_idx = $i; //'content' 위젯 호환용

                    $content_items[] = $content_item;
                }
                $content_items[0]->setFirstThumbnailIdx($first_thumbnail_idx); //'content' 위젯 호환용
            }
            return $content_items;
        }


        // 'comment'를 출력하는 함수
        function _getCommentItems($args) {
            // 해당 모듈의 model 객체를 받아서 결과를 객체화 시킴
            $oCommentModel = &getModel('comment');

            // 분류 구함
            $obj->module_srl = $args->module_srl;
            $output = executeQueryArray('widgets.widget_kgcontent.getCategories',$obj);
            if($output->toBool() && $output->data) {
                foreach($output->data as $key => $val) {
                    $category_lists[$val->module_srl][$val->category_srl] = $val;
                }
            }

            // 댓글 목록을 구함
            $obj->module_srl = $args->module_srl;
            $obj->sort_index = $args->order_target;
            $obj->order_type = $args->order_type=="desc"?"asc":"desc";
            $obj->list_count = $args->list_count * $args->page_count;
            $output = $oCommentModel->getNewestCommentList($obj);
            if(!count($output)) return;

            // 결과가 있으면 각 문서 객체화를 시킴
            $content_items = array();
            if(count($output)) {
                foreach($output as $key => $attribute) {
                    $oComment = new commentItem();
                    $oComment->setAttribute($attribute);
                    $GLOBALS['XE_COMMENT_LIST'][$oComment->comment_srl] = $oComment;
                    $comment_srls[] = $oComment->comment_srl;
                }

                for($i=0,$c=count($comment_srls);$i<$c;$i++) {
                    $oComment = $GLOBALS['XE_COMMENT_LIST'][$comment_srls[$i]];
                    $comment_srl = $oComment->comment_srl;
                    $document_srl = $oComment->document_srl;
                    $module_srl = $oComment->get('module_srl');
                    $category_srl = $oComment->get('category_srl');
                    $url = sprintf("%s#comment_%s",getUrl('','document_srl',$oComment->get('document_srl')),$oComment->get('comment_srl'));

                    if($args->show_thumbnail=='Y') {
                      $image_items = $this->getImageItems($comment_srl,$oComment);
                      $thumbnail = $image_items[0];
                      $all_thumbnail = $image_items;
                    }

                    if($args->show_media=='Y') {
                      $media_items = $this->getMediaItems($comment_srl,$oComment,$args->media_type);
                      $media = $media_items->media[0];
                      $media_thumb = $media_items->thumb[0];
                      $all_media = $media_items->media;
                      $all_media_thumb = $media_items->thumb;
                    }

                    $content_item = new kgcontentItem( $args->module_srls_info[$module_srl]->browser_title );
                    $content_item->adds($oComment->getObjectVars());
                    $content_item->setTitle($oComment->getSummary($args->subject_cut_size));
                    $content_item->setCategory( $category_lists[$module_srl][$category_srl]->title );
                    $content_item->setDomain( $args->module_srls_info[$module_srl]->domain );
                    $content_item->setContent($oComment->getSummary($args->content_cut_size));
                    $content_item->setLink( $url );
                    $content_item->setThumbnail($thumbnail);
                    $content_item->setAllThumbnail($all_thumbnail);
                    $content_item->setMedia($media);
                    $content_item->setMediaThumbnail($media_thumb);
                    $content_item->setAllMedia($all_media);
                    $content_item->setAllMediaThumbnail($all_media_thumb);
                    $content_item->setComment($output);
                    $content_item->add('mid', $args->mid_lists[$module_srl]);
                    $content_item->add('document_srl', $document_srl);
                    $content_item->add('comment_srl', $comment_srl);

                    $content_items[] = $content_item;
                }
            }
            return $content_items;
        }


        // 'RSS'를 출력하는 함수
        function getRssItems($args){
            $content_items = array();
            $args->mid_lists = array();

            foreach($args->rss_urls as $key => $rss){
                $args->rss_url = $rss;
                $content_item = $this->_getRssItems($args);
                if(count($content_item) > 0){
                    $browser_title = $content_item[0]->getBrowserTitle();
                    $args->mid_lists[] = $browser_title;
                    $content_items[] = $content_item;
                }
            }
            // If it is not a tab type
            $items = array();
            foreach($content_items as $key => $val){
                foreach($val as $k => $v){
                    $date = $v->get('regdate');
                    $i=0;
                    while(array_key_exists(sprintf('%s%02d',$date,$i), $items)) $i++;
                    $items[sprintf('%s%02d',$date,$i)] = $v;
                }
            }
            if($args->order_type =='asc') ksort($items);
            else krsort($items);
            $content_items = array_slice(array_values($items),0,$args->list_count*$args->page_count);
            return $content_items;
        }

        // 'RSS BODY'를 설정하는 함수
        function _getRssBody($value) {
            if(!$value || is_string($value)) return $value;
            if(is_object($value)) $value = get_object_vars($value);
            $body = null;
            if(!count($value)) return;
            foreach($value as $key => $val) {
                if($key == 'body') {
                    $body = $val;
                    continue;
                }
                if(is_object($val)||is_array($val)) $body = $this->_getRssBody($val);
                if($body !== null) return $body;
            }
            return $body;
        }

        //RSS 'thumbnail'을 가져오기 위한 함수
        function _getRssThumbnail($rss_key,$content) {
            $docu_summary = $content;
            if(preg_match('/<a.*?>/i',$docu_summary)) {
              $docu_summary = preg_replace('/<a.*?>/i', ' ', $docu_summary);
            }
            preg_match_all("/(http:\/\/|https:\/\/).+?\.(jpg|png|jpeg|gif|bmp)/i", $docu_summary, $link_file);
            for($k=1;$k<=count($link_file[0]);$k++) {
              $all_filename[$rss_key][] = $link_file[0][$k-1];
            }
            if(count($all_filename[$rss_key])) $image_items = $all_filename[$rss_key];
            else $image_items = null;
            return $image_items;
        }

        // 'RSS' 내용을 설정하는 함수
        function _getSummary($content, $str_size = 50) {
            $content = preg_replace('!(<br[\s]*/{0,1}>[\s]*)+!is', ' ', $content);
            // Replace tags such as </p> , </div> , </li> and others to a whitespace
            $content = str_replace(array('</p>', '</div>', '</li>'), ' ', $content);
            // Remove Tag
            $content = preg_replace('!<([^>]*?)>!is','', $content);
            // Replace tags to <, >, " and whitespace
            $content = str_replace(array('&lt;','&gt;','&quot;','&nbsp;'), array('<','>','"',' '), $content);
            // Delete  a series of whitespaces
            $content = preg_replace('/ ( +)/is', ' ', $content);
            // Truncate string
            $content = trim(cut_str($content, $str_size, $tail));
            // Replace back <, >, " to the original tags
            $content = str_replace(array('<','>','"'),array('&lt;','&gt;','&quot;'), $content);
            // Fixed to a newline bug for consecutive sets of English letters
            $content = preg_replace('/([a-z0-9\+:\/\.\~,\|\!\@\#\$\%\^\&\*\(\)\_]){20}/is',"$0-",$content);
            return $content; 
        }

       /**
         * @brief function to receive contents from rss url
         * For Tistory blog in Korea, the original RSS url has location header without contents. Fixed to work as same as rss_reader widget.
         **/
        function requestFeedContents($rss_url) {
            $rss_url = str_replace('&amp;','&',Context::convertEncodingStr($rss_url));
            return FileHandler::getRemoteResource($rss_url, null, 3, 'GET', 'application/xml');
        }

        // 'RSS'의 'xml'파일에서 내용을 추출하는 함수
        function _getRssItems($args){
            // Date Format
            $DATE_FORMAT = $args->date_format ? $args->date_format : "Y-m-d H:i:s";

            $buff = $this->requestFeedContents($args->rss_url);

            $encoding = preg_match("/<\?xml.*encoding=\"(.+)\".*\?>/i", $buff, $matches);
            if($encoding && !preg_match("/UTF-8/i", $matches[1])) $buff = Context::convertEncodingStr($buff);

            $buff = preg_replace("/<\?xml.*\?>/i", "", $buff);

            $oXmlParser = new XmlParser();
            $xml_doc = $oXmlParser->parse($buff);
            if($xml_doc->rss) {
                $rss->title = $xml_doc->rss->channel->title->body;
                $rss->link = $xml_doc->rss->channel->link->body;

                $items = $xml_doc->rss->channel->item;

                if(!$items) return;
                if($items && !is_array($items)) $items = array($items);

                $content_items = array();

                foreach ($items as $key => $value) {
                    if($key >= $args->list_count * $args->page_count) break;
                    unset($item);

                    foreach($value as $key2 => $value2) {
                        if(is_array($value2)) $value2 = array_shift($value2);
                        $item->{$key2} = $this->_getRssBody($value2);
                    }

                    if($args->show_thumbnail=='Y') {
                      $image_items = $this->_getRssThumbnail($key,$item->description);
                      $thumbnail = $image_items[0];
                      $all_thumbnail = $image_items;
                    }

                    $content_item = new kgcontentItem($rss->title);
                    $content_item->setContentsLink($rss->link);
                    $content_item->setTitle($item->title);
                    $content_item->setNickName(max($item->author,$item->{'dc:creator'}));
                    //$content_item->setCategory($item->category);
                    $content_item->setThumbnail($thumbnail);
                    $content_item->setAllThumbnail($all_thumbnail);
                    $item->description = preg_replace('!<a href=!is','<a onclick="window.open(this.href);return false" href=', $item->description);
                    $content_item->setContent($this->_getSummary($item->description, $args->content_cut_size).'...');
                    $content_item->setLink($item->link);
                    $date = date('YmdHis', strtotime(max($item->pubdate,$item->pubDate,$item->{'dc:date'})));
                    $content_item->setRegdate($date);

                    $content_items[] = $content_item;
                }
            } elseif($xml_doc->{'rdf:rdf'}) {
                // rss1.0 supported (XE's XML is case-insensitive because XML parser converts all to small letters. Fixed by misol
                $rss->title = $xml_doc->{'rdf:rdf'}->channel->title->body;
                $rss->link = $xml_doc->{'rdf:rdf'}->channel->link->body;

                $items = $xml_doc->{'rdf:rdf'}->item;

                if(!$items) return;
                if($items && !is_array($items)) $items = array($items);

                $content_items = array();

                foreach ($items as $key => $value) {
                    if($key >= $args->list_count * $args->page_count) break;
                    unset($item);

                    foreach($value as $key2 => $value2) {
                        if(is_array($value2)) $value2 = array_shift($value2);
                        $item->{$key2} = $this->_getRssBody($value2);
                    }

                    if($args->show_thumbnail=='Y') {
                      $image_items = $this->_getRssThumbnail($key,$item->description);
                      $thumbnail = $image_items[0];
                      $all_thumbnail = $image_items;
                    }

                    $content_item = new kgcontentItem($rss->title);
                    $content_item->setContentsLink($rss->link);
                    $content_item->setTitle($item->title);
                    $content_item->setNickName(max($item->author,$item->{'dc:creator'}));
                    //$content_item->setCategory($item->category);
                    $content_item->setThumbnail($thumbnail);
                    $content_item->setAllThumbnail($all_thumbnail);
                    $item->description = preg_replace('!<a href=!is','<a onclick="window.open(this.href);return false" href=', $item->description);
                    $content_item->setContent($this->_getSummary($item->description, $args->content_cut_size).'...');
                    $content_item->setLink($item->link);
                    $date = date('YmdHis', strtotime(max($item->pubdate,$item->pubDate,$item->{'dc:date'})));
                    $content_item->setRegdate($date);

                    $content_items[] = $content_item;
                }
            } elseif($xml_doc->feed && $xml_doc->feed->attrs->xmlns == 'http://www.w3.org/2005/Atom') {
                // Atom 1.0 spec supported by misol
                $rss->title = $xml_doc->feed->title->body;
                $links = $xml_doc->feed->link;
                if(is_array($links)) {
                    foreach ($links as $value) {
                        if($value->attrs->rel == 'alternate') {
                            $rss->link = $value->attrs->href;
                            break;
                        }
                    }
                }
                elseif($links->attrs->rel == 'alternate') $rss->link = $links->attrs->href;

                $items = $xml_doc->feed->entry;

                if(!$items) return;
                if($items && !is_array($items)) $items = array($items);

                $content_items = array();

                foreach ($items as $key => $value) {
                    if($key >= $args->list_count * $args->page_count) break;
                    unset($item);

                    foreach($value as $key2 => $value2) {
                        if(is_array($value2)) $value2 = array_shift($value2);
                        $item->{$key2} = $this->_getRssBody($value2);
                    }

                    $content_item = new kgcontentItem($rss->title);
                    $links = $value->link;
                    if(is_array($links)) {
                        foreach ($links as $val) {
                            if($val->attrs->rel == 'alternate') {
                                $item->link = $val->attrs->href;
                                break;
                            }
                        }
                    }
                    elseif($links->attrs->rel == 'alternate') $item->link = $links->attrs->href;

                    $content_item->setContentsLink($rss->link);
                    if($item->title) {
                        if(!preg_match("/html/i", $value->title->attrs->type)) $item->title = $value->title->body;
                    }
                    $content_item->setTitle($item->title);
                    $content_item->setNickName(max($item->author,$item->{'dc:creator'}));
                    $content_item->setAuthorSite($value->author->uri->body);
                    //$content_item->setCategory($item->category);
                    $item->description = preg_replace('!<a href=!is','<a onclick="window.open(this.href);return false" href=', $item->content);
                    if($item->description) {
                        if(!preg_match("/html/i", $value->content->attrs->type)) $item->description = htmlspecialchars($item->description);
                    }

                    if($args->show_thumbnail=='Y') {
                      if(!$item->description) $item->description = $item->summary;
                      $image_items = $this->_getRssThumbnail($key,$item->description);
                      $thumbnail = $image_items[0];
                      $all_thumbnail = $image_items;
                    }
                    $content_item->setThumbnail($thumbnail);
                    $content_item->setAllThumbnail($all_thumbnail);

                    if(!$item->description) {
                        $item->description = $item->summary;
                        if($item->description) {
                            if(!preg_match("/html/i", $value->summary->attrs->type)) $item->description = htmlspecialchars($item->description);
                        }
                    }
                    $content_item->setContent($this->_getSummary($item->description, $args->content_cut_size).'...');

                    $content_item->setLink($item->link);
                    $date = date('YmdHis', strtotime(max($item->published,$item->updated,$item->{'dc:date'})));
                    $content_item->setRegdate($date);

                    $content_items[] = $content_item;
                }
            }
            return $content_items;
        }



        // 'content' 위젯 스킨일 경우 '추출대상' 호환용 함수 모음('content' 위젯 호환용)-------------------------//
        function _getImageItems($args) {
            $oDocumentModel = &getModel('document');

            $obj->module_srls = $obj->module_srl = $args->module_srl;
            $obj->direct_download = 'Y';
            $obj->isvalid = 'Y';
            // Get categories
            $output = executeQueryArray('widgets.widget_kgcontent.getCategories',$obj);
            if($output->toBool() && $output->data) {
                foreach($output->data as $key => $val) {
                    $category_lists[$val->module_srl][$val->category_srl] = $val;
                }
            }
            // Get a file list in each document on the module
            $obj->list_count = $args->list_count * $args->page_count;
            $files_output = executeQueryArray("file.getOneFileInDocument", $obj);
            $files_count = count($files_output->data);
            if(!$files_count) return;

            $content_items = array();

            for($i=0;$i<$files_count;$i++) $document_srl_list[] = $files_output->data[$i]->document_srl;

            $tmp_document_list = $oDocumentModel->getDocuments($document_srl_list);

            if(!count($tmp_document_list)) return;

            foreach($tmp_document_list as $oDocument){
                $attribute = $oDocument->getObjectVars();
                $browser_title = $args->module_srls_info[$attribute->module_srl]->browser_title;
                $domain = $args->module_srls_info[$attribute->module_srl]->domain;
                $category = $category_lists[$attribute->module_srl]->text;
                $content = $oDocument->getSummary($args->content_cut_size);
                $url = sprintf("%s#%s",$oDocument->getPermanentUrl() ,$oDocument->getCommentCount());
                $thumbnail = $oDocument->getThumbnail($args->thumbnail_width,$args->thumbnail_height,$args->thumbnail_type);
                $extra_images = $oDocument->printExtraImages($args->duration_new);

                $content_item = new kgcontentItem($browser_title);
                $content_item->adds($attribute);
                $content_item->setCategory($category);
                $content_item->setContent($content);
                $content_item->setLink($url);
                $content_item->setThumbnail($thumbnail);
                $content_item->setExtraImages($extra_images);
                $content_item->setDomain($domain);
                $content_item->add('mid', $args->mid_lists[$attribute->module_srl]);
                $content_items[] = $content_item;
            }

            return $content_items;
        }

        function _getTrackbackItems($args){
            // Get categories
            $output = executeQueryArray('widgets.widget_kgcontent.getCategories',$obj);
            if($output->toBool() && $output->data) {
                foreach($output->data as $key => $val) {
                    $category_lists[$val->module_srl][$val->category_srl] = $val;
                }
            }

            $obj->module_srl = $args->module_srl;
            $obj->sort_index = $args->order_target;
            $obj->list_count = $args->list_count * $args->page_count;
            // Get model object from the trackback module and execute getTrackbackList() method
            $oTrackbackModel = &getModel('trackback');
            $output = $oTrackbackModel->getNewestTrackbackList($obj);
            // If an error occurs, just ignore it.
            if(!$output->toBool() || !$output->data) return;
            // If the result exists, make each document as an object
            $content_items = array();
            foreach($output->data as $key => $item) {
                $domain = $args->module_srls_info[$item->module_srl]->domain;
                $category = $category_lists[$item->module_srl]->text;
                $url = getSiteUrl($domain,'','document_srl',$item->document_srl);
                $browser_title = $args->module_srls_info[$item->module_srl]->browser_title;

                $content_item = new kgcontentItem($browser_title);
                $content_item->adds($item);
                $content_item->setTitle($item->title);
                $content_item->setCategory($category);
                $content_item->setNickName($item->blog_name);
                $content_item->setContent($item->excerpt);  ///<<
                $content_item->setDomain($domain);  ///<<
                $content_item->setLink($url);
                $content_item->add('mid', $args->mid_lists[$item->module_srl]);
                $content_item->setRegdate($item->regdate);
                $content_items[] = $content_item;
            }
            return $content_items;
        }
        //--------------------------------------------------------------------------------------------------//



        function _compile($args,$content_items){
            $oTemplate = &TemplateHandler::getInstance();

            // 기본설정 I
            $widget_info->skin_type = $args->skin_type;
            $widget_info->content_type = $args->content_type;
            $widget_info->list_count = $args->list_count;
            $widget_info->page_count = $args->page_count;
            $widget_info->new_window = $args->new_window;
            $widget_info->order_target = $args->order_target;
            $widget_info->order_type = $args->order_type;

            // 기본설정 II
            $widget_info->font_family = $args->font_family;
            $widget_info->font_size = $args->font_size;
            $widget_info->font_color = $args->font_color;
            $widget_info->colorset_num = $args->colorset_num;

            // 제목과 더보기 설정
            $widget_info->show_document_title = $args->show_document_title;
            $widget_info->document_title = $args->document_title;
            $widget_info->document_subtitle = $args->document_subtitle;
            $widget_info->show_more = $args->show_more;
            $widget_info->more_window = $args->more_window;

            // 게시물 목록 제목설정
            $widget_info->show_titlearea = $args->show_titlearea;
            $widget_info->show_list_number = $args->show_list_number;
            $widget_info->show_browser_title = $args->show_browser_title;
            $widget_info->show_category = $args->show_category;
            $widget_info->show_title = $args->show_title;
            $widget_info->subject_cut_size = $args->subject_cut_size;
            $widget_info->show_comment_count = $args->show_comment_count;
            $widget_info->show_trackback_count = $args->show_trackback_count;
            $widget_info->show_icon = $args->show_icon;
            $widget_info->duration_new = $args->duration_new;
            $widget_info->show_author = $args->show_author;
            $widget_info->show_date = $args->show_date;

            // 게시물 확장변수 설정
            $widget_info->show_extra_keyvars = $args->show_extra_keyvars;
            $widget_info->extra_keys_eid = $args->extra_keys_eid;
            $widget_info->show_extra_keys = $args->show_extra_keys;
            $widget_info->show_extra_vars = $args->show_extra_vars;

            // 게시물 썸네일 설정
            $widget_info->show_thumbnail = $args->show_thumbnail;
            $widget_info->image_type = $args->image_type;
            $widget_info->thumbnail_type = $args->thumbnail_type;
            $widget_info->thumbnail_width = $args->thumbnail_width;
            $widget_info->thumbnail_height = $args->thumbnail_height;

            // 게시물 미디어 설정
            $widget_info->show_media = $args->show_media;
            $widget_info->media_type = $args->media_type;
            $widget_info->media_width = $args->media_width;
            $widget_info->media_height = $args->media_height;
            $widget_info->show_media_thumb = $args->show_media_thumb;
            $widget_info->media_image_type = $args->media_image_type;
            $widget_info->media_thumb_type = $args->media_thumb_type;
            $widget_info->media_thumb_width = $args->media_thumb_width;
            $widget_info->media_thumb_height = $args->media_thumb_height;

            // 게시물 목록 내용설정
            $widget_info->show_content = $args->show_content;
            $widget_info->content_cut_size = $args->content_cut_size;

            // 게시물 목록 아래 댓글 설정
            $widget_info->show_subcomment = $args->show_subcomment;
            $widget_info->subcomment_count = $args->subcomment_count;

            // RSS 설정
            $widget_info->rss_url0 = $args->rss_url0;
            $widget_info->rss_url1 = $args->rss_url1;
            $widget_info->rss_url2 = $args->rss_url2;
            $widget_info->rss_url3 = $args->rss_url3;
            $widget_info->rss_url4 = $args->rss_url4;
            
            // 'content' 위젯 호환 탬플릿변수 설정('content' 위젯 호환용)--------------------------------------//
            if($args->content_widget == 'content_skin') {
              $widget_info->content_type2 = $args->content_type2;
              $widget_info->list_type = $args->list_type;
              $widget_info->tab_type = $args->tab_type;
              $widget_info->markup_type = $args->markup_type;
              $widget_info->cols_list_count = $args->cols_list_count;
              $widget_info->option_view_arr = $args->option_view_arr;
              $widget_info->mid_lists = $args->mid_lists;

              // If it is a tab type, list up tab items and change key value(module_srl) to index 
                if($args->tab_type != 'none' && $args->tab_type) {
                  $tab = array();
                  foreach($args->mid_lists as $module_srl => $mid){
                    if(!is_array($content_items[$module_srl]) || !count($content_items[$module_srl])) continue;
                    unset($tab_item);
                    $tab_item->title = $content_items[$module_srl][0]->getBrowserTitle();
                    $tab_item->content_items = $content_items[$module_srl];
                    $tab_item->domain = $content_items[$module_srl][0]->getDomain();
                    $tab_item->url = $content_items[$module_srl][0]->getContentsLink();
                    if(!$tab_item->url) $tab_item->url = getSiteUrl($tab_item->domain, '','mid',$mid);
                    $tab[] = $tab_item;
                  }
                  $widget_info->tab = $tab;
              } else {
                $widget_info->content_items = $content_items;
              }
            }
            //------------------------------------------------------------------------------------------------//


            // 'content' 위젯 스킨이 아닐 경우 $content_items 설정
            else if($args->content_widget == 'no_content') {
                $widget_info->content_items = $content_items;
            }

            unset($args->option_view_arr);
            unset($args->modules_info);

            Context::set('colorset', $args->colorset);
            Context::set('widget_info', $widget_info);

            //위젯스킨 폴더명 설정
            $widget_skin_name = $args->skin;
            $widget_skin_name = str_replace(".","_",$widget_skin_name);
            $widget_skin_name = str_replace("(","_",$widget_skin_name);
            $widget_skin_name = str_replace(")","",$widget_skin_name);
            $widget_skin_name = str_replace("/","",$widget_skin_name);
            Context::set('widget_skin_name', $widget_skin_name);

            //위젯 설치경로 설정
            Context::set('widget_path', $this->widget_path);

            //위젯스킨 설치경로 설정
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);

            //위젯스킨 css파일 생성(작업중)
            /*
            $kgcontent_css = FileHandler::readFile($tpl_path.'/kgcontent_css.html');
            $kgcontent_css = str_replace('<!--//스킨 기본 CSS 설정-->','@charset "utf-8";',$kgcontent_css);
            $kgcontent_css = str_replace('<style type="text/css">','',$kgcontent_css);
            $kgcontent_css = str_replace('</style>','',$kgcontent_css);
            $kgcontent_css = str_replace('{$widget_topdiv_class}',$widget_skin_name,$kgcontent_css);
            FileHandler::writeFile($tpl_path.'/css/kgcontent.css', $kgcontent_css, 'w');
            */

            //위젯 템플릿 컴파일 설정
            if($args->content_widget == 'no_content') {
              return $oTemplate->compile($tpl_path, "kgcontent");
            }
            else if($args->content_widget == 'content_skin') {
              return $oTemplate->compile($tpl_path, "content");
            }
        }
    }



    class kgcontentItem extends Object {

        var $browser_title = null;
        var $has_first_thumbnail_idx = false;
        var $first_thumbnail_idx = null;
        var $contents_link = null;
        var $domain = null;

        function kgcontentItem($browser_title=''){
            $this->browser_title = $browser_title;
        }

        function setCategory($category){
            $this->add('category',$category);
        }
        function setTitle($title){
            $this->add('title',$title);
        }
        function setExtraImages($extra_images){
            $this->add('extra_images',$extra_images);
        }
        function setNickName($nick_name){
            $this->add('nick_name',$nick_name);
        }
        function setRegdate($regdate){
            $this->add('regdate',$regdate);
        }
        function setLink($url){
            $this->add('url',$url);
        }

        function setThumbnail($thumbnail){
            $this->add('thumbnail',$thumbnail);
        }
        function setAllThumbnail($all_thumbnail){
            $this->add('all_thumbnail',$all_thumbnail);
        }
        function setFirstThumbnailIdx($first_thumbnail_idx){
            if(is_null($this->first_thumbnail) && $first_thumbnail_idx>-1) {
                $this->has_first_thumbnail_idx = true;
                $this->first_thumbnail_idx= $first_thumbnail_idx;
            }
        }

        function setMedia($media){
            $this->add('media',$media);
        }
        function setMediaThumbnail($media_thumbnail){
            $this->add('media_thumbnail',$media_thumbnail);
        }
        function setAllMedia($all_media){
            $this->add('all_media',$all_media);
        }
        function setAllMediaThumbnail($all_media_thumb){
            $this->add('all_media_thumb',$all_media_thumb);
        }

        function setContent($content){
            $this->add('content',$content);
        }
        function setContentsLink($link){
            $this->contents_link = $link;
        }

        function setComment($comment_items){
            $this->add('comment_items',$comment_items);
        }

        function setDomain($domain) {
            static $default_domain = null;
            if(!$domain) {
                if(is_null($default_domain)) $default_domain = Context::getDefaultUrl();
                $domain = $default_domain;
            }
            $this->domain = $domain;
        }
        // Save author's homepage url. By misol
        function setAuthorSite($site_url){
            $this->add('author_site',$site_url);
        }



        function getBrowserTitle(){
            return $this->browser_title;
        }
        function getCategory(){
            return $this->get('category');
        }
        function getTitle($cut_size = 0, $tail='...'){
            $title = strip_tags($this->get('title'));

            if($cut_size) $title = cut_str($title, $cut_size, $tail);

            $attrs = array();
            if($this->get('title_bold') == 'Y') $attrs[] = 'font-weight:bold';
            if($this->get('title_color') && $this->get('title_color') != 'N') $attrs[] = 'color:#'.$this->get('title_color');

            if(count($attrs)) $title = sprintf("<span style=\"%s\">%s</span>", implode(';', $attrs), htmlspecialchars($title));

            return $title;
        }
        function getCommentCount(){
            $comment_count = $this->get('comment_count');
            return $comment_count>0 ? $comment_count : '';
        }
        function getTrackbackCount(){
            $trackback_count = $this->get('trackback_count');
            return $trackback_count>0 ? $trackback_count : '';
        }
        function printExtraImages() {
            return $this->get('extra_images');
        }
        function getNickName(){
            return $this->get('nick_name');
        }
        function getRegdate($format = 'Y.m.d H:i:s') {
            return zdate($this->get('regdate'), $format);
        }
        function getLink(){
            return $this->get('url');
        }

        function getThumbnail(){
            return $this->get('thumbnail');
        }
        function getAllThumbnail(){
            return $this->get('all_thumbnail');
        }
        function haveFirstThumbnail() {
            return $this->has_first_thumbnail_idx;
        }
        function getFirstThumbnailIdx(){
            return $this->first_thumbnail_idx;
        }

        function getMedia(){
            return $this->get('media');
        }
        function getMediaThumbnail(){
            return $this->get('media_thumbnail');
        }
        function getAllMedia(){
            return $this->get('all_media');
        }
        function getAllMediaThumbnail(){
            return $this->get('all_media_thumb');
        }

        function getContent(){
            return $this->get('content');
        }
        function getContentsLink(){
            return $this->contents_link;
        }

        function getComment(){
            return $this->get('comment_items');
        }

        function getDomain() {
            return $this->domain;
        }
        function getModuleSrl(){
            return $this->get('module_srl');
        }
        function getMemberSrl() {
            return $this->get('member_srl');
        }
        function getAuthorSite(){
            return $this->get('author_site');
        }

    }
?>
