<?php

    /**
     * @class widget_kgcontent
     * @author sol (sol@ngleader.com) edit by kindguy
     * @brief widget_kgcontent를 출력하는 위젯
     * @version 201009xx
     **/

    class widget_kgcontent extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         *
         * ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/

        function proc($args) {

            // 스킨 칼라셋설정
            if(!$args->colorset_num) $args->colorset_num = 1;

            // 스킨 글꼴등 설정
            if(!$args->widget_font_family) $args->widget_font_family = null;
            if(!$args->widget_font_size) $args->widget_font_size = 12;
            if(!$args->widget_font_color) $args->widget_font_color = null;

            // 게시물 추출설정
            if(!$args->skin_type) $args->skin_type = 'image'; //xe1.4.5.9 이전스킨 미리보기 호환용.(이전 스킨코드에는 $args->skin_type 변수가 없어 썸네일출력이 안됨 - 재생성 하면 없어도 됨)
            if(!$args->content_type) $args->content_type = 'document';
            if(!$args->image_type) $args->image_type = 'flie_image';

            // 게시물 제목과 더보기 설정
            if(!$args->show_document_title) $args->show_document_title='Y';
            if(!$args->document_title) $args->document_title = null;
            if(!$args->document_subtitle) $args->document_subtitle = null;
            if(!$args->show_more) $args->show_more='Y';
            if(!$args->more_window) $args->more_window = 'self';

            // 게시물 썸네일(미디어) 설정
            if(!$args->show_thumbnail) $args->show_thumbnail='Y';
            if(!$args->thumbnail_type) $args->thumbnail_type='ratio';
            if(!$args->thumbnail_width) $args->thumbnail_width = 100;
            if(!$args->thumbnail_height) $args->thumbnail_height = 75;
            if(!$args->show_movie_thumbnail) $args->show_movie_thumbnail='Y';

            // 게시물 목록 제목설정
            if(!$args->show_titlearea) $args->show_titlearea='Y';
            if(!$args->show_list_number) $args->show_list_number='Y';
            if(!$args->show_browser_title) $args->show_browser_title='Y';
            if(!$args->show_category) $args->show_category='Y';
            if(!$args->show_title) $args->show_title='Y';
            if(!$args->subject_cut_size) $args->subject_cut_size = 0;
            if(!$args->show_comment_count) $args->show_comment_count='Y';
            if(!$args->show_trackback_count) $args->show_trackback_count='Y';
            if(!$args->show_icon) $args->show_icon='Y';
            if(!$args->duration_new) $args->duration_new = 12;
            if(!$args->show_extra_keyvars) $args->show_extra_keyvars='Y';
            if(!$args->extra_keys_eid) $args->extra_keys_eid = null;
            if(!$args->show_extra_keys) $args->show_extra_keys='Y';
            if(!$args->show_extra_vars) $args->show_extra_vars='Y';
            if(!$args->show_author) $args->show_author='Y';
            if(!$args->show_date) $args->show_date='Y';

            // 게시물 목록 내용설정
            if(!$args->show_content) $args->show_content='Y';
            if(!$args->content_cut_size) $args->content_cut_size = 100;

            // 게시물 목록 아래 댓글 설정(아래 댓글 스킨용)
            if(!$args->show_subcomment) $args->show_subcomment='Y';
            if(!$args->comment_count) $args->comment_count = 5;

            // 게시물 목록 및 추가설정
            if(!$args->list_count) $args->list_count = 5;
            if(!$args->page_count) $args->page_count = 1;
            if(!$args->new_window) $args->new_window = 'self';
            if(!in_array($args->order_target, array('list_order','update_order','regdate','readed_count','voted_count'))) $args->order_target = 'list_order';
            if(!in_array($args->order_type, array('asc','desc'))) $args->order_type = 'asc';

            // widget_kgcontent_old 호환 관련 설정
            $args->option_view_arr = explode(',','thumbnail,title,regdate,nickname,content');
            $args->cols_list_count = $args->list_count;



            // 내부적으로 쓰이는 변수 설정
            $oModuleModel = &getModel('module');
            $module_srls = $args->modules_info = $args->module_srls_info = $args->mid_lists = array();
            $site_module_info = Context::get('site_module_info');

            // rss 인 경우 URL정리
            if($args->content_type == 'rss'){
                $args->rss_urls = array();
                $rss_urls = array_unique(array($args->rss_url0,$args->rss_url1,$args->rss_url2,$args->rss_url3,$args->rss_url4));
                for($i=0,$c=count($rss_urls);$i<$c;$i++) {
                    if($rss_urls[$i]) $args->rss_urls[] = $rss_urls[$i];
                }

            // rss가 아닌 XE모듈일 경우 모듈 번호 정리 후 모듈 정보 구함
            } else {

                // 대상 모듈이 선택되어 있지 않으면 해당 사이트의 전체 모듈을 대상으로 함
                if(!$args->module_srls){
                    unset($obj);
                    $obj->site_srl = (int)$site_module_info->site_srl;
                    $output = executeQueryArray('widgets.widget_kgcontent.getMids', $obj);
                    if($output->data) {
                        foreach($output->data as $key => $val) {
                            $args->modules_info[$val->mid] = $val;
                            $args->module_srls_info[$val->module_srl] = $val;
                            $args->mid_lists[$val->module_srl] = $val->mid;
                            $module_srls[] = $val->module_srl;
                        }
                    }

                    $args->modules_info = $oModuleModel->getMidList($obj);
                // 대상 모듈이 선택되어 있으면 해당 모듈만 추출
                } else {
                    $obj->module_srls = $args->module_srls;
                    $output = executeQueryArray('widgets.widget_kgcontent.getMids', $obj);
                    if($output->data) {
                        foreach($output->data as $key => $val) {
                            $args->modules_info[$val->mid] = $val;
                            $args->module_srls_info[$val->module_srl] = $val;
                            $module_srls[] = $val->module_srl;
                        }
                        $idx = explode(',',$args->module_srls);
                        for($i=0,$c=count($idx);$i<$c;$i++) {
                            $srl = $idx[$i];
                            if(!$args->module_srls_info[$srl]) continue;
                            $args->mid_lists[$srl] = $args->module_srls_info[$srl]->mid;
                        }
                    }
                }

                // 아무런 모듈도 검색되지 않았다면 종료
                if(!count($args->modules_info)) return Context::get('msg_not_founded');
                $args->module_srl = implode(',',$module_srls);
            }

            /**
             * 컨텐츠 추출, 게시글/댓글/엮인글/RSS등 다양한 요소가 있어서 각 method를 따로 만듬
             **/
            // tab 형태
            if($args->tab_type == 'none' || $args->tab_type == '') {
                switch($args->content_type){
                    case 'comment':
                            $content_items = $this->_getCommentItems($args);
                        break;
                    case 'rss':
                            $content_items = $this->getRssItems($args);
                        break;
                    case 'trackback':
                            $content_items = $this->_getTrackbackItems($args);
                        break;
                    case 'docu_comment':
                            $content_items = $this->_getDocumentItems($args);
                        break;
                    default:
                            $content_items = $this->_getDocumentItems($args);
                        break;
                }
            // tab 형태가 아닐 경우
            } else {
                $content_items = array();

                switch($args->content_type){
                    case 'comment':
                            foreach($args->mid_lists as $module_srl => $mid){
                                $args->module_srl = $module_srl;
                                $content_items[$module_srl] = $this->_getCommentItems($args);
                            }
                        break;
                    case 'rss':
                            $content_items = $this->getRssItems($args);
                        break;
                    case 'trackback':
                            foreach($args->mid_lists as $module_srl => $mid){
                                $args->module_srl = $module_srl;
                                $content_items[$module_srl] = $this->_getTrackbackItems($args);
                            }
                        break;
                    default:
                            foreach($args->mid_lists as $module_srl => $mid){
                                $args->module_srl = $module_srl;
                                $content_items[$module_srl] = $this->_getDocumentItems($args);
                            }
                        break;
                }
            }

            $output = $this->_compile($args,$content_items);
            return $output;
        }



        /**
         * @brief 문서 목록을 추출하여 contentItem으로 return
         **/
        function _getDocumentItems($args){
            // document 모듈의 model 객체를 받아서 결과를 객체화 시킴
            $oDocumentModel = &getModel('document');
            // comment 모듈의 model 객체를 받아서 결과를 객체화 시킴
            $oCommentModel = &getModel('comment');
            // file 모듈의 model 객체를 받아서 결과를 객체화 시킴
            $oFileModel = &getModel('file');

            // 분류 구함
            $obj->module_srl = $args->module_srl;
            $output = executeQueryArray('widgets.widget_kgcontent.getCategories',$obj);
            if($output->toBool() && $output->data) {
                foreach($output->data as $key => $val) {
                    $category_lists[$val->module_srl][$val->category_srl] = $val;
                }
            }


            //'minishop'의 가격과 거래상태를 구함
            $obj->module_srl = $args->module_srl;
            $output = executeQueryArray('widgets.widget_kgcontent.getMinishopItems',$obj);
            if($output->toBool() && $output->data) {
                foreach($output->data as $key => $val) {
                    $minishop_items[$val->document_srl] = $val;
                }
            }


            // 글 목록을 구함
            $obj->module_srl = $args->module_srl;
            $obj->sort_index = $args->order_target;
            $obj->order_type = $args->order_type=="desc"?"asc":"desc";
            $obj->list_count = $args->list_count * $args->page_count;
            $output = executeQueryArray('widgets.widget_kgcontent.getNewestDocuments', $obj);
            if(!$output->toBool() || !$output->data) return;


            // 결과가 있으면 각 문서 객체화를 시킴
            $content_items = array();
            $first_thumbnail_idx = -1;
            if(count($output->data)) {
                foreach($output->data as $key => $attribute) {
                    $oDocument = new documentItem();
                    $oDocument->setAttribute($attribute, false);
                    $GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
                    $document_srls[] = $oDocument->document_srl;
                }
                $oDocumentModel->setToAllDocumentExtraVars();

                for($i=0,$c=count($document_srls);$i<$c;$i++) {
                    $oDocument = $GLOBALS['XE_DOCUMENT_LIST'][$document_srls[$i]];
                    $document_srl = $oDocument->document_srl;
                    $module_srl = $oDocument->get('module_srl');
                    $category_srl = $oDocument->get('category_srl');

                    //게시물 '첨부미디어' 또는 '링크미디어' 설정부분
                    if($args->skin_type=='media') {
                        //게시물 내용 중 첨부파일이 있을 경우 첨부파일주소반환
                        $file_list = $oFileModel->getFiles($document_srl);
                        if(count($file_list)) {
                          foreach($file_list as $file) {
                            if(preg_match("/\.(avi|wmv|mpg|mpeg|swf|flv|mp4|mp3)$/i",$file->source_filename)) {
                              if(!$thumbnail[$document_srl]) {
                                $thumbnail[$document_srl] = $file->uploaded_filename;
                              }
                              $all_filename[$document_srl][] = $file->uploaded_filename;
                              $all_thumbnail[$document_srl][] = $file->uploaded_filename;
                            }
                            if(preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",$file->source_filename)) {
                              if(!$movie_thumbnail[$document_srl]) {
                                $movie_thumbnail[$document_srl] = $file->uploaded_filename;
                              }
                              $all_movie_thumbfile[$document_srl][] = $file->uploaded_filename;
                              $all_movie_thumbnail[$document_srl][] = $file->uploaded_filename;
                            }
                          }
                        }
                        //게시물 내용 중 링크파일이 있을 경우 링크주소반환
                        $docu_summary = $oDocument->getContentText(0);
                        $docu_summary = preg_replace('/(a href).+?\.(avi|wmv|mpg|mpeg|swf|flv|mp4|mp3)/i', ' ', $docu_summary);
                        preg_match_all("/(http:\/\/|https:\/\/).+?\.(avi|wmv|mpg|mpeg|swf|flv|mp4|mp3)/i", $docu_summary, $link_file);
                        for($k=1;$k<=count($link_file[0]);$k++) {
                          if(!$thumbnail[$document_srl]) {
                            $thumbnail[$document_srl] = $link_file[0][$k-1];
                          }
                          //링크파일주소가 첨부파일 중에 있을 경우 중복방지
                          $exist_file = 0;
                          for($m=1;$m<=count($all_filename[$document_srl]);$m++) {
                            if($link_file[0][$k-1]==$all_filename[$document_srl][$m-1]) {
                              $exist_file = 1;
                              break;
                            }
                          }
                          if($exist_file!=1) {
                            $all_thumbnail[$document_srl][] = $link_file[0][$k-1];
                          }
                        }
                        preg_match_all("/(http:\/\/|https:\/\/).+?\.(jpg|png|jpeg|gif|bmp)/i", $docu_summary, $link_thumb);
                        for($k=1;$k<=count($link_file[0]);$k++) {
                          if(!$movie_thumbnail[$document_srl]) {
                            $movie_thumbnail[$document_srl] = $link_thumb[0][$k-1];
                          }
                          //링크파일주소가 첨부파일 중에 있을 경우 중복방지
                          $exist_file = 0;
                          for($m=1;$m<=count($all_movie_thumbfile[$document_srl]);$m++) {
                            if($link_thumb[0][$k-1]==$all_movie_thumbfile[$document_srl][$m-1]) {
                              $exist_file = 1;
                              break;
                            }
                          }
                          if($exist_file!=1) {
                            $all_movie_thumbnail[$document_srl][] = $link_thumb[0][$k-1];
                          }
                        }
                    }

                    //게시물 '첨부이미지' 또는 '링크이미지' 설정부분
                    else if($args->skin_type=='image') {
                      if($args->image_type=='flie_image') {
                          //게시물 내용 중 첨부파일이 있을 경우 첨부파일주소반환
                          $file_list = $oFileModel->getFiles($document_srl);
                          if(count($file_list)) {
                            foreach($file_list as $file) {
                              if(preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",$file->source_filename)) {
                                if(!$thumbnail[$document_srl]) {
                                  $thumbnail[$document_srl] = $file->uploaded_filename;
                                }
                                $all_filename[$document_srl][] = $file->uploaded_filename;
                                $all_thumbnail[$document_srl][] = $file->uploaded_filename;
                              }
                            }
                          }
                          //게시물 내용 중 링크파일이 있을 경우 링크주소반환
                          $docu_summary = $oDocument->getContentText(0);
                          $docu_summary = preg_replace('/(a href).+?\.(jpg|png|jpeg|gif|bmp)/i', ' ', $docu_summary);
                          preg_match_all("/(http:\/\/|https:\/\/).+?\.(jpg|png|jpeg|gif|bmp)/i", $docu_summary, $link_file);
                          for($k=1;$k<=count($link_file[0]);$k++) {
                            if(!$thumbnail[$document_srl]) {
                              $thumbnail[$document_srl] = $link_file[0][$k-1];
                            }
                            //링크파일주소가 첨부파일 중에 있을 경우 중복방지
                            $exist_file = 0;
                            for($m=1;$m<=count($all_filename[$document_srl]);$m++) {
                              if($link_file[0][$k-1]==$all_filename[$document_srl][$m-1]) {
                                $exist_file = 1;
                                break;
                              }
                            }
                            if($exist_file!=1) {
                              $all_thumbnail[$document_srl][] = $link_file[0][$k-1];
                            }
                          }
                      }
                      else {
                          $thumb_num = 1;
                          $file_list = $oFileModel->getFiles($document_srl);
                          if(count($file_list)) {
                            foreach($file_list as $file) {
                              if(preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",$file->source_filename)) {
                                $link_filename = substr($file->source_filename, 0,-4);
                                $thumbnail_path = sprintf('files/cache/thumbnails/%s',getNumberingPath($document_srl, 3));
                                $thumbnail_files = sprintf('%s%dx%d.%s'.$thumb_num.'_'.$link_filename.'.jpg', $thumbnail_path, $args->thumbnail_width, $args->thumbnail_height, $args->thumbnail_type);
                                $thumbnail_urls  = Context::getRequestUri().$thumbnail_files;
                                if(!file_exists($thumbnail_files)) {
                                  FileHandler::createImageFile($file->uploaded_filename, $thumbnail_files, $args->thumbnail_width, $args->thumbnail_height, 'jpg', $args->thumbnail_type);
                                }
                                $all_filename[$document_srl][] = $file->uploaded_filename;
                                $all_thumbnail[$document_srl][] = $thumbnail_urls;
                                if(!$thumbnail[$document_srl]) {
                                  $thumbnail[$document_srl] = $all_thumbnail[$document_srl][0];
                                }                              
                              }
                            $thumb_num++;
                            }
                          }
                          $docu_summary = $oDocument->getContentText(0);
                          $docu_summary = preg_replace('/(a href).+?\.(jpg|png|jpeg|gif|bmp)/i', ' ', $docu_summary);
                          preg_match_all("/(http:\/\/|https:\/\/).+?\.(jpg|png|jpeg|gif|bmp)/i", $docu_summary, $link_file);
                          for($k=1;$k<=count($link_file[0]);$k++) {
                            //링크파일주소가 첨부파일 중에 있을 경우 중복방지
                            $exist_file = 0;
                            for($m=1;$m<=count($all_filename[$document_srl]);$m++) {
                              if($link_file[0][$k-1]==$all_filename[$document_srl][$m-1]) {
                                $exist_file = 1;
                                break;
                              }
                            }
                            if($exist_file!=1) {
                              $link_filename = substr($link_file[0][$k-1], 0,-4);
                              $link_filename = substr(strrchr($link_filename, '/'),1);
                              $thumbnail_path = sprintf('files/cache/thumbnails/%s',getNumberingPath($document_srl, 3));
                              $thumbnail_files = sprintf('%s%dx%d.%s'.$thumb_num.'_'.$link_filename.'.jpg', $thumbnail_path, $args->thumbnail_width, $args->thumbnail_height, $args->thumbnail_type);
                              $thumbnail_urls  = Context::getRequestUri().$thumbnail_files;
                              $tmp_file = sprintf('./files/cache/tmp/%d', md5(rand(111111,999999).$document_srl));
                              if(!is_dir('./files/cache/tmp')) FileHandler::makeDir('./files/cache/tmp');
                              if(!file_exists($thumbnail_files)) {
                                FileHandler::getRemoteFile($link_file[0][$k-1], $tmp_file);
                                FileHandler::createImageFile($tmp_file, $thumbnail_files, $args->thumbnail_width, $args->thumbnail_height, 'jpg', $args->thumbnail_type);
                                FileHandler::removeFile($tmp_file);
                              }
                              $all_thumbnail[$document_srl][] = $thumbnail_urls;
                              if(!$thumbnail[$document_srl]) {
                                $thumbnail[$document_srl] = $all_thumbnail[$document_srl][0];
                              }                              
                            }
                          $thumb_num++;
                          }
                      }
                    }


                    $content_item = new kgcontentItem( $args->module_srls_info[$module_srl]->browser_title );
                    $content_item->adds($oDocument->getObjectVars());
                    $content_item->setTitle($oDocument->getTitle());
                    $content_item->setCategory( $category_lists[$module_srl][$category_srl]->title );
                    $content_item->setDomain( $args->module_srls_info[$module_srl]->domain );
                    $content_item->setContent($oDocument->getSummary($args->content_cut_size));
                    $content_item->setLink( getSiteUrl($domain,'','document_srl',$document_srl) );
                    $content_item->setThumbnail($thumbnail[$document_srl]);
                    $content_item->setMovieThumbnail($movie_thumbnail[$document_srl]);
                    $content_item->setAllThumbnail($all_thumbnail[$document_srl]);
                    $content_item->setAllMovieThumbnail($all_movie_thumbnail[$document_srl]);
                    $content_item->setExtraImages($oDocument->printExtraImages($args->duration_new * 60 * 60));
                    if($args->show_subcomment=='Y') $content_item->setComment($oDocument->getComments());
                    $content_item->add('mid', $args->mid_lists[$module_srl]);
                    if($first_thumbnail_idx==-1 && $thumbnail) $first_thumbnail_idx = $i;

                    //확장변수 키값을 '$content_item' 추가
                    $content_item->extra_keys = $oDocumentModel->getExtraKeys($module_srl);
                    $content_item->extra_vars = $oDocumentModel->getExtraVars($module_srl,$document_srl);


                    //'minishop' 가격과 거래상태를 '$content_item' 추가
                    if( $minishop_items[$document_srl]->document_srl == $document_srl){
                      $content_item->setMinishopPrice( $minishop_items[$document_srl]->minishop_price );
                    }
                    if( $minishop_items[$document_srl]->document_srl == $document_srl){
                      $content_item->setMinishopSelltype( $minishop_items[$document_srl]->minishop_sell_type );
                    }

                    $content_items[] = $content_item;
                }

                $content_items[0]->setFirstThumbnailIdx($first_thumbnail_idx);
            }
            return $content_items;
        }



        /**
         * @brief 댓글 목록을 추출하여 contentItem으로 return
         **/
        function _getCommentItems($args) {
            // comment 모듈의 model 객체를 받아서 결과를 객체화 시킴
            $oCommentModel = &getModel('comment');
            // file 모듈의 model 객체를 받아서 결과를 객체화 시킴
            $oFileModel = &getModel('file');

            // 분류 구함
            $obj->module_srl = $args->module_srl;
            $output = executeQueryArray('widgets.widget_kgcontent.getCategories',$obj);
            if($output->toBool() && $output->data) {
                foreach($output->data as $key => $val) {
                    $category_lists[$val->module_srl][$val->category_srl] = $val;
                }
            }


            // CommentModel::getNewestCommentList()를 이용하기 위한 변수 정리
            $obj->module_srl = $args->module_srl;
            $obj->sort_index = $args->order_target;
            $obj->order_type = $args->order_type=="desc"?"asc":"desc";
            $obj->list_count = $args->list_count * $args->page_count;

            // CommentModel::getNewestCommentList() method를 실행
            // 이 method를 실행 결과의 '$output'은 Query한 '$output->data'와 동일
            $output = $oCommentModel->getNewestCommentList($obj);



            $content_items = array();
            $first_thumbnail_idx = -1;
            if(!count($output)) return;

            foreach($output as $key => $attribute) {
                $oComment = new commentItem();
                $oComment->setAttribute($attribute);
                $GLOBALS['XE_COMMENT_LIST'][$oComment->comment_srl] = $oComment;
                $comment_srls[] = $oComment->comment_srl;
            }

            for($i=0,$c=count($comment_srls);$i<$c;$i++) {
                $oComment = $GLOBALS['XE_COMMENT_LIST'][$comment_srls[$i]];
                $comment_srl = $oComment->comment_srl;
                $document_srl = $oComment->document_srl;
                $module_srl = $oComment->get('module_srl');
                $category_srl = $oComment->get('category_srl');

                //게시물 '첨부미디어' 또는 '링크미디어' 설정부분
                if($args->skin_type=='media') {
                    //게시물 내용 중 첨부파일이 있을 경우 첨부파일주소반환
                    $file_list = $oFileModel->getFiles($comment_srl);
                    if(count($file_list)) {
                      foreach($file_list as $file) {
                        if(preg_match("/\.(avi|wmv|mpg|mpeg|swf|flv|mp4|mp3)$/i",$file->source_filename)) {
                          if(!$thumbnail[$comment_srl]) {
                            $thumbnail[$comment_srl] = $file->uploaded_filename;
                          }
                          $all_filename[$comment_srl][] = $file->uploaded_filename;
                          $all_thumbnail[$comment_srl][] = $file->uploaded_filename;
                        }
                        if(preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",$file->source_filename)) {
                          if(!$movie_thumbnail[$comment_srl]) {
                            $movie_thumbnail[$comment_srl] = $file->uploaded_filename;
                          }
                          $all_movie_thumbfile[$comment_srl][] = $file->uploaded_filename;
                          $all_movie_thumbnail[$comment_srl][] = $file->uploaded_filename;
                        }
                      }
                    }
                    //게시물 내용 중 링크파일이 있을 경우 링크주소반환
                    $docu_summary = $oComment->getContentText(0);
                    $docu_summary = preg_replace('/(a href).+?\.(avi|wmv|mpg|mpeg|swf|flv|mp4|mp3)/i', ' ', $docu_summary);
                    preg_match_all("/(http:\/\/|https:\/\/).+?\.(avi|wmv|mpg|mpeg|swf|flv|mp4|mp3)/i", $docu_summary, $link_file);
                    for($k=1;$k<=count($link_file[0]);$k++) {
                      if(!$thumbnail[$comment_srl]) {
                        $thumbnail[$comment_srl] = $link_file[0][$k-1];
                      }
                      //링크파일주소가 첨부파일 중에 있을 경우 중복방지
                      $exist_file = 0;
                      for($m=1;$m<=count($all_filename[$comment_srl]);$m++) {
                        if($link_file[0][$k-1]==$all_filename[$comment_srl][$m-1]) {
                          $exist_file = 1;
                          break;
                        }
                      }
                      if($exist_file!=1) {
                        $all_thumbnail[$comment_srl][] = $link_file[0][$k-1];
                      }
                    }
                    preg_match_all("/(http:\/\/|https:\/\/).+?\.(jpg|png|jpeg|gif|bmp)/i", $docu_summary, $link_thumb);
                    for($k=1;$k<=count($link_file[0]);$k++) {
                      if(!$movie_thumbnail[$comment_srl]) {
                        $movie_thumbnail[$comment_srl] = $link_thumb[0][$k-1];
                      }
                      //링크파일주소가 첨부파일 중에 있을 경우 중복방지
                      $exist_file = 0;
                      for($m=1;$m<=count($all_movie_thumbfile[$comment_srl]);$m++) {
                        if($link_thumb[0][$k-1]==$all_movie_thumbfile[$comment_srl][$m-1]) {
                          $exist_file = 1;
                          break;
                        }
                      }
                      if($exist_file!=1) {
                        $all_movie_thumbnail[$comment_srl][] = $link_thumb[0][$k-1];
                      }
                    }
                }
                //게시물 '첨부이미지' 또는 '링크이미지' 설정부분
                else if($args->skin_type=='image') {
                  if($args->image_type=='flie_image') {
                    //게시물 내용 중 첨부파일이 있을 경우 첨부파일주소반환
                    $file_list = $oFileModel->getFiles($comment_srl);
                    if(count($file_list)) {
                      foreach($file_list as $file) {
                        if(preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",$file->source_filename)) {
                          if(!$thumbnail[$comment_srl]) {
                            $thumbnail[$comment_srl] = $file->uploaded_filename;
                          }
                          $all_filename[$comment_srl][] = $file->uploaded_filename;
                          $all_thumbnail[$comment_srl][] = $file->uploaded_filename;
                        }
                      }
                    }
                    //게시물 내용 중 링크파일이 있을 경우 링크주소반환
                    $docu_summary = $oComment->getContentText(0);
                    $docu_summary = preg_replace('/(a href).+?\.(jpg|png|jpeg|gif|bmp)/i', ' ', $docu_summary);
                    preg_match_all("/(http:\/\/|https:\/\/).+?\.(jpg|png|jpeg|gif|bmp)/i", $docu_summary, $link_file);
                    for($k=1;$k<=count($link_file[0]);$k++) {
                      if(!$thumbnail[$comment_srl]) {
                        $thumbnail[$comment_srl] = $link_file[0][$k-1];
                      }
                      //링크파일주소가 첨부파일 중에 있을 경우 중복방지
                      $exist_file = 0;
                      for($m=1;$m<=count($all_filename[$comment_srl]);$m++) {
                        if($link_file[0][$k-1]==$all_filename[$comment_srl][$m-1]) {
                          $exist_file = 1;
                          break;
                        }
                      }
                      if($exist_file!=1) {
                        $all_thumbnail[$comment_srl][] = $link_file[0][$k-1];
                      }
                    }
                  }
                  else {
                    $thumb_num = 1;
                    $file_list = $oFileModel->getFiles($comment_srl);
                    if(count($file_list)) {
                      foreach($file_list as $file) {
                        if(preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",$file->source_filename)) {
                          $link_filename = substr($file->source_filename, 0,-4);
                          $thumbnail_path = sprintf('files/cache/thumbnails/%s',getNumberingPath($comment_srl, 3));
                          $thumbnail_files = sprintf('%s%dx%d.%s'.$thumb_num.'_'.$link_filename.'.jpg', $thumbnail_path, $args->thumbnail_width, $args->thumbnail_height, $args->thumbnail_type);
                          $thumbnail_urls  = Context::getRequestUri().$thumbnail_files;
                          if(!file_exists($thumbnail_files)) {
                            FileHandler::createImageFile($file->uploaded_filename, $thumbnail_files, $args->thumbnail_width, $args->thumbnail_height, 'jpg', $args->thumbnail_type);
                          }
                          $all_filename[$comment_srl][] = $file->uploaded_filename;
                          $all_thumbnail[$comment_srl][] = $thumbnail_urls;
                          if(!$thumbnail[$comment_srl]) {
                            $thumbnail[$comment_srl] = $all_thumbnail[$comment_srl][0];
                          }                              
                        }
                      $thumb_num++;
                      }
                    }
                    $docu_summary = $oComment->getContentText(0);
                    $docu_summary = preg_replace('/(a href).+?\.(jpg|png|jpeg|gif|bmp)/i', ' ', $docu_summary);
                    preg_match_all("/(http:\/\/|https:\/\/).+?\.(jpg|png|jpeg|gif|bmp)/i", $docu_summary, $link_file);
                    for($k=1;$k<=count($link_file[0]);$k++) {
                      //링크파일주소가 첨부파일 중에 있을 경우 중복방지
                      $exist_file = 0;
                      for($m=1;$m<=count($all_filename[$comment_srl]);$m++) {
                        if($link_file[0][$k-1]==$all_filename[$comment_srl][$m-1]) {
                          $exist_file = 1;
                          break;
                        }
                      }
                      if($exist_file!=1) {
                        $link_filename = substr($link_file[0][$k-1], 0,-4);
                        $link_filename = substr(strrchr($link_filename, '/'),1);
                        $thumbnail_path = sprintf('files/cache/thumbnails/%s',getNumberingPath($comment_srl, 3));
                        $thumbnail_files = sprintf('%s%dx%d.%s'.$thumb_num.'_'.$link_filename.'.jpg', $thumbnail_path, $args->thumbnail_width, $args->thumbnail_height, $args->thumbnail_type);
                        $thumbnail_urls  = Context::getRequestUri().$thumbnail_files;
                        $tmp_file = sprintf('./files/cache/tmp/%d', md5(rand(111111,999999).$comment_srl));
                        if(!is_dir('./files/cache/tmp')) FileHandler::makeDir('./files/cache/tmp');
                        if(!file_exists($thumbnail_files)) {
                          FileHandler::getRemoteFile($link_file[0][$k-1], $tmp_file);
                          FileHandler::createImageFile($tmp_file, $thumbnail_files, $args->thumbnail_width, $args->thumbnail_height, 'jpg', $args->thumbnail_type);
                          FileHandler::removeFile($tmp_file);
                        }
                        $all_thumbnail[$comment_srl][] = $thumbnail_urls;
                        if(!$thumbnail[$comment_srl]) {
                          $thumbnail[$comment_srl] = $all_thumbnail[$comment_srl][0];
                        }                              
                      }
                    $thumb_num++;
                    }
                  }
                }


                $content_item = new kgcontentItem( $args->module_srls_info[$module_srl]->browser_title );
                $content_item->adds($oComment->getObjectVars());
                $content_item->setTitle($oComment->getSummary($args->subject_cut_size));
                $content_item->setCategory( $category_lists[$module_srl][$category_srl]->title );
                $content_item->setDomain( $args->module_srls_info[$module_srl]->domain );
                $content_item->setContent($oComment->getSummary($args->content_cut_size));
                $url = sprintf("%s#comment_%s",getUrl('','document_srl',$oComment->get('document_srl')),$oComment->get('comment_srl'));
                $content_item->setLink( $url );
                $content_item->setThumbnail($thumbnail[$comment_srl]);
                $content_item->setMovieThumbnail($movie_thumbnail[$comment_srl]);
                $content_item->setAllThumbnail($all_thumbnail[$comment_srl]);
                $content_item->setAllMovieThumbnail($all_movie_thumbnail[$comment_srl]);
                $content_item->add('comment_srl', $comment_srl);
                $content_item->add('document_srl', $document_srl);
                if($args->show_subcomment=='Y') $content_item->setComment($output);
                $content_item->add('mid', $args->mid_lists[$module_srl]);
                if($first_thumbnail_idx==-1 && $thumbnail) $first_thumbnail_idx = $i;

                $content_items[] = $content_item;
            }

            $content_items[0]->setFirstThumbnailIdx($first_thumbnail_idx);
            return $content_items;
        }



        function getRssItems($args){

            $content_items = array();
            $args->mid_lists = array();

            foreach($args->rss_urls as $key => $rss){
                $args->rss_url = $rss;
                $content_item = $this->_getRssItems($args);
                if(count($content_item) > 0){
                    $browser_title = $content_item[0]->getBrowserTitle();
                    $args->mid_lists[] = $browser_title;
                    $content_items[] = $content_item;
                }
            }

            // 탭 형태가 아닐 경우
            if($args->tab_type == 'none' || $args->tab_type == ''){
                $items = array();
                foreach($content_items as $key => $val){
                    foreach($val as $k => $v){
                        $date = $v->get('regdate');
                        $i=0;
                        while(array_key_exists(sprintf('%s%02d',$date,$i), $items)) $i++;
                        $items[sprintf('%s%02d',$date,$i)] = $v;
                    }
                }
                if($args->order_type =='asc') ksort($items);
                else krsort($items);
                $content_items = array_slice(array_values($items),0,$args->list_count*$args->page_count);

            // 탭 형태
            } else {
                foreach($content_items as $key=> $content_item_list){
                    $items = array();
                    foreach($content_item_list as $k => $content_item){
                        $date = $content_item->get('regdate');
                        $i=0;
                        while(array_key_exists(sprintf('%s%02d',$date,$i), $items)) $i++;
                        $items[sprintf('%s%02d',$date,$i)] = $content_item;
                    }
                    if($args->order_type =='asc') ksort($items);
                    else krsort($items);

                    $content_items[$key] = array_values($items);
                }
            }
            return $content_items;
        }

        function _getRssBody($value) {
            if(!$value || is_string($value)) return $value;
            if(is_object($value)) $value = get_object_vars($value);
            $body = null;
            if(!count($value)) return;
            foreach($value as $key => $val) {
                if($key == 'body') {
                    $body = $val;
                    continue;
                }
                if(is_object($val)||is_array($val)) $body = $this->_getRssBody($val);
                if($body !== null) return $body;
            }
            return $body;
        }

        //RSS 'thumbnail'을 가져오기 위한 함수
        function _getRssThumbnail($content) {
          preg_match_all("!src=(\"|')([^\"' ]*?)(\"|')!is", $content, $matches, PREG_SET_ORDER);
          $cnt = count($matches);
          for($i=0;$i<$cnt;$i++) {
            $thumbnail_src = trim($matches[0][2]);
            if(!preg_match("/\.(jpg|png|jpeg|gif|bmp)$/i",$thumbnail_src)) {
              $thumbnail_src = '';
            }
            else {
              $thumbnail_src = $thumbnail_src;
            }
    			}
          return $thumbnail_src;
        }

        function _getSummary($content, $str_size = 50)
        {
            $content = preg_replace('!(<br[\s]*/{0,1}>[\s]*)+!is', ' ', $content);

            // </p>, </div>, </li> 등의 태그를 공백 문자로 치환
            $content = str_replace(array('</p>', '</div>', '</li>'), ' ', $content);

            // 태그 제거
            $content = preg_replace('!<([^>]*?)>!is','', $content);

            // < , > , " 를 치환
            $content = str_replace(array('&lt;','&gt;','&quot;','&nbsp;'), array('<','>','"',' '), $content);

            // 연속된 공백문자 삭제
            $content = preg_replace('/ ( +)/is', ' ', $content);

            // 문자열을 자름
            $content = trim(cut_str($content, $str_size, $tail));

            // >, <, "를 다시 복구
            $content = str_replace(array('<','>','"'),array('&lt;','&gt;','&quot;'), $content);

            // 영문이 연결될 경우 개행이 안 되는 문제를 해결
            $content = preg_replace('/([a-z0-9\+:\/\.\~,\|\!\@\#\$\%\^\&\*\(\)\_]){20}/is',"$0-",$content);
            return $content; 
        }


       /**
         * @brief rss 주소로 부터 내용을 받아오는 함수
         * tistory 의 경우 원본 주소가 location 헤더를 뿜는다. (내용은 없음)이를 해결하기 위한 수정 - rss_reader 위젯과 방식 동일
         **/
        function requestFeedContents($rss_url) {
            $rss_url = str_replace('&amp;','&',Context::convertEncodingStr($rss_url));
            return FileHandler::getRemoteResource($rss_url, null, 3, 'GET', 'application/xml');
        }

        function _getRssItems($args){
            // 날짜 형태
            $DATE_FORMAT = $args->date_format ? $args->date_format : "Y-m-d H:i:s";

            $buff = $this->requestFeedContents($args->rss_url);

            $encoding = preg_match("/<\?xml.*encoding=\"(.+)\".*\?>/i", $buff, $matches);
            if($encoding && !preg_match("/UTF-8/i", $matches[1])) $buff = Context::convertEncodingStr($buff);

            $buff = preg_replace("/<\?xml.*\?>/i", "", $buff);

            $oXmlParser = new XmlParser();
            $xml_doc = $oXmlParser->parse($buff);
            if($xml_doc->rss) {
                $rss->title = $xml_doc->rss->channel->title->body;
                $rss->link = $xml_doc->rss->channel->link->body;

                $items = $xml_doc->rss->channel->item;

                if(!$items) return;
                if($items && !is_array($items)) $items = array($items);

                $content_items = array();

                foreach ($items as $key => $value) {
                    if($key >= $args->list_count * $args->page_count) break;
                    unset($item);

                    foreach($value as $key2 => $value2) {
                        if(is_array($value2)) $value2 = array_shift($value2);
                        $item->{$key2} = $this->_getRssBody($value2);
                    }

                    $content_item = new kgcontentItem($rss->title);
                    $content_item->setContentsLink($rss->link);
                    $content_item->setTitle($item->title);
                    $content_item->setNickName(max($item->author,$item->{'dc:creator'}));
                    //$content_item->setCategory($item->category);

                    $content_item->setThumbnail($this->_getRssThumbnail($item->description));
                    $item->description = preg_replace('!<a href=!is','<a onclick="window.open(this.href);return false" href=', $item->description);
                    $content_item->setContent($this->_getSummary($item->description, $args->content_cut_size));

                    $content_item->setLink($item->link);
                    $date = date('YmdHis', strtotime(max($item->pubdate,$item->pubDate,$item->{'dc:date'})));
                    $content_item->setRegdate($date);

                    $content_items[] = $content_item;
                }
            } elseif($xml_doc->{'rdf:rdf'}) {
                // rss1.0 지원 (Xml이 대소문자를 구분해야 하는데 XE의 XML파서가 전부 소문자로 바꾸는 바람에 생긴 case) by misol
                $rss->title = $xml_doc->{'rdf:rdf'}->channel->title->body;
                $rss->link = $xml_doc->{'rdf:rdf'}->channel->link->body;

                $items = $xml_doc->{'rdf:rdf'}->item;

                if(!$items) return;
                if($items && !is_array($items)) $items = array($items);

                $content_items = array();

                foreach ($items as $key => $value) {
                    if($key >= $args->list_count * $args->page_count) break;
                    unset($item);

                    foreach($value as $key2 => $value2) {
                        if(is_array($value2)) $value2 = array_shift($value2);
                        $item->{$key2} = $this->_getRssBody($value2);
                    }

                    $content_item = new kgcontentItem($rss->title);
                    $content_item->setContentsLink($rss->link);
                    $content_item->setTitle($item->title);
                    $content_item->setNickName(max($item->author,$item->{'dc:creator'}));
                    //$content_item->setCategory($item->category);
                    $item->description = preg_replace('!<a href=!is','<a onclick="window.open(this.href);return false" href=', $item->description);

                    $content_item->setThumbnail($this->_getRssThumbnail($item->description));
                    $content_item->setContent($this->_getSummary($item->description, $args->content_cut_size));

                    $content_item->setLink($item->link);
                    $date = date('YmdHis', strtotime(max($item->pubdate,$item->pubDate,$item->{'dc:date'})));
                    $content_item->setRegdate($date);

                    $content_items[] = $content_item;
                }
            } elseif($xml_doc->feed && $xml_doc->feed->attrs->xmlns == 'http://www.w3.org/2005/Atom') {
                // Atom 1.0 spec 지원 by misol
                $rss->title = $xml_doc->feed->title->body;
                $links = $xml_doc->feed->link;
                if(is_array($links)) {
                    foreach ($links as $value) {
                        if($value->attrs->rel == 'alternate') {
                            $rss->link = $value->attrs->href;
                            break;
                        }
                    }
                }
                elseif($links->attrs->rel == 'alternate') $rss->link = $links->attrs->href;

                $items = $xml_doc->feed->entry;

                if(!$items) return;
                if($items && !is_array($items)) $items = array($items);

                $content_items = array();

                foreach ($items as $key => $value) {
                    if($key >= $args->list_count * $args->page_count) break;
                    unset($item);

                    foreach($value as $key2 => $value2) {
                        if(is_array($value2)) $value2 = array_shift($value2);
                        $item->{$key2} = $this->_getRssBody($value2);
                    }

                    $content_item = new kgcontentItem($rss->title);
                    $links = $value->link;
                    if(is_array($links)) {
                        foreach ($links as $val) {
                            if($val->attrs->rel == 'alternate') {
                                $item->link = $val->attrs->href;
                                break;
                            }
                        }
                    }
                    elseif($links->attrs->rel == 'alternate') $item->link = $links->attrs->href;

                    $content_item->setContentsLink($rss->link);
                    if($item->title) {
                        if(!preg_match("/html/i", $value->title->attrs->type)) $item->title = $value->title->body;
                    }
                    $content_item->setTitle($item->title);
                    $content_item->setNickName(max($item->author,$item->{'dc:creator'}));
                    $content_item->setAuthorSite($value->author->uri->body);
                    //$content_item->setCategory($item->category);
                    $item->description = preg_replace('!<a href=!is','<a onclick="window.open(this.href);return false" href=', $item->content);
                    if($item->description) {
                        if(!preg_match("/html/i", $value->content->attrs->type)) $item->description = htmlspecialchars($item->description);
                    }
                    if(!$item->description) {
                        $item->description = $item->summary;
                        if($item->description) {
                            if(!preg_match("/html/i", $value->summary->attrs->type)) $item->description = htmlspecialchars($item->description);
                        }
                    }

                    $content_item->setThumbnail($this->_getRssThumbnail($item->description));
                    $content_item->setContent($this->_getSummary($item->description, $args->content_cut_size));

                    $content_item->setLink($item->link);
                    $date = date('YmdHis', strtotime(max($item->published,$item->updated,$item->{'dc:date'})));
                    $content_item->setRegdate($date);

                    $content_items[] = $content_item;
                }
            }
            return $content_items;
        }

        function _getTrackbackItems($args){
            // 분류 구함
            $output = executeQueryArray('widgets.widget_kgcontent.getCategories',$obj);
            if($output->toBool() && $output->data) {
                foreach($output->data as $key => $val) {
                    $category_lists[$val->module_srl][$val->category_srl] = $val;
                }
            }

            $obj->module_srl = $args->module_srl;
            $obj->sort_index = $args->order_target;
            $obj->list_count = $args->list_count * $args->page_count;

            // trackback 모듈의 model 객체를 받아서 getTrackbackList() method를 실행
            $oTrackbackModel = &getModel('trackback');
            $output = $oTrackbackModel->getNewestTrackbackList($obj);

            // 오류가 생기면 그냥 무시
            if(!$output->toBool() || !$output->data) return;

            // 결과가 있으면 각 문서 객체화를 시킴
            $content_items = array();
            foreach($output->data as $key => $item) {
                $domain = $args->module_srls_info[$item->module_srl]->domain;
                $category = $category_lists[$item->module_srl]->text;
                $url = getSiteUrl($domain,'','document_srl',$item->document_srl);
                $browser_title = $args->module_srls_info[$item->module_srl]->browser_title;

                $content_item = new kgcontentItem($browser_title);
                $content_item->adds($item);
                $content_item->setTitle($item->title);
                $content_item->setCategory($category);
                $content_item->setNickName($item->blog_name);
                $content_item->setContent($item->excerpt);  ///<<
                $content_item->setDomain($domain);  ///<<
                $content_item->setLink($url);
                $content_item->add('mid', $args->mid_lists[$item->module_srl]);
                $content_item->setRegdate($item->regdate);
                $content_items[] = $content_item;
            }
            return $content_items;
        }

        function _compile($args,$content_items){
            $oTemplate = &TemplateHandler::getInstance();

            // 위젯스킨 탬플릿에 넘기기 위한 변수 설정
            $widget_info->colorset_num = $args->colorset_num;

            $widget_info->widget_font_family = $args->widget_font_family;
            $widget_info->widget_font_size = $args->widget_font_size;
            $widget_info->widget_font_color = $args->widget_font_color;

            $widget_info->skin_type = $args->skin_type;
            $widget_info->content_type = $args->content_type;
            $widget_info->image_type = $args->image_type;

            $widget_info->show_document_title = $args->show_document_title;
            $widget_info->document_title = $args->document_title;
            $widget_info->document_subtitle = $args->document_subtitle;
            $widget_info->show_more = $args->show_more;
            $widget_info->more_window = $args->more_window;

            $widget_info->show_thumbnail = $args->show_thumbnail;
            $widget_info->thumbnail_type = $args->thumbnail_type;
            $widget_info->thumbnail_width = $args->thumbnail_width;
            $widget_info->thumbnail_height = $args->thumbnail_height;
            $widget_info->show_movie_thumbnail = $args->show_movie_thumbnail;

            $widget_info->show_titlearea = $args->show_titlearea;
            $widget_info->show_list_number = $args->show_list_number;
            $widget_info->show_browser_title = $args->show_browser_title;
            $widget_info->show_category = $args->show_category;
            $widget_info->show_title = $args->show_title;
            $widget_info->subject_cut_size = $args->subject_cut_size;
            $widget_info->show_comment_count = $args->show_comment_count;
            $widget_info->show_trackback_count = $args->show_trackback_count;
            $widget_info->show_icon = $args->show_icon;
            $widget_info->duration_new = $args->duration_new * 60*60;
            $widget_info->show_extra_keyvars = $args->show_extra_keyvars;
            $widget_info->extra_keys_eid = explode(',',$args->extra_keys_eid);
            $widget_info->show_extra_keys = $args->show_extra_keys;
            $widget_info->show_extra_vars = $args->show_extra_vars;
            $widget_info->show_author = $args->show_author;
            $widget_info->show_date = $args->show_date;

            $widget_info->show_content = $args->show_content;
            $widget_info->content_cut_size = $args->content_cut_size;

            $widget_info->show_subcomment = $args->show_subcomment;
            $widget_info->comment_count = $args->comment_count;

            $widget_info->list_count = $args->list_count;
            $widget_info->page_count = $args->page_count;
            $widget_info->new_window = $args->new_window;
            $widget_info->order_target = $args->order_target;
            $widget_info->order_type = $args->order_type;


            // widget_kgcontent_old 호환 관련 설정
            $widget_info->cols_list_count = $args->cols_list_count; 
            $widget_info->option_view_arr = $args->option_view_arr;


            // 탭형태일경우 탭에 대한 정보를 정리하고 module_srl로 되어 있는 key값을 index로 변경
            if($args->tab_type != 'none' && $args->tab_type) {
                $tab = array();
                foreach($args->mid_lists as $module_srl => $mid){
                    if(!is_array($content_items[$module_srl]) || !count($content_items[$module_srl])) continue;

                    unset($tab_item);
                    $tab_item->title = $content_items[$module_srl][0]->getBrowserTitle();
                    $tab_item->content_items = $content_items[$module_srl];
                    $tab_item->domain = $content_items[$module_srl][0]->getDomain();
                    $tab_item->url = $content_items[$module_srl][0]->getContentsLink();
                    if(!$tab_item->url) $tab_item->url = getSiteUrl($tab_item->domain, '','mid',$mid);
                    $tab[] = $tab_item;
                }
                $widget_info->tab = $tab;
            } else {
                $widget_info->content_items = $content_items;
            }

            //unset($args->option_view_arr);

            unset($args->modules_info);

            Context::set('widget_info', $widget_info);


            //위젯스킨 폴더명 설정
            $widget_skin_name = $args->skin;
            Context::set('widget_skin_name', $widget_skin_name);

            //위젯스킨 설치경로 설정
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);

            return $oTemplate->compile($tpl_path, "kgcontent");
        }

    }
    //---------------------proc($args) 종료----------------------------



    class kgcontentItem extends Object {

        var $browser_title = null;
        var $has_first_thumbnail_idx = false;
        var $first_thumbnail_idx = null;
        var $contents_link = null;
        var $domain = null;

        function kgcontentItem($browser_title=''){
            $this->browser_title = $browser_title;
        }
        function setContentsLink($link){
            $this->contents_link = $link;
        }
        function setFirstThumbnailIdx($first_thumbnail_idx){
            if(is_null($this->first_thumbnail) && $first_thumbnail_idx>-1) {
                $this->has_first_thumbnail_idx = true;
                $this->first_thumbnail_idx= $first_thumbnail_idx;
            }
        }
        function setExtraImages($extra_images){
            $this->add('extra_images',$extra_images);
        }
        function setDomain($domain) {
            static $default_domain = null;
            if(!$domain) {
                if(is_null($default_domain)) $default_domain = Context::getDefaultUrl();
                $domain = $default_domain;
            }
            $this->domain = $domain;
        }
        function setLink($url){
            $this->add('url',$url);
        }
        function setTitle($title){
            $this->add('title',$title);
        }
        function setThumbnail($thumbnail){
            $this->add('thumbnail',$thumbnail);
        }
        function setMovieThumbnail($movie_thumbnail){
            $this->add('movie_thumbnail',$movie_thumbnail);
        }
        function setAllThumbnail($all_thumbnail){
            $this->add('all_thumbnail',$all_thumbnail);
        }
        function setAllMovieThumbnail($all_movie_thumbnail){
            $this->add('all_movie_thumbnail',$all_movie_thumbnail);
        }
        function setContent($content){
            $this->add('content',$content);
        }
        function setComment($comment_items){
            $this->add('comment_items',$comment_items);
        }
        function setRegdate($regdate){
            $this->add('regdate',$regdate);
        }
        function setNickName($nick_name){
            $this->add('nick_name',$nick_name);
        }
        // 글 작성자의 홈페이지 주소를 저장 by misol
        function setAuthorSite($site_url){
            $this->add('author_site',$site_url);
        }
        function setCategory($category){
            $this->add('category',$category);
        }


        function getBrowserTitle(){
            return $this->browser_title;
        }
        function getDomain() {
            return $this->domain;
        }
        function getContentsLink(){
            return $this->contents_link;
        }
        function getFirstThumbnailIdx(){
            return $this->first_thumbnail_idx;
        }
        function getLink(){
            return $this->get('url');
        }
        function getModuleSrl(){
            return $this->get('module_srl');
        }
        function getTitle($cut_size = 0, $tail='...'){
            $title = strip_tags($this->get('title'));

            if($cut_size) $title = cut_str($title, $cut_size, $tail);

            $attrs = array();
            if($this->get('title_bold') == 'Y') $attrs[] = 'font-weight:bold';
            if($this->get('title_color') && $this->get('title_color') != 'N') $attrs[] = 'color:#'.$this->get('title_color');

            if(count($attrs)) $title = sprintf("<span style=\"%s\">%s</span>", implode(';', $attrs), htmlspecialchars($title));

            return $title;
        }
        function getContent(){
            return $this->get('content');
        }
        function getCategory(){
            return $this->get('category');
        }
        function getNickName(){
            return $this->get('nick_name');
        }
        function getAuthorSite(){
            return $this->get('author_site');
        }
        function getCommentCount(){
            $comment_count = $this->get('comment_count');
            return $comment_count>0 ? $comment_count : '';
        }
        function getComment(){
            return $this->get('comment_items');
        }
        function getTrackbackCount(){
            $trackback_count = $this->get('trackback_count');
            return $trackback_count>0 ? $trackback_count : '';
        }
        function getRegdate($format = 'Y.m.d H:i:s') {
            return zdate($this->get('regdate'), $format);
        }
        function printExtraImages() {
            return $this->get('extra_images');
        }
        function haveFirstThumbnail() {
            return $this->has_first_thumbnail_idx;
        }
        function getThumbnail(){
            return $this->get('thumbnail');
        }
        function getMovieThumbnail(){
            return $this->get('movie_thumbnail');
        }
        function getAllThumbnail(){
            return $this->get('all_thumbnail');
        }
        function getAllMovieThumbnail(){
            return $this->get('all_movie_thumbnail');
        }
        function getMemberSrl() {
            return $this->get('member_srl');
        }


        //'minishp' 가격과 거래상태 설정
        function setMinishopPrice($minishop_price){
            $this->add('minishop_price',$minishop_price);
        }
        function setMinishopSelltype($minishop_selltype){
            $this->add('minishop_selltype',$minishop_selltype);
        }
        function getMinishopPrice(){
            return $this->get('minishop_price');
        }
        function getMinishopSelltype(){
            return $this->get('minishop_selltype');
        }

    }
?>
