<?php
    /**
     * @class widget_kgcalendar
     * @author kindguy(edited calendar)
     * @brief 보관현황 목록 출력
     * @version 0.1
     **/

    class widget_kgcalendar extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         *
         * ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
            $oModuleModel = &getModel('module');
            $oDocumentModel = &getModel('document');


            // 대상 모듈 (mid_list는 기존 위젯의 호환을 위해서 처리하는 루틴을 유지. module_srl로 위젯에서 변경)
            if($args->mid_list) {
                $tmp_mid = explode(",",$args->mid_list);
                $args->mid = $tmp_mid[0];
            } 

            // 대상 모듈의 mid를 srl로 변경
            if($args->mid) $args->srl = $oModuleModel->getModuleSrlByMid($args->mid);


            // 위젯에서 사용할 확장변수를 세팅
            if(!$args->day_cell_height) $args->day_cell_height = 30;
            if(!$args->subject_cut_size) $args->subject_cut_size = null;
            if(!$args->duration_new) $args->duration_new = 12;
            if(!$args->content_cut_size) $args->content_cut_size = 200;
            if(!$args->thumbnail_type) $args->thumbnail_type = 'ratio';
            if(!$args->thumbnail_width) $args->thumbnail_width = 50;
            if(!$args->thumbnail_height) $args->thumbnail_height = 50;
            if(!$args->font_family) $args->font_family = null;
            if(!$args->font_size) $args->font_size = 12;
            if(!$args->font_color) $args->font_color = null;



            // DB 쿼리전송을 위한 module_srl 값 지정
            $obj->module_srl = $args->srl;


            // 선택된 모듈이 없으면 실행 취소
            if(!$obj->module_srl) return Context::getLang('msg_not_founded');


            // 모듈의 정보를 구함
            $module_info = $oModuleModel->getModuleInfoByModuleSrl($obj->module_srl);


            // 등록일자 검색을 위한 변수 세팅
            if(Context::get('search_target')=='regdate') {
                $regdate = Context::get('search_keyword');
                if($regdate) $obj->regdate = zdate($regdate, 'Ym');
            }
            if(!$obj->regdate) $obj->regdate = zdate(date('YmdHis'), 'Ym');


            // document 모듈의 글목록을 구함
            if($obj->module_srl) {
              $obj->module_srl;
              $obj->sort_index = "list_order";
              $obj->order_type = "desc";
              $obj->list_count = 20;
              $docu_output = executeQueryArray('widgets.widget_kgcalendar.getNewestDocuments', $obj);
              if(!$docu_output->toBool() || !$docu_output->data) return;
            }

            $content_items = array();
            if(count($docu_output->data)) {
              foreach($docu_output->data as $d_key => $d_val) {
                $oDocument = new documentItem();
                $oDocument->setAttribute($d_val, false);
                $GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
                $document_srls[] = $oDocument->document_srl;
              }
              $oDocumentModel->setToAllDocumentExtraVars();

              for($i=0,$c=count($document_srls);$i<$c;$i++) {
                $oDocument = $GLOBALS['XE_DOCUMENT_LIST'][$document_srls[$i]];
                $document_srl = $oDocument->document_srl;

                $content_item = new kgcalendarItem();
                $content_item->adds($oDocument->getObjectVars());
                $content_item->title = $oDocument->getTitle($args->subject_cut_size);
                $content_item->content = $oDocument->getContent(true, true, false, true, false);
                $content_item->summary = $oDocument->getSummary($args->content_cut_size);
                $content_item->thumbnail = $oDocument->getThumbnail($args->thumbnail_width,$args->thumbnail_height,$args->thumbnail_type);
                $content_item->regdate = $oDocument->getRegdate('Ymd');
                $content_item->extra_images = $oDocument->printExtraImages($args->duration_new * 60 * 60);
                if($oDocument->getExtraEidValue($args->extra_key_eid)) $content_item->evar_date = $oDocument->getExtraEidValue($args->extra_key_eid);
                $content_item->url = $oDocument->getPermanentUrl();

                $content_items[] = $content_item;
              }

            }




            // 템플릿 파일에서 사용할 변수들을 세팅
            $widget_info->cur_date = $obj->regdate;
            $widget_info->evar_dates = $evar_dates; //해당문서의 확장변수(날짜)를 구함
            $widget_info->today_str = sprintf('%4d%s %2d%s',zdate($obj->regdate, 'Y'), Context::getLang('unit_year'), zdate($obj->regdate,'m'), Context::getLang('unit_month'));
            $widget_info->last_day = date('t', ztime($obj->regdate));
            $widget_info->start_week= date('w', ztime($obj->regdate));

            $widget_info->prev_month = date('Ym', mktime(1,0,0,zdate($obj->regdate,'m'),1,zdate($obj->regdate,'Y'))-60*60*24);
            $widget_info->prev_year = date('Y', mktime(1,0,0,1,1,zdate($obj->regdate,'Y'))-60*60*24);
            $widget_info->next_month = date('Ym', mktime(1,0,0,zdate($obj->regdate,'m'),$widget_info->last_day,zdate($obj->regdate,'Y'))+60*60*24);
            $widget_info->next_year = date('Y', mktime(1,0,0,12,$widget_info->last_day,zdate($obj->regdate,'Y'))+60*60*24);

            $widget_info->extra_key_eid = $args->extra_key_eid;
            $widget_info->day_cell_height = $args->day_cell_height;
            $widget_info->subject_cut_size = $args->subject_cut_size;
            $widget_info->duration_new = $args->duration_new;
            $widget_info->content_cut_size = $args->content_cut_size;
            $widget_info->thumbnail_type = $args->thumbnail_type;
            $widget_info->thumbnail_width = $args->thumbnail_width;
            $widget_info->thumbnail_height = $args->thumbnail_height;
            $widget_info->font_family = $args->font_family;
            $widget_info->font_size = $args->font_size;
            $widget_info->font_color = $args->font_color;

            $widget_info->content_items = $content_items;

            Context::set('widget_info', $widget_info);

            // 위젯스킨 폴더명 설정
            $widget_skin_name = $args->skin;
            Context::set('widget_skin_name', $widget_skin_name);

            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);

            // 템플릿 파일을 지정
            $tpl_file = 'kgcalendar';

            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }
    }


    class kgcalendarItem extends Object {
      /*
      function kgcalendarItem(){
      }
      */
    }

?>
