
var ytEmbed = {
    lcount : 0,
    ytQuery: 0,
    cl: 0,
    callback: {},
    cfg: {},
    player: true,

    /**
     * Main Init Method
     */
    init: function(cfg) {
        this.cfg = cfg || {};

        if (!this.cfg.key) {
               this.cfg.key = 'AIzaSyA8OmKcw2DMNkJicyCJ0vqvf90xgeH52zE';
        }

        if (!this.cfg.block) {
            this.message('설정 파일 각각의 요소를 다시설정주세요.');
        } else {
            if (!this.cfg.type) {
                this.message('검색 조건을 선택하세요');
            } else if (!this.cfg.q && !this.cfg.id) {
                this.message('유튜브 ID, 검색 키워드, 리스트 목록ID  입력이 잘못 되었습니다. 입력후 GO GO!');
            } else if (!this.cfg.key) {
                this.message('YouTube Data Api 키를 넣어야 됩니다 : <strong><a href="https://developers.google.com/youtube/registering_an_application">Api 키 만들기</a></strong>.');
            } else {
                var script = document.createElement('script');
                script.setAttribute('type', 'text/javascript');
                this.ytQuery++;
                
                if (!this.cfg.paging) {
                    this.cfg.paging = true;
                }
                
                if (!this.cfg.results) {
                    this.cfg.results = 20;
                }
                
                if (!this.cfg.meta) {
                    this.cfg.meta = false;
                }

                if (!this.cfg.order) {
                    this.cfg.orderby = 'relevance';
                    this.cfg.sortorder = 'descending';
                }
                
                if (!this.cfg.thumbnail) {
                    this.cfg.thumbnail = 200;
                }
                
                if (!this.cfg.width) {
                    this.cfg.width = 640;
                }
                
                if (!this.cfg.height) {
                    this.cfg.height = 390;
                }

                switch (this.cfg.order) {
                    case "new_first":
                        this.cfg.orderby = 'date';
                        break;
                    case "highest_rating":
                        this.cfg.orderby = 'rating';
                        break;
                    case "most_relevance":
                        this.cfg.orderby = 'relevance';
                        break;
                }
                
                var url = "https://www.googleapis.com";
                switch (this.cfg.type) {
                    case "search":
                        url += '/youtube/v3/search?q=' + this.cfg.q + '&type=video&callback=ytEmbed.callback[' + this.ytQuery + ']&order=' + this.cfg.orderby;
                        break;
                    case "user":
                        url += '/youtube/v3/channels?forUsername=' + this.cfg.q + '&callback=ytEmbed.callback[' + this.ytQuery + ']';
                        break;
                    case "playlist":
                        url += '/youtube/v3/playlistItems?playlistId=' + this.cfg.q + '&callback=ytEmbed.callback[' + this.ytQuery + ']&order=' + this.cfg.orderby;
                        break;
                    case "videos":
                        url += '/youtube/v3/videos?id=' + this.cfg.q + '&callback=ytEmbed.callback[' + this.ytQuery + ']&order=' + this.cfg.orderby;
                        break;
                    case "featured":
                        url += '/youtube/v3/videos?chart=mostPopular&callback=ytEmbed.callback[' + this.ytQuery + ']';
                        break;
                    default:
                        this.message('설정에 문제가 있습니다. 조건 : ID,검색, 재생 목록 , 사용자 등등을 다시 설정후 시도해 보세요.');
                        return;
                        break;
                }

                if (this.cfg.type == "user") {
                    url += '&part=contentDetails';
                } else if (this.cfg.type == "search" && this.cfg.meta) {
                    url += '&part=id'; 
                } else if (this.cfg.type == "search") {
                    url += '&part=snippet,contentDetails'; 
                } else if (this.cfg.type == "videos") {
                    url += '&part=snippet,contentDetails,statistics';
                } else {
                    url += '&part=snippet,contentDetails';
                }

                if (this.cfg.type == "user") {
                    url += '&maxResults=1';
                } else if (this.cfg.results) {
                    url += '&maxResults=' + this.cfg.results;
                }

                if (this.cfg.pageToken) {
                    url += '&pageToken=' + this.cfg.pageToken;
                }

                url += '&key=' + this.cfg.key;
                url += '&prettyPrint=false';

                script.setAttribute('src', url);                
                cfg.mC = this.ytQuery;
                
                if (this.cfg.type == "user") {
                    this.callback[this.ytQuery] = function(json) {
                        if (json.pageInfo.totalResults == 1) {
                            var playlistId = json.items[0].contentDetails.relatedPlaylists.uploads;                           
                            cfg.type = 'playlist';
                            cfg.q = playlistId;
                            ytEmbed.init(cfg);
                        } else{
                            ytEmbed.message('검색에 지정된 ID, 사용자 이름으로 검색된 결과가 없습니다.');                          
                        }
                    }
                } else if ((this.cfg.type == "playlist" || this.cfg.type == "search") && this.cfg.meta) {
                    this.callback[this.ytQuery] = function(json) {
                        if (json.items) {
                            var ids = '';
                            for (var i = 0; i < json.items.length; i++) {                       
                                if (json.items[i].snippet) {
                                    ids += json.items[i].snippet.resourceId.videoId + ",";
                                } else if (json.items[i].id) {
                                    ids += json.items[i].id.videoId + ",";
                                }
                            }
                            cfg.type = 'videos';
                            cfg.q = ids;
                            ytEmbed.init(cfg);
                        } else {
                            ytEmbed.message('조건에 일치하지 안는 검색어를 입력했습니다.<br>' + json.error.message);
                        }
                    }
                } else {
                    this.callback[this.ytQuery] = function(json) {
                        ytEmbed.listVideos(json, cfg);
                    }
                }
                document.getElementsByTagName('head')[0].appendChild(script);
            }
        }

    },

    listVideos: function(json, cfg) {   	 
        this.cfg = cfg;
        if (!this.cfg.player) {
            this.cfg.player = 'embed';
        }
        if (!this.cfg.layout) {
            this.cfg.layout = 'full';
        }
        var div = document.getElementById(this.cfg.block);
        var children = div.childNodes;
        for (var i = children.length; i > -1; i--) {
            if (children[i] && (children[i].className.indexOf("error") !== -1 || children[i].tagName === "UL")) { /* is error message or result list */
                div.removeChild(children[i]);
            }
        }
        if (json.error) {
            this.message('검색 결과가 없습니다.:<br>' + json.error.message);
        } else if (json.items) {
            var ul = document.createElement('ul');
            ul.className = 'ytlist';            
            var playlist = "";
             document.getElementById("titlelist").options.length='';
             document.getElementById("img_list").options.length='';
            for (var i = 0; i < json.items.length; i++) {
                var entry = json.items[i];
                if (entry.snippet && entry.snippet.resourceId) {               	
                    var id = entry.snippet.resourceId.videoId;
                } else if (entry.id.videoId) {
                    var id = entry.id.videoId;
                } else {
                    var id = entry.id;
                }           
                var li = document.createElement('li');
                li.className = 'list_'+i;
                var a = document.createElement('a');
                a.className = 'clip';

                if (this.cfg.player == 'embed') {
                    a.style.cursor = 'pointer';
                    if (a.addEventListener) {
                        a.addEventListener('click', this.playVideo.bind(this, {
                            'id': id,
                            'cfg': cfg
                        }), false);
                    } else if (a.attachEvent) {
                        a.attachEvent('onclick', this.playVideo.bind(this, {
                            'id': id,
                            'cfg': cfg
                        }));
                    }
                } else {
                    a.setAttribute('href', 'https://www.youtube.com/watch?v=' + id);
                }

                var span = document.createElement('span');
                span.className = 'list_img';
                a.appendChild(span);
                var img = document.createElement('img');
                img.setAttribute('src', (entry.snippet.thumbnails ? entry.snippet.thumbnails.medium.url : ''));
                span.appendChild(img);
                var em = document.createElement('em');
                span.appendChild(em);

                if (this.cfg.layout == 'full') {                                 
                    var pattern = /[ \{\}\[\]\/?.,;:|\)*~`!^\-_+┼<>@\#$%&\'\"\\\(\=]/gi;
                    if(entry.snippet.title.length > 50){
                       entry.snippet.title = entry.snippet.title.substr(0, 50) + '...';
                    }
                    var ytdescription = this.formatDescription(entry.snippet.description);
                    if(ytdescription.length > 60){
                       ytdescription = ytdescription.substr(0, 60) + '...';
                    }
                    var ytimg = entry.snippet.thumbnails ? entry.snippet.thumbnails.default.url : '';
                    if(id){                    	 
                        var p_title =entry.snippet.title.replace(pattern," ");
                        var media_url = 'https://www.youtube.com/watch?v=' + id;
                    }
                    if(ytimg){
                        var p_imgtitle = i + id+".jpg";
                        var p_image = ytimg;
                    }else{
                    	 var p_imgtitle = 'none';
                        var p_image = 'none';
                    } 
                    if(ytdescription){                     	                  	 
                        var p_description = ytdescription.replace(pattern," ");
                    }
                                       
                    document.getElementById("titlelist").options.add(new Option(p_title, media_url) );
                    document.getElementById("img_list").options.add(new Option(p_imgtitle, p_image) );
                    document.getElementById("cap_list").options.add(new Option('', '') );
                    document.getElementById("description").value += p_description+'|';    
                                                                                
                    li.innerHTML ='<table cellspacing="0" cellpadding="0" border="0"><tr><td valign="top" rowspan="2" class="ytplay"></td><td valign="top" class="list_di"><input type="checkbox" class="list" name="list" value="'+i+'" /><span class="list_tit">' + p_title + '</span></br><span class="list_des">' + p_description + '</span></br><span>' + (entry.contentDetails ? 'Duration: ' + ytEmbed.formatDuration(entry.contentDetails.duration)   : '') + (entry.statistics ? '&nbsp; &nbsp; 조회수: ' + entry.statistics.viewCount : '') + '&nbsp; &nbsp 소유자: <a href="http://www.youtube.com/profile?user=' + entry.snippet.channelTitle + '">' + entry.snippet.channelTitle + '</a></span></td></tr></table>'; 
                    li.firstChild.firstChild.firstChild.firstChild.appendChild(a);
                }
                ul.appendChild(li);
            }

            if (this.cfg.position == "fixed_bottom") {
                div.style.position = "fixed";
                div.style.bottom = '0px';
                div.style.left = '0px';
            }
            div.appendChild(ul);

            if (this.cfg.playlist == true) {
                this.cfg.playerVars.playlist = playlist.substr(0, playlist.length - 1);
            }

            if (this.cfg.player == "embed" && this.cfg.display_first == true) {
                ytPlayerParams.videoId = id;
                if (this.cfg.playerVars) {
                    ytPlayerParams.playerVars = this.cfg.playerVars;
                }
                this.player = this.createPlayer(this.cfg);
            }

            if (this.cfg.paging == true && json.nextPageToken) {
                this.cfg.display_first = false;
                var pul = document.createElement('ul');
                pul.setAttribute('id', 'ytPage');
                if (json.nextPageToken) {
                    var li = document.createElement('li');
                    var a = document.createElement('a');
                    a.className = 'ytNext';
                    a.style.cursor = 'pointer';
                    li.appendChild(a);
                    
                    if (a.addEventListener) {
                        a.addEventListener('click', ytEmbed.loadNext.bind(this, {
                            cfg: cfg,
                            token: json.nextPageToken
                        }), false);
                    }
                    a.innerHTML = 'Load next...';
                    li.appendChild(a); 
                    pul.appendChild(li);
                }

                if (json.prevPageToken) {
                    var li = document.createElement('li');
                    var a = document.createElement('a');
                    a.setAttribute('class', 'ytPrev');
                    a.style.cursor = 'pointer';
                    if (a.addEventListener) {
                        a.addEventListener('click', ytEmbed.loadPrevious.bind(this, {
                            cfg: cfg,
                            token: json.prevPageToken
                        }), false);
                    }
                    a.innerHTML = 'Load previous...';
                    li.appendChild(a);
                    pul.appendChild(li);
                }
                div.appendChild(pul);
            }
        } else {
            this.message('No YouTube videos found for your query:<br>Type:\'' + this.cfg.type + '\'<br>Query: \'' + this.cfg.q + '\'');
        }
    },

    createPlayer: function(cfg) {
        var div = document.getElementById(cfg.block);
        var hold = document.createElement('div');
        hold.className = 'ytPlayer';
        var iframe = document.createElement('iframe');
        iframe.setAttribute('id', cfg.block + 'Player');
        iframe.setAttribute('width', '640');
        iframe.setAttribute('height', '390');
        iframe.setAttribute('frameBorder', '0');
        iframe.setAttribute('src', 'http://www.youtube.com/embed/' + ytPlayerParams.videoId + '?autoplay=' + ytPlayerParams.autoplay + '&modestbranding=1'); 
        hold.appendChild(iframe);
        div.insertBefore(hold, div.firstChild);
        return iframe;
    },

    formatRating: function(rt, rc) {
                 
    },

    formatDuration: function(dr) {
        return dr.replace(/(M|H)/g, ':').replace("S", "").substr(2);
    },

    formatDescription: function(ds) {    	
        if (ds) {
            if (ds.length > 120) {
                return ds.substr(0, 120) + '...';
            } else {
                return ds;
            }
        } else {
            return "No description available.";
        }
    },

    formatDate: function(dt) {
        if (dt) {
            return dt.substr(0, 10)
        } else {
            return "unknown";
        }
    },

    mousOverImage: function(a, b, c) {

    },

    mouseOutImage: function(a, b) {

    },

    loadNext: function(data) {
        data.cfg.pageToken = data.token;
        ytEmbed.init(data.cfg);
    },

    loadPrevious: function(data) {
        data.cfg.pageToken = data.token;
        ytEmbed.init(data.cfg);
    },

    sortList: function(json) {

    },

    playVideo: function(data) {
        console.log(data);
        if (data.cfg.parent) {
            var player = document.getElementById(data.cfg.parent + "Player");
        } else {
            var player = document.getElementById(data.cfg.block + "Player");
        }

        if (!player) {
            ytPlayerParams.videoId = data.id;
            ytPlayerParams.autoplay = 1;

            this.createPlayer(data.cfg);
        } else {
            player.setAttribute('src', 'http://www.youtube.com/embed/' + data.id + '?autoplay=1&modestbranding=1&origin=' + document.location.protocol + '//' + document.location.hostname);
        }
    },

    test: function(e, b) {
        console.log(e);
        console.log(b);
        console.log(this.cfg.block);
    },

    onPlayerReady: function(id) {
    },
    onPlayerStateChange: function(id) {
    },

    message: function(msg) {
        if (!ytEmbed.cfg.block) {
        } else {
            document.getElementById(ytEmbed.cfg.block).innerHTML = '<div class="error">' + msg + '</div>';
        }
    }
};

var ytPlayer;
var ytPlayerParams = {
    autoplay: 0,
    modestbranding: 1,
    events: {
        'onReady': ytEmbed.onPlayerReady,
        'onStateChange': ytEmbed.onPlayerStateChange
    }
};
