<?php
    /**
     * @class  multimedia_link
     * @author NHN (developers@xpressengine.com)
     * @brief  본문에 멀티미디어 자료를 연결하는 컴포넌트
     **/

    class eh_player extends EditorHandler { 

        // editor_sequence 는 에디터에서 필수로 달고 다녀야 함....
        var $editor_sequence = 0;
        var $component_path = '';

        /**
         * @brief editor_sequence과 컴포넌트의 경로를 받음
         **/
        function eh_player($editor_sequence, $component_path) {
            $this->editor_sequence = $editor_sequence;
            $this->component_path = $component_path; 
			      $upload_target_srl = $_SESSION['upload_info'][$editor_sequence]->upload_target_srl;
            
			      $oFileModel = &getModel('file');
			      // 첨부파일 캡션 url 목록을 구함
			      $tmp_file_list = $oFileModel->getFiles($upload_target_srl);
			      $file_count = count($tmp_file_list);
  	                  
			      for($i=0;$i<$file_count;$i++){			        
			        if(preg_match("/\.(srt|vtt|dfxp)$/i",$tmp_file_list[$i]->source_filename)){
                $upfile_name[] = array($tmp_file_list[$i]->source_filename,$tmp_file_list[$i]->uploaded_filename);               
              }else if(preg_match("/\.(jpg|jpeg|gif|png|bmp)$/i",$tmp_file_list[$i]->source_filename)){
                $upfile_img[] = array($tmp_file_list[$i]->source_filename,$tmp_file_list[$i]->uploaded_filename);               
              }             
            }  
            Context::set("upfile_name", $upfile_name); 
            Context::set("upfile_img", $upfile_img); 
                                
        }
      
        /**
         * @brief popup window요청시 popup window에 출력할 내용을 추가하면 된다
         **/
        function getPopupContent() {
            // 템플릿을 미리 컴파일해서 컴파일된 소스를 return

		        $skin_path = $this->component_path."skins";
		        $skin_list = array();
             
		        $oDir = dir($skin_path);
		        while($file = $oDir->read())
		        {
		        	if(substr($file,0,1)=='.') continue;		        
		        	if(preg_match('/\.(xml)$/i',$file)) $skin_list[] = $file;
		        }
		        $oDir->close();
		        Context::set('skin_list', $skin_list);		        			        
		        $tpl_path = $this->component_path.'tpl';
		        $tpl_file = 'popup.html';
            Context::set("tpl_path", $tpl_path);   
            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);      
        }
		    
		      
          //debugPrint($skin_list );
        /**
         * @brief 에디터 컴포넌트가 별도의 고유 코드를 이용한다면 그 코드를 html로 변경하여 주는 method
         *
         * 이미지나 멀티미디어, 설문등 고유 코드가 필요한 에디터 컴포넌트는 고유코드를 내용에 추가하고 나서
         * DocumentModule::transContent() 에서 해당 컴포넌트의 transHtml() method를 호출하여 고유코드를 html로 변경
         **/
        function transHTML($xml_obj) {
          //아래 $jwkey에 jwplayer 라이센스 키값을 입력하세요 *** Ex)$jwkey = 'aaaaaaaaaabbbbbbbccccccccccccddddddddd=';           
        	  $jwkey = '';
            $p_list = $xml_obj->attrs->p_list;            
            $jw_js = sprintf("%sjwplayer.js",$this->component_path);	    	        	
	        	$skinfile = $xml_obj->attrs->skinfile; 
	        	$style = $xml_obj->attrs->style;	        	 
	        	$idex = explode(",", $xml_obj->attrs->jwcaptions); 	        		        		        	
	        	if( $idex > 0){	
	        		 $cc = count($idex)-1;       					
					    for($i=0; $i < $cc; $i++)
					    {
					    	$jwcapurl = explode(':', $idex[$i]);
                $jwcap=trim('{file:"'.$jwcapurl[1] .'",label:"').trim($jwcapurl[0] .'",kind:"captions",');
                if($i == 0){
                	$jwcap	=	$jwcap. '"default": true},';
                }else{$jwcap	=	$jwcap ."},";}
                $jwcaptions = $jwcaptions.$jwcap;				                              					                                 					    
              }
              $jwcaptions ='tracks:['.$jwcaptions.']';
					  }else{
					  	$jwcaptions ='';
					  }  
	        	                      
        	  $jurllink = $xml_obj->attrs->jurllink;
        	  if($jurllink == "Y"){
        	     $dock = "sharing: {},";
        	  }else{
        	     $dock ="";
        	  } 
		        $p_size = explode(",", $xml_obj->attrs->p_size);
		        $width = trim($p_size[0]);   
		        $height = trim($p_size[1]);   	      	  		        	
	          	    	
	        	if(!$width) $width = 460;
	        	if(!$height) $height = 320;	        	 	        	
	        	$id = rand(20,40)*333;
	        //debugPrint($width);	        
            $autostart = $xml_obj->attrs->autostart;  
            $p_plugins = $xml_obj->attrs->p_plugins;
            $jwbox = jwbox.$id;                                                    
            if(Mobile::isMobileCheckByAgent()){
                $da = "primary:'html5',";
                $playlist_bar = $xml_obj->attrs->playlist_bar;                                
              if ($playlist_bar!=""){
              	$listbar_size=200;  
                $playlist_bar = "listbar:{position:'bottom', size:".$listbar_size."},";                
          
              }else{                   
                $listbar_size= 0;        	    
	        	  } 
              $jre ='<script>
                     jQuery(document).ready(function() {
                         jQuery(window).resize();
                     });                                                                                                                                                               
                     jQuery(window).resize(function(){
                         var width = jQuery("#'.$jwbox.'").width();
                         var aspectRatio = 5/12; 
                         var height = (width * aspectRatio)+ '.$listbar_size.';                              
                         jwplayer().resize(width,height);                                                                                     
                     });                            
                  </script>';	        	   	                 
            }else if(!Mobile::isMobileCheckByAgent()){
                $da = "primary:'flash',";
                $playlist_bar = $xml_obj->attrs->playlist_bar;
                $jre ='';
            }   
	        	
	        	if($jwkey ==''){ 
	        		$jwkey ='';
	        	}else{	                                    
              $jwkey="<script type=\"text/javascript\">jwplayer.key = \"$jwkey\"</script>";
            }  
          return sprintf("<div id=\"jwbox$id\" ><div id=\"jw$id\">jwplayer</div>$jre </div><script type=\"text/javascript\" src=\"$jw_js\"> </script> $jwkey <script type=\"text/javascript\">jwplayer(\"jw$id\").setup({ $p_list $playlist_bar $skinfile $da $dock height:\"$height\",width:\"$width\",$autostart $p_plugins });</script></br>");
       
        }
    }
?>
