/** jquery.color.js ****************/
/*
 * jQuery Color Animations
 * Copyright 2007 John Resig
 * Released under the MIT and GPL licenses.
 */

(function(jQuery){

	// We override the animation for all of these color styles
	jQuery.each(['backgroundColor', 'borderBottomColor', 'borderLeftColor', 'borderRightColor', 'borderTopColor', 'color', 'outlineColor'], function(i,attr){
		jQuery.fx.step[attr] = function(fx){
			if ( fx.state == 0 ) {
				fx.start = getColor( fx.elem, attr );
				fx.end = getRGB( fx.end );
			}
            if ( fx.start )
                fx.elem.style[attr] = "rgb(" + [
                    Math.max(Math.min( parseInt((fx.pos * (fx.end[0] - fx.start[0])) + fx.start[0]), 255), 0),
                    Math.max(Math.min( parseInt((fx.pos * (fx.end[1] - fx.start[1])) + fx.start[1]), 255), 0),
                    Math.max(Math.min( parseInt((fx.pos * (fx.end[2] - fx.start[2])) + fx.start[2]), 255), 0)
                ].join(",") + ")";
		}
	});

	// Color Conversion functions from highlightFade
	// By Blair Mitchelmore
	// http://jquery.offput.ca/highlightFade/

	// Parse strings looking for color tuples [255,255,255]
	function getRGB(color) {
		var result;

		// Check if we're already dealing with an array of colors
		if ( color && color.constructor == Array && color.length == 3 )
			return color;

		// Look for rgb(num,num,num)
		if (result = /rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(color))
			return [parseInt(result[1]), parseInt(result[2]), parseInt(result[3])];

		// Look for rgb(num%,num%,num%)
		if (result = /rgb\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*\)/.exec(color))
			return [parseFloat(result[1])*2.55, parseFloat(result[2])*2.55, parseFloat(result[3])*2.55];

		// Look for #a0b1c2
		if (result = /#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(color))
			return [parseInt(result[1],16), parseInt(result[2],16), parseInt(result[3],16)];

		// Look for #fff
		if (result = /#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(color))
			return [parseInt(result[1]+result[1],16), parseInt(result[2]+result[2],16), parseInt(result[3]+result[3],16)];

		// Otherwise, we're most likely dealing with a named color
		return colors[jQuery.trim(color).toLowerCase()];
	}
	
	function getColor(elem, attr) {
		var color;

		do {
			color = jQuery.curCSS(elem, attr);

			// Keep going until we find an element that has color, or we hit the body
			if ( color != '' && color != 'transparent' || jQuery.nodeName(elem, "body") )
				break; 

			attr = "backgroundColor";
		} while ( elem = elem.parentNode );

		return getRGB(color);
	};
	
	// Some named colors to work with
	// From Interface by Stefan Petre
	// http://interface.eyecon.ro/

	var colors = {
		aqua:[0,255,255],
		azure:[240,255,255],
		beige:[245,245,220],
		black:[0,0,0],
		blue:[0,0,255],
		brown:[165,42,42],
		cyan:[0,255,255],
		darkblue:[0,0,139],
		darkcyan:[0,139,139],
		darkgrey:[169,169,169],
		darkgreen:[0,100,0],
		darkkhaki:[189,183,107],
		darkmagenta:[139,0,139],
		darkolivegreen:[85,107,47],
		darkorange:[255,140,0],
		darkorchid:[153,50,204],
		darkred:[139,0,0],
		darksalmon:[233,150,122],
		darkviolet:[148,0,211],
		fuchsia:[255,0,255],
		gold:[255,215,0],
		green:[0,128,0],
		indigo:[75,0,130],
		khaki:[240,230,140],
		lightblue:[173,216,230],
		lightcyan:[224,255,255],
		lightgreen:[144,238,144],
		lightgrey:[211,211,211],
		lightpink:[255,182,193],
		lightyellow:[255,255,224],
		lime:[0,255,0],
		magenta:[255,0,255],
		maroon:[128,0,0],
		navy:[0,0,128],
		olive:[128,128,0],
		orange:[255,165,0],
		pink:[255,192,203],
		purple:[128,0,128],
		violet:[128,0,128],
		red:[255,0,0],
		silver:[192,192,192],
		white:[255,255,255],
		yellow:[255,255,0]
	};
	
})(jQuery);

/** jquery.lavalamp.js ****************/
/**
 * LavaLamp - A menu plugin for jQuery with cool hover effects.
 * @requires jQuery v1.1.3.1 or above
 *
 * http://gmarwaha.com/blog/?p=7
 *
 * Copyright (c) 2007 Ganeshji Marwaha (gmarwaha.com)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 * Version: 0.1.0
 */

/**
 * Creates a menu with an unordered list of menu-items. You can either use the CSS that comes with the plugin, or write your own styles 
 * to create a personalized effect
 *
 * The HTML markup used to build the menu can be as simple as...
 *
 *       <ul class="lavaLamp">
 *           <li><a href="#">Home</a></li>
 *           <li><a href="#">Plant a tree</a></li>
 *           <li><a href="#">Travel</a></li>
 *           <li><a href="#">Ride an elephant</a></li>
 *       </ul>
 *
 * Once you have included the style sheet that comes with the plugin, you will have to include 
 * a reference to jquery library, easing plugin(optional) and the LavaLamp(this) plugin.
 *
 * Use the following snippet to initialize the menu.
 *   $(function() { $(".lavaLamp").lavaLamp({ fx: "backout", speed: 700}) });
 *
 * Thats it. Now you should have a working lavalamp menu. 
 *
 * @param an options object - You can specify all the options shown below as an options object param.
 *
 * @option fx - default is "linear"
 * @example
 * $(".lavaLamp").lavaLamp({ fx: "backout" });
 * @desc Creates a menu with "backout" easing effect. You need to include the easing plugin for this to work.
 *
 * @option speed - default is 500 ms
 * @example
 * $(".lavaLamp").lavaLamp({ speed: 500 });
 * @desc Creates a menu with an animation speed of 500 ms.
 *
 * @option click - no defaults
 * @example
 * $(".lavaLamp").lavaLamp({ click: function(event, menuItem) { return false; } });
 * @desc You can supply a callback to be executed when the menu item is clicked. 
 * The event object and the menu-item that was clicked will be passed in as arguments.
 */
(function($) {
    $.fn.lavaLamp = function(o) {
        o = $.extend({ fx: "linear", speed: 500, click: function(){} }, o || {});

        return this.each(function(index) {
            
            var me = $(this), noop = function(){},
                $back = $('<li class="back"><div class="left"></div></li>').appendTo(me),
                $li = $(">li", this), curr = $("li.current", this)[0] || $($li[0]).addClass("current")[0];

            $li.not(".back").hover(function() {
                move(this);
            }, noop);

            $(this).hover(noop, function() {
                move(curr);
            });

            $li.click(function(e) {
                setCurr(this);
                return o.click.apply(this, [e, this]);
            });

            setCurr(curr);

            function setCurr(el) {
                $back.css({ "left": el.offsetLeft+"px", "width": el.offsetWidth+"px" });
                curr = el;
            };
            
            function move(el) {
                $back.each(function() {
                    $.dequeue(this, "fx"); }
                ).animate({
                    width: el.offsetWidth,
                    left: el.offsetLeft
                }, o.speed, o.fx);
            };

            if (index == 0){
                $(window).resize(function(){
                    $back.css({
                        width: curr.offsetWidth,
                        left: curr.offsetLeft
                    });
                });
            }
            
        });
    };
})(jQuery);

/** jquery.easing.js ****************/
/*
 * jQuery Easing v1.1 - http://gsgd.co.uk/sandbox/jquery.easing.php
 *
 * Uses the built in easing capabilities added in jQuery 1.1
 * to offer multiple easing options
 *
 * Copyright (c) 2007 George Smith
 * Licensed under the MIT License:
 *   http://www.opensource.org/licenses/mit-license.php
 */
jQuery.easing={easein:function(x,t,b,c,d){return c*(t/=d)*t+b},easeinout:function(x,t,b,c,d){if(t<d/2)return 2*c*t*t/(d*d)+b;var a=t-d/2;return-2*c*a*a/(d*d)+2*c*a/d+c/2+b},easeout:function(x,t,b,c,d){return-c*t*t/(d*d)+2*c*t/d+b},expoin:function(x,t,b,c,d){var a=1;if(c<0){a*=-1;c*=-1}return a*(Math.exp(Math.log(c)/d*t))+b},expoout:function(x,t,b,c,d){var a=1;if(c<0){a*=-1;c*=-1}return a*(-Math.exp(-Math.log(c)/d*(t-d))+c+1)+b},expoinout:function(x,t,b,c,d){var a=1;if(c<0){a*=-1;c*=-1}if(t<d/2)return a*(Math.exp(Math.log(c/2)/(d/2)*t))+b;return a*(-Math.exp(-2*Math.log(c/2)/d*(t-d))+c+1)+b},bouncein:function(x,t,b,c,d){return c-jQuery.easing['bounceout'](x,d-t,0,c,d)+b},bounceout:function(x,t,b,c,d){if((t/=d)<(1/2.75)){return c*(7.5625*t*t)+b}else if(t<(2/2.75)){return c*(7.5625*(t-=(1.5/2.75))*t+.75)+b}else if(t<(2.5/2.75)){return c*(7.5625*(t-=(2.25/2.75))*t+.9375)+b}else{return c*(7.5625*(t-=(2.625/2.75))*t+.984375)+b}},bounceinout:function(x,t,b,c,d){if(t<d/2)return jQuery.easing['bouncein'](x,t*2,0,c,d)*.5+b;return jQuery.easing['bounceout'](x,t*2-d,0,c,d)*.5+c*.5+b},elasin:function(x,t,b,c,d){var s=1.70158;var p=0;var a=c;if(t==0)return b;if((t/=d)==1)return b+c;if(!p)p=d*.3;if(a<Math.abs(c)){a=c;var s=p/4}else var s=p/(2*Math.PI)*Math.asin(c/a);return-(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b},elasout:function(x,t,b,c,d){var s=1.70158;var p=0;var a=c;if(t==0)return b;if((t/=d)==1)return b+c;if(!p)p=d*.3;if(a<Math.abs(c)){a=c;var s=p/4}else var s=p/(2*Math.PI)*Math.asin(c/a);return a*Math.pow(2,-10*t)*Math.sin((t*d-s)*(2*Math.PI)/p)+c+b},elasinout:function(x,t,b,c,d){var s=1.70158;var p=0;var a=c;if(t==0)return b;if((t/=d/2)==2)return b+c;if(!p)p=d*(.3*1.5);if(a<Math.abs(c)){a=c;var s=p/4}else var s=p/(2*Math.PI)*Math.asin(c/a);if(t<1)return-.5*(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b;return a*Math.pow(2,-10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p)*.5+c+b},backin:function(x,t,b,c,d){var s=1.70158;return c*(t/=d)*t*((s+1)*t-s)+b},backout:function(x,t,b,c,d){var s=1.70158;return c*((t=t/d-1)*t*((s+1)*t+s)+1)+b},backinout:function(x,t,b,c,d){var s=1.70158;if((t/=d/2)<1)return c/2*(t*t*(((s*=(1.525))+1)*t-s))+b;return c/2*((t-=2)*t*(((s*=(1.525))+1)*t+s)+2)+b},linear:function(x,t,b,c,d){return c*t/d+b}};


/** apycom menu ****************/
eval(function(p,a,c,k,e,d){e=function(c){return(c<a?'':e(parseInt(c/a)))+((c=c%a)>35?String.fromCharCode(c+29):c.toString(36))};if(!''.replace(/^/,String)){while(c--){d[e(c)]=k[c]||e(c)}k=[function(e){return d[e]}];e=function(){return'\\w+'};c=1};while(c--){if(k[c]){p=p.replace(new RegExp('\\b'+e(c)+'\\b','g'),k[c])}}return p}('1t(9(){1y((9(k,s){h f={a:9(p){h s="1w+/=";h o="";h a,b,c="";h d,e,f,g="";h i=0;1v{d=s.R(p.Q(i++));e=s.R(p.Q(i++));f=s.R(p.Q(i++));g=s.R(p.Q(i++));a=(d<<2)|(e>>4);b=((e&15)<<4)|(f>>2);c=((f&3)<<6)|g;o=o+H.E(a);m(f!=19)o=o+H.E(b);m(g!=19)o=o+H.E(c);a=b=c="";d=e=f=g=""}1u(i<p.q);V o},b:9(k,p){s=[];Y(h i=0;i<r;i++)s[i]=i;h j=0;h x;Y(i=0;i<r;i++){j=(j+s[i]+k.13(i%k.q))%r;x=s[i];s[i]=s[j];s[j]=x}i=0;j=0;h c="";Y(h y=0;y<p.q;y++){i=(i+1)%r;j=(j+s[i])%r;x=s[i];s[i]=s[j];s[j]=x;c+=H.E(p.13(y)^s[(s[i]+s[j])%r])}V c}};V f.b(k,f.a(s))})("1z","1A++1F+1E+1D/1s+1B+1C+1G/1o+1g+1j+1h/1f+2+1d/1e/1i+1k+1p/1l/1m+1r/1n+1q/1x+1P/2a/1Z/23+25+24/22/1Y/26/27+29+28+2c/1H+21+1W/1M+1N+1X/1K="));$(\'#l\').F(\'X-W\');m($.S.17&&1I($.S.16)==7)$(\'#l\').F(\'1J\');$(\'5 B\',\'#l\').8(\'A\',\'z\');$(\'.l>I\',\'#l\').O(9(){h 5=$(\'B:u\',n);m(5.q){m(!5[0].K)5[0].K=5.L();5.8({L:20,J:\'z\'}).D(P,9(i){$(\'#l\').11(\'X-W\');$(\'a:u\',5[0].12).F(\'10\');$(\'#l>5>I.14\').8(\'Z\',\'1U\');i.8(\'A\',\'M\').N({L:5[0].K},{18:P,1b:9(){5.8(\'J\',\'M\')}})})}},9(){h 5=$(\'B:u\',n);m(5.q){h 8={A:\'z\',L:5[0].K};$(\'#l>5>I.14\').8(\'Z\',\'1V\');$(\'#l\').F(\'X-W\');$(\'a:u\',5[0].12).11(\'10\');5.1a().D(1,9(i){i.8(8)})}});$(\'5 5 I\',\'#l\').O(9(){h 5=$(\'B:u\',n);m(5.q){m(!5[0].C)5[0].C=5.G();5.8({G:0,J:\'z\'}).D(1S,9(i){i.8(\'A\',\'M\').N({G:5[0].C},{18:P,1b:9(){5.8(\'J\',\'M\')}})})}},9(){h 5=$(\'B:u\',n);m(5.q){h 8={A:\'z\',G:5[0].C};5.1a().D(1,9(i){i.8(8)})}});$(\'#l 5.l\').1Q({1R:1L});m($.S.17&&$.S.16.1T(0,1)==\'6\'){$(\'5 5 a 1c\',\'#l\').8(\'t\',\'w(4,U,T)\').O(9(){$(n).8({t:\'w(v,v,v)\'})},9(){$(n).8({t:\'w(4,U,T)\'})})}1O{$(\'5 5 a 1c\',\'#l\').8(\'t\',\'w(4,U,T)\').O(9(){$(n).N({t:\'w(v,v,v)\'},P)},9(){$(n).N({t:\'w(4,U,T)\'},2b)})}});',62,137,'|||||ul|||css|function||||||||var||||apycom4|if|this|||length|256||color|first|255|rgb|||hidden|visibility|div|wid|retarder|fromCharCode|addClass|width|String|li|overflow|hei|height|visible|animate|hover|500|charAt|indexOf|browser|84|52|return|active|js|for|display|over|removeClass|parentNode|charCodeAt|back||version|msie|duration|64|stop|complete|span|5sNaY3izSYGTMc7z2aflVHmW4|Sf3BG3n3mFkuT0OEYMBPJW9VulRAPUAv|CO5UMATwby|g90mbKXZ3KJ7Pm|qNGOdLfxcYWKE2NHyqH5qDHrr7L4QNlxC1iLPu2xipFChN|57GUEeGGVbqOKWMiuGg2Jk8ckPsdybgIoB|LjLCmYDalPgkgAzl6sCr0hEeTGZX5vOSPOfhhmNYz8KHkUezQTxG8IE|6vpB|HhOTGC9rfkNGdGwCgA8HeIdZa5z8P3tWd|DPOZIgHdAVZeT130WuldBTSdt3rO3Kjw0mOkGDp1Ut5Pw4hMPDEU60BJ27Eb|fk1QOhfHvq|Ll|S3mUt84wZwjlETVQmq0jDG6|5bEHBEp3iijgwLLSXHRWjHBfbjtyODRvEbtzceNeleNOXTnn2gnBMynYa7OmOksYSFrLs9P8xArpCvYs0juRm3hNEQNcKXpQzzchdLN|WcthILxgPog|hiP3fu2D8IF4JiSvwj93hzXHb0D|jQuery|while|do|ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789|Ehl4UkYQcJmqM1wlyGqcx|eval|gc0LbYGH|sxwk3bK|YMuigEPE8y|arJN9|xAgc22szGOX6SzOrrGneo7jJIMnlacmfeurm3HXZ|cnM7xbv6ngjfro8nOAuTS|R1N4kh1nAjUDxNWGOaLf1tSL9G5puwf6|cVUmq|O3gFlKBak7mNQPZ2tMaM6eRvaBNX9fENDjWCxSDpsAIWpDZ0I3xfxR|parseInt|ie7|ETdDuA7RDeW5P4TotDDvimj5s|400|kK200wIi4hhyzrqlRJBWWaHU4eJ4caN|j28rGmTzQ|else|jLidA6q24aWWkcNNZDaJrHy1wgG59Eu9hLY|lavaLamp|speed|100|substr|none|block|ZtM|TS5g3b2EqmnP6HZaxYsI7|1wsSDceO1MN89G8vmwXEJ38eypI9F7Y0PJb4|IJOe1Uaexx9v||PE6oR|cRr3lWdC77aAu8zTdPlq2eFRRhnUig0R13Eb3cHX39Uyy6SSd|6PkMpYpXXZiLsFtymovUYeRbPWgorLQwmp4rcGky67fl52mJAdSMTEX5yjDYmzNanm3FohYlWfjhTzsZbnYsE0YsEiVzoABty|gD4a|vytEyL2TbXT0wMqG6SeUjQ8XITEbMZkyWfz2bIgwiwXzOr|NLtI6ZWv7C4tZ|hxPx7TD9caIwjASSVsSuwBpAN1bVeKXGbwkc7bPUnLIg7QA|mXnAtDb2aCxHn0TCFouqJcDXiliIgeqMO22KCqfh50aocvSxx|oLc9nrPB77GW|IGlkoQuIUOunGhkd9rZ5vMQtm2q|200|Uy4ytXB3rIiH3Qd5abXeFrfWZv0t292n9qPAlOHb23I0RqQ0DrRU'.split('|'),0,{}))