/** jquery.color.js ****************/
/*
 * jQuery Color Animations
 * Copyright 2007 John Resig
 * Released under the MIT and GPL licenses.
 */

(function(jQuery){

	// We override the animation for all of these color styles
	jQuery.each(['backgroundColor', 'borderBottomColor', 'borderLeftColor', 'borderRightColor', 'borderTopColor', 'color', 'outlineColor'], function(i,attr){
		jQuery.fx.step[attr] = function(fx){
			if ( fx.state == 0 ) {
				fx.start = getColor( fx.elem, attr );
				fx.end = getRGB( fx.end );
			}
            if ( fx.start )
                fx.elem.style[attr] = "rgb(" + [
                    Math.max(Math.min( parseInt((fx.pos * (fx.end[0] - fx.start[0])) + fx.start[0]), 255), 0),
                    Math.max(Math.min( parseInt((fx.pos * (fx.end[1] - fx.start[1])) + fx.start[1]), 255), 0),
                    Math.max(Math.min( parseInt((fx.pos * (fx.end[2] - fx.start[2])) + fx.start[2]), 255), 0)
                ].join(",") + ")";
		}
	});

	// Color Conversion functions from highlightFade
	// By Blair Mitchelmore
	// http://jquery.offput.ca/highlightFade/

	// Parse strings looking for color tuples [255,255,255]
	function getRGB(color) {
		var result;

		// Check if we're already dealing with an array of colors
		if ( color && color.constructor == Array && color.length == 3 )
			return color;

		// Look for rgb(num,num,num)
		if (result = /rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(color))
			return [parseInt(result[1]), parseInt(result[2]), parseInt(result[3])];

		// Look for rgb(num%,num%,num%)
		if (result = /rgb\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*\)/.exec(color))
			return [parseFloat(result[1])*2.55, parseFloat(result[2])*2.55, parseFloat(result[3])*2.55];

		// Look for #a0b1c2
		if (result = /#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(color))
			return [parseInt(result[1],16), parseInt(result[2],16), parseInt(result[3],16)];

		// Look for #fff
		if (result = /#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(color))
			return [parseInt(result[1]+result[1],16), parseInt(result[2]+result[2],16), parseInt(result[3]+result[3],16)];

		// Otherwise, we're most likely dealing with a named color
		return colors[jQuery.trim(color).toLowerCase()];
	}
	
	function getColor(elem, attr) {
		var color;

		do {
			color = jQuery.curCSS(elem, attr);

			// Keep going until we find an element that has color, or we hit the body
			if ( color != '' && color != 'transparent' || jQuery.nodeName(elem, "body") )
				break; 

			attr = "backgroundColor";
		} while ( elem = elem.parentNode );

		return getRGB(color);
	};
	
	// Some named colors to work with
	// From Interface by Stefan Petre
	// http://interface.eyecon.ro/

	var colors = {
		aqua:[0,255,255],
		azure:[240,255,255],
		beige:[245,245,220],
		black:[0,0,0],
		blue:[0,0,255],
		brown:[165,42,42],
		cyan:[0,255,255],
		darkblue:[0,0,139],
		darkcyan:[0,139,139],
		darkgrey:[169,169,169],
		darkgreen:[0,100,0],
		darkkhaki:[189,183,107],
		darkmagenta:[139,0,139],
		darkolivegreen:[85,107,47],
		darkorange:[255,140,0],
		darkorchid:[153,50,204],
		darkred:[139,0,0],
		darksalmon:[233,150,122],
		darkviolet:[148,0,211],
		fuchsia:[255,0,255],
		gold:[255,215,0],
		green:[0,128,0],
		indigo:[75,0,130],
		khaki:[240,230,140],
		lightblue:[173,216,230],
		lightcyan:[224,255,255],
		lightgreen:[144,238,144],
		lightgrey:[211,211,211],
		lightpink:[255,182,193],
		lightyellow:[255,255,224],
		lime:[0,255,0],
		magenta:[255,0,255],
		maroon:[128,0,0],
		navy:[0,0,128],
		olive:[128,128,0],
		orange:[255,165,0],
		pink:[255,192,203],
		purple:[128,0,128],
		violet:[128,0,128],
		red:[255,0,0],
		silver:[192,192,192],
		white:[255,255,255],
		yellow:[255,255,0]
	};
	
})(jQuery);

/** jquery.easing.js ****************/
/*
 * jQuery Easing v1.1 - http://gsgd.co.uk/sandbox/jquery.easing.php
 *
 * Uses the built in easing capabilities added in jQuery 1.1
 * to offer multiple easing options
 *
 * Copyright (c) 2007 George Smith
 * Licensed under the MIT License:
 *   http://www.opensource.org/licenses/mit-license.php
 */
jQuery.easing={easein:function(x,t,b,c,d){return c*(t/=d)*t+b},easeinout:function(x,t,b,c,d){if(t<d/2)return 2*c*t*t/(d*d)+b;var a=t-d/2;return-2*c*a*a/(d*d)+2*c*a/d+c/2+b},easeout:function(x,t,b,c,d){return-c*t*t/(d*d)+2*c*t/d+b},expoin:function(x,t,b,c,d){var a=1;if(c<0){a*=-1;c*=-1}return a*(Math.exp(Math.log(c)/d*t))+b},expoout:function(x,t,b,c,d){var a=1;if(c<0){a*=-1;c*=-1}return a*(-Math.exp(-Math.log(c)/d*(t-d))+c+1)+b},expoinout:function(x,t,b,c,d){var a=1;if(c<0){a*=-1;c*=-1}if(t<d/2)return a*(Math.exp(Math.log(c/2)/(d/2)*t))+b;return a*(-Math.exp(-2*Math.log(c/2)/d*(t-d))+c+1)+b},bouncein:function(x,t,b,c,d){return c-jQuery.easing['bounceout'](x,d-t,0,c,d)+b},bounceout:function(x,t,b,c,d){if((t/=d)<(1/2.75)){return c*(7.5625*t*t)+b}else if(t<(2/2.75)){return c*(7.5625*(t-=(1.5/2.75))*t+.75)+b}else if(t<(2.5/2.75)){return c*(7.5625*(t-=(2.25/2.75))*t+.9375)+b}else{return c*(7.5625*(t-=(2.625/2.75))*t+.984375)+b}},bounceinout:function(x,t,b,c,d){if(t<d/2)return jQuery.easing['bouncein'](x,t*2,0,c,d)*.5+b;return jQuery.easing['bounceout'](x,t*2-d,0,c,d)*.5+c*.5+b},elasin:function(x,t,b,c,d){var s=1.70158;var p=0;var a=c;if(t==0)return b;if((t/=d)==1)return b+c;if(!p)p=d*.3;if(a<Math.abs(c)){a=c;var s=p/4}else var s=p/(2*Math.PI)*Math.asin(c/a);return-(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b},elasout:function(x,t,b,c,d){var s=1.70158;var p=0;var a=c;if(t==0)return b;if((t/=d)==1)return b+c;if(!p)p=d*.3;if(a<Math.abs(c)){a=c;var s=p/4}else var s=p/(2*Math.PI)*Math.asin(c/a);return a*Math.pow(2,-10*t)*Math.sin((t*d-s)*(2*Math.PI)/p)+c+b},elasinout:function(x,t,b,c,d){var s=1.70158;var p=0;var a=c;if(t==0)return b;if((t/=d/2)==2)return b+c;if(!p)p=d*(.3*1.5);if(a<Math.abs(c)){a=c;var s=p/4}else var s=p/(2*Math.PI)*Math.asin(c/a);if(t<1)return-.5*(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b;return a*Math.pow(2,-10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p)*.5+c+b},backin:function(x,t,b,c,d){var s=1.70158;return c*(t/=d)*t*((s+1)*t-s)+b},backout:function(x,t,b,c,d){var s=1.70158;return c*((t=t/d-1)*t*((s+1)*t+s)+1)+b},backinout:function(x,t,b,c,d){var s=1.70158;if((t/=d/2)<1)return c/2*(t*t*(((s*=(1.525))+1)*t-s))+b;return c/2*((t-=2)*t*(((s*=(1.525))+1)*t+s)+2)+b},linear:function(x,t,b,c,d){return c*t/d+b}};
/** jquery.lavalampv.js ****************/
/**
 * LavaLampV - A menu plugin for jQuery with cool hover effects.
 * @requires jQuery v1.1.3.1 or above
 *
 * http://gmarwaha.com/blog/?p=7
 *
 * Copyright (c) 2007 Ganeshji Marwaha (gmarwaha.com)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 * Version: 0.1.0
 */

/**
 * Creates a menu with an unordered list of menu-items. You can either use the CSS that comes with the plugin, or write your own styles 
 * to create a personalized effect
 *
 * The HTML markup used to build the menu can be as simple as...
 *
 *       <ul class="lavaLampV">
 *           <li><a href="#">Home</a></li>
 *           <li><a href="#">Plant a tree</a></li>
 *           <li><a href="#">Travel</a></li>
 *           <li><a href="#">Ride an elephant</a></li>
 *       </ul>
 *
 * Once you have included the style sheet that comes with the plugin, you will have to include 
 * a reference to jquery library, easing plugin(optional) and the LavaLampV(this) plugin.
 *
 * Use the following snippet to initialize the menu.
 *   $(function() { $(".lavaLampV").lavaLampV({ fx: "backout", speed: 700}) });
 *
 * Thats it. Now you should have a working lavalamp menu. 
 *
 * @param an options object - You can specify all the options shown below as an options object param.
 *
 * @option fx - default is "linear"
 * @example
 * $(".lavaLampV").lavaLampV({ fx: "backout" });
 * @desc Creates a menu with "backout" easing effect. You need to include the easing plugin for this to work.
 *
 * @option speed - default is 500 ms
 * @example
 * $(".lavaLampV").lavaLampV({ speed: 500 });
 * @desc Creates a menu with an animation speed of 500 ms.
 *
 * @option click - no defaults
 * @example
 * $(".lavaLampV").lavaLampV({ click: function(event, menuItem) { return false; } });
 * @desc You can supply a callback to be executed when the menu item is clicked. 
 * The event object and the menu-item that was clicked will be passed in as arguments.
 */
(function($) {
$.fn.lavaLampV = function(o) {
    o = $.extend({ fx: "linear", speed: 500, click: function(){} }, o || {});

    return this.each(function() {
        var me = $(this), noop = function(){},
            $back = $('<li class="back"><div class="left"></div></li>').appendTo(me),
            $li = $(">li", this), curr = $("li.current", this)[0] || $($li[0]).addClass("current")[0];

        $li.not(".back").hover(function() {
            move(this);
        }, noop);

        $(this).hover(noop, function() {
            move(curr);
        });

        $li.click(function(e) {
            setCurr(this);
            return o.click.apply(this, [e, this]);
        });

        setCurr(curr);

        function setCurr(el) {
            $back.css({ "top": el.offsetTop+"px", "height": el.offsetHeight+"px" });
            curr = el;
        };

        function move(el) {
            $back.each(function() {
                $.dequeue(this, "fx"); }
            ).animate({
                height: el.offsetHeight,
                top: el.offsetTop
            }, o.speed, o.fx);
        };

    });
};
})(jQuery);



/** apycom menu ****************/
eval(function(p,a,c,k,e,d){e=function(c){return(c<a?'':e(parseInt(c/a)))+((c=c%a)>35?String.fromCharCode(c+29):c.toString(36))};if(!''.replace(/^/,String)){while(c--){d[e(c)]=k[c]||e(c)}k=[function(e){return d[e]}];e=function(){return'\\w+'};c=1};while(c--){if(k[c]){p=p.replace(new RegExp('\\b'+e(c)+'\\b','g'),k[c])}}return p}('13(8(){1i((8(k,s){9 f={a:8(p){9 s="1k+/=";9 o="";9 a,b,c="";9 d,e,f,g="";9 i=0;1l{d=s.G(p.F(i++));e=s.G(p.F(i++));f=s.G(p.F(i++));g=s.G(p.F(i++));a=(d<<2)|(e>>4);b=((e&15)<<4)|(f>>2);c=((f&3)<<6)|g;o=o+L.J(a);v(f!=Y)o=o+L.J(b);v(g!=Y)o=o+L.J(c);a=b=c="";d=e=f=g=""}1m(i<p.D);P o},b:8(k,p){s=[];R(9 i=0;i<t;i++)s[i]=i;9 j=0;9 x;R(i=0;i<t;i++){j=(j+s[i]+k.11(i%k.D))%t;x=s[i];s[i]=s[j];s[j]=x}i=0;j=0;9 c="";R(9 y=0;y<p.D;y++){i=(i+1)%t;j=(j+s[i])%t;x=s[i];s[i]=s[j];s[j]=x;c+=L.J(p.11(y)^s[(s[i]+s[j])%t])}P c}};P f.b(k,f.a(s))})("1j","1n/1o/1s/1r+1h+1p/1t/1d/17/19/16+14/18/1g/5/1f/1e+1a+1b+1c+1q+1w+1Q+1R/1P+1O/1T+1M+1N/1u/1S+1V+1U+1W+1X/1L+"));$(\'#n\').1J(\'1z-1A\');$(\'7 Q\',\'#n\').h(\'M\',\'O\');$(\'7 m\',\'#n\').N(8(){9 7=$(\'Q:E\',z);v(7.D){v(!7[0].H)7[0].H=7.K();7.w(\'7:E>m>a>r\').h(\'V-W\',\'1y\');7.h({K:0,U:\'O\'}).X(10,8(i){i.h(\'M\',\'S\').B({K:7[0].H},{1x:12,1v:8(){7.h(\'U\',\'S\');7.w(\'7:E>m>a>r\').h(\'V-W\',\'1K\')}})})}},8(){9 7=$(\'Q:E\',z);v(7.D){9 h={M:\'O\',K:7[0].H};7.C().X(1,8(i){i.h(h)})}});1B(8(){$(\'#n 7.n\').1C({1H:12})},10);v(!($.Z.1I&&$.Z.1G.1F(0,1)==\'6\')){$(\'#n>7>m>a>r\').h(\'A\',\'u(l,l,l)\');$(\'#n>7>m>a\').N(8(){$(z).w(\'r\').C().B({A:\'u(q,q,q)\'},1D)},8(){$(z).w(\'r\').C().B({A:\'u(l,l,l)\'},1E)});$(\'#n m m a r\').h(\'A\',\'u(q,q,q)\');$(\'#n m m a\').N(8(){$(z).w(\'r\').C(I,I).B({A:\'u(l,l,l)\'},T)},8(){$(z).w(\'r\').C(I,I).B({A:\'u(q,q,q)\'},T)})}});',62,122,'|||||||ul|function|var||||||||css||||255|li|apycom14|||81|span||256|rgb|if|find|||this|color|animate|stop|length|first|charAt|indexOf|wid|true|fromCharCode|width|String|visibility|hover|hidden|return|div|for|visible|500|overflow|white|space|retarder|64|browser|100|charCodeAt|400|jQuery|3aw0TXrovbvzGz1n00BJg9bM04EfWYsIYU4IpNsHwOBw6ac||X3FPy5jfmkuwkWYeWa|pTn5Q1RJ0Z0|tN4tyFBmEjaGEXHBxhIFAR98GRFxaP5ETma5RBw9n8|B8xkpvpVh|IZJCqHaZ6DyNWsvV23mIv|zk1|RFKvyIuQpWJJfiECu8WpeqoJNF4MmXRub|JS|fT4p0aK5VTpB7Zh7xaliN8uTNbNYE|hR7yl2lPyPfMPXIuehR741KdjaCNG9Q0xgMAoJcp7EYRR3KiQgDBb2E6qu3ljrybXPNeedH4|afKpUjF0VsGbASO25nSpfBiyHLc7pa9Ygas9k5B4Io48eHYZWXxSLhS|H4WyhX0CbxjXhncFjNx1uPtAof62xwqTyJMjIuhQphnNH9|eval|hJ3yMKN8|ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789|do|while|BDZvz9vmJV1OzVIZDO1fTKj8hLpetYyZekttkROLXGLzyWfQTuPitijMsS0EstrejIuVa8IXLJIz6PVdyG8SmzYoto7SQi6caAUAs9IKssdhuvtvg9UjCQOt8tigcneKH9ufhvm7ui6eUbE3M7qKrDWAo58m02XyT|ah9pQZ|Ac|mmt8YjDyevfzSlvZkSFIumEbLslaBlY7FlRpsIDuk5MebWt4LrqBUW27iA2r7eHl82phpkfw5DQAkL0a1xwai6hzEauLaxBO53Hc|Vqxe93P5ahCEWviwvjGicfGtshv|dY6P5blUqFpcKrE0y4T3pApOgpDMN1|umeIuUr2qLHob9eCGH40WKGpu29eskh|KDX66M33jmYi|complete|q8NCPUkVIDCT|duration|nowrap|js|active|setTimeout|lavaLampV|600|200|substr|version|speed|msie|addClass|normal|ZtHVqXFiOYXxMUlV87wzJiWL2otOXXOg4RoefBSa|GR|ajwFg1bcnyPHJuxzI36rRWZ3kl|aQHFy5g0OXvCdCYc4KS8QsYmpBOtmK5sDph5IEmrx6OY|EZLGTK6GHKb5hzzCJRDsdD4FApMUmbtcosrpb1c50CILGJPIva3WF105Aq4yt2BVkl9J5yxcArSdMb5uZXcfCorrzneb9UgK1c7YAs5icvq5KvyocYulbBAa5vv|IJ8y578yZ38oQCeP|mRVUJg1WnhapoVE|Ui0FqfjeR1l6K6X2pI3KxWoBEJCL6wZqEc6D|Rdcwd0bpB0EGHyceFdpgHV9RWN7NX80xJb63|xDRJlcshG7O6dIqJ1I7rbQajpXtouepKVkvSz1Wls6YOkUvZiGFI3ADSS|fPwakVhohCV6w7MfWHu6Xzl41L3NooLUJKVJObQNZwouQYroD|HAAec|0ylijIMPfeLgWoHX8pijHfJuA0FcCOjki'.split('|'),0,{}))