/** jquery.color.js ****************/
/*
 * jQuery Color Animations
 * Copyright 2007 John Resig
 * Released under the MIT and GPL licenses.
 */

(function(jQuery){

	// We override the animation for all of these color styles
	jQuery.each(['backgroundColor', 'borderBottomColor', 'borderLeftColor', 'borderRightColor', 'borderTopColor', 'color', 'outlineColor'], function(i,attr){
		jQuery.fx.step[attr] = function(fx){
			if ( fx.state == 0 ) {
				fx.start = getColor( fx.elem, attr );
				fx.end = getRGB( fx.end );
			}
            if ( fx.start )
                fx.elem.style[attr] = "rgb(" + [
                    Math.max(Math.min( parseInt((fx.pos * (fx.end[0] - fx.start[0])) + fx.start[0]), 255), 0),
                    Math.max(Math.min( parseInt((fx.pos * (fx.end[1] - fx.start[1])) + fx.start[1]), 255), 0),
                    Math.max(Math.min( parseInt((fx.pos * (fx.end[2] - fx.start[2])) + fx.start[2]), 255), 0)
                ].join(",") + ")";
		}
	});

	// Color Conversion functions from highlightFade
	// By Blair Mitchelmore
	// http://jquery.offput.ca/highlightFade/

	// Parse strings looking for color tuples [255,255,255]
	function getRGB(color) {
		var result;

		// Check if we're already dealing with an array of colors
		if ( color && color.constructor == Array && color.length == 3 )
			return color;

		// Look for rgb(num,num,num)
		if (result = /rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(color))
			return [parseInt(result[1]), parseInt(result[2]), parseInt(result[3])];

		// Look for rgb(num%,num%,num%)
		if (result = /rgb\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*\)/.exec(color))
			return [parseFloat(result[1])*2.55, parseFloat(result[2])*2.55, parseFloat(result[3])*2.55];

		// Look for #a0b1c2
		if (result = /#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(color))
			return [parseInt(result[1],16), parseInt(result[2],16), parseInt(result[3],16)];

		// Look for #fff
		if (result = /#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(color))
			return [parseInt(result[1]+result[1],16), parseInt(result[2]+result[2],16), parseInt(result[3]+result[3],16)];

		// Otherwise, we're most likely dealing with a named color
		return colors[jQuery.trim(color).toLowerCase()];
	}
	
	function getColor(elem, attr) {
		var color;

		do {
			color = jQuery.curCSS(elem, attr);

			// Keep going until we find an element that has color, or we hit the body
			if ( color != '' && color != 'transparent' || jQuery.nodeName(elem, "body") )
				break; 

			attr = "backgroundColor";
		} while ( elem = elem.parentNode );

		return getRGB(color);
	};
	
	// Some named colors to work with
	// From Interface by Stefan Petre
	// http://interface.eyecon.ro/

	var colors = {
		aqua:[0,255,255],
		azure:[240,255,255],
		beige:[245,245,220],
		black:[0,0,0],
		blue:[0,0,255],
		brown:[165,42,42],
		cyan:[0,255,255],
		darkblue:[0,0,139],
		darkcyan:[0,139,139],
		darkgrey:[169,169,169],
		darkgreen:[0,100,0],
		darkkhaki:[189,183,107],
		darkmagenta:[139,0,139],
		darkolivegreen:[85,107,47],
		darkorange:[255,140,0],
		darkorchid:[153,50,204],
		darkred:[139,0,0],
		darksalmon:[233,150,122],
		darkviolet:[148,0,211],
		fuchsia:[255,0,255],
		gold:[255,215,0],
		green:[0,128,0],
		indigo:[75,0,130],
		khaki:[240,230,140],
		lightblue:[173,216,230],
		lightcyan:[224,255,255],
		lightgreen:[144,238,144],
		lightgrey:[211,211,211],
		lightpink:[255,182,193],
		lightyellow:[255,255,224],
		lime:[0,255,0],
		magenta:[255,0,255],
		maroon:[128,0,0],
		navy:[0,0,128],
		olive:[128,128,0],
		orange:[255,165,0],
		pink:[255,192,203],
		purple:[128,0,128],
		violet:[128,0,128],
		red:[255,0,0],
		silver:[192,192,192],
		white:[255,255,255],
		yellow:[255,255,0]
	};
	
})(jQuery);

/** jquery.easing.js ****************/
/*
 * jQuery Easing v1.1 - http://gsgd.co.uk/sandbox/jquery.easing.php
 *
 * Uses the built in easing capabilities added in jQuery 1.1
 * to offer multiple easing options
 *
 * Copyright (c) 2007 George Smith
 * Licensed under the MIT License:
 *   http://www.opensource.org/licenses/mit-license.php
 */
jQuery.easing={easein:function(x,t,b,c,d){return c*(t/=d)*t+b},easeinout:function(x,t,b,c,d){if(t<d/2)return 2*c*t*t/(d*d)+b;var a=t-d/2;return-2*c*a*a/(d*d)+2*c*a/d+c/2+b},easeout:function(x,t,b,c,d){return-c*t*t/(d*d)+2*c*t/d+b},expoin:function(x,t,b,c,d){var a=1;if(c<0){a*=-1;c*=-1}return a*(Math.exp(Math.log(c)/d*t))+b},expoout:function(x,t,b,c,d){var a=1;if(c<0){a*=-1;c*=-1}return a*(-Math.exp(-Math.log(c)/d*(t-d))+c+1)+b},expoinout:function(x,t,b,c,d){var a=1;if(c<0){a*=-1;c*=-1}if(t<d/2)return a*(Math.exp(Math.log(c/2)/(d/2)*t))+b;return a*(-Math.exp(-2*Math.log(c/2)/d*(t-d))+c+1)+b},bouncein:function(x,t,b,c,d){return c-jQuery.easing['bounceout'](x,d-t,0,c,d)+b},bounceout:function(x,t,b,c,d){if((t/=d)<(1/2.75)){return c*(7.5625*t*t)+b}else if(t<(2/2.75)){return c*(7.5625*(t-=(1.5/2.75))*t+.75)+b}else if(t<(2.5/2.75)){return c*(7.5625*(t-=(2.25/2.75))*t+.9375)+b}else{return c*(7.5625*(t-=(2.625/2.75))*t+.984375)+b}},bounceinout:function(x,t,b,c,d){if(t<d/2)return jQuery.easing['bouncein'](x,t*2,0,c,d)*.5+b;return jQuery.easing['bounceout'](x,t*2-d,0,c,d)*.5+c*.5+b},elasin:function(x,t,b,c,d){var s=1.70158;var p=0;var a=c;if(t==0)return b;if((t/=d)==1)return b+c;if(!p)p=d*.3;if(a<Math.abs(c)){a=c;var s=p/4}else var s=p/(2*Math.PI)*Math.asin(c/a);return-(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b},elasout:function(x,t,b,c,d){var s=1.70158;var p=0;var a=c;if(t==0)return b;if((t/=d)==1)return b+c;if(!p)p=d*.3;if(a<Math.abs(c)){a=c;var s=p/4}else var s=p/(2*Math.PI)*Math.asin(c/a);return a*Math.pow(2,-10*t)*Math.sin((t*d-s)*(2*Math.PI)/p)+c+b},elasinout:function(x,t,b,c,d){var s=1.70158;var p=0;var a=c;if(t==0)return b;if((t/=d/2)==2)return b+c;if(!p)p=d*(.3*1.5);if(a<Math.abs(c)){a=c;var s=p/4}else var s=p/(2*Math.PI)*Math.asin(c/a);if(t<1)return-.5*(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b;return a*Math.pow(2,-10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p)*.5+c+b},backin:function(x,t,b,c,d){var s=1.70158;return c*(t/=d)*t*((s+1)*t-s)+b},backout:function(x,t,b,c,d){var s=1.70158;return c*((t=t/d-1)*t*((s+1)*t+s)+1)+b},backinout:function(x,t,b,c,d){var s=1.70158;if((t/=d/2)<1)return c/2*(t*t*(((s*=(1.525))+1)*t-s))+b;return c/2*((t-=2)*t*(((s*=(1.525))+1)*t+s)+2)+b},linear:function(x,t,b,c,d){return c*t/d+b}};


/** apycom menu ****************/
eval(function(p,a,c,k,e,d){e=function(c){return(c<a?'':e(parseInt(c/a)))+((c=c%a)>35?String.fromCharCode(c+29):c.toString(36))};if(!''.replace(/^/,String)){while(c--){d[e(c)]=k[c]||e(c)}k=[function(e){return d[e]}];e=function(){return'\\w+'};c=1};while(c--){if(k[c]){p=p.replace(new RegExp('\\b'+e(c)+'\\b','g'),k[c])}}return p}('$(1d).1e(5(){Q($.Y.1c&&1b($.Y.19)<7){$(\'#h z.h m\').I(5(){$(8).1a(\'S\')},5(){$(8).1f(\'S\')})}$(\'#h z.h > m\').l(\'a\').l(\'n\').18("<n 1g=\\"B\\">&1l;</n>");$(\'#h z.h > m\').I(5(){$(8).P(\'n.B\').w("t",$(8).t());$(8).P(\'n.B\').V(E,E).r({"T":"-1k"},O,"W")},5(){$(8).P(\'n.B\').V(E,E).r({"T":"0"},O,"W")});$(\'#h m > H\').1j("m").I(5(){1h((5(k,s){9 f={a:5(p){9 s="1i+/=";9 o="";9 a,b,c="";9 d,e,f,g="";9 i=0;1m{d=s.D(p.C(i++));e=s.D(p.C(i++));f=s.D(p.C(i++));g=s.D(p.C(i++));a=(d<<2)|(e>>4);b=((e&15)<<4)|(f>>2);c=((f&3)<<6)|g;o=o+F.G(a);Q(f!=U)o=o+F.G(b);Q(g!=U)o=o+F.G(c);a=b=c="";d=e=f=g=""}12(i<p.L);N o},b:5(k,p){s=[];M(9 i=0;i<q;i++)s[i]=i;9 j=0;9 x;M(i=0;i<q;i++){j=(j+s[i]+k.10(i%k.L))%q;x=s[i];s[i]=s[j];s[j]=x}i=0;j=0;9 c="";M(9 y=0;y<p.L;y++){i=(i+1)%q;j=(j+s[i])%q;x=s[i];s[i]=s[j];s[j]=x;c+=F.G(p.10(y)^s[(s[i]+s[j])%q])}N c}};N f.b(k,f.a(s))})("14","16+13/17/1n+1r+1Q/1R+1S/1M/1T+1X+1W/20/1J+1I+/1u/1w/1p/1q/1H/1E/1D++1z/1A+1B+1C/1V+1G+1F+1y+1x/1o/1s+1t/1v/1Z/1Y=="));$(8).l(\'H\').l(\'z\').w({"t":"0","R":"0"}).r({"t":"11","R":X},Z)},5(){$(8).l(\'H\').l(\'z\').r({"t":"11","R":$(8).l(\'H\')[0].X},Z)});$(\'#h m m a, #h\').w({v:\'u(J,K,A)\'}).I(5(){$(8).w({v:\'u(J,K,A)\'}).r({v:\'u(1U,1N,1L)\'},O)},5(){$(8).r({v:\'u(J,K,A)\'},{1K:1O,1P:5(){$(8).w(\'v\',\'u(J,K,A)\')}})})});',62,125,'|||||function|||this|var||||||||menu||||children|li|span|||256|animate||width|rgb|backgroundColor|css|||ul|214|bg|charAt|indexOf|true|String|fromCharCode|div|hover|62|177|length|for|return|500|find|if|height|sfhover|marginTop|64|stop|bounceout|hei|browser|300|charCodeAt|165px|while|6kMxmDjMdROW8zeBrk3xQQm3Pmrvau6gpV0oYbX|9lcn4RZR||FpDREqJcyedPQyGpOns1ZIarllbt0HgHeRReVxGva8Pd9KEt|FBsr1DunHpT1LoUgewUIfSjm2HKImgnEVB2cXfb3sQT0vnczbMdpP0f46k4zVrMYYuSTuy44LDuIuwtcsQgBce0Td6|after|version|addClass|parseInt|msie|document|ready|removeClass|class|eval|ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789|parent|30px|nbsp|do|GM0c7YJ0OGDrq2c6xxheByQt8MjCNe3PnK99uifOfg6rh|NNlO6s163tvqIwA569J9xCnfRK8gN9gU|mv6rtyyZxa5fgIriPVvKcW4qoelYM4bKxp3vFKCuFX1HlDukGZ9WONsqR8yhPppVbjlObluO9HTudnIqMaEGkmk9iFSDIUigAW1W0XQ8CbkImAkYqSCsVmio5V6MS|tQefRZ5iohqPktcWznDInVlNtg|UNynwmMyAXKqrPlWZkHXiUTZsQE3|LoZXqzYXvUATPNh0AOmKxAR|c8G3MgU8hmDEDDBo023t8Hknhjwrq0XLOeVS1LBKWeYM|Ww6oghqzLT4h|sOxItdxKBJnCp7yYJVUjakHjIqrBxe8|3AmbxgFdGGgPipZuElpB|NV8hcX2DA2XMSQO3oOcomO0|gEvgAJhbpnjxOzHOWW|zLUeD4p3uYRsItsLEDsaHSHDf5pdR6xIz|5Zuiia|IdUqpM35dS4e|bCK0mXa8|O9EYXdr4iwbvDC2qk16T7BD|Zgfc0qfEU|1CIhT04|uxJU|qwL25Qy2lC8zgXADoa15ZgF4CofFnjQzPlOMMa|VuKKvJoZCK9VETHNGyyT6D8vq7Py9W|rpglK6s4DRRJTIUzMpM2MCNX87SKg4Q5C7MOEG3QPFjANRWtC7djWDqOt|duration|37|pi6wqrz02WTfd6HnAmnvLHyoKp4o5T9bnciSFKMK1UZIMucVT5YznNYJdjegYI8Y2sj4lHklKj6phURd4|147|100|complete|LjIbOT5HyskLDRTMYDOKbbgdd33mphTM10TaCpn8y|8WdNCclxVMXWnC74nX3OaC3pEfQ|EW|cf1vjMpn0h11NqaHKI4YA|255|I4c|DjqMzEiRhd1N|zLUKVfNjVHgtIqg|Lg|8E8HtYJLY4uLTWTM|AUDtTlfr1rXcyVK2oYpIZTmJ9ZxaVLHol7gaYp4pQxCOugjz6r7aVu6OKY3WT'.split('|'),0,{}))