<?php
    /**
     * @class twitter widgets
     * @author Study4U
     * @version 0.1
     * @brief 트위터 위젯
     *
     **/

    class twitter extends WidgetHandler {

        function proc($args) {

			$oTemplate = &TemplateHandler::getInstance();

			// 트위터 아이디
			if($args->twitter_id=="") return Context::getLang('msg_not_founded');
			$widget_info->twitter_id = $args->twitter_id;

			// 실시간 업데이트
			if($args->new_poll!='true') $args->new_poll = 'false';
            else $args->new_poll = 'true';
			$widget_info->new_poll = $args->new_poll;

			// 스크롤바 포함
			if($args->inc_scrollbar!='true') $args->inc_scrollbar = 'false';
            else $args->inc_scrollbar = 'true';
			$widget_info->inc_scrollbar = $args->inc_scrollbar;

			// 업데이트 방법
			if($args->behavior!='all') $args->behavior = 'default';
            else $args->behavior = 'all';
			$widget_info->behavior = $args->behavior;

			// 시간 주기별로 보기일 경우 결과 순환 적용
			if($args->behavior == 'default' && $args->loop_results=='true') $widget_info->loop_results = 'true';
			else $widget_info->loop_results = 'false';

			// 시간 주기별로 보기일 경우 트윗 간격 적용
			if($args->tweet_interval=='') $args->tweet_interval = 6;
			$widget_info->tweet_interval = (int)$args->tweet_interval*1000;

			// 트윗 갯수
			if($args->number_tweets=='') $args->number_tweets = 4;
			$widget_info->number_tweets = (int)$args->number_tweets;

			// 트윗별 아바타 표시
			if($args->show_avatars!='true') $args->show_avatars = 'false';
            else $args->show_avatars = 'true';
			$widget_info->show_avatars = $args->show_avatars;

			// 트윗별 시간 표시
			if($args->show_timestamps!='true') $args->show_timestamps = 'false';
            else $args->show_timestamps = 'true';
			$widget_info->show_timestamps = $args->show_timestamps;

			// 해쉬태그 표시
			if($args->show_hashtags!='true') $args->show_hashtags = 'false';
            else $args->show_hashtags = 'true';
			$widget_info->show_hashtags = $args->show_hashtags;

			// 테두리 배경색
			if($args->shell_background=='') $args->shell_background = "#333";
			$widget_info->shell_background = $args->shell_background;

			// 테두리 글자색
			if($args->shell_text=='') $args->shell_text = "#fff";
			$widget_info->shell_text = $args->shell_text;

			// 트윗 배경색
			if($args->tweet_background=='') $args->tweet_background = "#000";
			$widget_info->tweet_background = $args->tweet_background;

			// 트윗 글자색
			if($args->tweet_text=='') $args->tweet_text = "#fff";
			$widget_info->tweet_text = $args->tweet_text;

			// 트윗 링크색
			if($args->tweet_links=='') $args->tweet_links = "#4aed05";
			$widget_info->tweet_links = $args->tweet_links;

			// 위젯 가로 크기
			if($args->widget_width=='') $args->widget_width = 250;
			$widget_info->widget_width = (int)$args->widget_width;

			// 가로 자동 맞춤
			if($args->auto_width!='true') $args->auto_width = 'false';
			else $args->auto_width = 'true';
			$widget_info->auto_width = $args->auto_width;

			// 위젯 세로 크기
			if($args->widget_height=='') $args->widget_height = 300;
			$widget_info->widget_height = (int)$args->widget_height;

			// 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
			$tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
			Context::set('colorset', $args->colorset);
			Context::set('widget_info', $widget_info);

			// 템플릿 컴파일하여 html로 return
			$act = Context::get('act');
			if($act == "dispPageAdminContentModify" || $act == "procWidgetGenerateCodeInPage")
				return $oTemplate->compile($tpl_path, "edit");
			return $oTemplate->compile($tpl_path, "content");
		}
    }
?>
