var selected_node = null;

var tpl_path = './modules/editor/components/chess/tpl/';
var img_path = tpl_path + 'images/';
var alphabet_array = ["a", "b", "c", "d", "e", "f", "g", "h"];

function getChess() {
	// 부모창이 있는지 체크
	if(typeof(opener)=="undefined") return;

	// 부모 위지윅 에디터에서 선택된 영역이 있으면 처리
	var node = opener.editorPrevNode;
	if(node && node.nodeName == "IMG") {
		selected_node = node;

		// 말 정보 가져오기
		for (i = 0; i < 8; i++){
			for (j = 0; j < 8; j++){
				var name = alphabet_array[i] + (j+1);
				var piece = selected_node.getAttribute(name);
				jQuery("input[name=" + name + "]").val(piece);
				if (piece) jQuery("#" + name).html('<img src="' + img_path + piece + '.png" alt="' + piece + '" />');
			}
		}
	}

	// 초기 배치
	else{
		initChess();
	}
}

// 초기 배치
function initChess(){
	// a8부터 h8까지 이차원 배열(화면에 보이는 대로 배치하면 됨)
	var init_array = [
		// 8열
		// a			b				c				d				e			f				g				h
		["black_rook", "black_knight", "black_bishop", "black_queen", "black_king", "black_bishop", "black_knight", "black_rook"],
		// 7
		["black_pawn", "black_pawn", "black_pawn", "black_pawn", "black_pawn", "black_pawn", "black_pawn", "black_pawn"],
		// 6
		["", "", "", "", "", "", "", ""],
		// 5
		["", "", "", "", "", "", "", ""],
		// 4
		["", "", "", "", "", "", "", ""],
		// 3
		["", "", "", "", "", "", "", ""],
		// 2
		["white_pawn", "white_pawn", "white_pawn", "white_pawn", "white_pawn", "white_pawn", "white_pawn", "white_pawn"],
		// 1
		["white_rook", "white_knight", "white_bishop", "white_queen", "white_king", "white_bishop", "white_knight", "white_rook"]
	];

	for(i = 0; i < 8; i++){
		for (j = 0; j < 8; j++){
			var name = alphabet_array[j] + (8-i);

			if (init_array[i][j]){
				jQuery("#" + name).html('<img src="' + img_path + init_array[i][j] + '.png" alt="' + init_array[i][j] + '" />');
				jQuery("input[name=" + name + "]").val(init_array[i][j]);
			}else{
				jQuery("#" + name).html('');
				jQuery("input[name=" + name + "]").val('');
			}
		}
	}
}

var current_piece;
var click_time;
var current_cell;
jQuery(window).load(function(){
	// 말 선택
	jQuery(".chess_editor_component_piece img").bind("click", function(e){
		jQuery(".chess_editor_component_piece img").removeClass("select");
		jQuery(this).addClass("select");
		current_piece = this.id;
		jQuery("#" + current_cell + " img").css("position", "static");
		current_cell = '';
	});

	// 칸 선택
	jQuery(".chess_editor_component td").bind("click", function(e){
		// 말을 선택하고 칸 선택 시
		if (current_piece){
			jQuery(this).html('<img src="' + img_path + current_piece + '.png" alt="' + current_piece + '" />');
			jQuery("input[name=" + this.id + "]").val(current_piece);
			jQuery(".chess_editor_component_piece img").removeClass("select");
			current_piece = null;

		// 말을 선택하지 않고 칸 선택 시(현재 칸의 말을 옮긴다)
		}else if (!current_cell){
			if (!jQuery("input[name=" + this.id + "]").val()) return;

			current_cell = this.id;
			var piece_obj = jQuery("#" + current_cell + " img");
			piece_obj.css("position", "relative");
			piece_obj.css("top", -5);
			piece_obj.css("left", 5);

			// 현재 타임스탬프를 기록(click 이벤트와 dblclick 이벤트가 잘 안 된다, 그냥 click 이벤트에서 눌러진 시간차를 이용하자)
			click_time = new Date().getTime();

		// 칸의 말을 옮길 때
		}else if (current_cell){
			// 클릭한 시간차를 구한다.
			var diff_click_time = new Date().getTime() - click_time;

			// 같은 칸을 클릭했고 300ms 이내에 클릭되었다면 말 삭제
			if (current_cell == this.id && diff_click_time < 500){
				jQuery(this).html('');
				jQuery("input[name=" + this.id + "]").val('');
			}

			// 그냥 클릭이면 말 이동
			else{
				var piece = jQuery("input[name=" + current_cell + "]").val();

				// 새로운 칸으로 이동
				jQuery(this).html('<img src="' + img_path + piece + '.png" alt="' + piece + '" />');
				jQuery("input[name=" + this.id + "]").val(piece);

				// 이전 칸의 말은 삭제
				if (this.id != current_cell){
					jQuery("#" + current_cell).html('');
					jQuery("input[name=" + current_cell + "]").val('');
				}
			}

			current_cell = '';
		}
	});

	// 말 삭제
	// jQuery(".chess_editor_component td").bind("dblclick", function(e){
		// jQuery(this).html('');
		// jQuery("input[name=" + this.id + "]").val('');
		// current_cell = '';
	// });

	getChess();
});

// 칸 삭제
function del_piece(){
	if (!current_cell) return;
	jQuery("#" + current_cell).html('');
	jQuery("input[name=" + current_cell + "]").val('');
}

// 삽입
function insertChess(){
	if(typeof(opener)=="undefined") return;

	html = '<img src="../../../../common/tpl/images/blank.gif" style="width:220px;border:2px dotted #4371B9;background:url(./modules/editor/components/chess/tpl/chess_component.gif) no-repeat center;" editor_component="chess" ';

	// 말 정보 가져오기
	for (i = 0; i < 8; i++){
		for (j = 0; j < 8; j++){
			var name = alphabet_array[i] + (j+1);
			var piece = jQuery("input[name=" + name + "]").val();
			html += name + '="' + piece + '" ';
		}
	}
	html += '/>';

	opener.editorFocus(opener.editorPrevSrl);
	opener.editorRelKeys[opener.editorPrevSrl].pasteHTML(html);

	opener.editorFocus(opener.editorPrevSrl);

    window.close();
}
